/*

    File: cmospwd.c

    Copyright (C) 1998-2002 Christophe GRENIER <grenier@cgsecurity.org>
    http://www.cgsecurity.org
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Thanks to Bluefish for BSD support
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef __MSDOS__
#include <dos.h>
#include <ctype.h>
#include <conio.h>
#elif defined linux
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
int  ioperm(unsigned  long,  unsigned  long, int);
#elif defined WIN32
#include <conio.h>
#include <stdlib.h>
#include <windows.h>
#define outportb(PORT,VALUE) outp(PORT,VALUE)
#define inportb(PORT) inp(PORT)
//
// Macro definition for defining IOCTL and FSCTL function control codes.  Note
// that function codes 0-2047 are reserved for Microsoft Corporation, and
// 2048-4095 are reserved for customers.
//

#define CTL_CODE( DeviceType, Function, Method, Access ) (                 \
    ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
)
#define METHOD_BUFFERED                 0
#define FILE_ANY_ACCESS                 0

#define DEVICE_NAME_STRING      L"gwiopm"
#define IOPM_VERSION          110      // decimal
#define IOPM_TEST0         0x0123
#define IOPM_TEST1         0x1234
#define IOPM_TEST2         0x2345

// Device type           -- in the "User Defined" range."
#define IOPMD_TYPE 0xF100               // used several places

// The IOCTL function codes from 0x800 to 0xFFF are for non-Microsoft use.
// LIOPM means "local I/O Permission Map" maintained by this driver.
//-------------------------- 
// Test functions
#define IOCTL_IOPMD_READ_TEST        CTL_CODE(IOPMD_TYPE, 0x900, METHOD_BUFFERED, FILE_ANY_ACCESS ) // returns IOPM_TEST
#define IOCTL_IOPMD_READ_VERSION     CTL_CODE(IOPMD_TYPE, 0x901, METHOD_BUFFERED, FILE_ANY_ACCESS ) // returns IOPM_VERSION
// Manipulate local IOPM
#define IOCTL_IOPMD_CLEAR_LIOPM      CTL_CODE(IOPMD_TYPE, 0x910, METHOD_BUFFERED, FILE_ANY_ACCESS ) // set map to block perm on all I/O addresses
#define IOCTL_IOPMD_SET_LIOPM        CTL_CODE(IOPMD_TYPE, 0x911, METHOD_BUFFERED, FILE_ANY_ACCESS ) // set a byte (8 ports-worth) in LIOPM
#define IOCTL_IOPMD_GET_LIOPMB       CTL_CODE(IOPMD_TYPE, 0x912, METHOD_BUFFERED, FILE_ANY_ACCESS ) // get a byte from LIOPM (diagnostic)
#define IOCTL_IOPMD_GET_LIOPMA       CTL_CODE(IOPMD_TYPE, 0x913, METHOD_BUFFERED, FILE_ANY_ACCESS ) // get entire array of current LIOPM 
// Interact with kernel
#define IOCTL_IOPMD_ACTIVATE_KIOPM   CTL_CODE(IOPMD_TYPE, 0x920, METHOD_BUFFERED, FILE_ANY_ACCESS ) // copy LIOPM to be active map 
#define IOCTL_IOPMD_DEACTIVATE_KIOPM CTL_CODE(IOPMD_TYPE, 0x921, METHOD_BUFFERED, FILE_ANY_ACCESS ) // tell NT to forget map 
#define IOCTL_IOPMD_QUERY_KIOPM      CTL_CODE(IOPMD_TYPE, 0x922, METHOD_BUFFERED, FILE_ANY_ACCESS ) // get OS's IOPM into LIOPM? 

#define GWIOPM_PARAMCOUNT 3                            // for most functions
#define GWIOPM_PARAMCOUNT_BYTES GWIOPM_PARAMCOUNT * 4  // for most functions
#elif defined(bsd)
#include <ctype.h>
#include <stdlib.h>
FILE *cmos_fd;
#endif

typedef unsigned char      byte;    /* type of 8 bit unsigned quantity */
typedef unsigned char 	   Bit8u;
typedef unsigned short     Bit16u;  /* type of 16 bit unsigned quantity */
typedef unsigned long      Bit32u;  /* type of 32 bit unsigned quantity */
#define TAILLE_CMOS 3*0x80
#define TAILLE_CMOS_MAX 4096
#define TAILLE_BUFFER 2*0x200+TAILLE_CMOS_MAX
#define MINLEN_CRC 6
/* port i/o privileges & co. */
#define IO_READ  1
#define IO_WRITE 2
#define IO_RDWR  (IO_READ | IO_WRITE)
#define PORT_CMOS_0 0x70
#define PORT_CMOS_1 0x71
#define PORT_CMOS_2 0x72
#define PORT_CMOS_3 0x73
#define PORT_CMOS_4 0x74
#define PORT_CMOS_5 0x75
#define UNKNOWN_CAR '?'
#define VAL_NON_STOP 256
int get32(int position);
void printchar(unsigned char car, int scancode);
void aff_hexa(const unsigned char*buffer,const int lng);
int build_table(const int position, const int lng, const int meth_parcourt, int *table);
void table2val(const int *table, unsigned char *value, const int lng);
void aff_result(const unsigned char *value, const int lng,const int val_stop,const int mode_aff);
int generic_ami(unsigned char *value, const int lng, const int methode,const int val_stop);
void generic_acer(unsigned char *value, const int lng,const int val_stop);
void generic_award6(unsigned char *value, const int lng,const int val_stop);
void generic_dtk(unsigned char *value, const int lng,const unsigned char value_stop);
void generic_compaq(unsigned char *value, const int lng,const unsigned char value_stop);
void generic_unknown(unsigned char*value, const int lng,const int val_stop);
void generic_phoenix_dec(unsigned char *value, const int lng,const unsigned char value_stop);
void generic_phoenix_xor(unsigned char *value, const int lng,const unsigned char value_stop);
void generic_phoenix_add(unsigned char *value, const int lng,const unsigned char value_stop);
int check_filled(const unsigned char*value, const int lng, const unsigned char filled_value);
void generic_basic(const int position, const int lng, const int meth_parcourt,const int algo,const int val_stop,const int mode_aff);
int check_crcadd(int position, int size, int pos_crc);
void generic_crc(int algo, int position);
void award_backdoor(void);

byte scan2ascii(byte);
unsigned char filtre(unsigned char);
void dumpcmos(const int cmos_size, const int scancode);
int ask_YN(const char*);
byte parity_test(byte);
Bit16u rol(Bit16u);
Bit8u rcl8(Bit8u);
Bit8u rcl8n(Bit8u, int);
byte brute_awa(Bit16u, Bit16u, byte);
byte brute_award(Bit16u);
void set_permissions(void);
void unset_permissions(void);
Bit16u do_tosh(Bit16u, byte);
byte brute_tosh(Bit16u, Bit16u, byte);
byte brute_toshiba(Bit16u);
#define m_acer          		"\nAcer/IBM                     "
#define m_ami_old       		"\nAMI BIOS                     "
#define m_ami_winbios   		"\nAMI WinBIOS (12/15/93)       "
#define m_ami_winbios2  		"\nAMI WinBIOS 2.5              "
#define m_ami_unk			"\nAMI ?                        "
#define m_award         		"\nAward 4.5x/6.0               "
#define m_award_medallion 		"\nAward Medallion 6.0          "
#define m_award6			"\nAward 6.0                    "
#define m_compaq        		"\nCompaq (1992)                "
#define m_compaq2       		"\nCompaq                       "
#define m_compaq3   			"\nCompaq DeskPro               "
#define m_dtk				"\nDTK                          "
#define m_phoenixa08			"\nPhoenix A08, 1993            "
#define m_ibm           		"\nIBM (PS/2, Activa ...)       "
#define m_ibm_thinkpad  		"\nIBM Thinkpad boot pwd        "
#define m_ibm_300       		"\nIBM 300 GL                   "
#define m_ibm_thinkpad_765_380z 	"\nThinkpad 765/380z EEPROM     "
#define m_ibm_thinkpad_560x 		"\nThinkpad 560x EEPROM         "
#define m_ibm_thinkpad_x20_570_t20	"\nThinkpad x20/570/t20 EEPROM  "
#define m_packardbell   		"\nPackard Bell Supervisor/User "
#define m_phoenix       		"\nPhoenix 1.00.09.AC0 (1994)   "
#define m_phoenix2      		"\nPhoenix 1.04                 "
#define m_phoenix3      		"\nPhoenix 1.10 A03             "
#define m_phoenix4      		"\nPhoenix 4 release 6 (User)   "
#define m_phoenix5			"\nPhoenix 4.0 release 6.0      "
#define m_phoenix6			"\nPhoenix a486 1.03            "
#define m_phoenix405			"\nPhoenix 4.05 rev 1.02.943    "
#define m_phoenix406			"\nPhoenix 4.06 rev 1.13.1107   "
#define m_gateway_ph			"\nGateway Solo Phoenix 4.0 r6  "
#define m_toshiba       		"\nToshiba                      "
#define m_zenith_ami    		"\nZenith AMI Supervisor/User   "

void acer(void);
void ami_old(void);
void ami_winbios(void);
void ami_winbios2(void);
void ami_unk(void);
void award(void);
void award_medallion(void);
void award6(void);
void compaq(void);
void compaq2(void);
void compaq3(void);
void dtk(void);
void phoenixa08(void);
void ibm(void);
void ibm_thinkpad(void);
void ibm_thinkpad2(void);
void ibm_300(void);
void packardbell(void);
void phoenix(void);
void phoenix2(void);
void phoenix3(void);
void phoenix4(void);
void phoenix5(void);
void phoenix6(void);
void phoenix405(void);
void phoenix406(void);
void gateway_ph(void);
void toshiba(void);
void zenith_ami(void);
void (*tbl_func[])(void)={acer,
	ami_old,ami_winbios,ami_winbios2,ami_unk,
	award, award_medallion, award6,
	compaq,compaq3,compaq2,
	dtk,
	phoenixa08,
	ibm,ibm_thinkpad,ibm_thinkpad2,ibm_300,
	packardbell,
	phoenix,phoenix2,phoenix3,phoenix4,phoenix5,phoenix6,phoenix405,phoenix406,gateway_ph,
	toshiba,
	zenith_ami };
#define nbr_func sizeof(tbl_func)/sizeof(*tbl_func)
int kill_cmos(const int cmos_size);
int load_cmos(const int cmos_size);
int restore_cmos(const int cmos_size,const int choix);
int load_backup(const char*);
int save_backup(const int cmos_size, const char* name);
char get_table_pb(unsigned char);
void generic_packard(unsigned char *value, const int lng,const unsigned char value_stop);

typedef struct s_cmos_f t_cmos_f;
typedef struct s_cmos_l t_cmos_l;
typedef struct s_cmos t_cmos;

struct s_cmos_f
{
  int scancode;
  int position;
  int size;
  int order;
};

struct s_cmos_l
{
  int type;
  char* info;
  t_cmos_l *next;
};

struct s_cmos
{
  char *name;
  t_cmos_l *first;
};


#if defined(linux)||defined(bsd)
static __inline__ void outportb(Bit32u port,byte value)
{
  __asm__ volatile ("outb %0,%1"
		    ::"a" ((char) value), "d"((Bit16u) port));
}

static __inline__ byte inportb(Bit32u port)
{
  byte _v;
  __asm__ volatile ("inb %1,%0"
			 :"=a" (_v):"d"((Bit16u) port));
  return _v;
}
#endif

enum {KEYB_US,KEYB_FR, KEYB_DE};
int keyb=KEYB_US;
byte cmos[TAILLE_CMOS_MAX];

int get32(int position)
{
  return ((cmos[position+1] <<8) | cmos[position]);
}

/* CONVERTION ET FILTRAGE */
byte scan2ascii(byte car)
{
  static const byte tbl_fr[255]=
  { ' ',' ','1','2','3','4','5','6',
    '7','8','9','0',')','=',' ',' ',
    'A','Z','E','R','T','Y','U','I',     /* 10 */
    'O','P',' ','$',' ',' ','Q','S',     /* 18 */
    'D','F','G','H','J','K','L','M',     /* 20 */
    '%','',' ','*','W','X','C','V',
    'B','N',',',';',':','/',' ','*',     /* 30 */
    ' ',' ',' ','f','f','f','f','f',     /* F1 a F10 */
    'f','f','f','f','f',' ',' ','7',     /* 40 */
    '8','9','-','4','5','6','+','1',
    '2','3','0','.',' ',' ','>',' '};    /* 50 */

    static const byte tbl_de[255]=
    { ' ',' ','1','2','3','4','5','6',
      '7','8','9','0','-','=',' ',' ',
      'Q','W','E','R','T','Z','U','I',     /* 10 */
      'O','P',' ','$',' ',' ','A','S',     /* 18 */
      'D','F','G','H','J','K','L',';',     /* 20 */
      '','`',' ','*','Y','X','C','V',
      'B','N','M',',','.','/','"','*',     /* 30 */
      ' ',' ',' ','f','f','f','f','f',     /* F1 a F10 */
      'f','f','f','f','f',' ',' ','7',     /* 40 */
      '8','9','-','4','5','6','+','1',
      '2','3','0','.',' ',' ','>',' '};    /* 50 */

    static const byte tbl_us[255]=
    { ' ',' ','1','2','3','4','5','6',
      '7','8','9','0','-','=',' ',' ',
      'Q','W','E','R','T','Y','U','I',     /* 10 */
      'O','P',' ','$',' ',' ','A','S',     /* 18 */
      'D','F','G','H','J','K','L',';',     /* 20 */
      '','`',' ','*','Z','X','C','V',
      'B','N','M',',','.','/','"','*',     /* 30 */
      ' ',' ',' ','f','f','f','f','f',     /* F1 a F10 */
      'f','f','f','f','f',' ',' ','7',     /* 40 */
      '8','9','-','4','5','6','+','1',
      '2','3','0','.',' ',' ','>',' '};    /* 50 */
/* start */
  if (car<0x58)
  {
    switch(keyb)
    {
      case KEYB_FR:
	return tbl_fr[car];
      case KEYB_DE:
	return tbl_de[car];
      case KEYB_US:
      default:
	return tbl_us[car];
    }
  }
  return ' ';
}

unsigned char filtre(unsigned char lettre)
{
  if ((lettre>=32) && (lettre <=125))
    return lettre;
  else
    switch(lettre)
    {
      case(131):
      case(132):
      case(133):
      case(134):
      case(160):
	return 'a';
      case(130):
      case(136):
      case(137):
      case(138):
	return 'e';
      case(139):
      case(140):
      case(141):
      case(161):
	return 'i';
      case(164):
	return 'n';
      case(147):
      case(148):
      case(149):
      case(162):
	return 'o';
      case(150):
      case(151):
      case(163):
	return 'u';
      case(152):
	return 'y';
      case(142):
      case(143):
	return 'A';
      case(144):
	return 'E';
      case(165):
	return 'N';
      case(153):
	return 'O';
      case(154):
	return 'U';
      default:
	return ' ';
    }
}

char get_table_pb(unsigned char val)
{
  switch(val)
  {
    case 0xE7:
    case 0x3F:
      return 'B';
    case 0xA3:
      return 'C';
    case 0xFB:
      return 'D';
    case 0xBD:
      return 'E';
    case 0xF6:
      return 'F';
    case 0x77:
      return 'G';
    case 0xB9:
      return 'H';
    case 0xCF:
      return 'O';
    case 0xD7:
      return 'T';
  }
  return UNKNOWN_CAR;
}

/* Affichage de caractere */
void printchar(unsigned char car, int scancode)
{
  printf("%c", filtre(scancode?scan2ascii(car):car));
}

/* Affichage de la cmos */

void dumpcmos(const int cmos_size, const int scancode)
{
  int i,j;
  for (i=0;i<cmos_size;i+=0x10)
  {
    printf("\n%02X: ", i);
    for(j=0;j<0x10;j++)
      printf("%02X ", cmos[i+j]);
    printf(" |");
    for(j=0;j<0x10;j++)
      printchar(cmos[i+j],scancode);
    printf("|");
  }
  printf("\n");
}

void aff_hexa(const unsigned char*buffer,const int lng)
{
  int i;
  for(i=0;i<lng;i++)
    printf("%02X ",buffer[i]);
}

/* test et manipulation binaire */
byte parity_test(byte val)
{
  int res=0;
  int i;
  for(i=0;i<8;i++)
  {
    if(val&1)
      res^=1;
    val>>=1;
  }
  return res;
}

Bit8u rcl8(Bit8u num)
{
  return (num<<1)|(num >> 7);
}

Bit8u rcl8n(Bit8u num,int n)
{
  int i;
  Bit8u res=num;
  for(i=0;i<n;i++)
    res=rcl8(res);
  return res;
}

Bit16u rol(Bit16u n)
{
  return (n<<2)| ((n & 0xC000) >> 14);
}
/* Fonctions generiques */
/*
 *    pos_ini, size, meth_parcourt(COPIE, COPIE2)
 * => table
 * => table_de_valeur
 * => pre-verif
 * => decryptage
 * => post-verif
 * => affichage direct ou apres conversion scan2ascii
 *
 * methode_CRC
 *    pos_ini
 * => valeur
 * => brute force
 * */

enum { METH_PARC_NORMAL, METH_PARC_SWAP };
enum { ALGO_AMI_F0, ALGO_AMI, ALGO_AMI_80, ALGO_UNKNOW, ALGO_AWARD, ALGO_AWARD6, ALGO_TOSHIBA, ALGO_ACER, ALGO_PACKARD,ALGO_NONE,ALGO_PHOENIX_DEC,ALGO_PHOENIX_XOR,ALGO_PHOENIX_ADD,ALGO_DTK,ALGO_COMPAQ};
enum { AFF_SCAN,AFF_ASCII};

int build_table(const int position, const int lng, const int meth_parcourt, int *table)
{
  int i;
  switch(meth_parcourt)
  {
    case METH_PARC_NORMAL:
      for(i=0;i<lng;i++)
	table[i]=position+i;
      return 0;
    case METH_PARC_SWAP:
      for(i=0;i<lng;i+=2)
      {
	table[i]=position+i+1;
	if(i+1<lng)
	  table[i+1]=position+i;
      }
      return 0;
  }
  return 1;
}

void table2val(const int *table, unsigned char *value, const int lng)
{
  int i;
  for(i=0;i<lng;i++)
    if(table[i])
      value[i]=cmos[table[i]];
    else
      value[i]=UNKNOWN_CAR;
}

void aff_result(const unsigned char *value, const int lng,const int val_stop,const int mode_aff)
{
  int i;
  putchar('[');
  for(i=0;(i<lng) && (value[i]!=val_stop);i++)
  {
    if(value[i]==UNKNOWN_CAR)
      putchar('?');
    else
      switch(mode_aff)
      {
	case AFF_ASCII:
	  putchar(filtre(value[i]));
	  break;
	case AFF_SCAN:
	  putchar(filtre(scan2ascii(value[i])));
	  break;
	default:
	  printf("Bad display method");
      }
  }
  putchar(']');
}

int generic_ami(unsigned char *value, const int lng, const int methode,const int val_stop)
{
  int pos;
  unsigned char ah,al;
  switch(methode)
  {
    case ALGO_AMI_F0: 	al=value[0] & 0xF0; break;
    case ALGO_AMI: 	al=value[0]; break;
    case ALGO_AMI_80: 	al=0x80; break;
    default:		printf("Bad AMI ALGO"); return 1;
  }
  for(pos=1;pos<lng;pos++)
  {
    int i;
    ah=al;
    al=value[pos];
    if (al==val_stop) break;
    for (i=0;i<=255;i++)
    {
      if (al==ah) break;
      if (parity_test(0xE1&al)) al=(al<<1)|1; else al<<=1;
    }
    al=value[pos];
    if(i>255)
      value[pos-1]=UNKNOWN_CAR;
    else
      value[pos-1]=i;
    value[pos]=val_stop;
  }
  return 0;
}

void generic_acer(unsigned char *value, const int lng,const int val_stop)
{
  int i;
  for(i=0;(i<lng)&&(value[i]!=val_stop);i++)
    value[i]=value[i]>>1;	/* ibm_1 */
  /* shr al,1		D0 E8
   * cmp al,[bx+si]	3A 00
   */
}

void generic_award6(unsigned char *value, const int lng,const int val_stop)
{
  int i;
  for(i=0;(i<lng)&&(value[i]!=val_stop);i++)
    value[i]=rcl8n(value[i],i);
}

void generic_unknown(unsigned char*value, const int lng,const int val_stop)
{
  int i;
  for(i=0;(i<lng)&&(value[i]!=val_stop);i++)
    value[i]=UNKNOWN_CAR;
}

int check_filled(const unsigned char*value, const int lng, const unsigned char filled_value)
{
  int i;
  int etat=0;
  for(i=0;i<lng;i++)
  {
    switch(etat)
    {
      case 0:
	if(value[i]==filled_value)
	  etat++;
	break;
      case 1:
	if(value[i]!=filled_value)
	  return 1;
    }
  }
  return 0;
}

void generic_table(const int *table, const int lng, const int algo,const int val_stop,const int mode_aff);

void generic_basic(const int position, const int lng, const int meth_parcourt,const int algo,const int val_stop,const int mode_aff)
{
#if defined(__MSDOS__) || defined(WIN32)
  int table[10];
#else
  int table[lng];
#endif
  build_table(position,lng,meth_parcourt,table);
  generic_table(table,lng,algo,val_stop,mode_aff);
}

void generic_table(const int *table, const int lng, const int algo,const int val_stop,const int mode_aff)
{
#if defined(__MSDOS__)||defined(WIN32)
  unsigned char value[10];
#else
  unsigned char value[lng];
#endif
  table2val(table,value,lng);
  switch(algo)
  {
    case ALGO_AMI_F0:
    case ALGO_AMI:
    case ALGO_AMI_80:
      generic_ami(value,lng,algo,val_stop);
      break;
    case ALGO_UNKNOW:
      generic_unknown(value,lng,val_stop);
      break;
    case ALGO_ACER:
      generic_acer(value,lng,val_stop);
      break;
    case ALGO_AWARD6:
      generic_award6(value,lng,val_stop);
      break;
    case ALGO_PACKARD:
      check_filled(value,lng,val_stop);
      generic_packard(value,lng,val_stop);
      break;
    case ALGO_NONE:
      break;
    case ALGO_PHOENIX_DEC:
      generic_phoenix_dec(value,lng,val_stop);
      break;
    case ALGO_PHOENIX_XOR:
      generic_phoenix_xor(value,lng,val_stop);
      break;
    case ALGO_PHOENIX_ADD:
      generic_phoenix_add(value,lng,val_stop);
      break;
    case ALGO_DTK:
      generic_dtk(value,lng,val_stop);
      break;
    case ALGO_COMPAQ:
      generic_compaq(value,lng,val_stop);
      break;
    default:
      printf("BAD ALGO ");
      return;
  }
  aff_result(value,lng,val_stop,mode_aff);
}
/* ================================================================= */
int check_crcadd(int position, int size, int pos_crc)
{
  int i;
  int crc=0;
  for(i=position;i<position+size;i++)
    crc+=cmos[i];
  return ((crc & 0xFF) == cmos[pos_crc]);
}

void generic_packard(unsigned char *value, const int lng,const unsigned char value_stop)
{
  int i;
  for(i=1;(i<lng)&&(value[i]!=value_stop);i++) /* Ecrase le "CRC ?" */
  {
    value[i-1]=get_table_pb(value[i]);
    value[i]=value_stop;
  }
}
/* ==================================================== */

void generic_crc(int algo, int position)
{
  switch(algo)
  {
    case ALGO_AWARD:
      brute_award(get32(position));
      break;
    case ALGO_TOSHIBA:
      brute_toshiba(get32(position));
      break;
  }
}

/* Brute force Award */
int awa_pos;
char awa_res[9];

byte brute_awa(Bit16u but, Bit16u somme, byte lng)
{
  byte p;
  static byte const tbl_car[]={'0','1','2','3','4','5','6'};

  if (lng==0)
    return (but==somme);
  else
      for (p=0;p<4;p++)
	  if (brute_awa(but, rol(somme) + tbl_car[p], lng-1))
	    {
	      awa_res[awa_pos++]=tbl_car[p];
	      return 1;
	    }
  return 0;
}

byte brute_award(Bit16u but)
{
  int i;
  byte res;
  awa_pos=0;
  for(i=0;i<9;i++)
    awa_res[i]='\0';
  for (i=1;i<=8;i++)
  {
    res=brute_awa(but, 0,i);
   if (res) break;
  }
#ifndef TEST
  printf("[");
  for (i=awa_pos-1;i>=0;i--) printf("%c", awa_res[i]);
  printf("]");
#endif
  return res;
}

/* Brute force Toshiba */
Bit16u do_tosh(Bit16u valcrc, byte car)
{
    register byte ah,al,dh,dl;
    al=(byte)valcrc;
    ah=valcrc>>8;
    ah^=car;	/* xor ah,[bx] */
    dl=ah;	/* mov dl,ah */
    dl<<=4;	/* shl dl,4 	C0 E2 04 */
    ah^=dl;     /* xor ah,dl 	32 E2 */
    dl=ah;      /* mov dl,ah 	8A D4 */
    dl>>=5;	/* shl dl,5 */
    dl^=ah;	/* xor dl,ah */
    dh=ah;
    ah<<=3;
    ah^=al;
    dh>>=4;
    ah^=dh;
    al=dl;
    return (ah<<8)|al;
}

int tosh_pos;
char tosh_res[11];

byte brute_tosh(Bit16u but, Bit16u valcrc, byte lng)
{
  unsigned int p;
  static byte const tbl_car[]={0x10,0x11,0x12,0x13,0x14,0x20};

  if (lng==0)
  {
    if(valcrc==0)
      valcrc++;
    return (but==valcrc);
  }
  else
  {
    for (p=0;p<sizeof(tbl_car);p++)
      if (brute_tosh(but, do_tosh(valcrc,tbl_car[p]), lng-1))
      {
	tosh_res[tosh_pos++]=tbl_car[p];
	return 1;
      }
  }
  return 0;
}

byte brute_toshiba(Bit16u but)
{
  int i;
  byte res;
  tosh_pos=0;
  if(but==0)
  {
    printf("[KEY floppy]");
    return 1;
  }
  for(i=0;i<10;i++)
    tosh_res[i]='\0';
  for (i=1;i<=10;i++)
  {
    res=brute_tosh(but, 0,i);
   if (res) break;
  }
  if(res)
  {
    putchar('[');
    for (i=tosh_pos-1;i>=0;i--)
      putchar(scan2ascii(tosh_res[i]));
    putchar(']');
  }
  else
    printf("\nEchec");
  return res;
}

void acer()				/* ACER */
{
  printf(m_acer);
  generic_basic(0x27, 7, METH_PARC_NORMAL,ALGO_ACER,0,AFF_SCAN);
}

void ami_old()				/* AMI */
{
  printf(m_ami_old);
  generic_basic(0x37, 1+6, METH_PARC_NORMAL,ALGO_AMI_F0,0,AFF_ASCII);
}

void ami_winbios()
{
  printf(m_ami_winbios);
  generic_basic(0x37, 1+6, METH_PARC_NORMAL,ALGO_AMI,0,AFF_SCAN);
}

void ami_winbios2()
{
  printf(m_ami_winbios2);
  generic_basic(0x37, 1+6, METH_PARC_NORMAL,ALGO_AMI_80,0,AFF_SCAN);
  generic_basic(0x4B, 1+6, METH_PARC_NORMAL,ALGO_AMI_80,0,AFF_SCAN);
  /* setup, Added by Tompa Lorand, 01-apr-2003 */
  generic_basic(0x5f, 1+6, METH_PARC_NORMAL,ALGO_AMI_80,0,AFF_SCAN);

}

void ami_unk()
{
  //  Philippe Biondi <biondi@cartel-securite.fr>
  printf(m_ami_unk);
  generic_basic(0x4d, 1+7, METH_PARC_NORMAL,ALGO_AMI_80,0,AFF_SCAN);
  generic_basic(0x54, 1+7, METH_PARC_NORMAL,ALGO_AMI_80,0,AFF_SCAN);
  // Rajabaz <unknown__14@hotmail.com>
  generic_basic(0x4c, 1+7, METH_PARC_NORMAL,ALGO_AMI_80,0,AFF_SCAN);
  generic_basic(0x53, 1+7, METH_PARC_NORMAL,ALGO_AMI_80,0,AFF_SCAN);
}

/* AMI          @art.fr         CRC+Crypted adm pwd at 38-3F, filled with 00
 *                              user pwd at 0x40-47     */
void zenith_ami()
{
  printf(m_zenith_ami);
  generic_basic(0x38+1, 7, METH_PARC_NORMAL,ALGO_UNKNOW,0,AFF_ASCII);
  putchar(' ');
  generic_basic(0x40+1, 7, METH_PARC_NORMAL,ALGO_UNKNOW,0,AFF_ASCII);
}



				/* AWARD */
void award()
{
  printf(m_award);
  generic_crc(ALGO_AWARD,0x1C);
  generic_crc(ALGO_AWARD,0x60);
  generic_crc(ALGO_AWARD,0x4D);
  printf(m_award);
  generic_crc(ALGO_AWARD,0x63); /* putamadre7@hotmail.com */
  generic_crc(ALGO_AWARD,0x64); /* jedi@ukgateway.net */
  generic_crc(ALGO_AWARD,0x5D); /* Setup YOGESH M <my@myw.ltindia.com> */
}

void award_medallion()
{
/* Pencho Penchev <ppencho@hotmail.com>
   Hewllett Packard Brio system
*/
  printf(m_award_medallion);
  generic_crc(ALGO_AWARD,0x68);	/* supervisor */
  generic_crc(ALGO_AWARD,0x6A); /* user */
  generic_crc(ALGO_AWARD,0x4E); /*  Lewis DH <lewisdh@hotmail.com> */
  generic_crc(ALGO_AWARD,0x71); /*  Lewis DH <lewisdh@hotmail.com> */
}

void award6()
{
  /* Tompa Lorand-Mihaly <tl90248@Linux.SCS.UBBCluj.Ro>, april 2003 */
  printf(m_award6);
  generic_basic(0xE0, 8, METH_PARC_NORMAL,ALGO_AWARD6,0,AFF_ASCII);
}

				/* COMPAQ */
void compaq()
{
  printf(m_compaq);
  generic_basic(0x38, 8, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
}

void compaq2()
{
  printf(m_compaq2);
  generic_basic(0x51, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN); /* setup */
  generic_basic(0x38, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
}


void compaq3()
{
  printf(m_compaq3);
  /* - Luka "The /\/\ighty \/\/izzy" <cd.roma@flashnet.it>
   *   Compaq 5200, August 1998
   */
  generic_basic(0x37, 8, METH_PARC_NORMAL,ALGO_COMPAQ,0,AFF_SCAN);
   /* - Quattrocchi Stefano <S.Quattrocchi@tecnimont.it>
    *   Compaq DeskPro EP Serie 6350/6.4 EA2, May 2001
    */
  generic_basic(0x77, 8, METH_PARC_NORMAL,ALGO_COMPAQ,0,AFF_SCAN);
}


				/* IBM */
void ibm()
{
  printf(m_ibm);
  generic_basic(0x48, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
  generic_basic(0x38, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
}

void ibm_thinkpad()
{
  printf(m_ibm_thinkpad);
  generic_basic(0x38, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);	/* pwd boot */
}

void ibm_thinkpad2()
{
  printf(m_ibm_thinkpad_x20_570_t20);
  generic_basic(0x338, 7, METH_PARC_SWAP,ALGO_NONE,0,AFF_SCAN);
  generic_basic(0x3B8, 7, METH_PARC_SWAP,ALGO_NONE,0,AFF_SCAN);
  printf(m_ibm_thinkpad_560x);
  generic_basic(0xD0, 7, METH_PARC_SWAP,ALGO_NONE,0,AFF_SCAN);
  generic_basic(0xD8, 7, METH_PARC_SWAP,ALGO_NONE,0,AFF_SCAN);
  printf(m_ibm_thinkpad_765_380z);
  generic_basic(0x38, 7, METH_PARC_SWAP,ALGO_NONE,0,AFF_SCAN);
  generic_basic(0x40, 7, METH_PARC_SWAP,ALGO_NONE,0,AFF_SCAN);
}

void ibm_300()
{
  printf(m_ibm_300);
  generic_basic(0x48, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
}

void packardbell()				/* PACKARD BELL */
{
  printf(m_packardbell);
  generic_basic(0x38, 1+7, METH_PARC_NORMAL,ALGO_PACKARD,0xFF,AFF_ASCII);
  putchar(' ');
  generic_basic(0x40, 1+7, METH_PARC_NORMAL,ALGO_PACKARD,0xFF,AFF_ASCII);
}

/* ICI */
void phoenix()				/* PHOENIX */
{
  static const int tbl_phoenix[8]={0x39,0x3C,0x3B,0x3F,0x38,0x3E,0x3D,0x3A};
  byte res[8];
  byte crc=0;
  byte i;
  printf(m_phoenix);
  for (i=0;i<7;i++)
  {
    res[i]=cmos[tbl_phoenix[i]];
    if (res[i]==0) break;
    res[i]=(res[i] ^ 0xF0) + i;
    crc+=res[i];
  }
  if (crc==cmos[tbl_phoenix[7]])
    printf("[%s]", res);
  else
    printf("CRC pwd err");
  generic_table(tbl_phoenix, 7, ALGO_PHOENIX_XOR,0,AFF_ASCII);
}

void phoenix2()
{
  printf(m_phoenix2);
  generic_basic(0x50, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN); /* setup */
  generic_basic(0x48, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
}



void phoenix3()
{ /* Phoenix Bios V1.10 A03 / Dell GXi */
  printf(m_phoenix3);
  if(!check_crcadd(0x1D,7,0x1D+7) || !check_crcadd(0x38,7,0x38+7))
  {
    printf("CRC pwd err");
    return;
  }
  generic_basic(0x1D, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN); /* setup */
  generic_basic(0x38, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
}

void phoenix4()
{
  printf(m_phoenix4);
  generic_basic(0x35, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN); /* user */
}

void generic_phoenix_dec(unsigned char *value, const int lng,const unsigned char value_stop)
{
  int i;
  for(i=0;(i<lng)&&(value[i]!=value_stop);i++)
    value[i]=rcl8n(value[i],i+1);
}

void generic_phoenix_xor(unsigned char *value, const int lng,const unsigned char value_stop)
{
  int i;
  for(i=0;(i<lng)&&(value[i]!=value_stop);i++)
    value[i]=(value[i] ^ 0xF0) + i;
}

void generic_phoenix_add(unsigned char *value, const int lng,const unsigned char value_stop)
{
  int i;
  for(i=0;(i<lng)&&(value[i]!=value_stop);i++)
    value[i]+=0x20;
}


void phoenix5()
{
  printf(m_phoenix5);
  generic_basic(0x35, 7, METH_PARC_NORMAL,ALGO_PHOENIX_DEC,0,AFF_SCAN);
}

void phoenix6()
{
  printf(m_phoenix6);
  if(((cmos[0x60]==0)||(cmos[0x60]==1))&&(cmos[0x61]<=7))
    generic_basic(0x62, cmos[0x61], METH_PARC_NORMAL,ALGO_PHOENIX_ADD,0xFF,AFF_ASCII);
  else
    printf("err");
  /* CRC 32 en 7E
   * 3B-3D => 6A-6C
   * 40 => 6F
   * */
}

void phoenix405()
{
  static const int tbl[8]={0x45,0x52,0x4b,0x4a,0x50,0x4F,0x4D,0x48};
  static const int tbl2[8]={0x4c,0x51,0x49,0x54,0x53,0x47,0x46,0x4E};
  printf(m_phoenix405);
  generic_table(tbl, 8, ALGO_NONE,0,AFF_SCAN);
  generic_table(tbl2, 8, ALGO_NONE,0,AFF_SCAN);
}

void phoenix406()
{
  printf(m_phoenix406);
  generic_basic(0x45, 8, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
}

void dtk()
{
  printf(m_dtk);
  generic_basic(0x38,4,METH_PARC_NORMAL,ALGO_DTK,0,AFF_ASCII);
  generic_basic(0x3B,6,METH_PARC_NORMAL,ALGO_DTK,0,AFF_ASCII);
}

void generic_dtk(unsigned char *value, const int lng,const unsigned char value_stop)
{
  int i;
#if defined(__MSDOS__)||defined(WIN32)
  unsigned char value2[10];
#else
  unsigned char value2[lng];
#endif
  for(i=0;i<lng;i++)
  {
    int b;
    switch(i%4)
    {
      case 0: b=value[(i/4)*3] >> 2; break;
      case 1: b=(value[(i/4)*3] << 4) + (value[(i/4)*3+1]>>4); break;
      case 2: b=((value[(i/4)*3+1] << 2) & 0x3C) + (value[(i/4)*3+2] >> 6); break;
      case 3: b=value[(i/4)*3+2]; break;
    }
    b=b&0x3F;
    if(b==0)
      break;
    if(b<=10)
      value2[i]=b-1+'0';
    else
      value2[i]=b-1+'A';
  }
  for(i=0;i<lng;i++)
    value[i]=value2[i];
}

void generic_compaq(unsigned char *value, const int lng,const unsigned char value_stop)
{
  int i,j;
#if defined(__MSDOS__)||defined(WIN32)
  unsigned char value2[10];
#else
  unsigned char value2[lng];
#endif
  /* Data from
   * - Luka "The /\/\ighty \/\/izzy" <cd.roma@flashnet.it>
   *   Compaq 5200, August 1998
   * - Quattrocchi Stefano <S.Quattrocchi@tecnimont.it>
   *   Compaq DeskPro EP Serie 6350/6.4 EA2, May 2001
   */
  unsigned char tbl_deco[][4]={
    {0x00, 0xDD,0x2F,0x02},	/* 1 */
    {0x80, 0x73,0x13,0x03},	/* 2 */
    {0x00, 0x3A,0x09,0x04},	/* 3 */
    {0x80, 0x94,0x35,0x05},	/* 4 */
    {0x00, 0xE7,0x26,0x06},	/* 5 */
    {0x80, 0x49,0x1A,0x07},	/* 6 */
    {0x00, 0x74,0x12,0x08},	/* 7 */
    {0x80, 0xDA,0x2E,0x09},	/* 8 */
    {0x00, 0xA9,0x3D,0x0A},	/* 9 */
    {0x80, 0x07,0x01,0x0B},	/* 0 */
    {0x00, 0xE8,0x24,0x10},	/* Q */
    {0x80, 0x46,0x18,0x11},	/* W */
    {0x00, 0x35,0x0B,0x12},	/* E */
    {0x80, 0x9B,0x37,0x13},	/* R */
    {0x00, 0xD2,0x2D,0x14},	/* T */
    {0x80, 0x7C,0x11,0x15},	/* Y */
    {0x00, 0x0F,0x02,0x16},	/* U */
    {0x80, 0xA1,0x3E,0x17},	/* I */
    {0x00, 0x9C,0x36,0x18},	/* O */
    {0x80, 0x32,0x0A,0x19},	/* P */

    {0x00, 0x7B,0x10,0x1E},	/* A */
    {0x80, 0xD5,0x2C,0x1F},	/* S */
    {0x00, 0x50,0x1F,0x20},	/* D */
    {0x80, 0xFE,0x23,0x21},	/* F */
    {0x00, 0x8D,0x30,0x22},	/* G */
    {0x80, 0x23,0x0C,0x23},	/* H */
    {0x00, 0x6A,0x16,0x24},	/* J */
    {0x80, 0xC4,0x2A,0x25},	/* K */
    {0x00, 0xB7,0x39,0x26},	/* L */

    {0x00, 0x1E,0x04,0x2C},	/* Z */
    {0x80, 0xB0,0x38,0x2D},	/* X */
    {0x00, 0xC3,0x2B,0x2E},	/* C */
    {0x80, 0x6D,0x17,0x2F},	/* V */
    {0x00, 0xB8,0x3B,0x30},	/* B */
    {0x80, 0x16,0x07,0x31},	/* N */
    {0x00, 0x65,0x14,0x32},	/* M */

    {0x80, 0x62,0x15,0x39},	/*   */
    {0x00, 0x00,0x00,0x00}
  };
  for(i=0;i<lng/4;i++)
  {
    if((value[4*i+0]==0) && (value[4*i+1]==0) && (value[4*i+2]==0) && (value[4*i+3]==0))
    {
      value2[4*i+0]=0x0;
    }
    else
    {
      /* 1 */
      value2[4*i+0]=0x3F;	/* => ? */
      for(j=0;tbl_deco[j][3];j++)
	if(tbl_deco[j][1] == value[4*i+3])
	{
	  if((tbl_deco[j][0] & value[4*i+2]) == tbl_deco[j][0])
	  {
	    value2[4*i+0]=tbl_deco[j][3];
	    break;
	  }
	}
      /* 2 */
      value2[4*i+1]=value[4*i+0]^tbl_deco[j][2];
      //    printf("-%02X-",value2[4*i+1]);
      /* 3 */
      value2[4*i+2]=value[4*i+1]&0x7F;
      /* 4 */
      value2[4*i+3]=value[4*i+2]&0x7F;
    }
  }
  for(i=0;i<lng;i++)
    value[i]=value2[i];
}


void gateway_ph()
{	/* Gateway Solo */
  /*
  int i;
  unsigned int crc=0;
  for(i=0x40;i<0x47;i++)
  {
    crc^=scan2ascii(cmos[i]);
  printf(" %04X ", crc);
  }
  CRC inconnu en 5A et 5C
  */
  printf(m_gateway_ph);
  generic_basic(0x40, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
  generic_basic(0x47, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
}

void phoenixa08()
{
  printf(m_phoenixa08);
  generic_basic(0x23, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
  generic_basic(0x42, 7, METH_PARC_NORMAL,ALGO_NONE,0,AFF_SCAN);
}

void toshiba()
{
  printf(m_toshiba);
  generic_crc(ALGO_TOSHIBA,0x35);
  generic_crc(ALGO_TOSHIBA,0x33);
}


void set_permissions()
{
#ifdef linux
  if (ioperm(PORT_CMOS_0,3*2,IO_READ|IO_WRITE))
  {
    printf("Need to be run as root to access the Cmos.\n");
    exit(1);
  }
#elif defined WIN32
  char OutputBuffer[100];
  char InputBuffer[100];
HANDLE h;
  BOOLEAN bRc;
  ULONG bytesReturned;
  h = CreateFile("\\\\.\\gwiopm", GENERIC_READ, 0, NULL,
					OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if(h == INVALID_HANDLE_VALUE) {
	printf("Couldn't access gwiopm device\n");
	exit(2);
  }
  memset(OutputBuffer, 0, sizeof(OutputBuffer));
  InputBuffer[0]=0x70>>3;
	InputBuffer[1]=0;       /* 0x70 et 0x71 */
	bRc = DeviceIoControl ( h, 
					(DWORD) IOCTL_IOPMD_SET_LIOPM, 
					&InputBuffer, 
					2, 
					&OutputBuffer,
		    sizeof( OutputBuffer),
			&bytesReturned,
					NULL 
					);
	if(bRc!=TRUE)
		printf("Set_LIOPM failed");
//IOCTL_IOPMD_ACTIVATE_KIOPM
	bRc = DeviceIoControl ( h, 
					(DWORD) IOCTL_IOPMD_ACTIVATE_KIOPM, 
					&InputBuffer, 
					2, 
					&OutputBuffer,
		    sizeof( OutputBuffer),
			&bytesReturned,
					NULL 
					);
	if(bRc!=TRUE)
		printf("ACTIVATE_KIOPM failed");
	CloseHandle(h);
#elif defined(bsd)
    cmos_fd = fopen("/dev/io", "r");
    if(cmos_fd==NULL){
       perror("fopen /dev/io failed");
       exit(1);
    }
#endif
}

void unset_permissions()
{
#ifdef linux
  ioperm(PORT_CMOS_0,3*2,0);
#elif defined(bsd)
  fclose(cmos_fd);
#endif
}

byte read_cmos(const int cell);
void write_cmos(const int cell, const byte value);
byte read_cmos(const int cell)
{
  if(cell<128)
  {
    outportb(PORT_CMOS_0,cell);
    return inportb(PORT_CMOS_1);
  }
  if(cell<2*128)
  {
    outportb(PORT_CMOS_2,cell);
    return inportb(PORT_CMOS_3);
  }
#ifndef WIN32
  if(cell<3*128)
  {
    outportb(PORT_CMOS_4,cell);
    return inportb(PORT_CMOS_5);
  }
#endif
  return 0;
}

void write_cmos(const int cell, const byte value)
{
  if(cell<128)
  {
    outportb(PORT_CMOS_0,cell);
    outportb(PORT_CMOS_1,value);
    return;
  }
  if(cell<2*128)
  {
    outportb(PORT_CMOS_2,cell);
    outportb(PORT_CMOS_3,value);
    return;
  }
  if(cell<3*128)
  {
    outportb(PORT_CMOS_4,cell);
    outportb(PORT_CMOS_5,value);
    return;
  }
}

int kill_cmos(const int cmos_size)
{
  int i;
  char car;
  printf("Warning: if the password is stored in an eeprom (notebook), the password won't be erased\n"
         "\n1 - Kill cmos"
	 "\n2 - Kill cmos (try to keep date and time)"
	 "\n0 - Abort"
	 "\nChoice : ");
  fflush(stdout);
  do
   car=toupper(getchar());
  while((car<'0')||(car>'2'));
  fflush(stdout);
  if(car=='0')
    return 1;
  set_permissions();
  for (i=(car=='1'?0:0x10);i<cmos_size;i++)
    write_cmos(i,0);
  unset_permissions();
  printf("\nCmos killed!");
  if(car=='1')
    printf("\nRemember to set date and time");
  return 0;
}

int load_cmos(const int cmos_size)
{
  int i;
  set_permissions();
  for (i=0;i<cmos_size;i++)
    cmos[i]=read_cmos(i);
  unset_permissions();
  return 0;
}

int restore_cmos(const int cmos_size,const int choix)
{
  int i;
  char car='2';
  if(choix)
  {
    printf("\n1 - Restore full cmos"
	  "\n2 - Restore cmos (keep date and time)"
	  "\n0 - Abort"
	  "\nChoice : ");
    fflush(stdout);
    do
    car=toupper(getchar());
    while((car<'0')||(car>'2'));
    printf("%c\n", car);
    fflush(stdout);
    if(car==0)
      return 1;
  }
  set_permissions();
  for (i=(car=='1'?0:0x10);i<cmos_size;i++)
    write_cmos(i,cmos[i]);
  unset_permissions();
  if(car=='1')
    printf("\nRemember to set date and time");
  return 0;
}

int load_backup(const char* name)
{
  FILE *fb;
  unsigned char buffer[TAILLE_BUFFER+1];
  unsigned int taille,i;
  int cmos_size=0;
  fb=fopen(name,"rb");
  if (fb==0)
  {
    printf("\nUnable to read %s\n", name);
    return -1;
  }
  taille=fread(buffer,1, TAILLE_BUFFER,fb);
  fclose(fb);
  if((taille==64)||(taille==128)||(taille==256))
  {
    printf("\nRead a %d byte cmos backup (%s)",taille, name);
    for(i=0;i<taille;i++)
      cmos[i]=buffer[i];
    cmos_size=taille;
  }
  else
  if((taille==64-0x10)||(taille==128-0x10)||(taille==256-0x10))
  {
    printf("\nRead a %d byte cmos backup, first 16 byte skipped",taille);
    for(i=0x10;i<taille;i++)
      cmos[i]=buffer[i-0x10];
    cmos_size=taille+0x10;
  }
  else
  if(taille==0x400+TAILLE_CMOS-0x10)
  {
    printf("\nRead a cmos backup from a SAUVER file");
    for(i=0x10;i<TAILLE_CMOS;i++)
      cmos[i]=buffer[0x400+i-0x10];
    cmos_size=TAILLE_CMOS;
  }
  else
  if(taille==129)
  {
    printf("\nRead a %d byte cmos !BIOS backup (%s)",taille, name);
    for(i=0;i<taille;i++)
      cmos[i]=buffer[i];
    cmos_size=TAILLE_CMOS;
  }
  else
  {
    if(memcmp(buffer,":10000000",9)==0)
    {
      unsigned int pos_file;
      int pos_cmos=0;
      for(pos_file=9;pos_file<taille;)
      {
	char string[3];
	string[0]=buffer[pos_file];
	string[1]=buffer[pos_file+1];
	string[2]=0;
	cmos[pos_cmos++]=(unsigned char)strtol(string,NULL,16);
	if(pos_cmos%16==0)
	{
	  pos_file+=4;
	  if(buffer[pos_file]==0xA || buffer[pos_file]==0xD)
	    pos_file++;
	  if(buffer[pos_file]==0xA || buffer[pos_file]==0xD)
	    pos_file++;
	  pos_file+=9;
	}
	else
	  pos_file+=2;
      }
      cmos_size=pos_cmos-1;
    } else
    if(memcmp(buffer,":08000000",9)==0)
    {
      unsigned int pos_file;
      int pos_cmos=0;
      for(pos_file=9;pos_file<taille;)
      {
	char string[3];
	string[0]=buffer[pos_file];
	string[1]=buffer[pos_file+1];
	string[2]=0;
	cmos[pos_cmos++]=strtol(string,NULL,16);
	if(pos_cmos%8==0)
	{
	  pos_file+=4;
	  if(buffer[pos_file]==0xA || buffer[pos_file]==0xD)
	    pos_file++;
	  if(buffer[pos_file]==0xA || buffer[pos_file]==0xD)
	    pos_file++;
	  pos_file+=9;
	}
	else
	  pos_file+=2;
      }
      cmos_size=pos_cmos-1;
    } else
    if(memcmp(buffer,":06000000",9)==0)
    {
      int pos_file;
      int pos_cmos=0;
      for(pos_file=9;pos_file<taille;)
      {
	char string[3];
	string[0]=buffer[pos_file];
	string[1]=buffer[pos_file+1];
	string[2]=0;
	cmos[pos_cmos++]=strtol(string,NULL,16);
	if(pos_cmos%6==0)
	{
	  pos_file+=4;
	  if(buffer[pos_file]==0xA || buffer[pos_file]==0xD)
	    pos_file++;
	  if(buffer[pos_file]==0xA || buffer[pos_file]==0xD)
	    pos_file++;
	  pos_file+=9;
	}
	else
	  pos_file+=2;
      }
      cmos_size=pos_cmos-1;
    } else
    if(memcmp(buffer,"E2P!Lanc",8)==0)
    {
      taille-=152;
      if(taille>TAILLE_CMOS_MAX)
	taille=TAILLE_CMOS_MAX;
      for(i=0;i<taille;i++)
	cmos[i]=buffer[152+i];
      cmos_size=taille;
    } else
    {
      printf("\nUnknown file format");
      if(taille>TAILLE_CMOS_MAX)
	taille=TAILLE_CMOS_MAX;
      for(i=0;i<taille;i++)
	cmos[i]=buffer[i];
      cmos_size=taille;
    }
  }
  return cmos_size;
}

int save_backup(const int cmos_size, const char* name)
{
  FILE *fb;
  fb=fopen(name,"wb");
  if (fb==0)
  {
    printf("\nUnable to create %s", name);
    return 1;
  }
  if(fwrite(cmos,1, cmos_size,fb)!=cmos_size)
  {
    printf("\nWrite error");
    return 1;
  }
  fclose(fb);
  return 0;
}

#ifdef linux
void award_backdoor()
{
  int i;
  char car;
  FILE *fb;
  fb=fopen("/dev/mem","r");
  if(!fb)
    return ;
  fseek(fb,(0xF000<<4)+0xEC60,SEEK_SET);
  for(i=0;i<8;i++)
  {
    fread(&car,1,1,fb);
    printf("%c",(car<<5)|(car>>5)|(car&0x18));
  }
#ifdef ESSAI
  fseek(fb,(0xF000<<4)+0xFFF0,SEEK_SET);
  for(i=0;i<0x10;i++)
  {
    fread(&car,1,1,fb);
    printf("%c", car);
  }
#endif
  fclose(fb);
}
#endif

/* MAIN PROGRAM */
int main(int argc, char *argv[])
{
  int pos_name=-1;
  int do_dump=0;
  int module_arg=0;
  int cmos_size=TAILLE_CMOS;
  enum {MODE_NORM,MODE_HELP,MODE_LOAD, MODE_SAVE, MODE_KILL, MODE_RESTORE, MODE_RESTORE_FORCE} mode=MODE_NORM;
  printf("\nCmosPwd - BIOS Cracker 4.3, 16 June 2003, Copyright 1996-2003"
	 "\nGRENIER Christophe, grenier@cgsecurity.org"
	 "\nhttp://www.cgsecurity.org/\n");
  {
    int i;
    for(i=1;i<argc;i++)
    {
      if((pos_name==-1)&&((mode==MODE_LOAD)||(mode==MODE_SAVE)||(mode==MODE_RESTORE)||(mode==MODE_RESTORE_FORCE)))
	pos_name=i;
      else
	if(strcmp(argv[i],"/kfr")==0)
	  keyb=KEYB_FR;
	else
	  if(strcmp(argv[i],"/kde")==0)
	    keyb=KEYB_DE;
	  else
	    if(strcmp(argv[i],"/d")==0)
	      do_dump=1;
	    else
	      if(strcmp(argv[i],"/r")==0)
	      {
		if(mode) mode=MODE_HELP; else mode=MODE_RESTORE;
	      }
	      else
		if(strcmp(argv[i],"/R")==0)
		{
		  if(mode) mode=MODE_HELP; else mode=MODE_RESTORE_FORCE;
		}
		else
		  if(strcmp(argv[i],"/l")==0)
		  {
		    if(mode) mode=MODE_HELP; else mode=MODE_LOAD;
		  }
		  else
		    if((strcmp(argv[i],"/w")==0)||(strcmp(argv[i],"/s")==0))
		    {
		      if(mode) mode=MODE_HELP; else mode=MODE_SAVE;
		    }
		    else
		      if(strcmp(argv[i],"/k")==0)
		      {
			if(mode) mode=MODE_HELP; else mode=MODE_KILL;
		      }
		      else
			if(strncmp(argv[i],"/m",2)==0)
			  module_arg=i;
			else
			  mode=MODE_HELP;
      if(mode==MODE_HELP)
	break;
    }
  }
  if((pos_name==-1)&&((mode==MODE_LOAD)||(mode==MODE_SAVE)||(mode==MODE_RESTORE)||(mode==MODE_RESTORE_FORCE)))
  {
    printf("\nPlease choose a cmos backup file\n");
    return 1;
  }
  memset(cmos, 0, sizeof(cmos));
  switch(mode)
  {
    case MODE_HELP:
      printf(
      "\nUsage: cmospwd [/k[de|fr]] [/d]"
      "\n       cmospwd [/k[de|fr]] [/d] /[rlw] cmos_backup_file           restore/load/write"
      "\n       cmospwd /k                                          kill cmos"
      "\n       cmospwd [/k[de|fr]] /m[01]*	execute selected module"
      "\n"
      "\n /kfr french AZERTY keyboard, /kde german QWERTY keyboard"
      "\n /d to dump cmos"
      "\n /m0010011 to execute module 3,6 and 7"
      "\n"
      "\nNB: For Award BIOS, passwords are differents than original, but work."
      "\n");
      return 0;
    case MODE_KILL:
      return kill_cmos(cmos_size);
    case MODE_LOAD:
      if((cmos_size=load_backup(argv[pos_name]))<0)
	return 1;
      break;
    case MODE_RESTORE:
      if((cmos_size=load_backup(argv[pos_name]))<0)
	return 1;
      return restore_cmos(cmos_size,1);
    case MODE_RESTORE_FORCE:
      if((cmos_size=load_backup(argv[pos_name]))<0)
	return 1;
      return restore_cmos(cmos_size,0);
    default:
      if(load_cmos(cmos_size))
	return 1;
      if(mode==MODE_SAVE)
	return save_backup(cmos_size,argv[pos_name]);
      break;
  }
  switch(keyb)
  {
    case KEYB_FR:
      printf("\nKeyboard : FR");
      break;
    case KEYB_DE:
      printf("\nKeyboard : DE");
      break;
    case KEYB_US:
    default:
      printf("\nKeyboard : US");
      break;
  }
  if(module_arg)
  {
    unsigned int i;
    for(i=2;argv[module_arg][i] && (i<nbr_func+2);i++)
    {
      if(argv[module_arg][i]=='1')
	tbl_func[i-2]();
    }
  }
  else
  {
    unsigned int i;
    for(i=0;i<nbr_func;i++)
    {
      if(i==15)
      {
	printf("\nPress a key to continue");
	getchar();
      }
      tbl_func[i]();
    }
  }
  if(do_dump)
  {
    printf("\n\nPress a key to continue\n");
    fflush(stdout);
    getchar();
    printf("\nDump cmos");
    dumpcmos(cmos_size,0);
    printf("\nDump cmos (Scan code convertion)");
    dumpcmos(cmos_size,1);
  }
#if defined(WIN32) || defined(linux)
  printf("\n");
  fflush(stdout);
#endif
#ifdef linux
//  award_backdoor();
#endif
  return 0;
}
