package DOS::ConfigSys;

use warnings;
use strict;

our @ISA = qw< DOS::ConfigSys::Menu >;

sub id     { "menu" }
sub linkid { "menu" }
sub sub_linkid { $_[1] == 0 ? "menu" : $_[0]->SUPER::sub_linkid($_[1]) }

sub as_text {
  my $self = shift;
  local $_;

  my %done;
  my $recurse = sub {
    my ($me, $item) = @_;

    return () if $done{$item}++;
    return ($item) unless $item->isa("DOS::ConfigSys::Menu");
    return ($item, map { $me->($me, $_) } @{ $item->items });
  };

  my $text = join "",
    $self->SUPER::as_text,
    map { $_->as_text }
    sort {
      ($a->isa("DOS::ConfigSys::Menu") && !$b->isa("DOS::ConfigSys::Menu")
	? -1
	: 1) ||
      $a->id cmp $b->id
    }
    map { $recurse->($recurse, $_) }
    @{ $self->items };
}


package DOS::ConfigSys::ID;
our $ID = 0;
sub new { $ID++ }


package DOS::ConfigSys::Menu;

sub new { bless { @_[1..$#_], items => [] } => shift }

sub new_menu     { $_[0]->new_generic("DOS::ConfigSys::Menu",     @_[1..$#_]) }
sub new_item     { $_[0]->new_generic("DOS::ConfigSys::Item",     @_[1..$#_]) }
sub new_text     { $_[0]->new_generic("DOS::ConfigSys::TextItem", @_[1..$#_]) }
sub new_diskitem { $_[0]->new_generic("DOS::ConfigSys::DiskItem", @_[1..$#_]) }

sub new_generic {
  my ($self, $class, @args) = @_;

  push @{ $self->items }, my $item = $class->new(
    @args,
    id => sprintf "i%03d", DOS::ConfigSys::ID->new,
  );

  return $item;
}


sub sub_linkid { sprintf "%ss%03d", $_[0]->id, $_[1] }

sub as_text {
  my $self = shift;
  my $text = "";
  local $_;

  my ($subnum, $itemnum) = (0, 0);
  for(my $i = 0; $i < (@{ $self->items } || 1); $i++) {
    my $item = $self->items->[$i];

    if($itemnum == 0) {
      $text .= sprintf "[%s]\n", $self->sub_linkid($subnum);
      if($subnum == 0) {
	$text .= sprintf "submenu=%s, [Nichts]\n", $self->sub_linkid(0);
      } else {
	$text .= sprintf "submenu=%s, [Zurück]\n", $self->sub_linkid($subnum - 1);
      }
      $itemnum++;
    }

    if($item) {
      $text .= sprintf "%s=%s, %s\n",
	$item->isa("DOS::ConfigSys::Menu") || $item->isa("DOS::ConfigSys::TextItem")
	  ? "submenu"
	  : "menuitem",
	$item->isa("DOS::ConfigSys::TextItem")
	  ? $self->sub_linkid($subnum)
	  : $item->linkid,
	$item->title;
      $itemnum++;
    }

    if($itemnum == 8 and $i < $#{ $self->items }) {
      $text .= sprintf "submenu=%s, [Weiter]\n", $self->sub_linkid($subnum + 1);
      $subnum++;
      $itemnum = 0;
    }
  }

  return $text;
}

sub id    : lvalue { $_[0]->{id}        }
sub linkid         { $_[0]->id . "s000" }
sub title : lvalue { $_[0]->{title}     }
sub items : lvalue { $_[0]->{items}     }


package DOS::ConfigSys::Item;

sub new { bless { @_[1..$#_] } => shift }

sub as_text {
  my $self = shift;

  return join "",
    "[" . $self->linkid . "]\n",
    $self->install_hook ? "install=" . $self->install_hook . "\n" : "",
    "shell=" . $self->shell . "\n";
}

sub id    : lvalue { $_[0]->{id}        }
sub linkid         { $_[0]->id          }
sub title : lvalue { $_[0]->{title}     }
sub install_hook : lvalue { $_[0]->{install_hook} }
sub shell        : lvalue { $_[0]->{shell}        }


package DOS::ConfigSys::DiskItem;

sub new { bless { @_[1..$#_] } => shift }

sub as_text {
  my $self = shift;

  return sprintf <<EOF, $self->linkid, $self->disk, $self->file;
[%s]
shell=a:\\c.com /k a:\\r %d %s
EOF
}

sub id     : lvalue { $_[0]->{id}   }
sub linkid          { $_[0]->id     }
sub disk   : lvalue { $_[0]->{disk} }
sub file   : lvalue { $_[0]->{file} }
sub title           { sprintf "[%02d] %s", $_[0]->disk, $_[0]->{title} }


package DOS::ConfigSys::TextItem;

sub new { bless { @_[1..$#_] } => shift }

sub as_text { "" }

sub id    : lvalue { $_[0]->{id}    }
sub title : lvalue { $_[0]->{title} }


unless(caller) {
  my $sys  = DOS::ConfigSys->new;
  my $menu = $sys->new_menu(title => "Amenu");
  $menu->new_menu(title => "A1menu");
  $menu->new_menu(title => "A2menu")->new_menu(title => "A2Amenu");
  my $m = $menu->new_menu(title => "A3menu");
  $m->new_item(title => "A3Aitem", shell => "a.com", install_hook => 3);
  $m->new_item(title => "A3Bitem", shell => "b.com", install_hook => 4);
  $m->new_text(title => "A3Ctext");
  $m->new_diskitem(title => "A3Ddiskitem", command => "a.exe", disk => 3);
  $menu->new_menu(title => "A4menu");
  $menu->new_menu(title => "A5menu");
  $menu->new_menu(title => "A6menu");
  $menu->new_menu(title => "A7menu");
  $menu->new_menu(title => "A8menu");
  print $sys->as_text;
}

1;
