package DOS::MenuBatch;

use warnings;
use strict;

our @ISA = qw< DOS::MenuBatch::Menu >;

sub id     { "i" }
sub linkid { "i" }
sub sub_linkid { $_[1] == 0 ? "i" : $_[0]->SUPER::sub_linkid($_[1]) }
sub title { "Main Menu" }

sub tmpl { <<'EOF' }
@echo off
goto %%GLABEL%%
:choose
echo @SET GLABEL=i > 0.bat
echo @menu >> 0.bat
echo @menu >> 1.bat
echo @menu >> 2.bat
echo @menu >> 3.bat
echo @menu >> 4.bat
echo @menu >> 5.bat
echo @menu >> 6.bat
echo @menu >> 7.bat
echo @menu >> 8.bat
echo @menu >> 9.bat
set PROMPT=Select: 
goto end
%s
:end
EOF

sub as_text {
  my $self = shift;
  local $_;

  my %done;
  my $recurse = sub {
    my ($me, $item) = @_;

    return () if $done{$item}++;
    return ($item) unless $item->isa("DOS::MenuBatch::Menu");
    return ($item, map { $me->($me, $_) } @{ $item->items });
  };

  my $text = sprintf $self->tmpl, join "",
    $self->SUPER::as_text,
    map { $_->as_text }
    map { $recurse->($recurse, $_) }
    @{ $self->items };
}


package DOS::MenuBatch::ID;
our $ID = 0;
sub new { $ID++ }


package DOS::MenuBatch::Menu;

sub new { bless { @_[1..$#_], items => [] } => shift }

sub new_menu     { $_[0]->new_generic("DOS::MenuBatch::Menu",     @_[1..$#_]) }
sub new_item     { $_[0]->new_generic("DOS::MenuBatch::Item",     @_[1..$#_]) }
sub new_text     { $_[0]->new_generic("DOS::MenuBatch::TextItem", @_[1..$#_]) }
sub new_diskitem { $_[0]->new_generic("DOS::MenuBatch::DiskItem", @_[1..$#_]) }

sub new_generic {
  my ($self, $class, @args) = @_;

  push @{ $self->items }, my $item = $class->new(
    @args,
    id => sprintf "i%04d", DOS::MenuBatch::ID->new,
  );

  return $item;
}


sub sub_linkid { sprintf "%s%03d", $_[0]->id, $_[1] }

sub write_goto {
  my ($self, $num, $linkid) = @_;

  return sprintf
    "echo \@SET GLABEL=%s > %d.bat\n",
    $linkid, $num;
}

sub as_text {
  my $self = shift;
  my $text = "";
  local $_;

  my ($subnum, $itemnum) = (0, 0);
  for(my $i = 0; $i < (@{ $self->items } || 1); $i++) {
    my $item = $self->items->[$i];

    if($itemnum == 0) {
      $text .= sprintf ":%s\n", $self->sub_linkid($subnum);
      $text .= sprintf "cls\necho -- %s\n", $self->title;
      if($subnum == 0) {
	$text .= "echo 1. [Nichts]\n" . $self->write_goto(1 => $self->sub_linkid($subnum));
      } else {
	$text .= "echo 1. [Zurück]\n" . $self->write_goto(1 => $self->sub_linkid($subnum - 1));
      }
      $itemnum++;
    }

    if($item) {
      $text .= sprintf "echo %d. %s\n%s",
	$itemnum + 1, $item->title,
	$self->write_goto($itemnum + 1 => $item->linkid);
      $itemnum++;
    }

    if($itemnum == 8) {
      if($i < $#{ $self->items }) {
	$text .= "echo 9. [Weiter]\n" . $self->write_goto(9 => $self->sub_linkid($subnum + 1));
	$subnum++;
      }
      $text .= "goto choose\n";
      $itemnum = 0;
    }
  }
  $text .= "goto choose\n";

  return $text;
}

sub id    : lvalue { $_[0]->{id}       }
sub linkid         { $_[0]->id . "000" }
sub title : lvalue { $_[0]->{title}    }
sub items : lvalue { $_[0]->{items}    }


package DOS::MenuBatch::Item;

sub new { bless { @_[1..$#_] } => shift }

sub as_text {
  my $self = shift;

  return sprintf ":%s\n%s\n", $self->linkid, $self->shell;
}

sub id    : lvalue { $_[0]->{id}        }
sub linkid         { $_[0]->id          }
sub title : lvalue { $_[0]->{title}     }
sub shell : lvalue { $_[0]->{shell}     }


package DOS::MenuBatch::DiskItem;

sub new { bless { @_[1..$#_] } => shift }

sub as_text {
  my $self = shift;

  return sprintf ":%s\nreader.bat %d %s\n", $self->linkid, $self->disk, $self->file;
}

sub id     : lvalue { $_[0]->{id}   }
sub linkid          { $_[0]->id     }
sub disk   : lvalue { $_[0]->{disk} }
sub file   : lvalue { $_[0]->{file} }
sub title           { sprintf "[%02d] %s", $_[0]->disk, $_[0]->{title} }


package DOS::MenuBatch::TextItem;

sub new { bless { @_[1..$#_] } => shift }

sub as_text { "" }

sub id    : lvalue { $_[0]->{id}    }
sub title : lvalue { $_[0]->{title} }


unless(caller) {
  my $sys  = DOS::ConfigSys->new;
  my $menu = $sys->new_menu(title => "Amenu");
  $menu->new_menu(title => "A1menu");
  $menu->new_menu(title => "A2menu")->new_menu(title => "A2Amenu");
  my $m = $menu->new_menu(title => "A3menu");
  $m->new_item(title => "A3Aitem", shell => "a.com", install_hook => 3);
  $m->new_item(title => "A3Bitem", shell => "b.com", install_hook => 4);
  $m->new_text(title => "A3Ctext");
  $m->new_diskitem(title => "A3Ddiskitem", command => "a.exe", disk => 3);
  $menu->new_menu(title => "A4menu");
  $menu->new_menu(title => "A5menu");
  $menu->new_menu(title => "A6menu");
  $menu->new_menu(title => "A7menu");
  $menu->new_menu(title => "A8menu");
  print $sys->as_text;
}

1;
