#!/bin/sh

# -A : Chroot() fuer alle User ausser root
# -b : Startet den standalone Server im Hintergrund (daemonize).
# -c : maximale Anzahl der Clients an, die gleichzeitig verbunden sein koennen
# -C : max Verbindungen pro IP
# -E : Erlaubt es Benutzern, sich ausschliesslich authentifiziert einzuloggen
# -H : Hostname nicht aufloesen
# -k : erbietet den Upload, wenn Partition mehr als Prozentzahl belegt
#      -k 0: verbietet jeden upload
# -I : timeout in Minuten
# -p : first:last Port, die benutzt werden sollen
# -Z : verbiete Operationen wie chmod 000
# -R : verbiete alle chmod-aktionen

if [ "$1" = "start" ]; then
	echo Starting pure-ftpd... >&2
	/usr/sbin/pure-ftpd -A -b -B -c 4 -C 10 -E -H -k 0 -l puredb:/etc/pure-ftpd/pureftpd.pdb -I 5 -p 20000:20050 -Z -R -O w3c:/var/log/pureftpd.log
elif [ "$1" = "stop" ]; then
	echo Stopping pure-ftpd... >&2
	killall pure-ftpd
else
	echo "Usage: $0 start|stop" >&2
	exit 1
fi
