proc setupCanvas {} { 

catch {destroy .c} 

canvas .c 

pack .c 

# create chairs 

foreach i { 100 130 160 190 } {

.c create rect $i 100 [expr $i+20] 120 \
-fill red -tags {chair furniture}

}

# setup Chair behavior 

.c bind chair <Enter> {.c itemconfigure current -fill blue}

.c bind chair <Leave> {.c itemconfigure current -fill red}


#create Table 

.c create oval 20 20 100 150 -fill pink \
-tags {table rotatable furniture}

# setup Table behavior 

.c bind table <Enter> {.c itemconfigure current -fill skyblue}

.c bind table <Leave> {.c itemconfigure current -fill pink}

#create Couch 

.c create rect 20 200 200 250 -fill orange \
-tags {couch rotatable furniture}

# setup Couch behavior 

.c bind couch <Enter> {.c itemconfigure current -fill green}

.c bind couch <Leave> {.c itemconfigure current -fill orange}


# setup 'rotatable' behavior

.c bind rotatable <Button-2> rotate

# setup Furniture behavior

.c bind furniture <Button-1> {

set curX %x 

set curY %y 

}

.c bind furniture <Button1-Motion> {

.c move current [expr (%x-$curX)] [expr (%y-$curY)]

set curX %x; set curY %y

}

}


proc rotate {} { 

set r [.c find withtag current]

set coords [.c coords $r]

set x2 [expr ([lindex $coords 2] - [lindex $coords 0]) / 2]

set y2 [expr ([lindex $coords 3] - [lindex $coords 1]) / 2]

set xc [expr [lindex $coords 0] + $x2]

set yc [expr [lindex $coords 1] + $y2]

.c coords $r [expr $xc - $y2] \

[expr $yc - $x2] \

[expr $xc + $y2] \

[expr $yc + $x2] 

}

setupCanvas 

bind . <Control-l> setupCanvas

wm title . "Furniture Arranger"
