#!/usr/bin/perl -w

use warnings; use strict;
use List::Util 'shuffle';

my $nums = 2;
my @names = shuffle(<lektion??-??-1.txt>);
my @files = (@names[1..$nums]);

print "The following files I will ask you:\n@files\n\nPlease stand by.\n\n";
<STDIN>;

foreach my $file (@files) {
	print "Select $file (latin)\n";
	my @tokens = split '\.', $file;
	system("./lateinlearner > ./$tokens[0]-" . time() . ".prot");
  if(open(LOGFILE, ">>lateinwiederholer.log")) {
    print LOGFILE time() . ": $tokens[0]-" . time() . ".prot (from $file)\n";
    close LOGFILE;
  } else {
    warn "Couldnt open logfile: $!\n";
  }
}

foreach my $file (@files) {
	print "Select $file (deutsch)\n";
	my @tokens = split '\.', $file;
	$tokens[0] =~ s/-1/-2/g;
	system("./lateinlearner > ./$tokens[0]-" . time() . ".prot");
  if(open(LOGFILE, ">>lateinwiederholer.log")) {
    print LOGFILE time() . ": $tokens[0]-" . time() . ".prot (from $file)\n";
    close LOGFILE;
  } else {
    warn "Couldnt open logfile: $!\n";
  }
}

