#!/usr/bin/perl

use warnings;
use strict;

package MyCGI;

use POSIX ("strftime");

our %CGIinputs;
our %CGIcookies;

sub init {
	my $query_string;
	if ($ENV{QUERY_STRING}) { # GET-Request
		$query_string = $ENV{QUERY_STRING};
	} else { # POST
		read STDIN, $query_string, $ENV{CONTENT_LENGTH};
	}
	%CGIinputs = split /[=&]/, $query_string;
	$CGIinputs{$_} =~ s/\+/ /g for keys %CGIinputs;
	$CGIinputs{$_} =~ s/%([0-9A-Fa-f]{2})/chr(hex($1))/eg for keys %CGIinputs;

	my $raw_cookies = $ENV{HTTP_COOKIE} || $ENV{COOKIE} || "";
	%CGIcookies = split /[=&;]/, $raw_cookies;
}

sub param {
	my $name = shift;
	if (not defined $name) {
		return keys %CGIinputs;
	} else {
		return $CGIinputs{$name};
	}
}

sub cookie {
#	my %args = @_;
	if (@_ == 1) { # Query
		return $CGIcookies{(shift)};
	} else {
		my %args = @_;
		my $expires = $args{-expires} ||= "+1h";
		if ($expires =~ /^\+([0-9]+)([dhmy])$/) {
			my $num = $1;
			$num *= 60 if ($2 eq "m");
			$num *= 3600 if ($2 eq "h");
			$num *= 86400 if ($2 eq "d");
			$num *= 86400*365.25 if ($2 eq "y");
			$expires = time + $num;
		}
		return "Set-Cookie: $args{-name}=$args{-value}; path=/; expires=" .
			strftime(
				"%a, %d-%b-%Y %H:%M:%S GMT",
				localtime($expires)
			) . "\n";
	}
}

1;
