#!/usr/bin/perl -w

use warnings;
use strict;

package Datei;
use Text::Tabs;
sub new { 
	my $proto = shift; my $class = ref $proto || $proto;

	my $self      = {};
	$self->{sym}  = shift;
	$self->{real} = (shift) . $self->{sym};
	$self->{dir}  = -d "$self->{real}";
	$self->{type} = "text";
	if    ($self->{sym} =~ /\.txt$/)   { $self->{type} = "text" }
	elsif ($self->{sym} =~ /\.html?$/) { $self->{type} = "html" }

	bless $self, $class; return $self;
}
sub getRaw {
	my $self = shift; my $ret;
	open my $file, $self->{real} or die $!;
		undef $/;
		$ret = <$file>;
	close $file; return $ret;
}
sub getHTML {
	my $self = shift; my $ret;
	die "HTML request on directory ($self->{sym})!" if $self->{dir};
	$ret = $self->getRaw;
	$ret =~ s/&/&amp;/g; $ret =~ s/</&lt;/g; $ret =~ s/>/&gt;/g;
	$ret = expand $ret;
	my $x = shift;
	$ret =~ s/  / &nbsp;/g if (defined $x and $x ne "nobr");
	$ret =~ s/$/<br \/>/mg unless(defined $x and $x eq "nobr");
	return $ret;
}
sub getText {
	my $self = shift; my $ret;
	return "" if ($self->{dir} or $self->{type} ne "text");
	return $self->getRaw . "\n";
}
sub getMixed {
	my $self = shift;
	return $self->{type} eq "html" ? $self->getRaw : $self->getHTML(shift);
}

package HTMLQuote;
sub new { 
	my $proto = shift; my $class = ref $proto || $proto;

	my $self          = {};
	# Einlesen
	$self->{p}        = shift;
	$self->{text}     = join(($self->{p} =~ /br/ ? "<brx/>" : ""), @_);

	$self->{text}     =~ s/$_->[0]/$_->[1]/g for (["&" => "&amp;"],
																								["<" => "&lt;"],
																								[">" => "&gt;"],
																								($self->{p} =~ /nbsp/
																									? ["  " => " &nbsp;"]
																									: [""   => ""]));
	$self->{text}     =~ s/&lt;brx\/&gt;/<br \/>/g;
	$self->{text}     =~ s/\r//g;

	bless $self, $class; return $self;
}
sub print { my $self = shift; return $self->{text}; }

package HTTPQuote;
sub new { 
	my $proto = shift; my $class = ref $proto || $proto;

	my $self          = {};
	# Einlesen
	$self->{p}        = shift;
	$self->{p}        =~ s/(.)/"%" . unpack("H*", $1)/eg;

	bless $self, $class; return $self;
}
sub print { my $self = shift; return $self->{p}; }

1;
