#!/usr/bin/perl -w

package MyTemplate;

use warnings;
use strict;

sub new { 
	my $proto = shift; my $class = ref $proto || $proto;

	my $self      = {};
	# Einlesen
	$self->{file}     = shift;
	$self->{tag}      = shift;
	$self->{add}      = shift;
	$/ = "\n";
	open my $file, $self->{file} or die "$self->{file}: $!";
		my $status = 0;
		for (<$file>) {
			next if ($status == 0 and not /^__$self->{tag}__/);
			$status++;
			next if ($status == 1);
			last if ($status >= 1 and /^__[^_]+__/);
			$self->{template} .= $_;
		}
	close $file;
	undef $/;
	
	if (defined $self->{add} and $self->{add}) {
		$self->{template} =~ s/\[WhenAdd\]((.|\n)*)\[\/WhenAdd\]/$1/mg;
		$self->{template} =~ s/\[WhenNotAdd\](.|\n)*\[\/WhenNotAdd\]//mg;
	} else {
		$self->{template} =~ s/\[WhenNotAdd\]((.|\n)*)\[\/WhenNotAdd\]/$1/mg;
		$self->{template} =~ s/\[WhenAdd\](.|\n)*\[\/WhenAdd\]//mg;
	}
	$self->{template} =~ s/\[IfEval\|([^\|]+)\|\]((.|\n)*)\[\/IfEval\]/eval($1) ?  $2 : ""/meg;
	$self->{template} =~ s/\[Eval\|([^\|]+)\|\]/eval($1)/meg;

	bless $self, $class; return $self;
}
sub substitute {
	my $self = shift; my %what = @_;
	
	$self->{template} =~ s/\[$_\]/$what{$_}/g for (keys %what);
	
	return $self;
}
sub print {
	my $self = shift;
	return $self->{template};
}

1;
