#!/usr/bin/perl -w

package MyUserTracking;

use warnings;
use strict;

use MyTemplate;

sub new {
	my $proto = shift; my $class = ref($proto) || $proto;
	my $self  = {};
	my %args  = @_;

	%{ $self }       = %args;
	$self->{records} = {};

	bless $self, $class;
	return $self;
}

sub _read {
	my $self = shift;

	if (defined %{$self->{records}}) {
		return %{$self->{records}};
	}
	
	my %records;
	system("/bin/touch", $self->{logfile}) unless (-f "$self->{logfile}");
	open my $file, $self->{logfile} or die "SID-Konfigurationseinstellung berprfen: $self->{logfile} ==> $!";
		$/ = "\n";
		for (<$file>) {
			chomp(my @r = split /\|/, $_);
			my $id = shift @r;
			$records{$id} = {@r};
		}
	close $file;
	$self->{records} = {%records};

	return %records;
}

sub _write {
	my $self    = shift;

	$self->{records} = {@_};
}

sub store {
	my $self = shift;
	my %args = @_;
	chomp(%args);
	for (keys %args) {
		delete $args{$_} if ($args{$_} eq "none");
	}
	
	my %records = $self->_read;
	
	$records{$self->{sid}}->{count}++;
	$records{$self->{sid}}->{$_} = $args{$_} for (keys %args);
	$records{$self->{sid}}->{$_} =~ s/\|/(bar)/g
		for (keys %{ $records{$self->{sid}} });

	$self->_write(%records);
}

sub load {
	my $self = shift;

	my %records = $self->_read;

	return $records{$self->{sid}}->{(shift)};
}

sub finish {
	my $self = shift;
	
	my %records = $self->_read;
	
	open my $file, ">" . $self->{logfile} or die "SID-Konfigurationseinstellung berprfen!";
		print $file join("|", $_, %{ $records{$_} }) . "\n"
			for (keys %records);
	close $file;
}

sub stats {
	my $self = shift;
	my $sort = shift; $sort ||= "sid";

	my %records = $self->_read;

	my @data   = map { { sid => $_, %{ $records{$_} } } } sort { $records{$b}->{$sort} <=> $records{$a}->{$sort} } keys %records;
	$_->{visit} = scalar localtime $_->{visit} for (@data);
	$_->{sid}   = scalar localtime $_->{sid}   for (@data);
	
	my @fields = sort { $b cmp $a } keys %{ $data[0] };

	my %html;
	$html{head} .= MyTemplate->new($self->{template}, "STATS-COLUMNS")->substitute(
		Field => $_
	)->print for (@fields);
	foreach my $date (@data) {
		$html{rows} .= MyTemplate->new($self->{template}, "STATS-ROWS")->substitute(
			Values => join "", map {
				MyTemplate->new($self->{template}, "STATS-COLUMN")->substitute(
					Value => $date->{$_}
				)->print
			} @fields
		)->print;
	}
	
	return MyTemplate->new($self->{template}, "STATS")->substitute(
		Columns => $html{head},
		Rows    => $html{rows}
	)->print;
}

1;
