#!/usr/bin/perl -w

use warnings;
use strict;

use CGI qw/param cookie/;
use CGI::Carp 'fatalsToBrowser';
use Text::Tabs;

our %cmd = qw(dos2unix /usr/bin/dos2unix
							genuine /usr/bin/genuine
							latex /usr/bin/latex
							dvips /usr/bin/dvips
							ps2pdf /usr/bin/ps2pdf
							tar /bin/tar
							rm /bin/rm);

our ($passwort, $pfad) = ("pass", "/tmp/myCMS");
our $template = "$pfad/template.html";

our (%subst, %param);
our ($loggedin, $binary) = (0, "");

##############################################################################
# Binding
##############################################################################
$param{$_} = param($_) for param();
$param{$_} =~ s/%([0-9A-Fa-f]{2})/chr(hex($1))/eg for keys %param;
unless(defined $param{action}) {
	$param{action} = "show";
	$param{what} = "/";
}
$param{what} =~ s/%20/ /g;

##############################################################################
# Nice
##############################################################################
$subst{Zeit} = scalar localtime;
$subst{LastChanged} = scalar localtime;
$subst{Header} = "";
$subst{What} = $param{what};
my $tpfad = "";
$subst{Pfad} .= "<a href='mycms.pl?action=show&what=$_->[0]'>$_->[1]</a> :: "
	for(
		map {
			$_ ||= "/";
			-d "$pfad$tpfad$_" and $_ .= "/";
			s/\/\/$/\//;
			$tpfad .= "$_";
			[ $tpfad, $_ ];
		} split "/", $subst{What}
	);
$subst{Pfad} ||= "<a href='mycms.pl?action=show&what=/'>/</a> :: "; 
$subst{Pfad} .= $_ ne $param{action}
	? "<a href='mycms.pl?action=$_&what=$param{what}'>$_</a> "
	: "$_ "
		for qw{show pdf edit del};
my $twhat = " " . $param{what};
$subst{Titel} = "$param{action} :: " . [reverse split "/", $twhat]->[0];
$subst{Titel} .= "/" if $subst{Titel} eq "$param{action} ::  ";

$loggedin = (defined cookie("uid") and cookie("uid") eq $passwort);
$subst{Header} .= "Set-Cookie: " .
	cookie(-name => "uid", -value => $passwort, -expires => "+10m") . "\n"
		if $loggedin;

$subst{LoggedIn} = "<a href='mycms.pl?action=loginout'>" .
	($loggedin ? "Eingeloggt" : "Ausgeloggt") .
	"</a>";

##############################################################################
sub my_low_level_die {
##############################################################################
	$subst{Text} = shift;
	output();
}

##############################################################################
sub mydie {
##############################################################################
	if(	(($param{what} =~ /^[\/a-zA-Z0-9_, \.\-:%()\[\]]+(\.txt)?$/ or
				$param{what} eq "new") and
			 (not defined $param{new_what} or
			 	$param{new_what} =~ /^[\/a-zA-Z0-9_, \.\-:%()\[\]]+(\.txt)?$/)) or
		 		$param{action} eq "loginout") {
		# Grant. ;-)
	} else {
		my_low_level_die("<strong>N</strong>ice <strong>T</strong>ry!");
	}
}
mydie();

##############################################################################
sub get_files {
##############################################################################
	my $p = shift;
	$p =~ s/\/$//;
	map {
		[
			(scalar grep { /\// } split "", $_->[2]) -
				(substr($_->[2], -1) eq "/" ? 1 : 0),
			$_->[2]
		]
	}
		sort {
			$a->[0] <=> $b->[0] ||
			$a->[1] <=> $b->[1] ||
			$a->[2] cmp $b->[2]
		}
			map {
				$_ =~ s/^delme//;
				-d "$pfad$_" and $_ .= "/";
				my $o = $_;
				s/([0-9]+)//; my $a = $1; $a = 0 if not defined $a;
				/()/;
				s/([0-9]+)//; my $b = $1; $b = 0 if not defined $b or $b eq '';
				[ 0+$a, 0+$b, $o ];
			}
				split "\n",
					(-d $p
						? `find '$p' -print | sed -e 's+^$p+delme+'`
						: `find '$p' -print`);
	# ;-)
}

##############################################################################
sub show {
##############################################################################
	if(-d "$pfad$param{what}") {
		my ($ACT, $NEW, $WAN) = 0 .. 2;
		my @level = (0) x 3;
		$level[$WAN] = grep { /\// } split "", $param{what};

		my @files = get_files($pfad);

		$subst{Text} = "<ul>";
		for(@files) {
			$level[$NEW] = $_->[0];
			if($level[$NEW] >= $level[$WAN]) {
				my $trimmed = $_->[1];
				$trimmed =~ s/\/[^\/]*\/?$//;
				$trimmed .= "/";
				if($trimmed ne $param{what}) {
					next;
				}
			}

			while($level[$ACT] < $level[$NEW]) {
				$subst{Text} .= "<ul>";
				$level[$ACT]++;
			}
			while($level[$ACT] > $level[$NEW]) {
				$subst{Text} .= "</ul>";
				$level[$ACT]--;
			}
			
			my $show = $_->[1];
			$show =~ /\/([^\/]*\/?)$/;
			$show = $1;
			$show ||= "/";
			$subst{Text} .= "<li class='" .
				($_->[1] eq $param{what} ? "hi" : "nohi") .
				"'><a href='mycms.pl?action=show&what=$_->[1]'>$show</a> " .
				"<span class='flags_active'>" .
					"[<a href='mycms.pl?action=pdf&what=$_->[1]&type=raw'>RAW</a>] " .
					"[<a href='mycms.pl?action=pdf&what=$_->[1]&type=pdf'>PDF</a>] " .
				"</span>" .
				"<span class='flags_" .
				($loggedin ? "active" : "inactive") .
				"'>" .
					"[<a href='mycms.pl?action=edit&what=$_->[1]'>EDIT</a>] " .
					"[<a href='mycms.pl?action=del&what=$_->[1]'>DEL</a>] " .
					(substr($_->[1], -1) eq "/" ? "[<a href='mycms.pl?action=edit&what=new&new_what=$_->[1]Datei'>NEW</a>] " : "") .
					(substr($_->[1], -1) eq "/" ? "[<a href='mycms.pl?action=mkdir&what=$_->[1]Neuer_Ordner'>MKDIR</a>] " : "") .
				"</span>" .
				"</li>\n";
		}
		$subst{Text} .= "</ul>" while(0 < $level[$ACT]--);
		$subst{Text} .= "</ul>";
	} else {
		$subst{Text} = "<code>";
		open my $filename, "$pfad$param{what}" or my_low_level_die("$!");
			for(<$filename>) {
				s/&/&amp;/g; s/</&lt;/g; s/>/&gt;/g; s/"/&quot;/g;
				# Tabulatoren...
				$_ = expand $_;
				s/ /&nbsp;/g;
				$subst{Text} .= $_ . "<br />";
			}
#			$subst{Text} =~ s/\n\n/<br \/><br \/>/g;
			$subst{LastChanged} = scalar localtime [stat($filename)]->[9];
		close($filename);
		$subst{Text} .= "</code>";
	}
}
##########################################
sub need_login {
##########################################
	my_low_level_die "<a href='mycms.pl?action=loginout&old_action=$param{action}&old_what=$param{what}'>Login</a> erforderlich.";
}
##########################################
sub edit {
##########################################
	unless($loggedin) {
		need_login;
	} else {
		if($param{what} ne "new") {
			if(-d "$pfad$param{what}") {
				my_low_level_die("<a href='mycms.pl?action=show&what=$param{what}'>$param{what}</a> " .
					"ist ein Verzeichnis!");
			}
			if($param{edit}) {
				$param{new_what} ||= $param{what};
				unlink "$pfad$param{what}" or my_low_level_die("$!")
					if($param{new_what} ne $param{what} and -f "$pfad$param{what}");
				open my $filename, ">$pfad$param{new_what}" or my_low_level_die("$!");
					$param{edit} =~ s/\r//g; # stupid Micro$oft Window$
					print $filename $param{edit};
				close $filename;
				$subst{Text} = "$param{new_what} wurde " .
					"<a href='mycms.pl?action=show&what=$param{new_what}'>aktualisiert</a>.";
			} else {
				open my $filename, "$pfad$param{what}" or my_low_level_die("$!");
					my $text = join "", <$filename>;
				close $filename;
				$subst{Text} = "<code><form action='mycms.pl' action='post'>" .
					"<input type='text' name='new_what' value='$param{what}' /><br />" .
					"<textarea name='edit' rows='34' cols='80' class='code'>$text</textarea><br />" .
					"<input type='hidden' name='action' value='edit' />" .
					"<input type='hidden' name='what' value='$param{what}' />" .
					"<input type='submit' value='Abschicken!' />" .
					"</form></code>";
			}
		} else {
			$param{new_what} ||= "/Artikelpfad";
			$subst{Text} = "<code><form action='mycms.pl' action='post'>" .
				"<input type='text' name='what' value='$param{new_what}' /><br />" .
				"<textarea name='edit' rows='34' cols='80' class='code'></textarea><br />" .
				"<input type='hidden' name='action' value='edit' />" .
				"<input type='submit' value='Abschicken!' />" .
				"</form></code>";
		}
	}
}
##########################################
sub loginout {
##########################################
	if(defined cookie("uid") and cookie("uid") eq $passwort) {
		$subst{Header} .= "Set-Cookie: " .
			cookie(-name => "uid", -value => "nicht-eingeloggt", -expires => "+10m") . "\n";
		$subst{Text} = "Nun <a href='mycms.pl?action=show&what=/'>ausgeloggt</a>.";
		$loggedin = 0;
	} else {
		if($param{new_what} eq $passwort) {
			$subst{Text} = "Nun eingeloggt.";
			$subst{Text} = " <a href='mycms.pl?action=$param{old_action}&what=$param{old_what}'>Weiter</a>.";
			$subst{Header} .= "Set-Cookie: " .
				cookie(-name => "uid", -value => $passwort, -expires => "+10m") . "\n";
			$loggedin = 1;
		} else {
			$param{old_action} ||= "show";
			$param{old_what} ||= "/";
			$subst{Text} = "<form action='mycms.pl' method='post'>" .
				"Passwort: <input type='password' name='new_what' /><br />" .
				"<input type='hidden' name='action' value='loginout' />" .
				"<input type='hidden' name='old_action' value='$param{old_action}' />" .
				"<input type='hidden' name='old_what' value='$param{old_what}' />" .
				"<input type='submit' value='Abschicken!' />" .
				"</form>";
		}
	}
	$subst{Fach} = "/";
}
##########################################
sub pdf {
##########################################
	$param{type} ||= "pdf";
	$param{what} ||= "/";
	my $outp = ""; my $mime = "";
	my $tmp  = "/tmp/myCMS-$$-" . int rand 100000 . time;
	mkdir($tmp) or my_low_level_die("$!");
	chdir($tmp) or my_low_level_die("$!");

	my $recurse = substr($param{what}, -1) eq "/";
	my @files   = $recurse
		?
			grep {
				! $_ eq "delme"
			}
				map {
					$_ = $_->[1];
					s/^$pfad//;
					s/^$param{what}//;
					$_ = $pfad . $param{what} . $_;
					$_ = "delme" if -d "$_";
				}
					get_files $pfad . $param{what}
		: $pfad . $param{what};

	if($recurse and $param{type} eq "raw") {
		system($cmd{tar}, "-C", $pfad, "-cjf", "tmp.tar.bz2", ".");
		$outp = "$tmp/tmp.tar.bz2";
		$mime = "application/x-bzip2";
	} elsif(not $recurse and $param{type} eq "raw") {
		$outp = $pfad . $param{what};
		$mime = "text/plain";
	} elsif($param{type} eq "pdf") {
		open my $genuine, ">tmp.txt" or my_low_level_die("$!");
		
		for (grep { ! /\.html?$/ and ! /\.pdf$/ and ! /\.png/ } @files) {
			open my $filename, $_ or my_low_level_die "$_: $!";
				my $t = join "", <$filename>;
				$t =~ s/\r//; # $illy DoS/Window$...
				print $genuine $t . "\n";
			close $filename;
		}
	
		close $genuine;

		my $OSTDOUT = *STDOUT;
		my $OSTDERR = *STDERR;
		open STDOUT, ">/dev/null" or my_low_level_die($!);
		open STDERR, ">/dev/null" or my_low_level_die($!);
		system($cmd{dos2unix}, "tmp.txt");
		system($cmd{genuine}, "tmp.txt");
		system($cmd{latex}, "tmp.latex");
		system($cmd{latex}, "tmp.latex");
		system($cmd{latex}, "tmp.latex");
		system($cmd{latex}, "tmp.latex");
		system($cmd{dvips}, "tmp");
		system($cmd{ps2pdf}, "tmp.ps", "tmp.pdf");
		*STDOUT = $OSTDOUT;
		*STDERR = $OSTDERR;
		
		$outp = "$tmp/tmp.pdf";
		$mime = "application/pdf";
	}

	open my $output, $outp or my_low_level_die($!);
		undef $/;
		$binary = <$output>;
		unless($binary) {
			$binary = ""; undef $binary;
			my_low_level_die("Ausgabedatei leer!");
		}
	close $output;
	
	system($cmd{rm}, "-r", $tmp);

	$subst{Header} = "Content-Type: $mime\n";
}
##########################################
sub del {
##########################################
	unless($loggedin) {
		need_login;
	}
	unless(defined $param{new_what} and $param{new_what} eq "imsure") {
		$subst{Text} = "$param{what} wirklich " .
			"<a href='mycms.pl?action=del&what=$param{what}&new_what=imsure'>lschen</a>?";
	} else {
		system "/bin/rm", "-r", "$pfad$param{what}" and my_low_level_die("Fehler");
		$subst{Text} = "$param{what} gelscht.";
	}
}
##########################################
sub mmkdir {
##########################################
	need_login unless($loggedin);
	$param{new_what} ||= "notsure";
	$param{what} ||= "/Neuer_Ordner/";
	if($param{new_what} ne "imsure") {
		$subst{Text} = "<form action='mycms.pl' method='get'>" .
			"<input type='text' name='what' value='$param{what}' />" .
			"<input type='hidden' name='action' value='mkdir' />" .
			"<input type='hidden' name='new_what' value='imsure' />" .
			"<input type='submit' value='Abschicken!' />" .
			"</form>";
	} else {
		$param{what} .= "/" if substr($param{what}, -1) ne "/";
		mkdir($pfad . $param{what}) or my_low_level_die("$!");
		$subst{Text} = "<a href='mycms.pl?action=show&what=$param{what}'>$param{what}</a> " .
			"erstellt.";
	}
}

if($param{action} eq "show") { show; }
if($param{action} eq "pdf") { pdf; }
if($param{action} eq "edit") { edit; }
if($param{action} eq "del") { del; }
if($param{action} eq "mkdir") { mmkdir; }
if($param{action} eq "loginout") { loginout; }

$subst{LoggedIn} = "<a href='mycms.pl?action=loginout'>" .
	($loggedin ? "Eingeloggt" : "Ausgeloggt") .
	"</a>";

##############################################################################
sub output {
##############################################################################
	open my($datei), $template or my_low_level_die("$!");
		my $vorlage = join "", <$datei>;
	close $datei;

	my $text = $subst{Text};
	delete $subst{Text};
	$vorlage =~ s/\[$_\]/$subst{$_}/g for keys %subst;
	$vorlage =~ s/\[Text\]/$text/g;
	print "Cache-Control: no-cache\nPragma: no-cache\nExpires: -1\n";

	unless($binary) {
		print "Content-Type: text/html\n$subst{Header}\n";
		print $vorlage;
	} else {
		print "$subst{Header}\n";
		binmode STDOUT;
		print $binary;
	}
	exit 0;
}

output();
