#!/usr/bin/perl
###############################################################
# GenuineCMS -- The Content Management System for GenuineWord #
# Copyleft (C) 2003 by Ingo Blechschmidt <iblech@web.de>      #
###############################################################

use warnings;
use strict;

package Datei;
use Text::Tabs;
sub new { 
	my $proto = shift; my $class = ref $proto || $proto;

	my $self      = {};
	$self->{sym}  = shift;
	$self->{real} = (shift) . $self->{sym};
	$self->{dir}  = -d "$self->{real}";
	$self->{type} = "text";
	if    ($self->{sym} =~ /\.txt$/)   { $self->{type} = "text" }
	elsif ($self->{sym} =~ /\.html?$/) { $self->{type} = "html" }

	bless $self, $class; return $self;
}
sub getRaw {
	my $self = shift; my $ret;
	open my $file, $self->{real} or die $!;
		undef $/;
		$ret = <$file>;
	close $file; return $ret;
}
sub getHTML {
	my $self = shift; my $ret;
	die "HTML request on directory ($self->{sym})!" if $self->{dir};
	$ret = $self->getRaw;
	$ret =~ s/&/&amp;/g; $ret =~ s/</&lt;/g; $ret =~ s/>/&gt;/g;
	$ret = expand $ret;
	my $x = shift;
	$ret =~ s/  / &nbsp;/g if (defined $x and $x ne "nobr");
	$ret =~ s/$/<br \/>/mg unless(defined $x and $x eq "nobr");
	return $ret;
}
sub getText {
	my $self = shift; my $ret;
	return "" if ($self->{dir} or $self->{type} ne "text");
	return $self->getRaw . "\n";
}
sub getMixed {
	my $self = shift;
	return $self->{type} eq "html" ? $self->getRaw : $self->getHTML(shift);
}

package Template;
sub new { 
	my $proto = shift; my $class = ref $proto || $proto;

	my $self      = {};
	# Einlesen
	$self->{file}     = shift;
	$self->{tag}      = shift;
	$/ = "\n";
	open my $file, $self->{file} or die $!;
		my $status = 0;
		for (<$file>) {
			next if ($status == 0 and not /^__$self->{tag}__/);
			$status++;
			next if ($status == 1);
			last if ($status >= 1 and /^__[^_]+__/);
			$self->{template} .= $_;
		}
	close $file;
	undef $/;
	
	if (not $main::loggedin) {
		$self->{template} =~ s/\[WhenOut\]((.|\n)*)\[\/WhenOut\]/$1/mg;
		$self->{template} =~ s/\[WhenIn\](.|\n)*\[\/WhenIn\]//mg;
	} else {
		$self->{template} =~ s/\[WhenIn\]((.|\n)*)\[\/WhenIn\]/$1/mg;
		$self->{template} =~ s/\[WhenOut\](.|\n)*\[\/WhenOut\]//mg;
	}

	bless $self, $class; return $self;
}
sub substitute {
	my $self = shift; my %what = @_;
	$self->{template} =~ s/\[$_\]/$what{$_}/g for (keys %what);
	return $self;
}
sub print {
	my $self = shift;
	return $self->{template};
}

package HTMLQuote;
sub new { 
	my $proto = shift; my $class = ref $proto || $proto;

	my $self          = {};
	# Einlesen
	$self->{p}        = shift;
	$self->{text}     = join(($self->{p} =~ /br/ ? "<brx/>" : ""), @_);

	$self->{text}     =~ s/$_->[0]/$_->[1]/g for (["&" => "&amp;"],
																								["<" => "&lt;"],
																								[">" => "&gt;"],
																								($self->{p} =~ /nbsp/
																									? ["  " => " &nbsp;"]
																									: [""   => ""]));
	$self->{text}     =~ s/&lt;brx\/&gt;/<br \/>/g;
	$self->{text}     =~ s/\r//g;

	bless $self, $class; return $self;
}
sub print { my $self = shift; return $self->{text}; }

package HTTPQuote;
sub new { 
	my $proto = shift; my $class = ref $proto || $proto;

	my $self          = {};
	# Einlesen
	$self->{p}        = shift;
	$self->{p}        =~ s/(.)/"%" . unpack("H*", $1)/eg;

	bless $self, $class; return $self;
}
sub print { my $self = shift; return $self->{p}; }

package main;

sub H { return HTTPQuote->new(shift)->print };

use CGI qw/param cookie/;
use CGI::Carp 'fatalsToBrowser';
use Digest::MD5 "md5_hex";
use File::Basename;
use MIME::Base64;
use Mail::Mailer;
use Sys::Hostname;
use Date::Calc "Decode_Month";

undef $/;
our %cmd = qw(dos2unix /usr/bin/dos2unix
							genuine /usr/bin/genuine
							latex /usr/bin/latex
							dvips /usr/bin/dvips
							ps2pdf /usr/bin/ps2pdf
							tar /bin/tar
							mv /bin/mv
							touch /bin/touch
							mkdir /bin/mkdir
							rm /bin/rm);
our %actions;

our $configfile        = "/home/iblech/schule/10/.config";

open my $file, $configfile or die $!;
	$/ = "\n";
	chomp(our %config = map { @_ = split "="; $_[0] => join "=", @_[1..$#_] } <$file>);
close $file;
undef $/;

#our $where             = "http://localhost/cgi-bin/mycms.pl";
#our ($passwort, $config{pfad}) = ("pass", "/tmp/myCMS");
#our $config{template}          = "$config{pfad}/template.html";

our (%subst, %param);
our ($loggedin, $binary) = (0, "");

##############################################################################
# Binding
##############################################################################
$param{$_} = param($_) for param();
$param{$_} =~ s/%([0-9A-Fa-f]{2})/chr(hex($1))/eg for keys %param;
if(not defined $param{action} and defined $param{id}) {
	$param{what}   = "/";
	$param{action} = "invite";
	$param{p}      = 3;
}
unless(defined $param{action}) {
	$param{action} = "welcome";
	$param{what}   = "/";
}
$param{what}   ||= "/";
$param{what}     =~ s/%(..)/chr(hex($1))/eg;
$param{new_what}     =~ s/%(..)/chr(hex($1))/eg if (defined $param{new_what});

##############################################################################
# Nice
##############################################################################
$subst{Hostname} = hostname;
$subst{E_Mail}   = $config{contact_e};
$subst{Person}   = $config{contact_n};
$subst{Zeit}     = scalar localtime;
$subst{LastChanged} = scalar localtime;
$subst{Header}   = "";
$subst{What}     = $param{what};
$subst{Where}    = $config{where};
my $tpfad = "";
$subst{Pfad} .= "<a href='mycms.pl?action=show&what=".H($_->[0])."'>$_->[1]</a> :: "
	for(
		map {
			$_ ||= "/";
			-d "$config{pfad}$tpfad$_" and $_ .= "/";
			s/\/\/$/\//;
			$tpfad .= "$_";
			[ $tpfad, $_ ];
		} split "/", $subst{What}
	);
$subst{Pfad} ||= "<a href='mycms.pl?action=show&what=".H("/")."'>/</a> :: "; 
#$subst{Pfad} .= $_ ne $param{action}
#	? "<a href='mycms.pl?action=$_&what=$param{what}'>$_</a> "
#	: "$_ "
$loggedin = (defined cookie("uid") and cookie("uid") eq $config{passwort})
	? 1
	: 0;
$subst{Header} .= "Set-Cookie: " .
	cookie(-name => "uid", -value => $config{passwort}, -expires => "+10h") . "\n"
		if $loggedin;

$subst{Pfad} .= get_pF(get_poss($param{what}));

my $twhat = " " . $param{what};
$subst{Titel} = "$param{action} :: " . [reverse split "/", $twhat]->[0];
$subst{Titel} .= "/" if $subst{Titel} eq "$param{action} ::  ";

$subst{LoggedIn} = "<a href='mycms.pl?action=loginout&old_action=$param{action}&old_what=".H($param{what})."'>" .  ($loggedin ? "Eingeloggt" : "Ausgeloggt") .  "</a>";

##############################################################################
sub my_low_level_die {
##############################################################################
	$subst{Text} = shift;
	output();
}

##############################################################################
sub mydie {
##############################################################################
	return if ($param{action} eq "loginout");
#	if( not $param{what} =~ /\.[\.?*]/ and
#			not $param{new_what} =~ /\.\./ and
#	   	(($param{what} =~ /^[\/a-zA-Z0-9_, \.\-:%()\[\]]+(\.txt)?$/ or
#				$param{what} eq "new") and
#			 (not defined $param{new_what} or
#			 	$param{new_what} =~ /^[\/a-zA-Z0-9_, \.\-:%()\[\]]+(\.txt)?$/)) or
#		 		$param{action} eq "loginout") {
#		# Grant. ;-)
#	} else {
	my_low_level_die("<strong>N</strong>ice <strong>T</strong>ry!")
		if ((defined $param{what}     and $param{what}     =~ /\.\./) or
		    (defined $param{new_what} and $param{new_what} =~ /\.\./));
#	}
}
#open my $logfile, ">>" . $config{log} or die $!;
#	print $logfile scalar(localtime time) . "[$ENV{REMOTE_ADDR}]: $param{action}\n";
#close $logfile;
mydie();
$param{what} .= "/" if (-d "$config{pfad}$param{what}" and substr($param{what}, -1) ne "/");

##############################################################################
sub get_files {
##############################################################################
	my $p = shift;
	$p =~ s/\/$//;
	map {
		[
			(scalar grep { /\// } split "", $_->[0]) -
				(substr($_->[0], -1) eq "/" ? 1 : 0),
			$_->[0]
		]
	}
		sort {
			$a->[1] <=> $b->[1] ||
			$a->[2] <=> $b->[2] ||
			$a->[3] <=> $b->[3] ||
			$a->[0] cmp $b->[0]
		}
			grep { $_->[0] ne "delme" } map {
				$_ =~ s/^$config{pfad}//;
				$_ =~ s/\/$//;
				-d "$config{pfad}$_" and $_ .= "/";
				$_ = "delme" if (/\.[^\/]+$/);
				my $o = $_;
				my @counts;
				/()/; s/([0-9]+)//; push @counts, $1 ? $1 : 0;
				/()/; s/([0-9]+)//; push @counts, $1 ? $1 : 0;
				/()/; s/([0-9]+)//; push @counts, $1 ? $1 : 0;
				/()/; s/([0-9]+)//; push @counts, $1 ? $1 : 0;
				/()/; s/([0-9]+)//; push @counts, $1 ? $1 : 0;
#				s/([0-9]+)//; my $b = $1; $b = 0 if not defined $b or $b eq '';
				[ $o, @counts ];
			}
				split "\n", `find '$p' -print`
	# ;-)
}
sub get_poss {
	$_ = shift;
	my $s = $_;
	my @out     = qw#raw pdf tbz2 invite#;
	my @in      = qw#edit upl ren new del#;
	my @order   = reverse qw#invite pdf raw tbz2 edit ren del new upl#;
	my @dir     = qw#ren del pdf tbz2 ren new invite upl#;
	my @file    = qw#edit del ren raw pdf tbz2 invite upl#;
	my @result;

	my $isdir = substr($_, -1) eq "/";
	for my $action (@order) {
		my $status = 0;
		$status = 1 if ($isdir        and grep { $_ eq $action } @dir);
		$status = 1 if (not $isdir    and grep { $_ eq $action } @file);
		$status = 0 if (not $loggedin and grep { $_ eq $action } @in);
		push @result, [$status, $action];
	}

	$_ = $s;
	%actions = (edit  => [ edit  => $_ ],
							ren   => [ ren   => $_ ],
							new   => [ new   => $_ . "neu" ],
							upl   => [ upl   => $isdir ? $_ . "neu" : $_ ],
							del   => [ del   => $_ ],
							raw   => [ form  => $_, "raw" ],
							pdf   => [ form  => $_, "pdf" ],
							invite=> [ invite=> $_ ],
							tbz2  => [ form  => $_, "tbz2" ]);
	return @result;
}
sub get_pF {
	my @result = @_;
	my $ret;
	for (@result) {
		my ($dname, $daction, $dwhat, $dtype) =
				($_->[1], @{ $actions{$_->[1]} });
		$ret .= "<a href='mycms.pl?action=$daction&what=".H($dwhat).(defined $dtype ? "&type=$dtype" : "") . "'>" if $_->[0];
		$ret .= $dname;
		$ret .= "</a>" if $_->[0];
		$ret .= " ";
	}
	return $ret;
}
##############################################################################
sub show {
##############################################################################
	if(-d "$config{pfad}$param{what}") {
		my ($ACT, $NEW, $WAN) = 0 .. 2;
		my @level = (0) x 3;
		$level[$WAN] = grep { /\// } split "", $param{what};

		my @files = get_files($config{pfad});

		$subst{Text} = "<ul>";
		for(@files) {
			$level[$NEW] = $_->[0];
			next if ($level[$NEW] > $level[$WAN]);
			my $act_p_dir = dirname $_->[1];
			next unless ($param{what} =~ /^$act_p_dir/);
#			next if ($level[$WAN] < $level[$NEW] and not $_->[1] =~ /^$param{what}$/);
#			next if ($level[$NEW] <= $level[$WAN] and not $_->[1] =~ /^$param{what}/);
#			if($level[$NEW] >= $level[$WAN]) {
#				my $trimmed = $_->[1];
#				$trimmed =~ s/\/[^\/]*\/?$//;
#				$trimmed .= "/";
#				next if($trimmed ne $param{what});
#			}
#			$subst{Text} .= "[NEW=$level[$NEW],WAN=$level[$WAN],$_->[1]]";

			while($level[$ACT] < $level[$NEW]) {
				$subst{Text} .= "<ul>";
				$level[$ACT]++;
			}
			while($level[$ACT] > $level[$NEW]) {
				$subst{Text} .= "</ul>";
				$level[$ACT]--;
			}
			
			my $show = $_->[1];
			$show =~ /\/([^\/]*\/?)$/;
			$show = $1;
			$show ||= "/";

			my $s = $_;
			my @result = get_poss $_->[1];
			$_ = $s;
			my $down = -1 + grep { $_->[1] =~ /^$s->[1]/ } @files;
			
			$subst{Text} .= "<li class='" .
				($_->[1] eq $param{what} ? "hi" : "nohi") .
				"'><a href='mycms.pl?action=show&what=".H($_->[1])."'>$show</a> " .
				(substr($_->[1], -1) eq "/" ? "[$down]" : "") .
				"<span class='flags'>" . get_pF(@result) . "</span></li>\n";
		}
		$subst{Text} .= "</ul>" while(0 < $level[$ACT]--);
		$subst{Text} .= "</ul>";
	} else {
		$subst{Text} = "<code>" . Datei->new($param{what}, $config{pfad})->getMixed("nbsp") . "</code>";
		open my $filename, "$config{pfad}$param{what}" or my_low_level_die("$!");
			$subst{LastChanged} = scalar localtime [stat($filename)]->[9];
		close($filename);
	}
}
##########################################
sub nice {
##########################################
	if(-f "$config{pfad}$param{what}") {
		show;
	} else {
		my @files;
		@files = map {
			$_ = $param{what} . $_;
			$_ .= "/" if(-d "$config{pfad}$_");
			$_ = $_;
		}
			@files = ("..", split "\n", `ls -1 $config{pfad}$param{what}`);
		$subst{Text} = "<table border='0' width='100%'>";
		my $i = 0;
		for(@files) {
			if( $i % 4 == 0 ) {
				$subst{Text} .= $i == 0
					? ""
					: "</tr>";
				$subst{Text} .= "<tr>";
			}
			$_ = "/" . $_ if substr($_, 0, 1) ne "/";
			next if($_ eq "/../");
			my $back = "";
			if(/\/[^\/]+\/\.\.\/$/) {
				$back = "zurck zu ";
				$_ =~ s/\/[^\/]+\/\.\.\/$/\//;
				$_ = "/" if $_ eq "/../";
			}
			/\/([^\/]+\/?)$/;
			$subst{Text} .= "<td>" .
				"[Icon]<br />" .
				"<a href='mycms.pl?action=nice&what=".H($_)."'>$back" .
					($1
						? $1
						: "/"
					) . "</a>" .
				"</td>";
			$i++;
		}
	}
}
##########################################
sub need_login {
##########################################
	my_low_level_die "<a href='mycms.pl?action=loginout&old_action=$param{action}&old_what=".H($param{what})."'>Login</a> erforderlich.";
}
##########################################
sub edit {
##########################################
	$param{new_what}  ||= $param{what};
	$param{processed} ||= "no";
	my $meldung = shift;
	$meldung = defined $meldung ? $meldung . "<br />" : "";

	my_low_level_die "<a href='mycms.pl?action=show&what=".H("/")."'>/</a> kann nicht umbenannt werden!" if (-d "$config{pfad}$param{what}");
	need_login if not $loggedin;
		
	if ($param{processed} eq "no") {
		$subst{Text} = Template->new($config{template}, "EDIT")->substitute(
			Meldung => $meldung,
			What => $param{what},
			Inhalt => HTMLQuote->new(
				"",
				Datei->new($param{what}, $config{pfad})->getRaw
			)->print
		)->print;
	} else {
		$param{edit} =~ s/\r//g;
		open my $file, ">" . Datei->new($param{what}, $config{pfad})->{real} or
			my_low_level_die $!;
			print $file $param{edit};
		close $file;
		$param{processed} = "no";
		undef $param{edit};
		edit("<a href='mycms.pl?action=show&what=".H($param{what})."'>$param{what}</a> wurde editiert.");
		return;
	}
}
sub new {
	need_login if not $loggedin;
	$param{processed} ||= "no";

	if ($param{processed} eq "no") {
		$subst{Text} = Template->new($config{template}, "NEW")->substitute(
			What => $param{what}
		)->print;
	} else {
		system(($param{type} eq "file" ? $cmd{touch} : $cmd{mkdir}), $config{pfad} . $param{what}) and my_low_level_die $!;
		$subst{Text} = "<a href='mycms.pl?action=show&what=".H($param{what})."'>$param{what}</a> wurde erstellt.";
	}
}
sub ren {
	need_login if not $loggedin;
	$param{processed} ||= "no";

	if ($param{processed} eq "no") {
		$subst{Text} = Template->new($config{template}, "REN")->substitute(
			What     => $param{what},
			New_What => $param{what}
		)->print;
	} else {
		rename(Datei->new($param{what}, $config{pfad})->{real},
		       Datei->new($param{new_what}, $config{pfad})->{real}) or
			my_low_level_die $!;
		
		$subst{Text} = "$param{what} wurde in <a href='mycms.pl?action=show&what=".H($param{new_what})."'>$param{new_what}</a> umbenannt.";
	}
}
##########################################
sub loginout {
##########################################
	$param{old_action} ||= "show";
	$param{old_what} ||= "/";
	if(defined cookie("uid") and cookie("uid") eq $config{passwort}) {
		$subst{Header} .= "Set-Cookie: " .
			cookie(-name => "uid", -value => "nicht-eingeloggt", -expires => "+10h") . "\n";
		open my $logfile, ">>" . $config{logfile} or die;
			print $logfile scalar(localtime(time)) . ": OUT ==> " . $ENV{REMOTE_ADDR} . "\n";
		close $logfile;
		$subst{Text} = "Nun <a href='mycms.pl?action=$param{old_action}&what=".H($param{old_what})."'>ausgeloggt</a>.";
		$loggedin = 0;
	} else {
		if(defined $param{new_what} and md5_hex($param{new_what}) eq $config{passwort}) {
			system($cmd{touch}, $config{logfile}) unless (-f "$config{logfile}");
			open my $logfile, $config{logfile} or die;
				$subst{LastChanged} = scalar localtime [stat $logfile]->[9];
			close $logfile;
			open $logfile, ">>" . $config{logfile} or die;
				print $logfile scalar(localtime(time)) . ": IN ==> " . $ENV{REMOTE_ADDR} . "\n";
			close $logfile;
			$subst{Text} = "Nun eingeloggt.";
			$subst{Text} = " <a href='mycms.pl?action=$param{old_action}&what=".H($param{old_what})."'>Weiter</a>.";
			$subst{Header} .= "Set-Cookie: " .
				cookie(-name => "uid", -value => $config{passwort}, -expires => "+10h") . "\n";
			$loggedin = 1;
		} else {
			$subst{Text} = Template->new($config{template}, "LOGINOUT")->substitute(
				Old_Action => $param{old_action},
				Old_What   => $param{old_what}
			)->print;
		}
	}
	$subst{Fach} = "/";
}
##########################################
sub form {
##########################################
	$param{type} ||= "pdf";
	$param{what} ||= "/";
	$subst{Header} = "";

	my @files = map { Datei->new($_->[1], $config{pfad})->{sym} } get_files($config{pfad} . $param{what});

	my_low_level_die "<strong>N</strong>ice <strong>T</strong>ry!"
		if ($param{type} eq "raw" and $#files > 0);
	
	my $tid = time() . int rand 10000000;
	if ($param{type} eq "raw") {
		$subst{Header} = "Content-Type: application/octet-stream\nContent-Disposition: attachment; filename=" . '"' . "content" . '"' . "\n";
		$binary = Datei->new($param{what}, $config{pfad})->getRaw;
	} elsif ($param{type} eq "tbz2") {
		$subst{Header} = "Content-Type: application/x-bzip2\nContent-Disposition: attachment; filename='content.tar.bz2'\n";
		$subst{Header} =~ s/'/"/g;
		chdir $config{pfad};
		system($cmd{tar}, "-C", $config{pfad}, "--no-recursion", "--owner=0", "--group=0", "-cjf", "/tmp/myCMS-$tid", map { $_ = "." . $_ } @files);
		open my $file, "/tmp/myCMS-$tid" or my_low_level_die $!;
			undef $/;
			$binary = <$file>;
		close $file;
		unlink "/tmp/myCMS-$tid";
	} elsif ($param{type} eq "pdf") {
		my $all;
		$all .= Datei->new($_, $config{pfad})->getText for (@files);
		$all =~ s/\r//g;
		$tid = md5_hex $all;
		
		if (mkdir "/tmp/myCMS-$tid") {
			chdir "/tmp/myCMS-$tid";
			open my $file, ">/tmp/myCMS-$tid/all.txt" or my_low_level_die $!;
				print $file $all;
			close $file;
			
			close $file;
			open $file, ">/tmp/myCMS-$tid/Makefile" or my_low_level_die $!;
#				my $makefile = q%all.latex: all.txt^	@echo "genuining..." >&2^	@genuine -v all.txt^^all.dvi: all.latex^	@echo "latexing..." >&2^	@latex all.latex || genuinefixwrapper all; echo $$?^	@c=0; \^	while grep "Rerun to get cross-references right" all.log; do \^		latex all.latex || genuinefixwrapper all; echo $$?; \^		: $$[c++]; \^		[ "$$c" = "10" ] && exit 0; \^	done; \^	exit 0^^all.ps: all.dvi^	@echo "dvipsing..." >&2^	@dvips all.dvi^	@#Last line from Rick Holbert <holbert.13@osu.edu>. Thanks!^^all.pdf: all.ps^	@echo "pdfing..." >&2^	@ps2pdf all.ps all.pdf^^all: all.pdf^%;
				my $makefile = q'%.ascii: %.txt^	@echo "genuinetoccing..." >&2^	@genuinetoc -width:70 -pipe "-chars:.   " $< > $@^^%.latex: %.txt^	@echo "genuining..." >&2^	@cp $< temp.txt^	@genuine -v temp.txt^	@rm temp.txt^	@mv temp.latex $@^^%.dvi: %.latex^	@echo "latexing..." >&2^	@latex $< || genuinefixwrapper `basename $< .latex`; echo $$?^	@c=0; \^	while grep "Rerun to get cross-references right" `basename $< .latex`.log; do \^		latex $< || genuinefixwrapper `basename $< .latex`; echo $$?; \^		: $$[c++]; \^		[ "$$c" = "10" ] && exit 0; \^	done; \^	exit 0^^%.ps: %.dvi^	@echo "dvipsing..." >&2^	@dvips $< #-Pwww is better, but not available on all systems^^%.pdf: %.ps^	@echo "pdfing..." >&2^	@ps2pdf $< $@^^all: howto.de.ascii howto.de.pdf howto.en.ascii howto.en.pdf^^install: howto.de.pdf howto.en.pdf^	@echo "installing..." >&2^	mkdir -p $(DESTDIR)/usr/bin $(DESTDIR)/usr/share/doc/genuineword-0.89^	cp ascii2eps ascii2fig genuine genuinefix genuinefixwrapper genuineshot genuinetoc $(DESTDIR)/usr/bin^	cp COPYING Makefile genuine.vim howto* $(DESTDIR)/usr/share/doc/genuineword-0.89^^clean:^	@echo "cleaning..." >&2^	@rm texput.log *.pdf *.dvi *.ascii *.toc *.ps *.aux *.tmp *.latex *.log 2>/dev/null || true^	@rm -r .cached 2>/dev/null || true^^.PHONY: clean install^';
				$makefile =~ s/\^/\n/g;
				print $file $makefile;
			close $file;
			system("make all.pdf > log 2>&1");
		}
		open my $file, "/tmp/myCMS-$tid/log" or my_low_level_die $!;
			undef $/;
			$subst{Text} .= "<a href='mycms.pl?action=form&what=".H($param{what})."&type=pdf-finished&tid=$tid'>Hier</a> geht es weiter.<br /><br /><code>" . Datei->new("/tmp/myCMS-$tid/log", "/")->getHTML . "</code>";
			$subst{LastChanged} = scalar localtime [stat $file]->[9];
		close $file;
	} elsif ($param{type} eq "pdf-finished") {
		my_low_level_die "<strong>N</strong>ice <strong>T</strong>ry!"
			unless ($param{tid} =~ /^[a-z0-9]+$/);
		$tid = $param{tid};
		$subst{Header} = "Content-Type: application/pdf\nContent-Disposition: attachment; filename=" . '"' . "content.pdf" . '"' . "\n";
		open my $file, "/tmp/myCMS-$tid/all.pdf" or my_low_level_die $!;
			undef $/;
			$binary = <$file>;
		close $file;
	}
}
##########################################
sub del {
##########################################
	unless($loggedin) {
		need_login;
	}
	unless(defined $param{new_what} and $param{new_what} eq "imsure") {
		$subst{Text} = "$param{what} wirklich " .
			"<a href='mycms.pl?action=del&what=".H($param{what})."&new_what=imsure'>lschen</a>?";
	} else {
		system "/bin/rm", "-r", "$config{pfad}$param{what}" and my_low_level_die("Fehler");
		$subst{Text} = "$param{what} gelscht.";
	}
}
sub invite {
	$param{p} ||= "0";
	if ($param{p} eq "0") {
		$subst{Text} = Template->new($config{template}, "INVITE-0")->substitute(
			Ziele =>
				join("</option>",
					map { $_ = "<option value='$_'>$_" } split " ", q#pdf raw tbz2 show#),
			Time => time,
			What => $param{what}
		)->print;
	} elsif ($param{p} eq "1") {
		my_low_level_die "<strong>N</strong>ice <strong>T</strong>ry!"
			unless ($param{id} =~ /^[0-9a-z]+$/ and $param{time} =~ /^[0-9]+$/);
		my %s2a = (pdf => "form", raw => "form", tbz2 => "form", show => "show");
		my %s2t = (pdf => "pdf",  raw => "raw",  tbz2 => "tbz2", show => "");
		my $link = "mycms.pl?what=".H($param{what})."&action=$s2a{$param{dest}}&type=$s2t{$param{dest}}";
		$param{mesg}     = HTMLQuote->new("br,nbsp",split "\n",$param{mesg})->print;
		$param{absender} = HTMLQuote->new("", $param{absender})->print;
		$param{ziel}     = HTMLQuote->new("", $param{ziel})->print;
		my $instr = join "|", $param{id}, $param{time}, $ENV{REMOTE_ADDR}, $param{absender}, $param{ziel}, $link, $param{mesg};
		$instr =~ s/(.)/unpack "H*", $1/eg;
		
		$subst{Text} = Template->new($config{template}, "INVITE-1")->substitute(
			Instr    => $instr,
			Id       => $param{id},
			What     => $param{what},
			Dest     => $param{dest},
			Abs_IP   => $ENV{REMOTE_ADDR},
			Absender => $param{absender},
			Ziel     => $param{ziel},
			Vorschau => Template->new($config{template}, "INVITE-3")->substitute(
				Abs_IP   => $ENV{REMOTE_ADDR},
				Absender => $param{absender},
				Ziel     => $param{ziel},
				When     => scalar localtime $param{time},
				Mesg     => $param{mesg},
				Link     => "$config{where}?id=$param{id}"
			)->print
		)->print;
	} elsif ($param{p} eq "2") {
		$param{instr} =~ s/(..)/chr(hex($1))/eg;
		open my $file, ">>$config{pfad}/.invitations" or my_low_level_die $!;
			print $file "$param{instr}\n";
		close $file;
		$subst{Text} = "Die Einladung wurde <a href='$config{where}?id=$param{id}'>ausgestellt.</a>";
	} elsif ($param{p} eq "3") {
		open my $file, "$config{pfad}/.invitations" or my_low_level_die $!;
			undef $/;
			my @invitations = split "\n", <$file>;
		close $file;
		my $search_for = $param{id} eq "list" ? ".+" : $param{id};
		my @i_s    = grep { /^$search_for\|/ } @invitations;
		my_low_level_die "Fr Sie wurde keine Einladung ausgestellt."
			if (@i_s == 0);
		my @iterate_over = $param{id} eq "list" ? @i_s : pop @i_s;

		for (@iterate_over) {
			$subst{Text} .= "<div class='text'>\n" if (@iterate_over > 1);
			my ($id, $when, $ip, $abs, $des, $lnk, $msg) = split /\|/, $_;
			$subst{LastChanged} = scalar localtime $when;

			$subst{Text} .= Template->new($config{template}, "INVITE-3")->substitute(
				Abs_IP   => $ip,
				Absender => $abs,
				Ziel     => $des,
				When     => scalar localtime $when,
				Mesg     => $msg,
				Link     => $lnk
			)->print;
			$subst{Text} .= "</div><br />\n" if (@iterate_over > 1);
		}
	}
}
sub config {
	need_login if not $loggedin;
	$param{processed} ||= "no";
	if ($param{processed} eq "no") {
		$subst{Text} = Template->new($config{template}, "CONFIG")->substitute(%config)->print;
	} else {
		open my $file, ">" . $configfile or die $!;
			print $file $_ . "=" . $param{$_} . "\n" for keys %config;
		close $file;
		$subst{Text} = "Die Konfiguration wurde aktualisiert.";
	}
}
sub source {
	$subst{Text} = Datei->new($0, "/")->getHTML("nbsp");
}
sub ftp {
	if (substr($param{what}, -1) eq "/") {
		my $columns = 4;
		my $parent = $param{what};
		$parent =~ s/\/[^\/]*\/$//;
		my @files = grep { my $x = $param{what} . '[^/]*/?'; /^$x$/ } ($parent, map { $_->[1] } get_files $config{pfad} . $param{what});
		my $i = 0;
		$subst{Text} = "<table border='1'>\n<tr>";
		for (@files) {
			$subst{Text} .= "</tr>\n<tr>"
				if ($i % $columns == 0);
			/^$param{what}(.*)$/;
			my ($link, $icon, $name, $actions) = (
				"<a href='mycms.pl?action=ftp&what=".H($_)."'>",
				substr($_, -1) eq "/" ? "dir" : "file",
				$1 ? $1 : "/",
				get_pF(get_poss($_))
			);
			$subst{Text} .= "<td><table>" .
				"<tr><td>$link$icon</a></td></tr>" .
				"<tr><td>$link$name</a></td></tr>" .
				"<tr><td>$actions</td></tr>" .
				"</table></td>";
			$i++;
		}
		$subst{Text} .= "</tr></table>";
	} else {
		show;
	}
}
sub backup {
	my $tid = time() . int rand 10000000;
	chdir $config{pfad};
	system ($cmd{tar}, "-C", $config{pfad}, "-cjf", "/tmp/myCMS-$tid", ".");
	
	my $mailer = new Mail::Mailer;
	$mailer->open({
		From    => "GenuineCMS <".sprintf('%s@%s',scalar getpwuid($<),hostname).">",
		To      => $config{admin},
		Subject => "Backup of your GenuineCMS space"
	});
	print $mailer (scalar(localtime(time)), ": ", $ENV{REMOTE_ADDR}, "\n");
	open my $file, "/tmp/myCMS-" . $tid or my_low_level_die $!; undef $/;
		print $mailer encode_base64 <$file>;
	close $file;
	$mailer->close;

	$subst{Text} = "Backup erstellt.";
}
sub welcome {
	$subst{Text} = Template->new($config{template}, "WELCOME")->substitute(%subst)->print;
}
sub graph {
	my %dates;
	open my $file, $config{apache} or my_low_level_die $!;
		$/ = "\n";
		@_ = localtime time;
		my $now = join "", ($_[5] + 1900, sprintf("%.2d", $_[4] + 1), sprintf("%.2d", $_[3]));
		for (<$file>) {
			next unless /mycms\.pl/;
			@_ = split " ", $_;
			$_[3] =~ s/\[([0-9]+)\/([A-Za-z]+)\/([0-9]+).*/sprintf("%.4d%.2d%.2d",
																														 $3,
																														 Decode_Month($2),
																														 $1 % 2 == 0 ? $1 : $1)/e;
			next if ($now - 7 > $_[3]);
			$dates{$_[3]} ||= 0;
			$dates{$_[3]}++;
		}
	close $file;
	my @sorted = sort { $a <=> $b } keys %dates;
	$dates{$_} ||= 0 for ( map { $_ % 2 == 0 ? $_ : $_ } $sorted[0] .. $sorted[$#sorted] );
	@sorted    = sort { $a <=> $b } keys %dates;
	my @achsen = ([map { s/^(....)(..)(..)/$3.$2./; $_ } my @s = @sorted], [map { $dates{$_} } @sorted]);

	use GD::Graph::lines;
	$subst{Header} = "Content-Type: image/png\n";
	my $graph      = GD::Graph::lines->new(400, 300);
	$graph->set(x_label => "Tag", 
				 		  y_label => "Hits",
							title   => "Statistik") or my_low_level_die $graph->error;
	my $image      = $graph->plot(\@achsen) or my_low_level_die $graph->error;
	$binary        = $image->png or my_low_level_die $graph->error;
	$subst{Text}   = "";
}
sub upload {
	need_login if (not $loggedin);
	$param{processed} ||= "no";
	if ($param{processed} eq "no") {
		$subst{Text} = Template->new($config{template}, "UPLOAD")->substitute(
			What => $param{what}
		)->print;
	} else {
		open my $file, ">" . $config{pfad} . $param{what} or my_low_level_die $!;
			undef $/;
			my $handler = $param{edit};
			my $text    = <$handler>;
			print $file $text;
		close $file;
		$param{processed} = "no";
		undef $param{edit};
		edit("<a href='mycms.pl?action=show&what=".H($param{what})."'>$param{what}</a> wurde hochgeladen.");
	}
}			
sub sid_handling {
	my $sid;
	if (defined cookie("sid") and cookie("sid") =~ /^[a-fA-F0-9]$/) {
		$sid = cookie("sid");
	} else {
		$sid = md5_hex(time);
		$subst{Header} .= "Set-Cookie: " .
			cookie(-name => "sid", -value => $sid, -expires => "+100d") . "\n";
	}
	my %records;
	open my $file, $config{sid} or my_low_level_die "SID-Konfigurationseinstellung berprfen!";
		$/ = "\n";
		for (<$file>) {
			my @r = split /\|/;
			$records{$r[0]} = {count => $r[1],lip => $r[2],ldt => $r[3],UA => $r[4]};
		}
	close $file;
	$records{$sid}->{count}++;
	$records{$sid}->{lip} = $ENV{REMOTE_ADDR};
	$records{$sid}->{ldt} = time;
	$records{$sid}->{UA} = $ENV{HTTP_USER_AGENT};
	$records{$sid}->{UA} =~ s/\|/(bar)/g;
	open $file, ">" . $config{sid} or my_low_level_die "SID-Konfigurationseinstellung berprfen!";
		$/ = "\n";
		print $file join("|",$_,$records{$_}->{count},$records{$_}->{lip},$records{$_}->{ldt},$records{$_}->{UA})."\n" for (keys %records);
	close $file;
}

sid_handling;

if($param{action} eq "show") { show; }
#if($param{action} eq "nice") { nice; }
if($param{action} eq "ftp") { ftp; }
if($param{action} eq "form") { form; }
if($param{action} eq "invite") { invite; }
if($param{action} eq "edit") { edit; }
if($param{action} eq "new") { new; }
if($param{action} eq "upl") { upload; }
if($param{action} eq "ren") { ren; }
if($param{action} eq "del") { del; }
if($param{action} eq "loginout") { loginout; }
if($param{action} eq "config") { config; }
if($param{action} eq "source") { source; }
if($param{action} eq "backup") { backup; }
if($param{action} eq "welcome") { welcome; }
if($param{action} eq "graph") { graph; }

$subst{LoggedIn} = "<a href='mycms.pl?action=loginout&old_action=$param{action}&old_what=".H($param{what})."'>" .  ($loggedin ? "Eingeloggt" : "Ausgeloggt") .  "</a>";

##############################################################################
sub output {
##############################################################################
	my $text = $subst{Text};
	delete $subst{Text};
	my $vorlage = Template->new($config{template}, "MAIN")->
		substitute(%subst)->
			substitute(Text => $text)->print;
	print "Cache-Control: no-cache\nPragma: no-cache\nExpires: -1\n";

	unless($binary) {
		print "Content-Type: text/html\n$subst{Header}\n";
		print $vorlage;
	} else {
		print "$subst{Header}\n";
		binmode STDOUT;
		print $binary;
	}
	exit 0;
}

output();

__END__
