#!/usr/bin/perl -w

use warnings;
use strict;

use lib '/home/iblech/lib';
use Getopt::Long;
use File::Basename;
use File::Find;
use POSIX qw/strftime/;
use File::stat;
use Digest::MD5 qw/md5_hex/;
use Storable;
use MyRest;
use MyTemplate;

our %config = (template    => "template.html",
							 mmark       => "MAIN",
							 name        => "Ingo Blechschmidt",
							 mail        => "iblech\@web.de",
							 pdf         => 1,
							 verbose     => 0,
							 files       => [],
							 dirs        => [],
							 output      => "result",
							 record      => ".record",
							 makefile    => "Makefile",
							 cols        => 80,
							 base        => "http://home.augustakom.net/gblech/klasse10/",
							 start       => ".");
my %temp    = (count       => 0);

GetOptions ("template=s"   => \$config{template},
						"mmark=s"      => \$config{mmark},
						"name=s"       => \$config{name},
						"mail=s"       => \$config{mail},
						"verbose+"     => \$config{verbose},
						"pdf"          => \$config{pdf},
						"output=s"     => \$config{output},
						"record=s"     => \$config{record},
						"makefile=s"   => \$config{makefile},
						"cols=i"       => \$config{cols},
						"base=s"       => \$config{base},
						"start=s"      => \$config{start});

$config{all} = [ getNames($config{start}) ];
#find(sub { -d && push @{ $config{dirs} }, $File::Find::name }, $config{start});
#find(sub { -f && /\.txt$/ && push @{ $config{files} }, $File::Find::name }, $config{start});
map { s/^\.\///; $_ = "." if ($_ eq ""); $_; } @{ $config{all} };
@{ $config{all} } = grep { ! /$config{output}/ } @{ $config{all} };
warn join " ", @{$config{all}};

die "Error: No files to be processed!\n" if (@{ $config{all} } == 0);

unless (-f $config{record}) {
	store {}, $config{record};
}
our %record = %{ retrieve($config{record}) };

mkdir $config{output} unless (-d $config{output});

for (@{ $config{all} }) {
	if ($config{verbose} == 1) {
		print STDERR "=" x (($temp{count} - 0) / @{ $config{all} } * $config{cols} -
											 	($temp{count} - 1) / @{ $config{all} } * $config{cols});
	} elsif ($config{verbose} > 1) {
		print STDERR "Processing: $_\n";
	}
	
	$temp{subst}          = {
		basename   => basename($_) eq "." ? "/" : basename($_) . (-d $_ ? "/" : ""),
		dirname    => dirname($_),
		navigation => navigation($_, "navigation"),
		changed    => changed($_)
	};
	use Data::Dumper;
#	print STDERR Dumper(\%temp);
	
	my $template = MyTemplate->new($config{template}, $config{mmark})->
		substitute(%config)->
			substitute(%{ $temp{subst} });
	
	my $ofile;
	if (-d $_) {
		$template->substitute(text => navigation($_, "dirlist"));
		
		mkdir "$config{output}/$_" unless (-d "$config{output}/$_");
		open $ofile, ">$config{output}/$_/index.html" or
			die "$!";
	} else {
		$template->substitute(text => getFile($_));
		
		open $ofile, ">$config{output}/$_.html" or
			die "$!";
	}
	print $ofile $template->print;
	close $ofile;

	if ($config{pdf}) {
		my $act       = $_;
		my @pdf_names = getNames($act);
		my $md5       = md5_hex(join(" ", map { changed($act) } @pdf_names));
		if (defined $record{$act} and $record{$act} eq $md5) {
			# PDF schon da
		} else {
			# Create PDF
			system("/bin/rm", "tmp.txt");
			open my $pfile, ">>tmp.txt" or die ">>tmp.txt: $!\n";
			undef $/;
			for (@pdf_names) {
				open my $ifile, $_          or die "$_: "  .  "$!\n";
					print $pfile "" . <$ifile> . "\n";
				close $ifile;
			}
			close $pfile;
			system("make -f $config{makefile} tmp.pdf " .
						 ($config{verbose} > 1 ? "" : ">/dev/null 2>&1"));
			system("/bin/mv", "tmp.pdf", $config{output} . "/" . (-d $act ?  "$act/index.pdf" : "$act.pdf"));
			$record{$act} = $md5;
		}
	}
	$temp{count}++;
}

store \%record, $config{record};

sub getFile {
	$_ = shift;
	open my $file, $_ or die $!;
		undef $/;
		return MyTemplate->new($config{template}, "FILE")->substitute(
				text => HTMLQuote->new("br,nbsp", split "\n", <$file>)->print
		)->print;
	close $file; # Never executed
}
sub navigation {
	my ($target, $base) = (shift, ".");
	my $style = shift;
	my ($ACT, $NEW, $WAN) = 0 .. 2; my @level = (0) x 3;
	my $return = "";
	$target = unify($target, $base);
	$level[$WAN] = 1 + grep { /\// } split "", $target;
	$target .= "/" if (-d "$base$target");
	$target .= "/" if ($target eq "");
	my @files = getFiles($base);
	if ($style eq "navigation") {
		$return = "<ul>";
	} else {
		$return = "<table cellspacing='1' cellpadding='1' class='dtable' width='100%'>\n" .
			"<tr class='h'><th class='tdl'>Name (PDF)</th><th class='tdd'>Zuletzt modifiziert</th></tr>";
	}
	my $cou = 0;
	for (@files) {
		$_ =~ s/\/$//; $level[$NEW] = grep { /\// } split "", $_; $_ .= "/" if (-d "$base$_");
		next if ($level[$NEW] > $level[$WAN]);
		my $act_p_dir = dirname $_;
		next unless ($target =~ /^$act_p_dir/);
		if ($style eq "navigation") {
			while($level[$ACT] < $level[$NEW]) { $return .= "<ul>"; $level[$ACT]++; }
			while($level[$ACT] > $level[$NEW]) { $return .= "</ul>"; $level[$ACT]--; }
		}
		/\/([^\/]*\/?)$/;
		my $show = $1 || "/"; my $act = $_; my $down = -1 + grep { /^$act/ } @files;

		if ($style eq "navigation") {
			$return .= "<li class='" .
				($act eq $target ? "hi" : ($cou % 2 == 0 ? "nohi1" : "nohi2")) .
				"'>" .
					"<a href='" . getLink($act, $base) . ".html'>$show</a> " .
					"<a href='" . getLink($act, $base) . ".pdf'>(PDF)</a> " .
				"</li>\n";
		} else {
			$return .= "<tr class='d" . ($act eq $target ? "hi" : "nohi") . "'>" .
								   "<td class='tdl'>" .
									   "&nbsp;&nbsp;&nbsp;" x $level[$NEW] .
										 "<a href='" . getLink($act, $base) . ".html'>$show</a> " .
										 "<a href='" . getLink($act, $base) . ".pdf'>(PDF)</a>" .
									 "</td>" .
									 "<td class='tdd'>" .
									   changed($base . $act) .
									 "</td>" .
								 "</tr>\n";
		}
		$cou++;
	}
	if ($style eq "navigation") {
		$return .= "</ul>" while(0 < $level[$ACT]--);
		$return .= "</ul>";
	} else {
		$return .= "</table>";
	}
	return $return;
}
sub changed {
	my $file = stat($_[0]);
	return strftime("%e.%_m.%Y %H:%M", localtime $file->ctime);
} 

sub unify {
	my $tx  = shift;
	my $target = $tx;
	$target .= "/" if (-d $target);
#	$target = dirname($target) if (-f $target);
	$target = "" if ($target eq "./");
	$target = "/" . $target;
	$target =~ s/\/$//;
	return $target;
}
sub getLink {
	my ($act, $base) = (shift, shift);
	return "$config{base}$act" .
		(-d "$base$act" ? "index" : "");
}
sub getFiles {
	my $base = shift;
	return
		grep {
			if (-d "$base$_") {
				1;
			} else {
				if ($_ =~ /\.txt$/) {
					1;
				} else {
					0;
				}
			}
		}
		grep { $_ ne "/$config{output}/" } map {
			s/^\.\//\//;
			$_ = "/" if ($_ eq ".");
			$_ .= "/" if (substr($_, -1) ne "/" and -d "$base$_");
			$_;
		}
		getNames($base); #split chr(0), `find $base -print0`;
}
sub getNames {
	my $gerade = $_[0];
	$gerade .= "/" if (substr($gerade, -1) ne "/" and -d $gerade);
	if (-d $gerade) {
		if (-f "$gerade/.toc") {
			$/ = "\n";
			open my $ifile, "$gerade/.toc" or die "$gerade/.toc: $!";
				chomp(my @new = <$ifile>);
				map { $_ = $gerade . $_ } @new;
				my @ret = ();
				for (@new) {
					push @ret, getNames($_);
				}
				return ($gerade, @ret);
			close $ifile;
		} else {
			return (); # No new;
		}
	} else {
		return ($_);
	}
}
