#!/usr/bin/perl -X
# GPL >= 2


use HTML::Template;
use CGI qw/param/;

our $base = "http://localhost/cgi-bin/web";
our $images = "http://localhost/web/images/";

print "Content-Type: text/html\n\n";

my $template = HTML::Template->new(filename => 'index.tmpl');

sub error {
  print (shift);
	exit 0;
}

sub parseMenu {
  my @menu = (); my $line = ""; my @field = (); my $lang = "";
	my $oberpunkt = ""; my $index = -1; my $oldlang = ""; my $subindex = -1;

  open(MENU, "<" . shift) || &error("Kann Menu-Datei nicht laden: $!\n");
	while(chomp($line = <MENU>)) {
	  @field = split(' ', $line);
		$oldlang = $lang; $lang = $field[0];
		if($oldlang ne $lang) { $index = -1; }
		unless($field[1] eq '*') {
			$index++; $subindex = 0;
			push @menu, [ $lang, $index, $subindex, $field[1] ];
		} else {
		  $subindex++;
			push @menu, [ $lang, $index, $subindex, $field[2] ];
		}
	}
	close(MENU);
	return @menu;
}

sub makeMenu {
  my $item = shift; my $lang = shift; my $show = shift;
	@loop_data = ();
	for $ele (@menu) {
	  next unless($ele->[0] eq $lang);
	  my %ref;
		if($ele->[2] == 0) {
		  $ref{name} = $ele->[3];
			$ref{oben} = 1;
			$ref{link} = "$base/index.pl?lang=$lang&item=$ele->[1]&show=" unless($ele->[1] == $item);
			$ref{name} =~ s/_/ /g;
    } else {
		  if($ele->[1] == $item) {
		    $ref{name} = $ele->[3];
				$ref{oben} = 0;
				$ref{link} = "$base/index.pl?lang=$lang&item=$item&show=$ref{name}" unless($ref{name} eq $show);
				$ref{name} =~ s/_/ /g;
			} else {
			  next
			}
		}
	  push @loop_data, \%ref;
	}
	return @loop_data;
}

sub getText {
  my $name = shift; my $lang = shift;
	my $arr = "";
	$name =~ s/ /_/g;
	# attacks...
	$name =~ s/[\.\/]//g;
	open(INP, "<$name") || return("Diese Seite wurde noch nicht fertig geschrieben.");
	$arr = join("\n", <INP>);
	close(INP);
	return $arr;
}

our @menu = ();
split(',', $ENV{HTTP_ACCEPT_HEADER}); $lang = param('lang') || $_[0] || "de";
$item = param('item') || 0;

@menu = &parseMenu("./menu.inc");

for $ele (@menu) {
  next unless($ele->[0] eq $lang);
	next unless($ele->[1] == $item);
	next unless($ele->[2] == 1);
	$show = param('show') || $ele->[3];
	last;
}

@mymenu = &makeMenu($item, $lang, $show);

$text = getText($lang, $show);

$template->param(MENU => \@mymenu);
$template->param(titel => $show);
$template->param(text => $text);
$template->param(images => $images);

print $template->output();

