#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, %D);

sub handleADB {
	my ($uid, $host) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $blame) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [qw/ Arial 12 /]),
		$screen->Label(@L, -text => join("\n\t >", L("GOVSystem"), qw/readonly readwrite admin/)),
	);
	$title->grid(-row => 0, -column => 0, -sticky => "wn");
	$blame->grid(-row => 1, -column => 0, -sticky => "wn");
	BindLabel($screen, L("ok"), "<ButtonPress-1>", sub {
		logInScreen(
			$uid,
			$host,
			sub {
				playSound("login");
				triggerTrace() if($host->{Records}{$windows{UserEntry}}{Level} == 0);
				newNews("BROKENIN", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
				handleADBmenu($uid, $host, $windows{UserEntry})
			}
		);
	})->grid(-row => 2, -column => 0, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
};

sub handleADBmenu {
	my ($uid, $host, $user) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my $menu   = new MyLinkMenu($screen);
	$menu->addItem(1, "Title"             => $host->{Name});
	$menu->addItem(1, "Subtitle"          => L("MainMenu"));
	$menu->addItem(1, L("SearchDatabase") => sub { ADBrecords(sub { handleADBmenu($uid, $host, $user) }, $uid, $host, $user) });
	$menu->addItem($host->{Records}{$user}{Level} == 0 ? 1 : 0, L("AdminMenu") => sub { _admin(sub { handleADBmenu($uid, $host, $user) }, $host, $uid, $user, qw/Logs Security Records/) });
	$_->pack for($menu, $screen);
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub ADBrecords {
	my ($return, $uid, $host, $user) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $nameE, $searchB, $pictureL, $picL, $oldT, $done, $newE, $okB, $clear);
	my ($nameV, $newV) = (L("EnterPersonName"), "");
	my $showSub = sub {
		my $toShow = shift;
		($nameV, $newV) = ($toShow, "");
		$oldT->delete(qw/ 0.0 end /);
		$oldT->insert("0.0", (join "\n", @{ $host->{Database}{$toShow} }) || L("ADB_NoQualifications"));
		my $id = 0;
		$id   += ord($_) * ord($_) for(split "", $toShow);
		if(exists $D{Credits}->{$toShow}) {
			$pictureL->configure(-file => "graphics/person" . $D{Credits}->{$toShow} . ".xpm");
		} else {
			$pictureL->configure(-file => "graphics/person" . ($id % 14) . ".xpm");
		}
	};
	($title, $subtitle, $nameE, $searchB, $pictureL, $oldT, $done, $newE, $okB, $clear) = (
		$screen->Label(@H, -text => $host->{Name},     -font => [qw/ Arial 12 /]),
		$screen->Label(@H, -text => L("SearchDatabase"), -font => [qw/ Arial 8 /]),
		$screen->Entry(@E, -textvariable => \$nameV,   -width => 40),
		BindLabel($screen, L("Search"), "<ButtonPress-1>", sub {
			$host = update($host, $uid);
			my ($index, $found, $searchV) = ((0) x 2, $nameV);
			foreach my $entry (sort { lc($a) cmp lc($b) } keys %{ $host->{Database} }) {
				$screen->after($index++ * 400, sub { $showSub->($entry) });
				if($entry eq $searchV) {
					$found++;
					last;
				}
			}
			$screen->after($index++ * 400, sub { MyMesg(L("RecordNotFound_Title"), L("RecordNotFound_Text", $searchV)) })
				if(not $found);
		}),
		$screen->Photo(-file => "graphics/person0.xpm"),
		$screen->ROText(@E, -width => 20, -height => 12, -wrap => "word"),
		BindLabel($screen, L("DB_Done"), "<ButtonPress-1>", $return),
		$screen->Entry(@E, -textvariable => \$newV, -width => 40),
		BindLabel($screen, L("DB_Add"), "<ButtonPress-1>", sub {
			return if($host->{Records}{$user}{Level} > 1);
			if(not exists $host->{Database}{$nameV}) {
				MyMesg(L("RecordNotFound_Title"), L("RecordNotFound_Text", $nameV));
			} else {
				newNews("DBMODIFIED", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
				$host = update($host, $uid);
				push @{ $host->{Database}{$nameV} }, $newV;
				$rpc->call("storObject", $uid, $host);
				$showSub->($nameV);
			}
		}),
		BindLabel($screen, L("ADB_ClearQualifications"), "<ButtonPress-1>", sub {
			return if($host->{Records}{$user}{Level} > 1);
			if(not exists $host->{Database}{$nameV}) {
				MyMesg(L("RecordNotFound_Title"), L("RecordNotFound_Text", $nameV));
			} else {
				newNews("DBMODIFIED", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
				$host = update($host, $uid);
				$host->{Database}{$nameV} = [ ];
				$rpc->call("storObject", $uid, $host);
				$showSub->($nameV);
			}
		}),
	);
	$nameE->bind("<Enter>", sub { $nameV = "" if($nameV eq L("EnterPersonName")) });
	$picL = $screen->Label(@L, -image => $pictureL);
	if($host->{Records}{$user}{Level} > 1) {
		$_->configure(-foreground => "grey") for($okB, $clear);
		$newE->configure(-state => "disabled");
	}
	$title   ->grid(-row => 0, -column => 0, -columnspan => 2, -sticky => "nw");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 2, -sticky => "nw");
	$searchB ->grid(-row => 2, -column => 0, -columnspan => 1, -sticky => "we");
	$nameE   ->grid(-row => 2, -column => 1, -columnspan => 1, -sticky => "we");
	$oldT    ->grid(-row => 3, -column => 1, -columnspan => 1, -sticky => "we");
	$newE    ->grid(-row => 4, -column => 1, -columnspan => 1, -sticky => "we");
	$okB     ->grid(-row => 5, -column => 1, -columnspan => 1, -sticky => "we");
	$clear   ->grid(-row => 6, -column => 1, -columnspan => 1, -sticky => "we");
	$done    ->grid(-row => 7, -column => 0, -columnspan => 2, -sticky => "we");
	$picL    ->grid(-row => 3, -column => 0, -columnspan => 1, -rowspan => 4, -sticky => "nw");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

1;
