#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, %D, %actions);

sub _admin {
	my ($return, $host, $uid, $user, %allowed) = (shift, shift, shift, shift, map { $_ => 1 } @_);
	%allowed = map { $_ => 1 } qw/Logs Security Console Records/ if($host->{Type} eq "B"); # EVIL HACK
	$host = update($host, $uid);
	my $screen = $windows{Main}->Frame(@F);
	my $adminMenu = new MyLinkMenu($screen);
	$adminMenu->addItem(1, "Title"    => $host->{Name});
	$adminMenu->addItem(1, "Subtitle" => L("AdminMenu"));
	$adminMenu->addItem(1, L("Admin_FileServer")  => sub { _fileServer(sub { _admin($return, $host, $uid, $user, %allowed) }, $host, $uid, $user) }) if($allowed{Files} or $allowed{Bank});
	$adminMenu->addItem(1, L("Admin_EditSites")   => sub { _editSites(sub { _admin($return, $host, $uid, $user, %allowed) }, $host, $uid, $user) }) if($allowed{Sites});
	$adminMenu->addItem(1, L("Admin_ViewLogs")    => sub {  _adminLogs(sub { _admin($return, $host, $uid, $user, %allowed) }, $host, $uid, $user) }) if($allowed{Logs});
	$adminMenu->addItem(1, L("Admin_ViewRecords") => sub { _viewRecords(sub { _admin($return, $host, $uid, $user, %allowed)}, $host, $uid, $user) }) if($allowed{Records});
	$adminMenu->addItem(1, L("Admin_ViewLinks")   => sub { _viewLinks(sub { _admin($return, $host, $uid, $user, %allowed) }, $host, $uid, $user) }) if($allowed{Links});
	$adminMenu->addItem(1, L("Admin_Wallet")      => sub { _externWallet(sub { _admin($return, $host, $uid, $user, %allowed) }, $host, $uid, $user) }) if($allowed{Wallet});
	$adminMenu->addItem(1, L("Admin_Security")    => sub {  _adminSecu(sub { _admin($return, $host, $uid, $user, %allowed)}, $host, $uid, $user) }) if($allowed{Security});
	$adminMenu->addItem(1, L("Admin_Console")     => sub { _adminShell(sub { _admin($return, $host, $uid, $user, %allowed)}, $host, $uid, $user) }) if($allowed{Console});
	$adminMenu->addItem(1, L("Admin_LogOut")      => sub { _adminLogOut(sub { _admin($return, $host, $uid, $user, %allowed)}, $host, $uid, $user) }) if($allowed{LogOut});
	$adminMenu->addItem(1, L("back")              => $return) if(defined ref($return) and ref($return) eq "CODE");
	$adminMenu->pack;
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub _editSites {
	my ($return, $host, $uid, $user, $screen) = (@_, $windows{Main}->Frame(@F));
	my $suFr = $screen->Frame(@F);
	my ($inSuFr, %text);
	$text{$_} = $suFr->Text(@E, -width => 68, -height => 10) for(keys %{ $host->{Sites} });
	$text{$_}->insert("0.0", $host->{Sites}{$_})             for(keys %{ $host->{Sites} });
	my $tree = $screen->Optionmenu(
		-options => [ sort keys %{ $host->{Sites} } ],
		-command => sub {
			$inSuFr->gridForget if(defined $inSuFr);
			$text{$_[0]}->grid(-row => 0, -column => 0, -sticky => "wens");
			$inSuFr = $text{$_[0]};
		},
	);	
	my $back = BindLabel($screen, L("back"), "<ButtonPress-1>", $return);
	my ($title, $subtitle) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("Admin_EditSites"), -font => [ qw/Arial 8/ ]),
	);
	my $save = BindLabel($screen, L("SaveChanges"), "<ButtonPress-1>", sub {
		$host = update($host, $uid);
		$host->{Sites}{$_} = $text{$_}->get(qw/ 0.0 end /) for(keys %{ $host->{Sites} });
		$rpc->call("storObject", $uid, $host);
	});
	$title   ->grid(-row => 0, -column => 0, -sticky => "nw");
	$subtitle->grid(-row => 1, -column => 0, -sticky => "nw");
	$tree    ->grid(-row => 2, -column => 0, -sticky => "we");
	$suFr    ->grid(-row => 3, -column => 0, -sticky => "we");
	$save    ->grid(-row => 4, -column => 0, -sticky => "we");
	$back    ->grid(-row => 5, -column => 0, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub _adminLogOut {
	my ($return, $host, $uid, $user) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $mesg, $back);
	($title, $subtitle, $mesg, $back) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("Admin_LogOut"), -font => [ qw/Arial 8/ ]),
		BindLabel($screen, L("Admin_LogOut_Really"), "<ButtonPress-1>", sub {
			$host = update($host, $uid);
			$host->{LogOut} = 1;
			$rpc->call("storObject", $uid, $host);
			$mesg->configure(-text => L("Admin_LogOut_Out"));
			$windows{Top}->after(1000, sub { disConnect() });
		}),
		BindLabel($screen, L("back"), "<ButtonPress-1>", $return),
	);
	$title    ->grid(-row => 0, -column => 0, -sticky => "w");
	$subtitle ->grid(-row => 1, -column => 0, -sticky => "w");
	$mesg     ->grid(-row => 2, -column => 0, -sticky => "wens");
	$back     ->grid(-row => 3, -column => 0, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub _adminLogs {
	my ($return, $host, $uid, $user, $selector) = @_;
	$selector ||= sub { 1 };
	$host = update($host, $uid);
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $table, $back) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("Admin_ViewLogs"), -font => [ qw/Arial 8/ ]),
		MyTable(
			$screen,
			@F,
			-rows       => 15,
			-columns    => 3,
			-scrollbars => "e",
			-fixedrows  => 1,
		),
		$screen->Button(@B, -text => L("back"), -command => $return),
	);
	$table->put(0, $_->[0], $_->[1]) for([0, L("Timestamp")], [1, L("Admin_Logs_Message")]);
	my $index = 0;
	foreach my $key (sort { $b <=> $a } grep { $selector->($_, $host->{Logs}{$_}) } keys %{ $host->{Logs} }) {
		my $show = $host->{Logs}{$key};
		$show    = "(deleted)" if($show =~ /^\(deleted\)/);
		$table->put(++$index, 0, MyLinkPopup(m2m($key), $table, "log://$uid/$key", sub { _adminLogs($return, $host, $uid, $user, $selector) }));
		$table->put($index,   1, MyLinkPopup($show, $table, "log://$uid/$key", sub { _adminLogs($return, $host, $uid, $user, $selector) }));
	}
	$title->grid(   -row => 0, -column => 0, -sticky => "w");
	$subtitle->grid(-row => 1, -column => 0, -sticky => "w");
	$table->grid(   -row => 2, -column => 0, -sticky => "wens");
	$back->grid(    -row => 3, -column => 0, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub _adminShell {
	my ($return, $host, $uid, $user) = @_;
	$host = update($host, $uid);
	my $screen = $windows{Main}->Frame(@F);
	my ($dir, $console, $command, $send) = ("/", MyScrolled($screen, "ROText", -scrollbars => "e", -width => 80, @E));
	my $wBD        = 0;
	my $showPrompt = sub { $console->insert("end", "$user\@$host->{Name}:$dir # ") if($send->cget("-state") eq "active") };
	my $sendCmd    = sub {
		my ($console, $command) = @_;
		$console->insert("end", "$command\n");
		"" =~ /()()/;
		$command =~ s/([^ ]+) ?//;
		my ($cmd, $arg) = (lc($1), $command);
		if($cmd eq "ls" or $cmd eq "dir") {
			$console->windowCreate("end", -create => sub {
				my $rows;
				$rows = 5 if($dir eq "/");
				$rows = 5 if($dir eq "/sys" and not $wBD);
				$rows = 2 if($dir eq "/sys" and     $wBD);
				$rows = 2 if($dir eq "/etc");
				$rows = 10 if($dir eq "/usr");
				my $listing = MyTable($console, @F, -rows => $rows, -columns => 3, -fixedrows => 1, -scrollbars => "e");
				$listing->put(0, $_->[0], $_->[1]) for(
					[0, L("Filename")],
					[1, L("Size")],
					[2, L("EncryptionLevel")]
				);
				if($dir eq "/") {
					$listing->put(1, $_->[0], LL($listing, $_->[1])) for([0, "/"],    [1, L("n/a")], [2, L("n/a")]);
					$listing->put(2, $_->[0], LL($listing, $_->[1])) for([0, "/usr"], [1, L("n/a")], [2, L("n/a")]);
					$listing->put(3, $_->[0], LL($listing, $_->[1])) for([0, "/sys"], [1, L("n/a")], [2, L("n/a")]);
					$listing->put(4, $_->[0], LL($listing, $_->[1])) for([0, "/etc"], [1, L("n/a")], [2, L("n/a")]);
				} elsif($dir eq "/sys") {
					$listing->put(1, $_->[0], LL($listing, $_->[1])) for([0, ".."],    [1, L("n/a")], [2, L("n/a")]);
					if(not $wBD) {
						$listing->put(2, $_->[0], LL($listing, $_->[1])) for([0, "kernel.dat"], [1, "3 gigaquods"], [2, "0"]);
						$listing->put(3, $_->[0], LL($listing, $_->[1])) for([0, "network.dat"], [1, "4 gigaquods"], [2, "0"]);
						$listing->put(4, $_->[0], LL($listing, $_->[1])) for([0, "system.dat"], [1, "1 gigaquods"], [2, "0"]);
					}
				} elsif($dir eq "/etc") {
					$listing->put(1, $_->[0], LL($listing, $_->[1])) for([0, L("Admin_Shell_NoAccessFromConsole")], [1, L("n/a")], [2, L("n/a")]);
				} elsif($dir eq "/usr") {
					my $index = 1;
					$listing->put(1, $_->[0], LL($listing, $_->[1])) for([0, ".."], [1, L("n/a")], [2, L("n/a")]);
					foreach my $key (sort { lc($a) cmp lc($b) } keys %{ $host->{Files} }) {
						$listing->put(++$index, 0, LL($listing, $key));
						$listing->put($index,   1, LL($listing, L("GQs", $host->{Files}{$key}{Gigaquods})));
						$listing->put($index,   2, LL($listing, L("Level", $host->{Files}{$key}{Encrypted})));
					}
				}
				$listing;
			});
			$console->insert("end", "\n");
		} elsif($cmd eq "cd") {
			if($arg =~ /^(\/?usr\/?|\/?sys\/?|\/?etc\/?|\/)$/) {
				$arg =~ s/\///g;
				$dir = "/$arg";
			} elsif($arg eq "..") {
				$dir = "/";
			} else {
				$console->insert("end", L("Admin_Shell_DirNotFound", $arg) . "\n");
			}
		} elsif($cmd eq "run") {
			$host = update($host, $uid);
			if(exists $host->{Files}{$arg} and $arg =~ /-prog/ and $host->{Files}{$arg}{Encrypted} == 0) {
				$send->configure(-state => "disabled");
				$console->insert("end", L("Admin_Shell_StartingPrg", $arg));
				$actions{$arg}->((undef) x 3, "console://$uid");
				$console->after(2000, sub { $console->insert("end", L("Admin_Shell_Done") . "\n") });
				$console->after(2500, sub { $send->configure(-state => "active"); $showPrompt->() });
			} elsif($host->{Files}{$arg}{Encrypted}) {
				$console->insert("end", L("Admin_Shell_Encrypted", $arg) . "\n");
			} else {
				$console->insert("end", L("Admin_Shell_PrgNotFound", $arg) . "\n");
			}
		} elsif($cmd eq "shutdown") {
			$send->configure(-state => "disabled");
			$console->after(0000, sub { $console->insert("end", L("Admin_Shell_Down1")) });
			$console->after(1000, sub { $console->insert("end", L("Admin_Shell_Down2") . "\n") });
			$console->after(3000, sub { $console->insert("end", L("Admin_Shell_Down3") . "\n") });
			if($wBD) {
				$console->after(5000, sub { $console->insert("end", L("Admin_Shell_Down1nok")) });
				$console->after(7000, sub { $console->insert("end", L("Admin_Shell_Down2nok") . "\n") });
				$console->after(7500, sub { $console->insert("end", L("Admin_Shell_Down3nok")) });
				$host = update($host, $uid);
				$host->{Down} = 1;
				newNews("DOWN", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
				$rpc->call("storObject", $uid, $host);
				$rpc->call("storTimer",  time + $D{ReUp}, { ReUp => $uid });
				$console->after(9000, sub { disConnectOnly($uid) });
			} else {
				$console->after(5000,  sub { $console->insert("end", L("Admin_Shell_Down1ok")) });
				$console->after(7000,  sub { $console->insert("end", L("Admin_Shell_Down2ok") . "\n") });
				$console->after(7500,  sub { $console->insert("end", L("Admin_Shell_Down3ok")) });
				$console->after(9500,  sub { $console->insert("end", L("Admin_Shell_Down4ok") . "\n") });
				$console->after(10000, sub { $console->insert("end", L("Admin_Shell_Down5ok")) });
				$console->after(12000, sub { $console->insert("end", L("Admin_Shell_Down6ok") . "\n") });
				$console->after(13000, sub { $console->insert("end", L("Admin_Shell_Down7ok") . "\n") });
				$console->after(13500, sub { $send->configure(-state => "active"); $showPrompt->() });
			}
		} elsif($cmd eq "delete") {
			if($dir eq "/" or $dir eq "/etc") {
				$console->insert("end", L("Admin_Shell_NoDeleteFromConsole", $dir) . "\n");
			} elsif($dir eq "/sys") {
				$send->configure(-state => "disabled");
				$console->insert("end", L("Admin_Shell_Deleting", $dir) . "\n");
				newNews("SYSFILES", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
				my $time = 0;
				my %files = (
					"kernel.dat"  => { Gigaquods => 3 },
					"network.dat" => { Gigaquods => 4 },
					"system.dat"  => { Gigaquods => 1 },
				);
				foreach my $key (sort { lc($a) cmp lc($b) } keys %files) {
					$console->after($time += 50, sub { $console->insert("end", L("Admin_Shell_Deleting", $key)) });
					$console->after($time += $files{$key}{Gigaquods} * 1000, sub { $console->insert("end", L("Admin_Shell_Done") . "\n") });
				};
				$wBD = 1;
				$console->after($time + 100, sub { $console->insert("end", L("Admin_Shell_FinishedDeleting", $dir) . "\n") });
				$console->after($time + 100, sub { $send->configure(-state => "active"); $showPrompt->() });
			} elsif($dir eq "/usr") {
				$send->configure(-state => "disabled");
				$console->insert("end", 'Deleting "' . $dir . '"...' . "\n");
				newNews("DATALOSS", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
				my $time = 0;
				foreach my $key (sort { lc($a) cmp lc($b) } keys %{ $host->{Files} }) {
					$console->after($time += 50, sub { $console->insert("end", 'Deleting "' . $key . '"... ') });
					$console->after($time += $host->{Files}{$key}{Gigaquods} * 1000, sub { $console->insert("end", "done.\n") });
					$console->after($time += $host->{Files}{$key}{Gigaquods} * 1000, sub { $host = update($host, $uid); delete $host->{Files}{$key}; $rpc->call("storObject", $uid, $host) });
				};
				$console->after($time + 100, sub { $console->insert("end", 'Finished deleting "' . $dir . '".' . "\n") });
				$console->after($time + 100, sub { $send->configure(-state => "active"); $showPrompt->() });
			}
		} elsif($cmd eq "help") {
			$console->windowCreate("end", -create => sub {
				my $listing = MyTable($console, @F, -rows => 6, -columns => 2, -fixedrows => 1, -scrollbars => "e");
				$listing->put(0, $_->[0], $_->[1]) for([0, L("Admin_Shell_Help_Command")], [1, L("Admin_Shell_Help_Description")]);
				$listing->put(1, $_->[0], $_->[1]) for([0, L("Admin_Shell_Help_help")],    [1, L("Admin_Shell_Help_helpHelp")]);
				$listing->put(2, $_->[0], $_->[1]) for([0, L("Admin_Shell_Help_cd")],      [1, L("Admin_Shell_Help_cdHelp")]);
				$listing->put(3, $_->[0], $_->[1]) for([0, L("Admin_Shell_Help_dir")],     [1, L("Admin_Shell_Help_dirHelp")]);
				$listing->put(4, $_->[0], $_->[1]) for([0, L("Admin_Shell_Help_delete")],  [1, L("Admin_Shell_Help_deleteHelp")]);
				$listing->put(4, $_->[0], $_->[1]) for([0, L("Admin_Shell_Help_exit")],    [1, L("Admin_Shell_Help_exitHelp")]);
				$listing;
			});
			$console->insert("end", "\n");
		} elsif($cmd eq "exit") {
			$return->();
		} else {
			$console->insert("end", L("Admin_Shell_NotFound", $cmd) . "\n");
		}
		$showPrompt->();
	};
	$send = $screen->Button(@B, -text => "Send", -state => "active", -command => sub { $sendCmd->($console, $command); $command = "" }),
	my ($title, $subtitle, $enter, $back) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("Admin_Console"), -font => [ qw/Arial 8/ ]),
		$screen->Entry(@E, -textvariable => \$command, -width => 51, -font => [ qw/Courier 8/ ]),
	);
	$back = $screen->Button(@B, -text => L("back"), -command => $return);
	$console->insert("0.0", L("Admin_Shell_Welcome") . "\n");
	$title->   grid(-row => 0, -column => 0, -columnspan => 2, -sticky => "w");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 2, -sticky => "w");
	$console-> grid(-row => 2, -column => 0, -columnspan => 2);
	$enter->   grid(-row => 3, -column => 0, -columnspan => 1);
	$send->    grid(-row => 3, -column => 1, -columnspan => 1);
	$back->    grid(-row => 4, -column => 0, -columnspan => 2, -sticky => "we");
	$console->after(1500, $showPrompt);
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

1;
