#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H);

sub handleB {
	my ($uid, $host) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my $menu   = new MyLinkMenu($screen);
	$menu->addItem(1, "Title"    => $host->{Name});
	$menu->addItem(1, "Subtitle" => L("MainMenu"));
	$menu->addItem(1, L("Bank_AboutUs") =>
		sub {
			handleBcontacts(
				sub { handleB($uid, $host) },
				$uid,
				$host
			)
		});
	$menu->addItem(1, L("Bank_CreateNew") =>
		sub {
			handleBnew(
				sub { handleB($uid, $host) },
				$uid,
				$host
			)
		});
	$menu->addItem(1, L("Bank_ManageOld") =>
		sub {
			logInScreen($uid, $host, sub {
				playSound("login");
				handleBold(
					sub { handleB($uid, $host) },
					$uid,
					$host,
					$windows{UserEntry}
				)
			})
		});
	$menu->addItem(1, L("AdminMenu") =>
		sub {
			handleCmenu(sub { handleB($uid, $host) }, $uid, $host);
		});
	$menu->pack;
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub handleBold {
	my ($return, $uid, $host, $username) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my $menu   = new MyLinkMenu($screen);
	my ($viewAcc, $viewStatement, $transferMoney, $manageLoan);
	($viewAcc, $viewStatement, $transferMoney, $manageLoan) = (
		sub {
			my $rr = shift;
			my $ss = $windows{Main}->Frame(@F);
			$host  = update($host, $uid);
			my ($tt, $stt) = (
				$ss->Label(@H, -text => $host->{Name},     -font => [qw/ Arial 12 /]),
				$ss->Label(@H, -text => L("Bank_AccInfo"), -font => [qw/ Arial 8 /]),
			);
			my $ff = MyLinkForm(
				$ss,
				[],
				"Labels",
				[ L("Username"), L("Bank_CreditsTotal"), L("Bank_Credits"), L("Bank_Loan") ],
				[ \($username, L("Credits", $host->{Records}{$username}{Credits} + $host->{Records}{$username}{Loan}), L("Credits", $host->{Records}{$username}{Credits}), L("Credits", $host->{Records}{$username}{Loan})) ],
			);
			$tt ->grid(-row => 0, -column => 0, -sticky => "nw");
			$stt->grid(-row => 1, -column => 0, -sticky => "nw");
			$ff ->grid(-row => 2, -column => 0, -sticky => "wens");
			BindLabel($ss, L("back"), "<ButtonPress-1>", $rr)->grid(-row => 3, -column => 0, -sticky => "we");
			$ss->pack;
			$windows{InMain}->packForget if($windows{InMain});
			$windows{InMain} = $ss;
		},
		sub {
			$host = update($host, $uid);
			_adminLogs(
				$_[0],
				$host,
				$uid,
				$username,
				sub {
					$_[1] =~ /\Qlogged in as $username\E/ or
					$_[1] =~ /to \Q$username\E/ or
					$_[1] =~ /from \Q$username\E/
				},
			);
		},
		sub {
			my $rr = shift;
			my $ss = $windows{Main}->Frame(@F);
			my ($tt, $stt) = (
				$ss->Label(@H, -text => $host->{Name},      -font => [qw/ Arial 12 /]),
				$ss->Label(@H, -text => L("Bank_Transfer"), -font => [qw/ Arial 8 /]),
			);
			my $ff = MyLinkForm(
				$ss,
				[],
				"Entries",
				[ L("Bank_FromAcc"), L("Bank_FromBankIP"), L("Bank_ToAcc"), L("Bank_ToBankIP"), L("Bank_Amount") ],
				[ "$username", "$uid", \my ($toAcc, $toBank, $toAmount) ],
			);
			my $SS = sub {
				$uObject = update($uObject, $uIP);
				$host    = update($host, $uid);
				my $ourRecord = $host->{Records}{$username};
				my $hisBank   = $rpc->call("recvObject", $toBank);
				if($hisBank eq "ERROR") {
					MyMesg(L("Bank_IPNotFound_Title"), L("Bank_IPNotFound_Text", $toBank));
				} elsif(not $toAmount =~ /^[0-9-]+$/) {
					MyMesg(L("Bank_NaN_Title"), L("Bank_NaN_Text", $toAmount));
				} elsif($hisBank->{Type} ne "B") {
					MyMesg(L("Bank_RemoteNotABank_Title"), L("Bank_RemoteNotABank_Text", $toBank));
				} elsif(not exists $hisBank->{Records}{$toAcc}) {
					MyMesg(L("Bank_RemoteAccNotFound_Title"), L("Bank_RemoteAccNotFound_Text", $toAcc, $toBank));
				} elsif($ourRecord->{Credits} + $ourRecord->{Loan} < $toAmount) {
					MyMesg(L("Bank_InsuffCredits_Title"), L("Bank_InsuffCredits_Text", L("Credits", $toAmount)));
				} else {
					if($toBank eq $uid) {
						$host->{Records}{$username}{Credits} -= $toAmount;
						$host->{Records}{$toAcc}{Credits}    += $toAmount;
						$host->{Logs}{u2m(time)}              = "${toAmount}c transferred from $username to $toAcc";
						$rpc->call("storObject", $uid, $host);
					} else {
						$host->{Records}{$username}{Credits} -= $toAmount;
						$hisBank->{Records}{$toAcc}{Credits} += $toAmount;
						$host->{Logs}{u2m(time)}              = "${toAmount}c transferred from $username to $toAcc\@$toBank";
						$hisBank->{Logs}{u2m(time)}           = "${toAmount}c received from $username\@$uid to $toAcc";
						$rpc->call("storObject", $uid, $host);
						$rpc->call("storObject", $toBank, $hisBank);
					}
					$rr->();
					MyMesg(L("Bank_TransferOK_Title"), L("Bank_TransferOK_Text", L("Credits", $toAmount)));
				}
			};
			$tt ->grid(-row => 0, -column => 0, -columnspan => 2, -sticky => "nw");
			$stt->grid(-row => 1, -column => 0, -columnspan => 2, -sticky => "nw");
			$ff ->grid(-row => 2, -column => 0, -columnspan => 2, -sticky => "wens");
			BindLabel($ss, L("back"), "<ButtonPress-1>", $rr)->grid(-row => 3, -column => 0, -sticky => "we");
			BindLabel($ss, L("Bank_TransferSend"), "<ButtonPress-1>", $SS)->grid(-row => 3, -column => 1, -sticky => "we");
			$ss->pack;
			$windows{InMain}->packForget if($windows{InMain});
			$windows{InMain} = $ss;
		},
		sub {
			my $rr = shift;
			my $ss = $windows{Main}->Frame(@F);
			$host  = update($host, $uid);
			my ($tt, $stt) = (
				$ss->Label(@H, -text => $host->{Name},         -font => [qw/ Arial 12 /]),
				$ss->Label(@H, -text => L("Bank_ManageLoan"), -font => [qw/ Arial 8 /]),
			);
			my $ff = MyLinkForm(
				$ss,
				[],
				"Labels",
				[ L("Bank_Credits"), L("Bank_CurLoan"), L("Bank_MaxLoan") ],
				[ \(
					L("Credits", $host->{Records}{$username}{Credits}),
					L("Credits", $host->{Records}{$username}{Loan}),
					L("Credits", $host->{Records}{$username}{LoanMax})
				) ],
			);
			my $incLoan = BindLabel($ss, L("Bank_IncLoan"), "<ButtonPress-1>", sub {
				$host = update($host, $uid);
				if($host->{Records}{$username}{Loan} + 100 <= $host->{Records}{$username}{LoanMax}) {
					$host->{Records}{$username}{Loan} += 100;
					$rpc->call("storObject", $uid, $host);
					$manageLoan->($rr);
				} else {
					MyMesg(L("Bank_NoNewLoan_Title"), L("Bank_NoNewLoan_Text"));
				}
			});
			my $decLoan = BindLabel($ss, L("Bank_DecLoan"), "<ButtonPress-1>", sub {
				$host = update($host, $uid);
				if($host->{Records}{$username}{Loan} - 100 < 0) {
					MyMesg(L("Bank_NoNewLoan_Title"), L("Bank_NewLoan0_Text"));
				} elsif($host->{Records}{$username}{Loan} + $host->{Records}{$username}{Credits} - 100 < 0) {
					MyMesg(L("Bank_NoNewLoan_Title"), L("Bank_NewLoanDebts_Text"));
				} else {
					$host->{Records}{$username}{Loan} -= 100;
					$rpc->call("storObject", $uid, $host);
					$manageLoan->($rr);
				}
			});
			$tt ->grid(-row => 0, -column => 0, -columnspan => 2, -sticky => "nw");
			$stt->grid(-row => 1, -column => 0, -columnspan => 2, -sticky => "nw");
			$ff ->grid(-row => 2, -column => 0, -columnspan => 2, -sticky => "wens");
			$incLoan->grid(-row => 3, -column => 0, -sticky => "we");
			$decLoan->grid(-row => 3, -column => 1, -sticky => "ew");
			BindLabel($ss, L("back"), "<ButtonPress-1>", $rr)->grid(-row => 4, -column => 0, -columnspan => 2, -sticky => "we");
			$ss->pack;
			$windows{InMain}->packForget if($windows{InMain});
			$windows{InMain} = $ss;
		},
	);
	$menu->addItem(1, "Title"                 => $host->{Name});
	$menu->addItem(1, "Subtitle"              => L("Bank_ManageOld"));
	$menu->addItem(1, L("Bank_AccInfo")       => sub { $viewAcc->(sub { handleBold($return, $uid, $host, $username) }) });
	$menu->addItem(1, L("Bank_ViewStatement") => sub { $viewStatement->(sub { handleBold($return, $uid, $host, $username) }) });
	$menu->addItem(1, L("Bank_Transfer")      => sub { $transferMoney->(sub { handleBold($return, $uid, $host, $username) }) });
	$menu->addItem(1, L("Bank_ManageLoan")    => sub { $manageLoan   ->(sub { handleBold($return, $uid, $host, $username) }) });
	$menu->pack;
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub handleBcontacts {
	my ($return, $uid, $host) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $frame, $back) = (
		$screen->Label(@H, -text => $host->{Name},     -font => [qw/ Arial 12 /]),
		$screen->Label(@H, -text => L("Bank_AboutUs"), -font => [qw/ Arial 8 /]),
		$screen->Frame(@F),
		BindLabel($screen, L("back"), "<ButtonPress-1>", $return),
	);
	my @contacts = genContacts($frame, $host);
	$contacts[$_]->grid(-row => int($_ / 2), -column => $_ % 2, -sticky => "wens") for(0 .. $#contacts);
	$title   ->grid(-row => 0, -column => 0, -sticky => "w");
	$subtitle->grid(-row => 1, -column => 0, -sticky => "w");
	$frame   ->grid(-row => 2, -column => 0, -sticky => "we");
	$back    ->grid(-row => 3, -column => 0, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub handleBnew {
	my ($return, $uid, $host) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($username, $pwd, $repwd, $okSub) = ("") x 3;
	my ($title, $subtitle, $frame, $ok, $back) = (
		$screen->Label(@H, -text => $host->{Name},       -font => [qw/ Arial 12 /]),
		$screen->Label(@H, -text => L("Bank_CreateNew"), -font => [qw/ Arial 8 /]),
		MyLinkForm(
			$screen,
			[],
			"Entries",
			[ L("Bank_DesiredUsername"), L("Password"), L("Bank_RepeatPassword") ],
			[ \($username, $pwd, $repwd) ],
		),
		$screen->Button(@B, -text => L("ok"),   -width => 40, -command => sub { $okSub->() }),
		$screen->Button(@B, -text => L("back"), -command => $return),
	);
	$okSub = sub {
		my $error;
		if(not defined $username or not $username) {
			$error = L("Bank_ErrSpecifyBoth");
		}
		elsif($pwd ne $repwd) {
			$error = L("Bank_ErrRepeated");
		}
		elsif(exists $host->{Records}{$username}) {
			$error = L("Bank_ErrAlreadyExists", $username);
		} else {
			$host = update($host, $uid);
			$host->{Records}{$username} = {
				Password => $pwd,
				Level    => 3,
				Credits  => 0,
				Loan     => 0,
				LoanMax  => 1000,
			};
			$rpc->call("storObject", $uid, $host);
		}
		if($error) {
			playSound("zap");
			$ok->configure(-text => $error, -state => "disabled");
			$screen->after(2000, sub { $ok->configure(-text => L("ok"), -state => "active") });
		} else {
			$_->gridForget for($frame, $ok, $back);
			$uObject = update($uObject, $uIP);
			$uObject->{Wallet}{$uid}{$username} = $pwd;
			$rpc->call("storObject", $uIP, $uObject);
			playSound("login");
			my $eFrame = BindLabel(
				$screen,
				L("Bank_Proceed"),
				"<ButtonPress-1>",
				sub { handleBold($return, $uid, $host, $username) }
			);
			$eFrame->grid(-row => 2, -column => 0, -columnspan => 2, -sticky => "we");
		}
	};
	$title   ->grid(-row => 0, -column => 0, -columnspan => 2, -sticky => "w");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 2, -sticky => "w");
	$frame   ->grid(-row => 2, -column => 0, -columnspan => 2, -sticky => "we");
	$ok      ->grid(-row => 3, -column => 0, -columnspan => 1, -sticky => "we");
	$back    ->grid(-row => 3, -column => 1, -columnspan => 1, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

1;
