#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;

our %CACHE_N;
our %CACHE_T;

sub _cacheFetch {
	my $uid = shift;
#	STDERR->print("Cache lookup to $uid...: ");
	if(exists $CACHE_N{$uid}) {
#		STDERR->print("found, $CACHE_N{$uid}\n");
	} else {
		my $host = $rpc->call("recvObject", $uid);
		$CACHE_N{$uid} = $host->{Name};
		$CACHE_T{$uid} = $host->{Type};
#		STDERR->print("miss, $CACHE_N{$uid}\n");
	}
}

sub C_N {
	my $uid = shift;
	_cacheFetch($uid);
	return $CACHE_N{$uid};
}

sub C { C_N(@_) }

sub C_T {
	my $uid = shift;
	_cacheFetch($uid);
	return $CACHE_T{$uid};
}

1;
