#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, @W);

sub handleC {
	my ($uid, $host, $lastBounce) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $msg, $ok) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [qw/ Arial 12 /]),
		$screen->Label(@L, -wraplength => "500", -text =>
			C_N($lastBounce) =~ /\Q$host->{Allowed}\E/
				? L("Central_Hello", $lastBounce)
				: L("Central_Closed", $host->{Allowed})),
		BindLabel($screen, L("ok"), "<ButtonPress-1>", sub {
			if($rpc->call("recvObject", $lastBounce)->{Name} =~ /\Q$host->{Allowed}\E/) {
				handleCmenu($uid, $host);
			} else {
				disConnect();
			}
		}),
	);
	my $index = 0;
	$_->grid(-row => $index++, -column => 0, -sticky => "wn") for($title, $msg);
	$_->grid(-row => $index++, -column => 0, -sticky => "we") for($ok);
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub handleCmenu {
	my $back;
	$back = shift if(ref($_[0]) eq "CODE");
	my ($uid, $host) = (shift, shift);
	newNews("BREAKATTEMPT", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
	multipleSecurity(
		defined $back ? $back : undef,
		$uid,
		$host,
		{ pwd => 0, elliptic => 0, voice => 0 },
		sub {
			newNews("BROKENIN", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
			_admin(
				0,
				$host,
				$uid,
				(grep { $host->{Records}{$_}{Level} == 0 } keys %{ $host->{Records} })[0],
				qw/Files Logs Records Security Console/
			)
		}
	);
}

sub multipleSecurity {
	my ($back, $uid, $host, %ok) = (shift, shift, shift, %{ (shift) });
	warn Dumper(\%ok);
	my $callback = shift;
	my $screen = $windows{Main}->Frame(@F);
	my $title  = $screen->Label(@H, -text => $host->{Name}, -font => [qw/ Arial 12 /]);
	my %gotos  = ();
	$gotos{pwd} = BindLabel($screen,
										 			L("Central_PWDAuth"),
										 			"<ButtonPress-1>",
										 			sub {
														return if($ok{pwd});
														logInScreen(
															$uid,
											 				$host,
															(grep { $host->{Records}{$_}{Level} == 0 } keys %{ $host->{Records} })[0],
															sub {
																playSound("done");
																triggerTrace();
																multipleSecurity($back, $uid, $host, { %ok, pwd => 1 }, $callback);
															}
														)
													}) if(exists $ok{pwd});
	$gotos{elliptic} = BindLabel($screen,
										 					L("Central_EllAuth"),
															"<ButtonPress-1>",
										 					sub {
																return if($ok{elliptic});
																elliptic($uid, $host);
																playSound("done");
																multipleSecurity($back, $uid, $host, { %ok, elliptic => 1 }, $callback);
															}) if(exists $ok{elliptic});
	$gotos{voice} = BindLabel($screen,
											 			L("Central_VoiAuth"),
											 			"<ButtonPress-1>",
											 			sub {
															return if($ok{voice});
															voiceCheck($uid, $host);
															playSound("done");
															multipleSecurity($back, $uid, $host, { %ok, voice => 1 }, $callback);
														}) if(exists $ok{voice});
	my %stati = map {
		$_ => $screen->Label(@W, @L,
												 -text       => $ok{$_} ? L("Central_Granted") : L("Central_Denied"),
												 -foreground => $ok{$_} ? "green"   : "red")
	} keys %gotos;
	$title     ->grid(-row => 0, -column => 0, -columnspan => 2);
	my $index = 0;
	for(qw/pwd elliptic voice/) {
		next unless(exists $gotos{$_});
		$gotos{$_}->grid(-row => ++$index, -column => 0, -columnspan => 1, -sticky => "w");
		$stati{$_}->grid(-row => $index,   -column => 1, -columnspan => 1, -sticky => "e");
		$gotos{$_}->configure(-foreground => "grey") if($ok{$_});
	}
	my $proceed = $screen->Button(
		-text    => L("Proceed"),
		-state   => (scalar (grep { $ok{$_} == 1 } keys %ok) == scalar keys %gotos) ? "active" : "disabled",
		-command => sub {
			playSound("login");
			triggerTrace();
			$callback->();
		}
	);
	$proceed->grid(-row => ++$index,    -column => 0, -columnspan => 2, -sticky => "we");
	$screen->Button(-text => L("back"), -command => sub { playSound("mouseclick"); $back->() })
		      ->grid(-row => ++$index,    -column => 0, -columnspan => 2, -sticky => "we")
						if(defined $back);
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub voiceCheck {
	my ($uid, $host) = (shift, shift);
	my $screen = $windows{Main}->Frame(@F);
	my $retOk  = 0;
	my $title  = $screen->Label(@H, -text => $host->{Name}, -font => [qw/ Arial 12 /]);
	my $stitle = $screen->Label(@H, -text => L("Central_VoiAuth"), -font => [qw/ Arial 8 /]);
	my @wave   = map { int rand 50 } 1 .. 40;
	$windows{VoiceIPC} = -1;
	$windows{VoiceOk}  = 0;
	my ($eliteCanvas, $label, $okYesNo) = (
		$screen->Canvas(@F, -width => 200, -height => 100),
		$screen->Label(@L,     -text => L("Central_VoiRoot")),
		$screen->Label(@L, @W, -text => L("Central_VoiUndef"), -foreground => "grey"),
	);
	my ($eliteID, $eliteSub);
	$eliteSub = sub {
		shift @wave;
		push @wave, int rand 50;
		$eliteCanvas->delete($eliteID) if(defined $eliteID);
		$eliteID = $eliteCanvas->createLine((map { $_ * 5, $wave[$_] + 26 } 0 .. $#wave), -smooth => 1, -fill => "green");
		if($windows{VoiceIPC} eq $host->{Records}{(grep { $host->{Records}{$_}{Level} == 0 } keys %{ $host->{Records} })[0]}{Voice}) {
			$okYesNo->configure(-text => L("Central_VoiOk"), -foreground => "green");
			$screen->after(1000, sub { $windows{VoiceOk} = 1 });
		} elsif($windows{VoiceIPC} ne -1) {
			$okYesNo->configure(-text => L("Central_VoiNok"), -foreground => "red");
			$screen->after(50, $eliteSub);
		} else {
			$screen->after(50, $eliteSub);
		}
	};
	$title      ->grid(-row => 0, -column => 0, -columnspan => 2, -rowspan => 1, -sticky => "w");
	$stitle     ->grid(-row => 1, -column => 0, -columnspan => 2, -rowspan => 1, -sticky => "w");
	$eliteCanvas->grid(-row => 2, -column => 0, -columnspan => 1, -rowspan => 2, -sticky => "w");
	$label      ->grid(-row => 2, -column => 1, -columnspan => 1, -rowspan => 1, -sticky => "e");
	$okYesNo    ->grid(-row => 3, -column => 1, -columnspan => 1, -rowspan => 1, -sticky => "e");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
	$eliteSub->();
	$screen->waitVariable(\$windows{VoiceOk});
}

sub elliptic {
	my ($uid, $host) = (shift, shift);
	my $screen = $windows{Main}->Frame(@F);
	my $retOk  = 0;
	my $title  = $screen->Label(@H, -text => $host->{Name}, -font => [qw/ Arial 12 /]);
	my $stitle = $screen->Label(@H, -text => L("Central_EllAuth"), -font => [qw/ Arial 8 /]);
	# 20x10 matrix: huhuhu ^^ ;-) :) :-)
	my ($w,$h) = (40, 15);
	my @number = map { int(rand 9) + 1 } 1 .. $w * $h;
	my @label  = map { $screen->Label(@L, -textvariable => \$number[$_ - 1]) } 1 .. $w * $h;
	$_ = MyLinkPopup($label[$_], "elliptic://$uid") for(0 .. $w * $h - 1);
	my @times  = map { 0 } 1 .. $w * $h;
	$title    ->grid(-row => 0,                -column => 0, -columnspan => $w, -sticky => "wn");
	$stitle   ->grid(-row => 1,                -column => 0, -columnspan => $w, -sticky => "wn");
	$label[$_]->grid(-row => 2 + int($_ / $w), -column => $_ % $w) for(0 .. $w * $h - 1);
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
	$windows{EllipticIPC}    = -1;
	$windows{EllipticCycles} = 0;
	$windows{EllipticOk}     = 0;
	$windows{EllipticTotal}  = $w * $h;
	my $updSub;
	$updSub = sub {
		for(my $i = 0; $i < $w * $h; $i++) {
			$number[$i] = int(rand 9) + 1 unless($number[$i] == 0);
		}
		if($windows{EllipticIPC} > -1 and
			 ++$windows{EllipticCycles} * 200 >= $windows{EllipticIPC}) {
			my $count = ($windows{EllipticCycles} * 200) / $windows{EllipticIPC};
			$windows{EllipticCycles} = 0;
				for(my $c = 0; $c < $count; $c++) {
				my @candidates = grep { $number[$_] != 0 } 0 .. $w * $h - 1;
				my @fuenf      = ();
				my $steps      = 5;
				push @fuenf, splice @candidates, int rand @candidates, 1 for(1 .. $steps);
				$number[$_] = 0 for(@fuenf);
				$windows{EllipticOk} += $steps;
				foreach my $i (qw/1 2 3 4 5 6 7 8 9 a b c d e f/) {
					$screen->after((hex($i) - 1) * 100, sub {
						my $neg = 10 - hex($i);
						$neg    = 0 if($neg < 0);
						$label[$_]->configure(-background => "#$i$i$i", -textvariable => \$neg)
							for(@fuenf);
					});
				}
			}
		}
		if($windows{EllipticOk} == $windows{EllipticTotal}) {
			$screen->after(1500, sub { $retOk = 1 });
		} else {
			$screen->after(200, $updSub);
		}
	};
	$screen->after(200, $updSub);
	$screen->waitVariable(\$retOk);
	undef $windows{EllipticIPC};
}

1;
