#!/usr/bin/perl -w

use warnings;
use strict;

our $VERSION = "0.93";

our %D = (
	300    => 60 * 60,  # 300c for gateway-using
	Loan   => 60 * 15,  # 100c for having a positive loan
	"300c" => 300,      # 300 c for gw-using
	LoanC  => 100,      # 100 c for having a loan
	ReUp   => 60 * 15,  # Time needed to restore a previously destroyed computer
	PWCh   => 60 * 1,   # Random-password-broke-in-checker
	NewGW  => 60 * 1.5, # Time needed to build a new Gateway
	NewHW1 => 60 * 0.5, # Time needed to send sb to your GW
	NewHW2 => 60 * 1.0, # Time needed to finish GW-work
	Yeah   => 60 * 0.3, # Time needed to check if the user has succeeded a mission

	ActiveDelays => {
		PC     =>  2,
		AT     =>  3,
		V      =>  5,
		P      =>  5,
		U      => 10,
		F      => 14,
		N      => 15,
		I      => 15,
		M      => 18,
		W      => 19,
		ADB    => 20,
		C      => 23,
		SOCSEC => 24,
		GCD    => 24,
		B      => 25,
		Randomness => 7,
	},

	PassiveDelays => {
		B      =>  30,
		C      =>  35,
		GCD    =>  35,
		SOCSEC =>  35,
		W      =>  55,
		ADB    =>  60,
		M      =>  60,
		I      =>  90,
		F      =>  95,
		U      => 160,
		P      => 180,
		V      => 180,
		AT     => 360,
		PC     => 360,
		Randomness => 30,
	},

	MissionDel => 3,

	Credits => {			# associations name <=> image number
		"Iblech Blechschmidt" => 13,
		"Hoerner96 Kuemmerle" => 5,
		"Andi Heitmann"       => 6,
		"Estel Hartmann"      => 8,
		"Krischi Grafporno"   => 9,
		"Nytron Fietz"        => 10,
		"Jodo Dosch"          => 11,
		"Vim TheEditor"       => 12,
		"Dave"                => 4,
		"Phips Heinrich"      => 3,
		"Est Stamp"           => 2,
		"TheMaaaa Frieb"      => 1,
		"Florian Wintermayr"  => 7,
		"Datenzalat Prescher" => 14,
		"Fernando XXX"        => 15,
		"XXX XXX"             => 16,
		"Gernot Forstner"     => 17,
	},
);

our (@F, @B, @L, @E, @H, @M, @S, @P, @SB, @T, @HL, @NHL, @EHL, @W);
sub initStyle {
	@HL  = (qw/-highlightbackground black -highlightcolor blue/);
	@NHL = (qw/-highlightbackground black -highlightcolor black/);
	@EHL = (qw/-highlightbackground white -highlightcolor white/);
	@F   = (qw/-background black/, @NHL);
	@W   = (qw/-background black -relief groove -borderwidth 1/, @NHL);
	@B   = (qw/-foreground white -background black -borderwidth 0 -activebackground black -activeforeground yellow -pady 1 -padx 1/, @HL);
	@L   = (qw/-foreground white -background black -anchor w -justify left/, @NHL);
	@M   = (qw/-foreground white -background black/);
	@H   = (-foreground => "#1874CD", qw/-background black -anchor w -justify left/);
	@E   = (-background => "#00008B", -insertbackground => "#FF4500", qw/-foreground yellow -borderwidth 1 -relief sunken -insertofftime 400 -insertontime 400/, @HL);
	@S   = (-background => "#ADD8E6", qw/-troughcolor black -borderwidth 0 -width 10/);
	@P   = (qw/-background black/);
	@T   = (-selectbackground => "#00008B", qw/-background black -foreground white -selectforeground red/, @NHL);
	@SB  = (-background => "#00008B", qw/-troughcolor black -borderwidth 0 -activebackground blue/, @NHL);
}

1;
