#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, @W, %D);

sub progressAnim {
	my ($to, $etop, $p) = @_;

	unless(defined $etop) {
		$p = $windows{Top}->Toplevel(-width => 160, -height => 204, @F);
	} else {
		$p = $etop        ->Toplevel(-width => 160, -height => 204, @F);
	}
	$p->overrideredirect(1);
	my ($x, $y);
	unless(defined $etop) {
		$windows{Top}->geometry =~ /.*?\+([^+]+)\+(.*)$/;
		($x, $y) = ($1, $2);
	} else {
		$etop->geometry         =~ /.*?\+([^+]+)\+(.*)$/;
		($x, $y) = ($1, $2);
	}
	$p->geometry("154x164+" . ($x + 400 - 154/2) . "+" . ($y + 300 - 164/2));
	my $progress = $p->Frame(@W);

	my $index = 0;
	my %buttons;
	foreach my $button qw/1 2 3  4 5 6  7 8 9  - 0 ./ {
		$buttons{$button} = $progress->Button(@B, -text => $button, -width => 1.67, -height => 2.5);
		$buttons{$button}->grid(-column => $index % 3, -row => int($index / 3));
		$index++;
	}
	
	my $string = L("Dialing") . " ";
	$buttons{Fazit} = $progress->Entry(@E, -textvariable => \$string);
	$buttons{Fazit}->grid(-column => 0, -columnspan => 3, -row => 4);

	$index = 0;
	foreach my $taste (split "", $to) {
		my $oTaste = $taste;
		$taste     = "1" unless($taste =~ /^[1-9]$/);
		$progress->after($index * 250 + 000, sub { $buttons{$taste}->configure(-relief => "sunken") });
		$progress->after($index * 250 + 000, sub { playSound($taste) });
		$progress->after($index * 250 + 100, sub { $string .= $oTaste });
		$progress->after($index * 250 + 249, sub { $buttons{$taste}->configure(-relief => "raised") });
		$index++;
	}
	$progress->after($index * 250 + 150, sub { $p->destroy });

	$progress->pack;

	return $index * 250 + 150;
}

sub update {
	my ($object, $uid) = @_;
	if($rpc->call("recvSum", $uid) eq chkSum($object)) {
		return $object;
	} else {
		return $rpc->call("recvObject", $uid);
	}
}

sub dial {
	disConnect(1) if($windows{ConnectedTo});
	my ($to, @bounces) = @_;
	$uObject = update($uObject, $uIP);
	if(exists $uObject->{ARPed} and $uObject->{ARPed}) {
		$to = "128.0.0.13";
		@bounces = ();
	}
	
	$windows{Top}->after(progressAnim(@bounces ? $bounces[0] : $to), sub {
		$windows{Bounces} = [ @bounces ];
		my $lastBounce    = @{ $windows{Bounces} } == 0 ? $uIP : $windows{Bounces}->[$#{$windows{Bounces}}];
		my $time          = time;
		for(my $i = 0; $i < @bounces; $i++) {
			my $bounce = $rpc->call("recvObject", $bounces[$i]);
			$bounce->{Logs} = { } unless(exists $bounce->{Logs});
			$bounce->{Logs}{u2m($time)} =
				"Bouncing connection from " .
				($i == 0 ? $uIP : $bounces[$i - 1]) .
				" to " .
				($i == $#bounces ? $to : $bounces[$i + 1]);
			$rpc->call("storObject", $bounces[$i], $bounce);
		}
		my $host = $rpc->call("recvObject", $to);
		if(exists $host->{Down} and $host->{Down}) {
			mainMsg(L("HostUnreachable"));
		} else {
			$uObject = update($uObject, $uIP);
			$uObject->{Logs} = { } unless(exists $uObject->{Logs});
			$uObject->{Logs}{u2m($time)} =
				"Connection established to " .
				(@bounces ? $bounces[0] : $to);
			$rpc->call("storObject", $uIP, $uObject);
			$host->{Logs} = { } unless(exists $host->{Logs});
			$host->{Logs}{u2m($time)} =
				"Connection accepted from " .
				(@bounces
					? pop @bounces
					: $uIP);
			$rpc->call("storObject", $to, $host);
			$windows{ConnectedTo} = $to;
			showMap();
			if($host->{Type} eq "I") {
				handleI($to, $host);
			} elsif($host->{Type} eq "F") {
				handleI($to, $host);
			} elsif($host->{Type} eq "M") {
				handleM($to, $host);
			} elsif($host->{Type} eq "N") {
				handleN($to, $host);
			} elsif($host->{Type} eq "V") {
				handleV($to, $host);
			} elsif($host->{Type} eq "U") {
				handleU($to, $host);
			} elsif($host->{Type} eq "C") {
				handleC($to, $host, $lastBounce);
			} elsif($host->{Type} eq "B") {
				handleB($to, $host);
			} elsif($host->{Type} eq "GCD") {
				handleGCD($to, $host);
			} elsif($host->{Type} eq "ADB") {
				handleADB($to, $host);
			} elsif($host->{Type} eq "SOCSEC") {
				handleSOCSEC($to, $host);
			} elsif($host->{Type} eq "P") {
				handleP($to, $host);
			} elsif($host->{Type} eq "AT") {
				handleAT($to, $host);
			} elsif($host->{Type} eq "PC") {
				handlePC($to, $host);
			} elsif($host->{Type} eq "W") {
				handleW($to, $host);
			}
		}
	});
}

sub disConnectOnly {
	my ($onlyIf, $add) = @_;
	disConnect($add) if($onlyIf eq $windows{ConnectedTo});
}

sub disConnect {
	playSound("close");
	if($windows{ConnectedTo}) {
		my $rHost = $rpc->call("recvObject", $windows{ConnectedTo});
		$rHost->{Logs}{u2m(time)} = "Connection closed";
		delete $rHost->{UnAuthAccess} if($rHost->{Type} eq "P");
		$rpc->call("storObject", $windows{ConnectedTo}, $rHost);
		undef $windows{ConnectedTo};
	}
	undef $windows{Bounces};
	undef $windows{ActiveTraceOriginating};
	undef $windows{ActiveTraceTimeLeft};
	undef $windows{ActiveTraceTimeTotal};
	undef $windows{ActiveTraceHopsTotal};
	undef $windows{ActiveTraceHopsDone};
	listLinks() unless(shift);
}

sub triggerTrace {
	passiveTrace($windows{ConnectedTo}, u2m(time));
	activeTrace();
}

sub passiveTrace {
	my ($nexthop, $time) = @_;
	my $host = $rpc->call("recvObject", $nexthop);
	return if(exists $host->{NoPassiveTrace} and $host->{NoPassiveTrace});
	my $delay;
	$delay = $D{PassiveDelays}->{$host->{Type}};
	$delay = int(
		(rand($D{PassiveDelays}->{Randomness}) + 100 - $D{PassiveDelays}->{Randomness}/2) *
		$delay /
		100
	);
	die "No! $host->{Type}" unless(defined $delay);
	foreach my $log (grep { $_ >= $time - 90 and $_ <= $time + 90 } keys %{ $host->{Logs} }) {
		if ($host->{Logs}{$log} =~ /^Connection accepted from ([^ ]+)$/) {
			warn "Initiated passive trace against ($nexthop)->($1)->($delay)->($time)\n";
			$rpc->call(
				"storTimer",
				time + 5,
				{
					FollowLog => {
						nh    => $nexthop,
						hop   => $1,
						ts    => $log,
						delay => $delay,
						orig  => $nexthop,
					}
				}
			);
		}
	}
}

sub activeTrace {
	my $host = $rpc->call("recvObject", $windows{ConnectedTo});
	return if(exists $host->{NoActiveTrace} and $host->{NoActiveTrace});
	return if(defined $windows{ActiveTraceOriginating} and $windows{ConnectedTo} eq $windows{ActiveTraceOriginating});
	$windows{ActiveTraceTimeLeft}  = 0;
	$windows{ActiveTraceTimeTotal} = 0;
	$windows{ActiveTraceHopsDone}  = 0;
	$windows{ActiveTraceHopsTotal} = 0;
	$windows{ActiveTraceOriginating} = $windows{ConnectedTo};
	my @hosts;
	if($windows{Bounces}) {
		my @timeToSayGoodBye = map {
			my $bhost = $rpc->call("recvObject", $_);
			my $ret;
			$ret = $D{ActiveDelays}->{C_T($_)};
			die "Noooo $bhost->{Type}!\n" unless(defined $ret);
			$ret += 1 if(int rand $D{ActiveDelays}->{Randomness} == 0);
			unshift @hosts, [ C($_), $ret ];
			$ret;
		} @{ $windows{Bounces} };
		$windows{ActiveTraceTimeLeft} += $_ for(@timeToSayGoodBye);
		$windows{ActiveTraceHopsTotal} = @{ $windows{Bounces} };
	} else {
		$windows{ActiveTraceTimeLeft} = 6;
	}
	$windows{ActiveTraceTimeTotal} = $windows{ActiveTraceTimeLeft};
	my ($checkSub, $lastHopTL);
	$checkSub = sub {
		undef $windows{ActiveTraceOriginating} unless($windows{ConnectedTo});
		undef $windows{ActiveTraceTimeLeft}    unless($windows{ConnectedTo});
		undef $windows{ActiveTraceTimeTotal}   unless($windows{ConnectedTo});
		undef $windows{ActiveTraceHopsTotal}   unless($windows{ConnectedTo});
		undef $windows{ActiveTraceHopsDone}    unless($windows{ConnectedTo});
		undef $windows{Bounces}                unless($windows{ConnectedTo});
		return unless($windows{ConnectedTo});
		$lastHopTL ||= $windows{ActiveTraceTimeLeft};
		$windows{ActiveTraceTimeLeft}--;
		if(defined $hosts[0]->[1] and $lastHopTL - $windows{ActiveTraceTimeLeft} >= $hosts[0]->[1]) {
			$windows{ActiveTraceHopsDone}++;
			$lastHopTL = $windows{ActiveTraceTimeLeft};
			pop @hosts;
		}
		if($windows{ActiveTraceTimeLeft} <= 0) {
			my $oldUID = $windows{ConnectedTo};
			disConnect();
			my $screen = $windows{Main}->Frame(@F);
			$screen->Label(@L, -text => L("ConnTerminatedByR"))->pack;
			BindLabel($screen, L("ok"), "<ButtonPress-1>", sub { listLinks() })->pack(-fill => "x");
			$screen->pack;
			$windows{InMain}->packForget if($windows{InMain});
			$windows{InMain} = $screen;
			$uObject = update($uObject, $uIP);
			$uObject->{Mails}{u2m(time)} = {
				Type    => "News",
				From    => "tracedaemon\@" . C_N($oldUID),
				Subject => L("ActiveTrace_Caught_Subject"),
				Text    => L("ActiveTrace_Caught_Text", C_N($oldUID), $oldUID),
				Time    => u2m(time),
			};
			$rpc->call("storObject", $uIP, $uObject);
			my $GCD = $rpc->call("recvObject", "66.241.237.147");
			push @{ $GCD->{Database}{$uObject->{Records}{$uObject->{Unixname}}{Realname}} }, "Computer crime";
			$rpc->call("storObject", "66.241.237.147", $GCD);
		} else {
			$windows{Top}->after(1000, $checkSub);
		}
	};
	$windows{Top}->after(1000, $checkSub);
}

1;
