#!/usr/bin/perl -w

use warnings;
use strict;

our %windows;

sub MyDottedLine {
	my ($canvas, @args) = @_;
	my @oArgs = @args;
	my @coords;
	push @coords, shift @args while($args[0] =~ /^[0-9.-]+$/);
	my %opts = @args;
	
	my $tag = $opts{-tags}->[0];
	die "No tag specified (MyLinkDottedLine(@oArgs))\n" unless($tag);

	my $id  = $canvas->createLine(@coords, %opts, -dash => ".");
	
	$windows{DottedLines} ||= {};
	my $rand   = int rand 100000;
	my $offset = 0;
	my $sub;
	$sub      = sub {
#		warn "maybe: $tag $rand\n";
		return unless(defined $windows{DottedLines} and
									$windows{DottedLines}->{$tag} == $rand
									and $canvas->find("withtag", $id));
#		warn "yes:   $tag $rand\n";
		$canvas->itemconfigure($id, -dashoffset => ($offset %= 6) --);
		$canvas->after($opts{dottedAfter} || 100, $sub);
	};
	$windows{DottedLines}->{$tag} = $rand;
	$canvas->after($opts{dottedAfter} || 100, $sub);
	return $id;
}

1;
