#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, @S);

use Tk::NoteBook;

sub missionEditor {
	my ($w, $x, $y, $uri) = @_;
	my $window = new MainWindow (-title => "Mission Editor");
	$window->geometry("800x400+$x+$y");
	
	my $leftFrame  = $window->Frame(-width => 300);
	my $rightFrame = $window->Frame(-width => 500);

	my $inRechts;
	my $selectA   = $leftFrame->Scrolled("HList", -separator => "/", -scrollbars => "osoe", -browsecmd => sub { $inRechts->packForget if($inRechts); $inRechts = missionEditorChanger($rightFrame, @_); });
	my $restartB  = $leftFrame->Button(-text => "Reset daemon (relogin afterwards)", -command => sub {
		$rpc->call("reset");
		exit 0;
	});
	my $newF      = $leftFrame->Entry(-textvariable => \my $newIP); $newIP = "0.0.0.0";
	my $newB      = $leftFrame->Button(-text => "New mission", -command => sub {
		open my $ofile, ">data/stdmissions/$newIP" or die $!;
		print $ofile "";
		close $ofile;
		$selectA->add("/$newIP", -text => "$newIP");
	});

	$selectA->add("/", -text => "STD_Missions");
	foreach my $host (sort grep { $_ ne "index" } split "\n", `ls -1 data/stdmissions/`) {
		warn "<<$host\n";
		$selectA->add("/$host", -text => "$host");
	}
	
	$selectA->pack;
	$restartB->pack;
	$newF->pack;
	$newB->pack;
	$leftFrame->grid(-row => 0, -column => 0);
	$rightFrame->grid(-row => 0, -column => 1);
}

sub missionEditorChanger {
	my $screen = shift;
	my $ip     = substr(shift, 1);
	open my $ifile, "<data/stdmissions/$ip" or die $!;
	my $c = join "", <$ifile>;
	my $host = eval("{ $c }");
	close $ifile;
	warn Dumper($ip, $host);

	my $nb      = $screen->NoteBook();
	my $general = $nb->add("General", -anchor => "nw", -label => "General");
	my $success = $nb->add("Success", -anchor => "nw", -label => "Success conditions");

	missionEditorGeneral($general, $ip, $host);
	missionEditorSuccess($success, $ip, $host);

	$nb->pack;
	return $nb;
}

sub missionEditorGeneral {
	my ($frame, $ip, $host) = @_;

	my $pRN    = $frame->Label(-text => "RankNeeded:");
		my $pfRN = $frame->Entry(-textvariable => \$host->{RankNeeded});
	my $pC     = $frame->Label(-text => "Credits on success:");
		my $pfC  = $frame->Entry(-textvariable => \$host->{Credits});
	my $pSubj  = $frame->Label(-text => "Subject:");
		my $pfSubj = $frame->Entry(-textvariable => \$host->{Subject});
	my $pText  = $frame->Label(-text => "Text:");
		my $pfText = $frame->Scrolled("Text", -width => 23, -height => 10, -wrap => "word", -scrollbars => "e");
		$pfText->insert("0.0", $host->{Text}),
	my $pLinks = $frame->Label(-text => "Links (blank separated):");
		my $pfLinks = $frame->Entry(-textvariable => \my $links);
	$host->{Links} ||= [ ];
	$links = join " ", @{ $host->{Links} };

	my $allC = $frame->Button(-text => "Save all changes to disk\n(don't forget to click on commit\nat all the other tabs!)", -command => sub {
		$host->{Links} = [ split " ", $links ];
		$host->{Text}  = $pfText->get(qw/ 0.0 end /);
		foreach my $k (keys %$host) { delete $host->{$k} unless(defined $host->{$k}) }
		my @data = split "\n", Dumper($host);
		shift @data; pop @data;
		s/^          // for(@data);
		my $data = join "\n", @data;
		open my $ofile, ">data/stdmissions/$ip" or die $!;
		print $ofile ($data);
		close $ofile;
	});

	$pRN   ->grid(-row => 0, -column => 0); $pfRN   ->grid(-row => 0, -column => 1);
	$pC    ->grid(-row => 1, -column => 0); $pfC    ->grid(-row => 1, -column => 1);
	$pSubj ->grid(-row => 2, -column => 0); $pfSubj ->grid(-row => 2, -column => 1);
	$pText ->grid(-row => 3, -column => 0); $pfText ->grid(-row => 3, -column => 1);
	$pLinks->grid(-row => 4, -column => 0); $pfLinks->grid(-row => 4, -column => 1);
	$allC->grid(-row => 5, -columnspan => 2, -column => 0);
}

sub missionEditorSuccess {
	my ($frame, $ip, $host, @recs) = @_;

	$host->{Success}     ||= { };
	$host->{Success}{Attachments} ||= [ ];
	my $attachments = join " ", @{ $host->{Success}{Attachments} };
	my $pAtts = $frame->Label(-text => "Attachments (blank separated):");
	my $fAtts = $frame->Entry(-textvariable => \$attachments);
	
	my $okB = $frame->Button(-text => "Commit", -command => sub {
		$host->{Success} = { };
		if($attachments) {
			$host->{Success}{Attachments} = [ split " ", $attachments ];
		}
	});

	$pAtts->pack(-side => "left");
	$fAtts->pack(-side => "right");
	$okB->pack;
}




















sub serverEditor {
	my ($w, $x, $y, $uri) = @_;
	my $window = new MainWindow (-title => "Server Editor");
	$window->geometry("800x400+$x+$y");
	
	my $leftFrame  = $window->Frame(-width => 300);
	my $rightFrame = $window->Frame(-width => 500);

	my $inRechts;
	my $selectA   = $leftFrame->Scrolled("HList", -separator => "/", -scrollbars => "osoe", -browsecmd => sub { $inRechts->packForget if($inRechts); $inRechts = serverEditorChanger($rightFrame, @_); });
	my $restartB  = $leftFrame->Button(-text => "Reset daemon (relogin afterwards)", -command => sub {
		$rpc->call("reset");
		exit 0;
	});
	my $newF      = $leftFrame->Entry(-textvariable => \my $newIP); $newIP = "0.0.0.0";
	my $newB      = $leftFrame->Button(-text => "New host", -command => sub {
		open my $ofile, ">data/$newIP" or die $!;
		print $ofile "Type => 'I',\n";
		close $ofile;
		$selectA->add("/$newIP", -text => "$newIP");
	});

	$selectA->add("/", -text => "Hosts");
	foreach my $host (sort @{ $rpc->call("recvObject", ":ALL") }) {
		warn ">>$host\n";
		$selectA->add("/$host", -text => "$host (" . $rpc->call("recvObject", $host)->{Name} . ")");
	}
	
	$selectA->pack;
	$restartB->pack;
	$newF->pack;
	$newB->pack;
	$leftFrame->grid(-row => 0, -column => 0);
	$rightFrame->grid(-row => 0, -column => 1);
}

sub serverEditorChanger {
	my $screen = shift;
	my $ip     = substr(shift, 1);
	open my $ifile, "<data/$ip" or die $!;
	my $host = eval("{ " . join("", <$ifile>) . " }");
	close $ifile;
	warn Dumper($ip, $host);

	my $nb      = $screen->NoteBook();
	my $general = $nb->add("General", -anchor => "nw", -label => "General");
	my $files   = $nb->add("Files",   -anchor => "nw", -label => "Files");
	my $records = $nb->add("Records", -anchor => "nw", -label => "Records");
	my $links   = $nb->add("Links",   -anchor => "nw", -label => "Links");
	my $contact = $nb->add("Contact", -anchor => "nw", -label => "Contacts");
	my $sites   = $nb->add("Sites",   -anchor => "nw", -label => "Websites");

	serverEditorGeneral($general, $ip, $host);
	serverEditorFiles  ($files,   $ip, $host);
	serverEditorRecords($records, $ip, $host);
	serverEditorLinks  ($links,   $ip, $host);
	serverEditorContact($contact, $ip, $host);
	serverEditorSites  ($sites,   $ip, $host);

	$nb->pack;
	return $nb;
}

sub serverEditorGeneral {
	my ($frame, $ip, $host) = @_;

	my $pIP   = $frame->Label(-text => "IP:");
		my $pfIP = $frame->Entry(-textvariable => \$ip, -state => "disabled");
	my $pName = $frame->Label(-text => "Name:");
		my $pfName = $frame->Entry(-textvariable => \$host->{Name});
	my $pType = $frame->Label(-text => "Type:");
		my $pfType = $frame->Entry(-textvariable => \$host->{Type});
	
	my $pAllo = $frame->Label(-text => "Allowed (only at Cs):");
		my $pfAllo = $frame->Entry(-textvariable => \$host->{Allowed});
	
	my $pFlags = $frame->Label(-text => "Flags:");
	$host->{NoPassiveTrace} = 0 unless(exists $host->{NoPassiveTrace});
	$host->{NoActiveTrace}  = 0 unless(exists $host->{NoActiveTrace});
	$host->{NoNews}         = 0 unless(exists $host->{NoNewsTrace});
	my $pfNoPa = $frame->Checkbutton(-variable => \$host->{NoPassiveTrace}, -text => "No passive trace");
	my $pfNoAc = $frame->Checkbutton(-variable => \$host->{NoActiveTrace},  -text => "No active trace");
	my $pfNoNe = $frame->Checkbutton(-variable => \$host->{NoNews},         -text => "No news");

	my $allC = $frame->Button(-text => "Save all changes to disk\n(don't forget to click on commit\nat all the other tabs!)", -command => sub {
		$host->{Logs} = { };
		foreach my $k (keys %$host) { delete $host->{$k} unless(defined $host->{$k}) }
		my @data = split "\n", Dumper($host);
		shift @data; pop @data;
		s/^          // for(@data);
		my $data = join "\n", @data;
		open my $ofile, ">data/$ip" or die $!;
		print $ofile ($data);
		close $ofile;
	});
	my $allD = $frame->Button(-text => "Save all changes only to daemon\n(don't forget to click on commit\nat all the other tabs!)", -command => sub {
		$host->{Logs} = { };
		$rpc->call("storObject", $ip, $host);
	});

	$pIP   ->grid(-row => 0, -column => 0); $pfIP->grid(-row => 0, -column => 1);
	$pName ->grid(-row => 1, -column => 0); $pfName->grid(-row => 1, -column => 1);
	$pType ->grid(-row => 2, -column => 0); $pfType->grid(-row => 2, -column => 1);
	$pFlags->grid(-row => 3, -column => 0);
		$pfNoPa->grid(-row => 3, -column => 1);
		$pfNoAc->grid(-row => 4, -column => 1);
		$pfNoNe->grid(-row => 5, -column => 1);
	$allC->grid(-row => 6, -columnspan => 2, -column => 0);
	$allD->grid(-row => 7, -columnspan => 2, -column => 0);
}

sub serverEditorFiles {
	my ($frame, $ip, $host, @files) = @_;

	my $table = $frame->Table(-rows => 10, -columns => 4, -fixedrows => 1, -scrollbars => "e");
	$table->put(0, $_->[0], $_->[1]) for([0, "Del"], [1, "Filename"], [2, "Size"], [3, "Encryption level"]);

	$host->{Files} = {} unless(exists $host->{Files});
	@files = map { [0, $_, $host->{Files}{$_}{Gigaquods}, $host->{Files}{$_}{Encrypted}] } sort keys %{ $host->{Files} } unless(scalar @files);
	for(my $i = 0; $i < @files; $i++) {
		$table->put($i + 1, 0, $table->Checkbutton(-variable => \$files[$i][0]));
		$table->put($i + 1, 1, $table->Entry(-textvariable => \$files[$i][1]));
		$table->put($i + 1, 2, $table->Entry(-textvariable => \$files[$i][2]));
		$table->put($i + 1, 3, $table->Entry(-textvariable => \$files[$i][3]));
	}
	
	my $addB = $frame->Button(-text => "Create new file", -command => sub {
		push @files, [0, "", 0, 0];
		$table->put(scalar @files, 0, $table->Checkbutton(-variable => \$files[$#files][0]));
		$table->put(scalar @files, 1, $table->Entry(-textvariable => \$files[$#files][1]));
		$table->put(scalar @files, 2, $table->Entry(-textvariable => \$files[$#files][2]));
		$table->put(scalar @files, 3, $table->Entry(-textvariable => \$files[$#files][3]));
	});

	my $okB = $frame->Button(-text => "Commit", -command => sub {
		$host->{Files} = {
			map { warn "@$_\n"; $_->[1] => { Gigaquods => $_->[2], Encrypted => $_->[3] } }
			grep { not $_->[0] }
			@files
		};
	});

	$table->pack;
	$addB->pack;
	$okB->pack;
}

sub serverEditorRecords {
	my ($frame, $ip, $host, @recs) = @_;

	my $table = $frame->Table(-rows => 10, -columns => 8, -fixedrows => 1, -scrollbars => "e");
	$table->put(0, $_->[0], $_->[1]) for([0, "Del"], [1, "Username"], [2, "Password"], [3, "Level"], [4, "Voice auth"], [5, "Credits"], [6, "Loan"], [7, "LoanMax"]);

	$host->{Records} = {} unless(exists $host->{Records});
	@recs = map { [0, $_, $host->{Records}{$_}{Password}, $host->{Records}{$_}{Level}, $host->{Records}{$_}{Voice} || "", $host->{Records}{$_}{Credits} || 0, $host->{Records}{$_}{Loan} || 0, $host->{Records}{$_}{LoanMax} || 1000] } sort keys %{ $host->{Records} } unless(scalar @recs);
	for(my $i = 0; $i < @recs; $i++) {
		$table->put($i + 1, 0, $table->Checkbutton(-variable => \$recs[$i][0]));
		$table->put($i + 1, 1, $table->Entry(-textvariable => \$recs[$i][1]));
		$table->put($i + 1, 2, $table->Entry(-textvariable => \$recs[$i][2]));
		$table->put($i + 1, 3, $table->Entry(-textvariable => \$recs[$i][3]));
		$table->put($i + 1, 4, $table->Entry(-textvariable => \$recs[$i][4]));
		$table->put($i + 1, 5, $table->Entry(-textvariable => \$recs[$i][5]));
		$table->put($i + 1, 6, $table->Entry(-textvariable => \$recs[$i][6]));
		$table->put($i + 1, 7, $table->Entry(-textvariable => \$recs[$i][7]));
	}
	
	my $addB = $frame->Button(-text => "Create new records", -command => sub {
		push @recs, [0, "", 0, 0, ""];
		$table->put(scalar @recs, 0, $table->Checkbutton(-variable => \$recs[$#recs][0]));
		$table->put(scalar @recs, 1, $table->Entry(-textvariable => \$recs[$#recs][1]));
		$table->put(scalar @recs, 2, $table->Entry(-textvariable => \$recs[$#recs][2]));
		$table->put(scalar @recs, 3, $table->Entry(-textvariable => \$recs[$#recs][3]));
		$table->put(scalar @recs, 4, $table->Entry(-textvariable => \$recs[$#recs][4]));
		$table->put(scalar @recs, 5, $table->Entry(-textvariable => \$recs[$#recs][5]));
		$table->put(scalar @recs, 6, $table->Entry(-textvariable => \$recs[$#recs][6]));
		$table->put(scalar @recs, 7, $table->Entry(-textvariable => \$recs[$#recs][7]));
	});

	my $okB = $frame->Button(-text => "Commit", -command => sub {
		$host->{Records} = {
			map { $_->[1] => {
				Password => $_->[2],
				Level    => $_->[3],
				($_->[4] ? (Voice   => $_->[4]) : ()),
				($_->[5] ? (Credits => $_->[5]) : ()),
				($_->[6] ? (Loan    => $_->[6]) : ()),
				($_->[7] ? (LoanMax => $_->[7]) : ()),
			} }
			grep { not $_->[0] }
			@recs
		};
	});

	$table->pack;
	$addB->pack;
	$okB->pack;
}

sub serverEditorLinks {
	my ($frame, $ip, $host) = @_;
	my $howto = $frame->Label(-text => "Enter the links (IPs), blank-separated");
	my $links = $frame->Entry(-textvariable => \my $ll);
	$host->{Links} = [] unless(exists $host->{Links});
	$ll = join " ", @{ $host->{Links} };
	my $okbu = $frame->Button(-text => "Commit", -command => sub { $host->{Links} = [ split " ", $ll ] });
	$howto->pack;
	$links->pack;
	$okbu ->pack;
}

sub serverEditorContact {
	my ($frame, $ip, $host, @contacts) = @_;

	my $table = $frame->Table(-rows => 10, -columns => 3, -fixedrows => 1, -scrollbars => "e");
	$table->put(0, $_->[0], $_->[1]) for([0, "Del"], [1, "Role"], [2, "IP=phone number"]);

	$host->{Contacts} = {} unless(exists $host->{Contacts});
	@contacts = map { [0, $_, $host->{Contacts}{$_}] } sort keys %{ $host->{Contacts} } unless(scalar @contacts);
	for(my $i = 0; $i < @contacts; $i++) {
		$table->put($i + 1, 0, $table->Checkbutton(-variable => \$contacts[$i][0]));
		$table->put($i + 1, 1, $table->Entry(-textvariable => \$contacts[$i][1]));
		$table->put($i + 1, 2, $table->Entry(-textvariable => \$contacts[$i][2]));
	}
	
	my $addB = $frame->Button(-text => "Create new Contacts", -command => sub {
		push @contacts, [0, "", 0, 0, ""];
		$table->put(scalar @contacts, 0, $table->Checkbutton(-variable => \$contacts[$#contacts][0]));
		$table->put(scalar @contacts, 1, $table->Entry(-textvariable => \$contacts[$#contacts][1]));
		$table->put(scalar @contacts, 2, $table->Entry(-textvariable => \$contacts[$#contacts][2]));
	});

	my $okB = $frame->Button(-text => "Commit", -command => sub {
		$host->{Contacts} = {
			map { $_->[1] => $_->[2] }
			grep { not $_->[0] }
			@contacts
		};
	});

	$table->pack;
	$addB->pack;
	$okB->pack;
}

sub serverEditorSites {
	my ($frame, $ip, $host, @sites) = @_;

	my $table = $frame->Table(-rows => 10, -columns => 3, -fixedrows => 1, -scrollbars => "e");
	$table->put(0, $_->[0], $_->[1]) for([0, "Del"], [1, "Sitename"], [2, "Text"]);

	$host->{Sites} = {} unless(exists $host->{Sites});
	@sites = map { [0, $_, $host->{Sites}{$_}] } sort keys %{ $host->{Sites} } unless(scalar @sites);
	for(my $i = 0; $i < @sites; $i++) {
		$table->put($i + 1, 0, $table->Checkbutton(-variable => \$sites[$i][0]));
		$table->put($i + 1, 1, $table->Entry(-textvariable => \$sites[$i][1]));
		$table->put($i + 1, 2, $table->Entry(-textvariable => \$sites[$i][2]));
	}
	
	my $addB = $frame->Button(-text => "Create new site", -command => sub {
		push @sites, [0, "", 0, 0, ""];
		$table->put(scalar @sites, 0, $table->Checkbutton(-variable => \$sites[$#sites][0]));
		$table->put(scalar @sites, 1, $table->Entry(-textvariable => \$sites[$#sites][1]));
		$table->put(scalar @sites, 2, $table->Entry(-textvariable => \$sites[$#sites][2]));
	});

	my $okB = $frame->Button(-text => "Commit", -command => sub {
		$host->{Sites} = {
			map { $_->[1] => $_->[2] }
			grep { not $_->[0] }
			@sites
		};
	});

	$table->pack;
	$addB->pack;
	$okB->pack;
}

1;
