#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, %D);

sub handleGCD {
	my ($uid, $host) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $blame) = (
		$screen->Label(@H, -text => $host->{Name},         -font => [qw/ Arial 12 /]),
		$screen->Label(@L, -text => join("\n\t >", L("GOVSystem"), qw/readonly readwrite admin/)),
	);
	$title->grid(-row => 0, -column => 0, -sticky => "wn");
	$blame->grid(-row => 1, -column => 0, -sticky => "wn");
	BindLabel($screen, L("ok"), "<ButtonPress-1>", sub {
		multipleSecurity(
			undef,
			$uid,
			$host,
			{ pwd => 0, elliptic => 0 },
			sub {
				triggerTrace() if($host->{Records}{$windows{UserEntry}}{Level} == 0);
				newNews("BROKENIN", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
				handleGCDmenu($uid, $host, $windows{UserEntry})
			}
		);
	})->grid(-row => 2, -column => 0, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
};

sub handleGCDmenu {
	my ($uid, $host, $user) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my $menu   = new MyLinkMenu($screen);
	$menu->addItem(1, "Title"             => $host->{Name});
	$menu->addItem(1, "Subtitle"          => L("MainMenu"));
	$menu->addItem(1, L("SearchDatabase") => sub { GCDrecords(sub { handleGCDmenu($uid, $host, $user) }, $uid, $host, $user) });
	$menu->addItem($host->{Records}{$user}{Level} == 0 ? 1 : 0, L("AdminMenu") => sub { _admin(sub { handleGCDmenu($uid, $host, $user) }, $host, $uid, $user, qw/Logs Security Records/) });
	$_->pack for($menu, $screen);
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub GCDrecords {
	my ($return, $uid, $host, $user) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($f,$title, $subtitle, $nameE, $searchB, $pictureL, $picL, $oldT, $aA, $done, $newE, $okB, $clear);
	my ($nameV, $newV) = (L("EnterPersonName"), "");
	$f = $screen->Frame(@F);
	my $showSub = sub {
		my $toShow = shift;
		($nameV, $newV) = ($toShow, "");
		$oldT->delete(qw/ 0.0 end /);
		$oldT->insert("0.0", (join "\n", grep { ! /^IP:/ } @{ $host->{Database}{$toShow} }) || L("GCD_NoConvinctions"));
		my $id = 0;
		$id   += ord($_) * ord($_) for(split "", $toShow);
		if(exists $D{Credits}->{$toShow}) {
			$pictureL->configure(-file => "graphics/person" . $D{Credits}->{$toShow} . ".xpm");
		} else {
			$pictureL->configure(-file => "graphics/person" . ($id % 14) . ".xpm");
		}
	};
	($title, $subtitle, $nameE, $searchB, $pictureL, $oldT, $aA, $done, $newE, $okB, $clear) = (
		$screen->Label(@H, -text => $host->{Name},       -font => [qw/ Arial 12 /]),
		$screen->Label(@H, -text => L("SearchDatabase"), -font => [qw/ Arial 8 /]),
		$f->Entry(@E, -textvariable => \$nameV,   -width => 40),
		BindLabel($f, L("Search"), "<ButtonPress-1>", sub {
			$host = update($host, $uid);
			my ($index, $found, $searchV) = ((0) x 2, $nameV);
			foreach my $entry (sort { lc($a) cmp lc($b) } keys %{ $host->{Database} }) {
				$screen->after($index++ * 400, sub { $showSub->($entry) });
				if($entry eq $searchV) {
					$found++;
					last;
				}
			}
			$screen->after($index++ * 400, sub { MyMesg(L("RecordNotFound_Title"), L("RecordNotFound_Text", $searchV)) })
				if(not $found);
		}),
		$f->Photo(-file => "graphics/person0.xpm"),
		$f->ROText(@E, -width => 20, -height => 12, -wrap => "word"),
		BindLabel($screen, L("GCD_AuthArrest"), "<ButtonPress-1>", sub {
			return if($host->{Records}{$user}{Level} > 1);
			return unless(waterWallCheck($uid, $host));
			if(not exists $host->{Database}{$nameV}) {
				MyMesg(L("RecordNotFound_Title"), L("RecordNotFound_Text", $nameV));
			} elsif(scalar (grep { ! /^IP:/ } @{ $host->{Database}{$nameV} }) < 3) {
				MyMesg(L("GCD_ArrestNok_Title"), L("GCD_ArrestNok_Text"));
			} else {
				newNews("DBMODIFIED", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
				MyMesg(L("GCD_ArrestOk_Title"), L("GCD_ArrestOk_Text", $nameV));
				if(scalar (grep { /^IP:/ } @{ $host->{Database}{$nameV} }) > 0) {
					my $hisIP = (grep { /^IP:/ } @{ $host->{Database}{$nameV} })[0];
					$hisIP =~ s/^IP://;
					$rpc->call("storTimer", time + 1 * 60, { Arrest => $hisIP });
				}
				$rpc->call("storTimer", time + 1 * 60, { News => [ "ARREST", $nameV ] });
			}
		}),
		BindLabel($screen, L("DB_Done"), "<ButtonPress-1>", $return),
		$f->Entry(@E, -textvariable => \$newV, -width => 40),
		BindLabel($f, L("DB_Add"), "<ButtonPress-1>", sub {
			return if($host->{Records}{$user}{Level} > 1);
			return unless(waterWallCheck($uid, $host));
			if(not exists $host->{Database}{$nameV}) {
				MyMesg(L("RecordNotFound_Title"), L("RecordNotFound_Text", $nameV));
			} else {
				newNews("DBMODIFIED", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
				$host = update($host, $uid);
				push @{ $host->{Database}{$nameV} }, $newV;
				$rpc->call("storObject", $uid, $host);
				$showSub->($nameV);
			}
		}),
		BindLabel($f, L("GCD_ClearHistory"), "<ButtonPress-1>", sub {
			return if($host->{Records}{$user}{Level} > 1);
			return unless(waterWallCheck($uid, $host));
			if(not exists $host->{Database}{$nameV}) {
				MyMesg(L("RecordNotFound_Title"), L("RecordNotFound_Text", $nameV));
			} else {
				newNews("DBMODIFIED", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
				$host = update($host, $uid);
				$host->{Database}{$nameV} = grep { /^IP:/ } @{ $host->{Database}{$nameV} };
				$rpc->call("storObject", $uid, $host);
				$showSub->($nameV);
			}
		}),
	);
	$nameE->bind("<Enter>", sub { $nameV = "" if($nameV eq L("EnterPersonName")) });
	$picL = $f->Label(@L, -image => $pictureL);
	if($host->{Records}{$user}{Level} > 1) {
		$_->configure(-foreground => "grey") for($aA, $okB, $clear);
		$newE->configure(-state => "disabled");
	}
	$title   ->grid(-row => 0, -column => 0, -sticky => "nw");
	$subtitle->grid(-row => 1, -column => 0, -sticky => "nw");
	$f       ->grid(-row => 2, -column => 0, -sticky => "nw");
	$done    ->grid(-row => 3, -column => 0, -sticky => "we");
	
	$searchB ->grid(-row => 0, -column => 0, -sticky => "we");
	$nameE   ->grid(-row => 0, -column => 1, -sticky => "we");
	$picL    ->grid(-row => 1, -column => 0, -sticky => "nw");
	$oldT    ->grid(-row => 1, -column => 1, -sticky => "we");
	$okB     ->grid(-row => 2, -column => 0, -sticky => "we");
	$newE    ->grid(-row => 2, -column => 1, -sticky => "we");
	$clear   ->grid(-row => 3, -column => 0, -sticky => "we");
	$aA      ->grid(-row => 3, -column => 1, -sticky => "w");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

1;
