#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, @M, @T, @EHL, %D);

sub showMails {
	if(not (shift)) {
		$windows{Mails}->repeat(10000, sub { showMails("once") });
	}
	do { $windows{$_}->placeForget; delete $windows{$_} }
		for(grep { /^HUDButtons/ } keys %windows);
	$uObject = update($uObject, $uIP);
	my $screen = $windows{Mails}->Frame(@F);
	my $mmPN = $windows{Top}->Photo(-file => "graphics/mainmenu.xpm");
	my $mmPH = $windows{Top}->Photo(-file => "graphics/mainmenu-hovered.xpm");
	my $mmSN = $windows{Top}->Photo(-file => "graphics/status.xpm");
	my $mmSH = $windows{Top}->Photo(-file => "graphics/status-hovered.xpm");
	my $mmBN = $windows{Top}->Photo(-file => "graphics/bank.xpm");
	my $mmBH = $windows{Top}->Photo(-file => "graphics/bank-hovered.xpm");
	my $mmAN = $windows{Top}->Photo(-file => "graphics/analyser.xpm");
	my $mmAH = $windows{Top}->Photo(-file => "graphics/analyser-hovered.xpm");
	my $mmWN = $windows{Top}->Photo(-file => "graphics/wallet.xpm");
	my $mmWH = $windows{Top}->Photo(-file => "graphics/wallet-hovered.xpm");
	my $mmNN = $windows{Top}->Photo(-file => "graphics/newsmail.xpm");
	my $mmNH = $windows{Top}->Photo(-file => "graphics/newsmail-hovered.xpm");
	my $mmMN = $windows{Top}->Photo(-file => "graphics/missionmail.xpm");
	my $mmMH = $windows{Top}->Photo(-file => "graphics/missionmail-hovered.xpm");
	my @buttons;
	my $gen  = sub {
		my ($pN, $pH, $cB, $id, $x, $index) = (@_, scalar @buttons);
		if($x < 0) {
			$windows{Top}->geometry =~ /([^x]+)x/;
			$x += $1 - 2;
		}
		push @buttons, $windows{Top}->Label(@L, -image => $pN);
		$buttons[$index]->bind("<Enter>", sub { $buttons[$index]->configure(-image => $pH) });
		$buttons[$index]->bind("<Leave>", sub { $buttons[$index]->configure(-image => $pN) });
		$buttons[$index]->bind("<ButtonPress-1>", $cB);
		$buttons[$index]->place(
			-in     => $windows{Top},
			-rely   => 1,
			-anchor => "sw",
			-x      => $x
		);
		$windows{"HUDButtons$id"}->placeForget if($windows{"HUDButtons$id"});
		$windows{"HUDButtons$id"} = $buttons[$index];
	};
	my $index = 0;
	foreach my $mail (sort { $a <=> $b} keys %{ $uObject->{Mails} }) {
		next unless(exists $uObject->{Mails}{$mail});
		my $Mail       = $uObject->{Mails}{$mail};
		$gen->(
			$Mail->{Type} eq "News" ? ($mmNN, $mmNH) : ($mmMN, $mmMH),
			sub { showMail($Mail, $mail) },
			"Mail$mail",
			$index++ * -41
		);
		if(exists $Mail->{Links}) {
			for(@{ $Mail->{Links} }) {
				if(/^(.+):(.+)@(.+)$/) {
					$uObject->{Wallet}{$3} = { } unless(exists $uObject->{Wallet}{$3});
					$uObject->{Wallet}{$3}{$1} = $2;
				} else {
					$uObject->{Links}{$_} = 1
						unless(exists $uObject->{Links}{$_});
				}
			}
		}
		if(exists $Mail->{Cancels} and exists $uObject->{Mails}{$Mail->{Cancels}}) {
			$uObject = update($uObject, $uIP);
			$uObject->{Yeahs}++;
			playSound("success");
			delete $uObject->{Mails}{$Mail->{Cancels}};
			$rpc->call("storObject", $uIP, $uObject);
			$windows{Mails}->after(300, sub { showMails("once") });
		}
	}
	$rpc->call("storObject", $uIP, $uObject);
	my @msgs = sort { $b <=> $a } keys %{ $uObject->{Mails} };
	$windows{KNoM} = 0 unless(defined $windows{KNoM});
	if(scalar @msgs > 0 and $windows{KNoM} < $msgs[0]) {
		playSound("newmail") for(grep { $_ > $windows{KNoM} } @msgs);
	}
	$windows{KNoM} = $msgs[0];
	$gen->($mmPN, $mmPH, sub {                }, "Main",     0);
	MyLinkPopup($buttons[$#buttons], "undef");
	$gen->($mmSN, $mmSH, sub { showStatus()   }, "Status",  55);
	$gen->($mmBN, $mmBH, sub { showBank()     }, "Bank",    96);
	$gen->($mmWN, $mmWH, sub { showWallet()   }, "Wallet", 137);
	$gen->($mmAN, $mmAH, sub { connAnalysis() }, "ConnA",  178)
		if(exists $uObject->{Files}{"HUD_ConnectionAnalysis-prog"});
	$screen->pack;
	$windows{InMails}->packForget if($windows{InMails});
	$windows{InMails} = $screen;
}

sub connAnalysis {
	my $screen  = $windows{Infos}->Frame(@F);
	my $canvas  = $screen->Canvas(@F, -width => 200, -height => 340);
	my $lPhotoN = $canvas->Photo(-file => "graphics/localhost.xpm");
	my $lPhotoH = $canvas->Photo(-file => "graphics/localhost-hovered.xpm");
	my $rPhotoN = $canvas->Photo(-file => "graphics/remotehost.xpm");
	my $rPhotoH = $canvas->Photo(-file => "graphics/remotehost-hovered.xpm");
	my $fPhotoN = $canvas->Photo(-file => "graphics/lock.xpm");
	my $fPhotoH = $canvas->Photo(-file => "graphics/lock-hovered.xpm");
	my $uPhotoN = $canvas->Photo(-file => "graphics/unlock.xpm");
	my $uPhotoH = $canvas->Photo(-file => "graphics/unlock-hovered.xpm");
	
	my $localI  = $canvas->createImage(10, 10, -image => $lPhotoN, -anchor => "nw");
	$canvas->bind($localI, "<Enter>", sub { $canvas->itemconfigure($localI, -image => $lPhotoH) });
	$canvas->bind($localI, "<Leave>", sub { $canvas->itemconfigure($localI, -image => $lPhotoN) });
	my $localT  = $canvas->createText(60, 10, -anchor => "nw", -fill => "white", -text => L("ConnAnalysis_Localhost", $uIP, C_N($uIP)));

	if($windows{ConnectedTo}) {
		my $hisHost = $rpc->call("recvObject", $windows{ConnectedTo});

		my $remotI = $canvas->createImage(150, 290, -image => $rPhotoN, -anchor => "nw");
		$canvas->bind($remotI, "<Enter>", sub { $canvas->itemconfigure($remotI, -image => $rPhotoH) });
		$canvas->bind($remotI, "<Leave>", sub { $canvas->itemconfigure($remotI, -image => $rPhotoN) });
		my $remotT = $canvas->createText(10, 330, -anchor => "sw", -fill => "white", -text => L("ConnAnalysis_Remotehost", $windows{ConnectedTo}, C_N($windows{ConnectedTo})));

		my $gerade = MyDottedLine(
			$canvas,
			30,50, 30,150, 170,150, 170,290,
			-fill  => "white",
			-arrow => "last",
			-tags  => [qw/ HUD_ConnAnalysis_Dotted /],
		);
		if($hisHost->{Firewalled} and not $windows{NoFirewall}) {
			my $waterL = $canvas->Label(@L, -image => $fPhotoN);
			$waterL->bind("<Enter>", sub { $waterL->configure(-image => $fPhotoH) });
			$waterL->bind("<Leave>", sub { $waterL->configure(-image => $fPhotoN) });
			my $waterI = $canvas->createWindow(80, 128, -window => MyLinkPopup(
				$waterL,
				"lock://$windows{ConnectedTo}",
			), -anchor => "nw");
			my $waterT = $canvas->createText(100, 178, -fill => "white", -text => L("ConnAnalysis_Firewall"));
		} elsif($hisHost->{Firewalled} and $windows{NoFirewall}) {
			my $waterL = $canvas->Label(@L, -image => $uPhotoN);
			$waterL->bind("<Enter>", sub { $waterL->configure(-image => $uPhotoH) });
			$waterL->bind("<Leave>", sub { $waterL->configure(-image => $uPhotoN) });
			my $waterI = $canvas->createWindow(80, 128, -window => MyLinkPopup(
				$waterL,
				"lock://$windows{ConnectedTo}",
			), -anchor => "nw");
			my $waterT = $canvas->createText(100, 178, -fill => "white", -text => L("ConnAnalysis_Firewall"));
		}
	}

	$canvas->pack;
	$screen->pack;
	$windows{InInfos}->packForget if($windows{InInfos});
	$windows{InInfos} = $screen;
	$windows{CAO} = "" unless($windows{CAO});
	$windows{InfoScreen} = sub {
		connAnalysis() if(chkSum([$windows{ConnectedTo} || "", $windows{NoFirewall} || ""]) ne $windows{CAO});
		$windows{CAO} = chkSum([$windows{ConnectedTo} || "", $windows{NoFirewall} || ""]);
	};
}

sub showBank {
	my $yview  = shift;
	$uObject   = update($uObject, $uIP);
	my $screen = $windows{Infos}->Frame(@F);
	my $GQsTotal = $uObject->{Memory};
	my $GQsUsed  = 0;
	$GQsUsed += $uObject->{Files}{$_}{Gigaquods} for(keys %{ $uObject->{Files} });
	my $GQsFree  = $GQsTotal - $GQsUsed;
	my ($GQsUL, $GQsFL, $GQsTL, $GQsUE, $GQsFE, $GQsTE, $table) = (
		$screen->Label(@L,  -text  => L("Bank_GQsUsed")),
		$screen->Label(@L,  -text  => L("Bank_GQsFree")),
		$screen->Label(@L,  -text  => L("Bank_GQsTotal")),
		$screen->Label(@L,  -text  => L("GQs", $GQsUsed)),
		$screen->Label(@L,  -text  => L("GQs", $GQsFree)),
		$screen->Label(@L,  -text  => L("GQs", $GQsTotal)),
		MyScrolled(
			$screen,
			"Canvas",
			-width        => 180,
			-height       => 180,
			-scrollbars   => "e",
			-scrollregion => [qw/ 0 0 180 /, $GQsTotal * 20],
			@EHL
		),
	);
	my $index = 0;
	my $verlauf = sub {
		my ($sy, $ey, $sc, $ec, $uri) = @_;
		my $STEPS = 8;
		my $SIZE  = 180 / $STEPS;
		if((grep { $sc->[$_] == $ec->[$_] } 0 .. $#{$sc}) == @$sc) {
			my $id = $table->createRectangle(
				0,   $sy,
				180, $ey,
				map { $_ => "black" } qw/ -fill -outline /,
			);
			MyLinkPopup([ $table, $id ], $uri, sub { showBank($table->yview) }) if($uri);
		} else {
			for(my $x   = 0;   $x <= 180; $x += $SIZE) {
				for(my $y = $sy; $y <= $ey; $y += $SIZE) {
					my $color = "#" . join(
						"",
						map {
							my $t = $sc->[$_] + ($ec->[$_] - $sc->[$_]) / ($ey - $sy + 180) * ($y - $sy + 1.5*$x);
							sprintf
								"%.2x",
								$t < 0 ? 0 : $t > 255 ? 255 : $t,
						} 0 .. 2,
					);
					my $id = $table->createRectangle(
						$x,
						$y,
						$x + $SIZE,
						$y + $SIZE,
						map { $_ => $color } qw/ -fill -outline /,
					);
					MyLinkPopup([ $table, $id ], $uri, sub { showBank($table->yview) }) if($uri);
				}
			}
		}
	};
	foreach my $key (sort { lc($a) cmp lc($b) } keys %{ $uObject->{Files} }) {
		$verlauf->(
			$index,
			$index + 20 * $uObject->{Files}{$key}{Gigaquods},
			$key =~ /-prog/ ? [qw/ 255   0   0 /] : [qw/   0 255   0 /],
			$key =~ /-prog/ ? [qw/ 255 100 100 /] : [qw/ 100 255 100 /],
			"local://$key",
		);
		my $id = $table->createText(
			0,
			$index,
			-anchor => "nw",
			-fill   => "white",
			-text   =>
				$uObject->{Files}{$key}{Encrypted}
					? L("Bank_FileEncrypted", $key, $uObject->{Files}{$key}{Encrypted})
					: L("Bank_FileDecrypted", $key)
		);
		MyLinkPopup([ $table, $id ], "local://$key", sub { showBank($table->yview) });
		$index += 20 * $uObject->{Files}{$key}{Gigaquods};
	}
	$verlauf->($index, 20 * $GQsTotal, [qw/ 0 0 0 /], [qw/ 0 0 0 /], "local://");
	$table->yviewMoveto($yview) if(defined $yview);
	$index = 0; $_->grid(-row => $index++, -column => 0, -columnspan => 1, -sticky => "w")
		for($GQsTL, $GQsUL, $GQsFL);
	$index = 0; $_->grid(-row => $index++, -column => 1, -columnspan => 1, -sticky => "e")
		for($GQsTE, $GQsUE, $GQsFE);
	$table        ->grid(-row => $index++, -column => 0, -columnspan => 2, -sticky => "wens");
	$screen->pack;
	$windows{InInfos}->packForget if($windows{InInfos});
	$windows{InInfos} = $screen;
	$windows{BankOldFiles} = chkSum([ $uObject->{Files}, $uObject->{Memory} ]);
	$windows{InfoScreen} = sub {
		$uObject = update($uObject, $uIP);
		showBank($table->yview) if(chkSum([ $uObject->{Files}, $uObject->{Memory} ]) ne $windows{BankOldFiles});
		$windows{BankOldFiles} = chkSum([ $uObject->{Files}, $uObject->{Memory} ]);
	}
}

sub showWallet {
	$uObject   = update($uObject, $uIP);
	my $screen = $windows{Infos}->Frame(@F);
	my $tree   = MyScrolled(
		$screen,
		"MyTree",
		-separator  => "/",
		-width      => 25,
		-height     => 17,
		-scrollbars => "ose",
		@T,
	);
	my $openCMD = sub {
		my $path   = shift;
		$uObject   = update($uObject, $uIP);
		""         =~ /()/;
		$path      =~ /^\/(.*)$/;
		unless($1) {
			$tree->delete("offsprings", "/");
			foreach my $walletHost (
				sort { lc(C($a)) cmp lc(C($b)) }
				keys %{ $uObject->{Wallet} }
			) {
				$tree->add    ("/$walletHost", -text => C($walletHost));
				$tree->setmode("/$walletHost", "open");
			}
		} else {
			my $hisUID = $1;
			$tree->delete("offsprings", "/$hisUID");
			foreach my $walletUser (sort { lc($a) cmp lc($b) } keys %{ $uObject->{Wallet}{$hisUID} }) {
				$tree->add("/$hisUID/$walletUser", -text => "$walletUser: $uObject->{Wallet}{$hisUID}{$walletUser}");
				$tree->setmode("/$hisUID/$walletUser", "none");
			}
		}
	};
	my $lastBug;
	my $browseCMD = sub {
		my $path = shift;
		""       =~ /()()/;
		$path    =~ /^\/(.*?)\/(.*)$/;
		$uObject = update($uObject, $uIP);
		if($2) {
			$windows{UserEntry} = $2;
			$windows{PassEntry} = $uObject->{Wallet}{$1}{$2};
			playSound("mouseclick") unless(defined $lastBug and $lastBug eq $path);
		}
		$lastBug = $path;
	};
	$tree->configure(-opencmd   => sub { $openCMD  ->(@_) });
	$tree->configure(-browsecmd => sub { $browseCMD->(@_) });
	$tree->add    ("/", -text => L("Wallet_KnownHosts"));
	$tree->setmode("/", "close");
	$openCMD->("/");
	if($windows{ConnectedTo} and exists $uObject->{Wallet}{$windows{ConnectedTo}}) {
		$openCMD->("/$windows{ConnectedTo}");
	}
	$tree->grid(-row => 0, -column => 0, -sticky => "wens");
	$screen->pack;
	$windows{InInfos}->packForget if($windows{InInfos});
	$windows{InInfos} = $screen;
	$windows{WalletOldC} = $windows{ConnectedTo};
	$windows{WalletOldS} = chkSum($uObject->{Wallet});
	$windows{InfoScreen} = sub {
		return if(not defined $windows{WalletOldC} and not defined $windows{ConnectedTo});
		showWallet()
			if(
				(
					not (not defined $windows{WalletOldC} and not defined $windows{ConnectedTo}) and
					(
						(not defined $windows{WalletOldC} and defined $windows{ConnectedTo}) or
						(defined $windows{WalletOldC} and not defined $windows{ConnectedTo}) or
						($windows{WalletOldC} ne $windows{ConnectedTo})
					)
				) or
				($windows{WalletOldS} ne chkSum($uObject->{Wallet}))
			);
		$windows{WalletOldC} = $windows{ConnectedTo};
		$windows{WalletOldS} = chkSum($uObject->{Wallet});
	};
}

sub changePass {
	$uObject   = update($uObject, $uIP);
	my $screen = $windows{Infos}->Frame(@F);
	my ($level, $advanceSub) = (-1);
	my ($acti, $feld, $ohke) = (
		$screen->Label(@L, -textvariable => \my $toDO, -width => 25),
		$screen->Entry(@E, -textvariable => \my $data, -state => "disabled", -show => "*"),
		BindLabel($screen, L("ok"), "<ButtonPress-1>", sub { $advanceSub->() }),
	);
	my $newPWD;
	$advanceSub = sub {
		if($level == -1) {
			$toDO = L("Status_ReallyCPWD");
			$level++;
		} elsif($level == 0) {
			$feld->grid(-row => 1, -column => 0, -sticky => "we");
			$toDO = L("Status_EnterOPWD");
			$feld->configure(-state => "normal");
			$level++;
		} elsif($level == 1) {
			if($data ne $uObject->{Records}{$uObject->{Unixname}}{Password}) {
				$toDO = L("Status_IncorrectOPWD");
				$feld->gridForget;
				$data = "";
				$level = 0;
			} else {
				$toDO = L("Status_EnterNPWD");
				$data = "";
				$level = 2;
			}
		} elsif($level == 2) {
			$newPWD = $data;
			$toDO = L("Status_ReEnterNPWD");
			$data = "";
			$level = 3;
		} elsif($level == 3) {
			if($newPWD eq $data) {
				($toDO, $uObject) = (L("Status_PWDChanged"), update($uObject, $uIP));
				$uObject->{Records}{$uObject->{Unixname}}{Password} = $newPWD;
				$rpc->call("storObject", $uIP, $uObject);
				$feld->gridForget;
				$data  = "";
				$level = 4;
			} else {
				$toDO  = L("Status_PWDsDiffer");
				$feld->gridForget;
				$data  = "";
				$level = 0;
			}
		} elsif($level == 4) {
			$screen->packForget;
		}
	};
	$advanceSub->();
	$acti->grid(-row => 0, -column => 0, -sticky => "we");
	$ohke->grid(-row => 2, -column => 0, -sticky => "we");
	$screen->pack;
	$windows{InInfos}->packForget if($windows{InInfos});
	$windows{InInfos} = $screen;
	undef $windows{InfoScreen};
}

sub showStatus {
	$uObject   = update($uObject, $uIP);
	my $screen = $windows{Infos}->Frame(@F);
	my $br     = $rpc->call("recvObject", $uObject->{Credits}[0])->{Records}{$uObject->{Credits}[1]};
	my ($RatingL, $CreditsL, $GatewayL, $cpuL, $ModemL, $MemoryL,
			$RatingE, $CreditsE, $GatewayE, $cpuE, $ModemE, $MemoryE,
			$changePass) = (
		$screen->Label(@L, -text => L("Status_Rating")),
		$screen->Label(@L, -text => L("Status_Credits")),
		$screen->Label(@L, -text => L("Status_Gateway")),
		$screen->Label(@L, -text => L("Status_CPU")),
		$screen->Label(@L, -text => L("Status_Bandwidth")),
		$screen->Label(@L, -text => L("Status_Memory")),
		$screen->Label(@L, -text => L("Status_Grade", getRank($uObject->{Yeahs}))),
		$screen->Label(@L, -text => L("Credits", $br->{Credits} + $br->{Loan})),
		$screen->Label(@L, -text => $uObject->{Gateway}),
		$screen->Label(@L, -text => L("GHz", $uObject->{CPU})),
		$screen->Label(@L, -text => L("GQs/s", $uObject->{Modem})),
		$screen->Label(@L, -text => L("GQs", $uObject->{Memory})),
		BindLabel($screen, L("Status_CPWD"), "<ButtonPress-1>", sub { changePass() }),
	);
	my $index;
	$index = 0; $_->grid(-row => $index++, -column => 0, -columnspan => 1, -sticky => "w")
		for($RatingL, $CreditsL, $GatewayL, $cpuL, $ModemL, $MemoryL);
	$index = 0; $_->grid(-row => $index++, -column => 1, -columnspan => 2, -sticky => "e")
		for($RatingE, $CreditsE, $GatewayE, $cpuE, $ModemE, $MemoryE);
	$changePass->grid(-row => $index, -column => 0, -columnspan => 3, -sticky => "we");
	$screen->pack;
	$windows{InInfos}->packForget if($windows{InInfos});
	$windows{InInfos} = $screen;
	$windows{StatusOld} = chkSum([getRank($uObject->{Yeahs}),$br->{Credits} + $br->{Loan},$uObject->{Gateway},$uObject->{CPU},$uObject->{Modem},$uObject->{Memory}]);
	$windows{InfoScreen} = sub {
		my $newStatus = chkSum([getRank($uObject->{Yeahs}),$br->{Credits} + $br->{Loan},$uObject->{Gateway},$uObject->{CPU},$uObject->{Modem},$uObject->{Memory}]);
		showStatus() if($newStatus ne $windows{StatusOld});
		$windows{StatusOld} = $newStatus;
	}
}

sub showMail {
	my ($mail, $id) = @_;
	$uObject   = update($uObject, $uIP);
	my $screen = $windows{Infos}->Frame(@F);
	my ($fromL, $timeL, $subjL, $refuL, $fromE, $timeE, $subjE, $refuE, $text) = (
		$screen->Label(@L, -text => L("Mail_From"), -anchor => "w", -justify => "left"),
		$screen->Label(@L, -text => L("Mail_Sent")),
		$screen->Label(@L, -text => L("Mail_Subject")),
		$screen->Label(@L, -text => L("Mail_Refund")),
		$screen->Entry(@E, -textvariable => \$mail->{From}, -state => "disabled"),
		$screen->Entry(@E, -textvariable => \do { m2m($mail->{Time}) }, -state => "disabled"),
		$screen->Entry(@E, -textvariable => \$mail->{Subject}, -state => "disabled"),
		$screen->Entry(@E, -textvariable => \do { defined $mail->{Credits} ? L("Credits", $mail->{Credits}) : "n/a" }, -state => "disabled"),
		MyScrolled($screen, "ROText", @E, -width => 23, -height => 10, -wrap => "word", -scrollbars => "e"),
	);
	$text->insert("0.0", $mail->{Text});
	if($mail->{Links}) {
		$text->insert("end", "\n\n" . L("Mail_Links") . "\n");
		$text->insert("end", "$_: " . C($_) . "\n")
			for(grep { ! /@/ } @{ $mail->{Links} });
	}
	my $delSub = sub {
		$uObject = update($uObject, $uIP);
		delete $uObject->{Mails}{$id};
		$uObject->{Yeahs} -= 6 if($uObject->{Yeahs} > 6);
		if($mail->{Type} eq "Mission") {
			playSound("failure");
			$rpc->call("storTimer", time + $D{MissionDel}, { Mail => [ $uIP, {
				Type    => "News",
				From    => "agents\@MyLink Corporation.net",
				Subject => L("Mail_Abandon_Subject"),
				Text    => L("Mail_Abandon_Text"),
			} ] });
		}
		$rpc->call("storObject", $uIP, $uObject);
		$screen->packForget;
		showMails("once");
	};
	my ($close, $reply, $delete);
	($close, $reply, $delete) = (
		BindLabel($screen, L("Mail_Close"),  "<ButtonPress-1>", sub {
			$screen->packForget;
			undef $windows{InfoScreen};
		}),
		BindLabel($screen, L("Mail_Reply"), "<ButtonRelease-1>", sub { answerMail($id, $mail) }),
		BindLabel($screen, $mail->{Type} eq "Mission" ? L("Mail_Abandon") : L("Mail_Delete"), "<ButtonPress-1>", sub {
			$uObject = update($uObject, $uIP);
			unless(exists $uObject->{Mails}{$id}) {
				$screen->packforget;
				undef $windows{InfoScreen};
			} else {
				if($mail->{Type} eq "Mission") {
					$delete->configure(-text => L("Mail_Really"));
					$delete->bind("<ButtonPress-1>", sub { playSound("mouseclick"); $delSub->() });
				} else {
					$delSub->();
				}
			}
		}),
	);
	
	my $index;
	$index = 0; $_->grid(-row => $index++, -column => 0, -columnspan => 1, -sticky => "w")
		for($fromL, $timeL, $subjL, $refuL);
	$index = 0; $_->grid(-row => $index++, -column => 1, -columnspan => 2, -sticky => "e")
		for($fromE, $timeE, $subjE, $refuE);
	$text         ->grid(-row => $index++, -column => 0, -columnspan => 3, -sticky => "wens");
	$close        ->grid(-row => $index,   -column => 0, -columnspan => 1, -sticky => "we");
	$reply        ->grid(-row => $index,   -column => 1, -columnspan => 1, -sticky => "we");
	$delete       ->grid(-row => $index,   -column => 2, -columnspan => 1, -sticky => "we");
	
	$screen->pack;
	$windows{InInfos}->packForget if($windows{InInfos});
	$windows{InInfos} = $screen;
	$windows{InfoScreen} = sub { 1 }
}

sub answerMail {
	my ($id, $mail, $screen) = (@_, $windows{Infos}->Frame(@F));
	my %vars  = (To      => $mail->{From},
					 		 Time    => m2m(u2m(time)),
							 Subject => L("Mail_Re", $mail->{Subject}),
							 From    => "$uObject->{Unixname}\@MyLink Corporation.net");
	my @files = ();
	my $text  = MyScrolled($screen, "Text", @E, -width => 23, -height => 10, -wrap => "word", -scrollbars => "e");
	$text->insert("0.0", L("Mail_Completed", $mail->{From}) . "\n");
	my $sendSub = sub {
		my %toBeDone = %{ $mail->{Success} };
		$uObject     = update($uObject, $uIP);
		my $ok       = 1;
		foreach my $test (keys %toBeDone) {
			if($test eq "Attachments") {
				my $oo = 1;
				foreach my $hastobe (@{ $toBeDone{Attachments} }) {
					$oo = 0 unless(grep { $_ eq $hastobe } @files);
				}
				$ok = 0 unless($oo);
			} elsif($test eq "TextContaining") {
				$toBeDone{$test} =~ s/remote:\/\///;
				my ($ip, @ems) = split "/", $toBeDone{$test};
				my $subKey = $rpc->call("recvObject", $ip);
				$subKey = $subKey->{$_} for(@ems);
				$ok = 0 unless($text->get(qw/0.0 end/) =~ /\Q$subKey\E/);
			}
		}
		my $rMail;
		if($ok == 0) {
			$rMail = {
				Type    => "News",
				From    => "$mail->{From}",
				Subject => L("Mail_Re", L("Mail_Re", $mail->{Subject})),
				Text    => L("Mail_NotDone"),
			};
		} else {
			$rpc->call(
				"storTimer",
				time + $D{Yeah},
				{
					AddCredits => {
						bank   => $uObject->{Credits}[0],
						acc    => $uObject->{Credits}[1], 
						from   => "agents\@MyLink Corporation.net",
						amount => $mail->{Credits},
					}
				}
			);
			$rMail = {
				Type    => "News",
				From    => "$mail->{From}",
				Subject => L("Mail_Re", L("Mail_Re", $mail->{Subject})),
				Text    => L("Mail_Yeah", L("Credits", $mail->{Credits})),
				Cancels => $id,
			};
		}
		$rpc->call("storTimer",  time + $D{Yeah}, { Mail => [ $uIP, $rMail ] });
		$rpc->call("storObject", $uIP, $uObject);
		$screen->packForget;
		showMails("once");
	};
	my $attachSub = sub {
		my ($w, $x, $y) = @_;
		$uObject = update($uObject, $uIP);
		my $menu = $screen->Menu(-type => "tearoff", @M);
		foreach my $file (sort { lc($a) cmp lc($b) } keys %{ $uObject->{Files} }) {
			$menu->command(@M, -label => $file, -command => sub {
				$text->insert("end", L("Mail_File", $file) . "\n");
				push @files, $file;
			});
		}
		$menu->overrideredirect(1);
		$menu->Post($x, $y);
	};
	my ($close, $send, $attach) = (
		BindLabel($screen, L("Mail_Close"),  "<ButtonPress-1>", sub {
			$screen->packForget;
			undef $windows{InfoScreen};
		}),
		BindLabel($screen, L("Mail_Send"),   "<ButtonPress-1>", $sendSub),
		$screen->Label(@L, -text => L("Mail_Attach")),
	);
	$attach->bind("<ButtonRelease-1>", [ $attachSub, Ev("X"), Ev("Y") ]);
	my $index = 0;
	$screen
		->Label(@L, -text => L("Mail_$_"))
		->grid(-row => $index++, -column => 0, -columnspan => 1, -sticky => "w")
			for(qw/From To Time Subject/);
	$index = 0;
	$screen
		->Entry(@E, -textvariable => \$vars{$_}, -state => "disabled")
		->grid(-row => $index++, -column => 1, -columnspan => 2)
			for(qw/From To Time Subject/);
	$text  ->grid(-row => $index++, -column => 0, -columnspan => 3);
	$close ->grid(-row => $index,   -column => 0);
	$attach->grid(-row => $index,   -column => 1);
	$send  ->grid(-row => $index,   -column => 2);
	$screen->pack;
	$windows{InInfos}->packForget if($windows{InInfos});
	$windows{InInfos} = $screen;
	$windows{InfoScreen} = sub { 1 }
}

sub listLinks {
	my $filter = lc(shift) || "";
	undef $windows{ConnectedTo};
	undef $windows{Bounces};
	undef $windows{MapOldInMain};
	$uObject   = update($uObject, $uIP);
	my $screen = $windows{Main}->Frame(@F);
	my $table  = MyTable($screen,
											 @F,
											 -rows       => 15,
											 -columns    => 4,
											 -fixedrows  => 1,
											 -takefocus  => 1,
											 -scrollbars => "e");
	my $filtEr = $screen->Entry(@E, -width => 60, -textvariable => \$filter);
	my $filteR = BindLabel($screen, L("Filter"), "<ButtonPress-1>", sub { listLinks($filter) });
	my $delPhoto        = $table->Photo(-file => "graphics/del.xpm");
	my $delHoveredPhoto = $table->Photo(-file => "graphics/del-hovered.xpm");
	my $visPhoto        = $table->Photo(-file => "graphics/visible.xpm");
	my $visHoveredPhoto = $table->Photo(-file => "graphics/visible-hovered.xpm");
	my $index = 0;
	$table->put($index, $_->[0], $_->[1]) for([0, " "], [1, "IP"], [2, "Name"], [3, " "]);
	foreach my $host (sort { lc(C($a)) cmp lc(C($b)) } grep { lc(C($_)) =~ /\Q$filter\E/ } keys %{ $uObject->{Links} }) {
		my $maybeDel = $table->Label(@L, -image => $delPhoto);
		$maybeDel->bind("<Enter>", sub { $maybeDel->configure(-image => $delHoveredPhoto) });
		$maybeDel->bind("<Leave>", sub { $maybeDel->configure(-image => $delPhoto) });
		$maybeDel->bind("<ButtonPress-1>", sub {
			playSound("mouseclick");
			$uObject = update($uObject, $uIP);
			delete $uObject->{Links}{$host};
			$rpc->call("storObject", $uIP, $uObject);
			listLinks($filter);
			showMap();
		});
		my $maybeVis = $table->Label(@L, $uObject->{Links}{$host} ? (-image => $visPhoto) : (-text => " "));
		$maybeVis->bind("<Enter>", sub { $maybeVis->configure(-image => $visHoveredPhoto) if($uObject->{Links}{$host}) });
		$maybeVis->bind("<Leave>", sub { $maybeVis->configure(-image => $visPhoto) if($uObject->{Links}{$host}) });
		$maybeVis->bind("<ButtonPress-1>", sub {
			playSound("mouseclick");
			$uObject = update($uObject, $uIP);
			if($uObject->{Links}{$host}) {
				$uObject->{Links}{$host} = 0;
				$maybeVis->configure(-image => undef);
				$maybeVis->configure(-text  => " ");
			} else {
				$uObject->{Links}{$host} = 1;
				$maybeVis->configure(-image => $visPhoto);
			}
			$rpc->call("storObject", $uIP, $uObject);
			showMap();
		});
		$table->put(++$index, 0, $maybeDel);
		$table->put($index,   1, BindLabel($table,
																			 $host,
																			 "left|<ButtonPress-1>",
																			 sub { dial($host) }));
		$table->put($index,   2, BindLabel($table,
																			 C($host),
																			 "left|<ButtonPress-1>",
																			 sub { dial($host) }));
		$table->put($index,   3, $maybeVis);
	}
	$table ->grid(-row => 0, -column => 0, -columnspan => 2, -sticky => "wen");
	$filtEr->grid(-row => 1, -column => 0, -sticky => "wens");
	$filteR->grid(-row => 1, -column => 1, -sticky => "ens");
#	SHOW($screen, "InMain");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
	showMap();
	FFF($filtEr);
}

require MyLinkMap;

sub showMap {
	my $little = (defined $_[0] ? shift : 1);
	$uObject = update($uObject, $uIP);
	if($little) {
		showMapLittle();
	} else {
		showMapBig();
	}
}

sub checkForDead {
	$windows{Top}->repeat(5000, sub { checkForDead("once") }) unless(shift);
	$uObject = update($uObject, $uIP);
	if(
		(exists $uObject->{Dead} and $uObject->{Dead}) or
		(exists $uObject->{Down} and $uObject->{Down})) {
		warn "down...\n";
		playSound("revelation");
		sleep 3; # ja, stimmt so!
		exit 0;
	}
}

1;
