#!/usr/bin/perl -w

use warnings;
use strict;

our $LANG;
our $DEFAULT_LANG = "en";

our %TEXTS = ();
for(< MyLinkI18N-*.txt >) {
	my $lang = $_;
	$lang =~ s/^MyLinkI18N-([^.]+)\.txt$/$1/;
	$TEXTS{$lang} = { do $_ };
	die $@ if $@;
	warn "Got language definition file: $_\n";
};

1;

sub L {
	my ($id, @p) = @_;
	$LANG ||= $DEFAULT_LANG;
	my $text;
	if(exists $TEXTS{$LANG}->{$id}) {
		$text = $TEXTS{$LANG}->{$id};
	} elsif(exists $TEXTS{$DEFAULT_LANG}->{$id}) {
		warn "No $LANG translation found for $id!\n";
		$text = $TEXTS{$DEFAULT_LANG}->{$id};
	} else {
		die "No text found for $id!\n";
	}
	$text = $text->(@p) if(ref($text) eq "CODE");
	chomp($text);
	$text =~ s/-$_-/$p[$_]/g for(0 .. $#p);
	return $text;
}
