#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H);

sub handleI {
	my ($uid, $host) = @_;
	logInScreen(
		$uid,
		$host,
		sub {
			playSound("login");
			newNews("BROKENIN", $uid) if($host->{Records}{$windows{UserEntry}}{Level} == 0 and not (exists $host->{NoNews} and $host->{NoNews}));
			_handleImenu(
				sub { warn 42 },
				$uid,
				$host,
				$windows{UserEntry},
			)
		},
	);
}

sub _handleImenu {
	my ($return, $uid, $host, $user) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my $menu = new MyLinkMenu($screen);
	$menu->addItem(1, "Title"                => $host->{Name});
	$menu->addItem(1, "Subtitle"             => L("MainMenu"));
	$menu->addItem(1, L("Admin_FileServer")  => sub { _fileServer(sub { _handleImenu($return, $uid, $host, $user) }, $host, $uid, $user) });
	$menu->addItem(1, L("Admin_ViewRecords") => sub { _viewRecords(sub { _handleImenu($return, $uid, $host, $user) }, $host, $uid, $user) });
	$menu->addItem(1, L("Admin_ViewLinks")   => sub { _viewLinks(sub { _handleImenu($return, $uid, $host, $user) }, $host, $uid, $user) });
	$menu->addItem($host->{Records}{$user}{Level} == 0,
								 L("AdminMenu") => sub {
									 _admin(sub { _handleImenu($return, $uid, $host, $user) },
													$host, $uid, $user,
													qw/Logs Security Console/)
								});
	$menu->pack;
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub _fileServer {
	my ($return, $host, $uid, $user) = @_;
	$host = update($host, $uid);
	my $frame = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $table, $back) = (
		$frame->Label(@H, -text => $host->{Name}, -font => [ qw/Arial 12/ ]),
		$frame->Label(@H, -text => L("Admin_FileServer"), -font => [ qw/Arial 8/ ]),
		MyTable(
			$frame,
			@F,
			-rows       => 15,
			-columns    => 3,
			-scrollbars => "e",
			-fixedrows  => 1,
		),
	);
	$back = $frame->Button(@B, -text => L("back"), -command => $return);
	$table->put(0, $_->[0], $_->[1]) for([0, L("Filename")], [1, L("Size")], [2, L("EncryptionLevel")]);
	my $index = 0;
	foreach my $key (sort { lc($a) cmp lc($b) } keys %{ $host->{Files} }) {
		$table->put(++$index, 0, MyLinkPopup($key, $table, "remote://$user\@$uid/$key", sub { _fileServer($return, $host, $uid, $user) }));
		$table->put($index,   1, MyLinkPopup(L("GQs", $host->{Files}{$key}{Gigaquods}), $table, "remote://$user\@$uid/$key", sub { _fileServer($return, $host, $uid, $user) }));
		$table->put($index,   2, MyLinkPopup(L("Level", $host->{Files}{$key}{Encrypted}), $table, "remote://$user\@$uid/$key", sub { _fileServer($return, $host, $uid, $user) }));
	}
	$title->grid(   -row => 0, -column => 0, -sticky => "wn");
	$subtitle->grid(-row => 1, -column => 0, -sticky => "wn");
	$table->grid(   -row => 2, -column => 0, -sticky => "wens");
	$back->grid(    -row => 3, -column => 0, -sticky => "we");
	$frame->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $frame;
}

sub _viewRecords {
	my ($return, $host, $uid, $user) = @_;
	$host = update($host, $uid);
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $table, $back) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("Admin_ViewRecords"), -font => [ qw/Arial 8/ ], -justify => "left"),
		MyTable(
			$screen,
			@F,
			-rows       => 15,
			-columns    => 3,
			-scrollbars => "e",
			-fixedrows  => 1,
		),
	);
	$table->put(0, $_->[0], substr($_->[1], 0, -1)) for([0, L("Username")], ["1", L("Password")], ["2", L("SecurityLevel")]);
	my $index = 0;
	my @records = map { [ $_, $host->{Records}{$_}{Password}, $host->{Records}{$_}{Level} ] } sort { lc($a) cmp lc($b) } keys %{ $host->{Records} };
	for(@records) {
		my $a = sub { _viewRecords($return, $host, $uid, $user) };
		$table->put(++$index,0,MyLinkPopup($table->Entry(@E,-textvariable =>\$_->[0]),"records://$uid",$a));
		$table->put($index,  1,MyLinkPopup($table->Entry(@E,-textvariable =>\$_->[1]),"records://$uid",$a));
		$table->put($index,  2,MyLinkPopup($table->Entry(@E,-textvariable =>\$_->[2]),"records://$uid",$a));
	}
	my $commit = $screen->Button(
		@B,
		-text    => L("CommitChanges"),
		-state   => $host->{Records}{$user}{Level} == 0 ? "active" : "disabled",
		-command => sub {
			my $Records = {
				map {
					$_->[0] => { Password => $_->[1], Level => $_->[2] }
				} @records
			};
			$host->{Records} = $Records;
			$rpc->call("storObject", $uid, $host);
			warn Dumper($Records);
		}
	);
	$back = $screen->Button(@B, -text => L("back"), -command => $return);
	$title->grid(   -row => 0, -column => 0, -columnspan => 2, -sticky => "wn");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 2, -sticky => "wn");
	$table->grid(   -row => 2, -column => 0, -columnspan => 2, -sticky => "wens");
	$back->grid(    -row => 3, -column => 0, -columnspan => 1, -sticky => "we");
	$commit->grid(  -row => 3, -column => 1, -columnspan => 1, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub _viewLinks {
	my ($return, $host, $uid, $user, $filter) = @_;
	$filter    = lc($filter);
	$host      = update($host, $uid);       $host->{Links} ||= [qw/ /];
	$uObject   = update($uObject, $uIP);
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $table, $ffield, $fok, $back) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("Admin_ViewLinks"), -font => [ qw/Arial 8/ ], -justify => "left"),
		MyTable(
			$screen,
			@F,
			-rows       => 15,
			-columns    => 3,
			-scrollbars => "e",
			-fixedrows  => 1,
		),
		$screen->Entry(@E, -textvariable => \$filter),
		BindLabel($screen, L("Filter"), "<ButtonPress-1>", sub {_viewLinks($return,$host,$uid,$user,$filter)}),
		$screen->Button(@B, -text => L("back"), -command => $return),
	);
	$table->put(0, $_->[0], $_->[1]) for([0, " "], ["1", "IP"], ["2", "Name"]);
	my $addPhoto        = $table->Photo(-file => "graphics/add.xpm");
	my $addHoveredPhoto = $table->Photo(-file => "graphics/add-hovered.xpm");
	my $index = 0;
	my %name;
	foreach my $hh (
		sort { lc($a->[1]) cmp lc($b->[1]) }
		grep { lc($_->[1]) =~ /\Q$filter\E/ }
		map { [ $_, C($_) ] }
		(ref($host->{Links}) eq "ARRAY" ? @{ $host->{Links} } : keys %{ $host->{Links} })
	) {
		my ($host, $name) = @$hh;
		my $maybeAdd = $table->Label(@L,
																 exists $uObject->{Links}{$host}
																	 ? (-text  => " ")
																	 : (-image => $addPhoto));
		$maybeAdd->bind("<Enter>", sub {
			$maybeAdd->configure(-image => $addHoveredPhoto) if(not exists $uObject->{Links}{$host});
		});
		$maybeAdd->bind("<Leave>", sub {
			$maybeAdd->configure(-image => $addPhoto)        if(not exists $uObject->{Links}{$host});
		});
		$maybeAdd->bind("<ButtonPress-1>", sub {
			$uObject = update($uObject, $uIP);
			if(exists $uObject->{Links}{$host}) {
				# nix
			} else {
				playSound("mouseclick");
				$uObject->{Links}{$host} = 1;
				$maybeAdd->configure(-image => undef);
				$maybeAdd->configure(-text  => " ");
				$rpc->call("storObject", $uIP, $uObject);
				showMap();
			}
		});
		$table->put(++$index, 0, $maybeAdd);
		$table->put($index,   1, BindLabel($table,
																			 $host,
																			 "left|<ButtonPress-1>",
																			 sub { dial($host) }));
		$table->put($index,   2, BindLabel($table,
																			 $name,
																			 "left|<ButtonPress-1>",
																			 sub { dial($host) }));
	}
	$title   ->grid(-row => 0, -column => 0, -columnspan => 2, -sticky => "wn");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 2, -sticky => "wn");
	$table   ->grid(-row => 2, -column => 0, -columnspan => 2, -sticky => "wens");
	$ffield  ->grid(-row => 3, -column => 0, -columnspan => 1, -sticky => "we");
	$fok     ->grid(-row => 3, -column => 1, -columnspan => 1, -sticky => "e");
	$back    ->grid(-row => 4, -column => 0, -columnspan => 2, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

1;
