#!/usr/bin/perl -w

use warnings;
use strict;
use Storable qw/lock_store lock_retrieve freeze thaw/;
use Data::Dumper;

require MyLinkI18N;

our ($dbfile, %D);

sub runXML {
	my ($code, $db) = (shift, lock_retrieve $dbfile);
	foreach my $key (keys %{ $code }) {
		my $mkey = $key;
		$mkey =~ s/[0-9]+$//;
		if($mkey eq "Arrest") {
			my $hisIP = $code->{$key};
			warn "Manually arrested $hisIP.\n";
			$db->{hosts}{$hisIP}{Dead} = 1;
		} elsif($mkey eq "PassCheck") {
			my ($mip, $delay, %checks) = ("128.0.0.13", @{ $code->{$key} });
			foreach my $h (keys %checks) {
				if(
					scalar
					grep {
						$_ > u2m(time - $delay - 15) and
						$db->{hosts}{$mip}{News}{$_}{Type} =~ /^(BROKENIN|BREAKATTEMPT)$/ and
						$db->{hosts}{$mip}{News}{$_}{A}[0] eq $h
					}
					keys %{ $db->{hosts}{$mip}{News} }
				) {
					warn "Resetting $h (" . join(" ", @{ $checks{$h} }) . ")...\n";
					$db->{hosts}{$h}{Records}{$_}{Password} = getRandPWD() for(@{ $checks{$h} });
					warn Dumper($db->{hosts}{$h}{Records});
				}
			}
			push @{ $db->{queue} }, [ time + $delay, { PassCheck => [ $delay, %checks ] } ];
		} elsif($mkey eq "AddCredits") {
			my ($bankIP, $accTO, $from, $amount) = ($code->{$key}{bank}, $code->{$key}{acc}, $code->{$key}{from}, $code->{$key}{amount});
			$db->{hosts}{$bankIP}{Records}{$accTO}{Credits} += $amount;
			$db->{hosts}{$bankIP}{Logs}{u2m(time)} = "${amount}c transferred from $from to $accTO";
		} elsif($mkey eq "DelCredits") {
			my ($bankIP, $accFROM, $to, $amount) = ($code->{$key}{bank}, $code->{$key}{acc}, $code->{$key}{to}, $code->{$key}{amount});
			$db->{hosts}{$bankIP}{Records}{$accFROM}{Credits} -= $amount;
			$db->{hosts}{$bankIP}{Logs}{u2m(time)} = "${amount}c transferred from $accFROM to $to";
		} elsif($mkey eq "GWCheck") {
			my ($thing, $ip, $comp, $ifFalse, $ifTrue) = @{ $code->{$key} };
			my $do = 0;
			if($thing eq "Memory") {
				$do++ if($db->{hosts}{$ip}{Memory} > $comp->{MaxCapacity});
			} elsif($thing eq "Modem") {
				$do++ if($db->{hosts}{$ip}{Modem}  > $comp->{MaxModem});
			} elsif($thing eq "CPU") {
				$do++ if($db->{hosts}{$ip}{CPU}    > $comp->{MaxCPU});
			} elsif($thing eq "Security") {
				$do++ if(scalar(grep { /Motion_Sensor|Self_Destruct/ } keys %{ $db->{hosts}{$ip}{Files} }) > $comp->{MaxSecurity});
			}
			warn Dumper({t=>$thing,i=>$ip,c=>$comp,f=>$ifFalse,do=>$do});
			push @{ $db->{queue} }, [
				time,
				$ifFalse,
			] if($do);
			push @{ $db->{queue} }, [
				time,
				$ifTrue,
			] unless($do);
		} elsif($mkey eq "Mail") {
			my ($uid, $mail) = @{ $code->{$key} };
			my $time = u2m(time);
			$time++ while(exists $db->{hosts}{$uid}{Mails}{$time});
			$db->{hosts}{$uid}{Mails}{$time} = { Time => u2m(time), %{ $mail } };
		} elsif($mkey eq "SetKey") {
			my ($to, @keys, $last) = @{ $code->{$key} };
			$last = pop @keys;
			warn ">>$mkey >>$key >>$to >>@keys >>$last\n";
			my $subkey = $db->{hosts};
			$subkey = $subkey->{$_} for(@keys);
			$subkey->{$last} = $to;
		} elsif($mkey eq "DelKey") {
			my (@keys, $last) = @{ $code->{$key} };
			$last = pop @keys;
			warn "del: >>$mkey >>$key >>@keys >>$last\n";
			my $subkey = $db->{hosts};
			$subkey = $subkey->{$_} for(@keys);
			delete $subkey->{$last};
		} elsif($mkey eq "Add") {
			my ($to, @keys, $last) = @{ $code->{$key} };
			$last = pop @keys;
			warn "add: >>$mkey >>$key >>$to >>@keys >>$last\n";
			my $subkey = $db->{hosts};
			$subkey = $subkey->{$_} for(@keys);
			$subkey->{$last} += $to;
		} elsif($mkey eq "Push") {
			my ($to, @keys, $last) = @{ $code->{$key} };
			$last = pop @keys;
			warn "p: >>$mkey >>$key >>$to >>@keys >>$last\n";
			my $subkey = $db->{hosts};
			$subkey = $subkey->{$_} for(@keys);
			push @{ $subkey->{$last} }, $to;
		} elsif($mkey eq "ReUp") {
			$db->{hosts}{$code->{$key}}{Down} = 0;
		} elsif($mkey eq "Down") {
			$db->{hosts}{$code->{$key}}{Down} = 1;
		} elsif($mkey eq "Spy") {
			my ($sendto, $uid, $ohost) = ($code->{$key}{sendto}, $code->{$key}{uid}, $code->{$key}{ohost});
			my $chost = thaw freeze $db->{hosts}{$uid};
			delete $ohost->{Logs};
			delete $chost->{Logs};
			if(chkSum($ohost) ne chkSum($chost)) {
				my @changes = ();
				if(chkSum($ohost->{Records}) ne chkSum($chost->{Records})) {
					foreach my $rr (keys %{ $chost->{Records} }) {
						if(not exists $ohost->{Records}{$rr}) {
							push @changes, [ NEWRECORD => [ $rr, $chost->{Records}{$rr}{Password} ] ];
						} elsif(not exists $chost->{Records}{$rr}) {
							push @changes, [ DELRECORD => $rr ];
						} else {
							push @changes, [ RECORDMOD => [ $rr, $chost->{Records}{$rr}{Password} ] ];
						}
					}
				}
				if(chkSum($ohost->{Files}) ne chkSum($chost->{Files})) {
					foreach my $ff (keys %{ $chost->{Files} }) {
						if(not exists $ohost->{Files}{$ff}) {
							push @changes, [ NEWFILE => $ff ];
						} elsif(not exists $chost->{Files}{$ff}) {
							push @changes, [ DELFILE => $ff ];
						} else {
							push @changes, [ FILEMOD => $ff ];
						}
					}
				}
				if(chkSum($ohost->{Sites}) ne chkSum($chost->{Sites})) {
					foreach my $ss (keys %{ $chost->{Sites} }) {
						if($chost->{Sites}{$ss} ne $ohost->{Sites}{$ss}) {
							push @changes, [ SITEMOD => $ss ];
						}
					}
				}
				$_->{Down} ||= 0 for($ohost, $chost);
				if($ohost->{Down} != $chost->{Down}) {
					push @changes, [ DOWN => $chost->{Down} ];
				}
				if(@changes) {
					$db->{hosts}{$sendto}{Mails}{u2m(time)} = {
						Type    => "News",
						From    => "orwell\@$chost->{Name}",
						Subject => L("Machines_Orwell_Subject"),
						Text    => 
							join(
								"\n",
								L("Machines_Orwell_Text", $chost->{Name}),
								map {
	my $mesg;
	$mesg = L("Machines_Orwell_NewFile",   $_->[1]) if($_->[0] eq "NEWFILE");
	$mesg = L("Machines_Orwell_DelFile",   $_->[1]) if($_->[0] eq "DELFILE");
	$mesg = L("Machines_Orwell_FileMod",   $_->[1]) if($_->[0] eq "FILEMOD");
	$mesg = L("Machines_Orwell_NewRecord", $_->[1]->[0], $_->[1]->[1]) if($_->[0] eq "NEWRECORD");
	$mesg = L("Machines_Orwell_RecordMod", $_->[1]->[0], $_->[1]->[1]) if($_->[0] eq "RECORDMOD");
	$mesg = L("Machines_Orwell_DelRecord", $_->[1]) if($_->[0] eq "DELRECORD");
	$mesg = L("Machines_Orwell_SiteMod",   $_->[1]) if($_->[0] eq "SITEMOD");
	$mesg = L("Machines_Orwell_Down")               if($_->[0] eq "DOWN" and $_->[1]);
	$mesg = L("Machines_Orwell_ReUp")               if($_->[0] eq "DOWN" and not $_->[1]);
	$mesg;
									}
								@changes
							),
						Time    => u2m(time),
						Links   => [ map { "$_:$chost->{Records}{$_}{Password}\@$uid" } keys %{ $chost->{Records} } ]
					};
				}
			}
			push @{ $db->{queue} }, [
				time,
				{
					Spy => {
						sendto => $sendto,
						uid    => $uid,
						ohost  => thaw freeze $db->{hosts}{$uid}
					}
				}
			];
		} elsif($mkey eq "News") {
			my ($type, @A) = @{ $code->{$key} };
			my $mip = "128.0.0.13";
			warn "Adding news $type, @A to [$mip]\n";
			$db->{hosts}{$mip}{News}{u2m(time)} = { Type => $type, A => [ @A ] };
		} elsif($mkey eq "300c") {
			my ($bankIP, $accNO, $userIP, $whenAgain) = @{ $code->{$key} };
			$db->{hosts}{$bankIP}{Records}{$accNO}{Credits} -= $D{"300c"};
			$db->{hosts}{$userIP}{Mails}{u2m(time)} = {
				Type    => "News",
				From    => "agents\@MyLink International Bank.net",
				Subject => L("Machines_Membership_Subject", L("Credits", $D{"300c"})),
				Text    => L("Machines_Membership_Text"   , L("Credits", $D{"300c"})),
				Time    => u2m(time),
			};
			push @{ $db->{queue} }, [ time + $whenAgain, { "300c" => $code->{$key} } ];
		} elsif($mkey eq "Loan") {
			my ($bankIP, $accNO, $userIP, $whenAgain) = @{ $code->{$key} };
			if($db->{hosts}{$bankIP}{Records}{$accNO}{Loan} > 0 or $db->{hosts}{$bankIP}{Records}{$accNO}{Credits} < 0) {
				$db->{hosts}{$bankIP}{Records}{$accNO}{Credits} -= $D{LoanC};
				$db->{hosts}{$userIP}{Mails}{u2m(time)} = {
					Type    => "News",
					From    => "internal\@MyLink International Bank.net",
					Subject => L("Machines_Loan_Subject"),
					Text    => L("Machines_Loan_Text", L("Credits", $D{LoanC})),
					Time    => u2m(time),
				};
			}
			push @{ $db->{queue} }, [ time + $whenAgain, { "300c" => $code->{$key} } ];
		} elsif($mkey eq "FollowLog") {
			my ($nexthop, $hop, $time, $delay, $orig) = ($code->{$key}{nh}, $code->{$key}{hop}, $code->{$key}{ts}, $code->{$key}{delay}, $code->{$key}{orig});
			warn "Got FollowLog request: $nexthop, $hop, $time, $delay, $orig\n";
			warn Dumper($db->{hosts}{$hop}{Logs});
			next unless(exists $db->{hosts}{$hop}{Logs}{$time});
			if(
				$db->{hosts}{$hop}{Type} eq "P" and
				$db->{hosts}{$hop}{Logs}{$time} =~ /^Connection established to \Q$nexthop\E$/
			) { # Got you *muhahaha*
				push @{ $db->{queue} }, [ time, { Arrest => $hop } ];
				warn "Let $hop being arrested.\n";
				push @{ $db->{queue} }, [
					time,
					{
						News => [
							"ARRESTCC",
							$db->{hosts}{$hop}{Unixname},
							$db->{hosts}{$hop}{Records}{$db->{hosts}{$hop}{Unixname}}{Realname},
							$orig,
						]
					}
				] unless(exists $db->{hosts}{$hop}{Dead} and $db->{hosts}{$hop}{Dead});
			} else {
				if(
					$db->{hosts}{$hop}{Logs}{$time} =~ /^Bouncing connection from ([^ ]+) to ([^ ]+)$/
					and $2 eq $nexthop
				) {
					warn "Following: $nexthop, $hop, $time, $delay ==> $1\n";
					push @{ $db->{queue} }, [
						time + $delay,
						{
							FollowLog => {
								nh    => $hop,
								hop   => $1,
								ts    => $time,
								delay => $delay,
								orig  => $orig,
							}
						}
					];
				}
			}
		}
	}
	lock_store $db, $dbfile;
}

1;
