#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, %D);

sub mapGeoPos {
	$windows{MapMask   } ||= $windows{Top}->Photo(-file => "graphics/worldmap-mask.xpm");
	$windows{MapPosUsed} ||= { };
	$windows{MapPosAss}  ||= { };
	my $name = shift;
	my @re;
	unless($windows{MapPossAss}->{$name}) {
		my $pos = 0;
		$pos   += ord($_) * ord($_) for(split "", chkSum($name));
		do{warn"$pos oha! ;-)\n";warn join(", ",keys%{$windows{MapPosUsed}});$pos   *= 2} while(exists $windows{MapPosUsed}->{$pos} and $windows{MapPosUsed}->{$pos});
		do {
			@re = ($pos % 100, int($pos / 100) % 100);
			$pos ++;
		} while(
			not @re or
			($windows{MapMask}->get($re[0] * 600 / 100, $re[1] * 500 / 100))[0] == 255
		);
		$windows{MapPossAss}->{$name} = [ @re ];
		$windows{MapPosUsed}->{$pos} = 1;
	} else {
		@re = @{ $windows{MapPossAss}->{$name} };
	}
	$re[0] *= shift;
	$re[1] *= shift;
	return @re;
}

sub mapGeoLittleBox {
	my ($key, $sx, $sy) = @_;
	return (mapGeoPos($key, $sx, $sy), map { $_ +  2 } mapGeoPos($key, $sx, $sy));
}
sub mapGeoLittleMiddle {
	my ($key, $sx, $sy) = @_;
	return map { $_ + 1 } mapGeoPos($key, $sx, $sy);
}
sub mapGeoBigBox {
	my ($key, $sx, $sy) = @_;
	return (mapGeoPos($key, $sx, $sy), map { $_ + 10 } mapGeoPos($key, $sx, $sy));
}
sub mapGeoBigMiddle {
	my ($key, $sx, $sy) = @_;
	return map { $_ + 5 } mapGeoPos($key, $sx, $sy);
}

sub showMapLittleRoute {
	my $sum = chkSum([
		@{ $windows{Bounces} || [ ] },
		$windows{ConnectedTo} || "",
		exists $uObject->{Files}{"HUD_MapShowTrace-prog"},
		$windows{ActiveTraceHopsTotal} || 0,
	]);
	if(not defined $windows{MapLittleOld} or $windows{MapLittleOld} ne $sum) {
		warn "new (lr)!\n";
		$windows{LMC}->delete("LilRoute$_") for( 0 .. 2);
		if($windows{ConnectedTo}) {
			MyDottedLine(
				$windows{LMC},
				map({mapGeoLittleMiddle($_, 200/100,160/100)} $uIP, @{$windows{Bounces}}, $windows{ConnectedTo}),
				-fill  => "yellow",
				-arrow => "last",
				-tags  => [ "LilRoute0" ],
			);
			if(exists $uObject->{Files}{"HUD_MapShowTrace-prog"} and $windows{ActiveTraceHopsTotal} and $windows{Bounces}) {
				my @r = reverse @{ $windows{Bounces} };
				MyDottedLine(
					$windows{LMC},
					map({mapGeoLittleMiddle($_, 200/100,160/100)} $windows{ConnectedTo}, (@r, $uIP)[0 .. $windows{ActiveTraceHopsDone}]),
					-fill  => "red",
					-arrow => "last",
					-tags  => [ "LilRoute1" ],
				);
			}
			$windows{LMC}->createText(
				map({ $_ + 3 } mapGeoPos($windows{ConnectedTo}, 200 / 100, 160 / 100)),
				-text => C($windows{ConnectedTo}),
				-fill => "red", -anchor => "w",
				-tags => [ "LilRoute2" ],
			);
		}
		$windows{MapLittleOld} = $sum;
	}
}

sub showMapLittleButton {
	if($windows{ConnectedTo}) {
		$windows{LMB}->configure(-text => L("Disconnect"), -command => sub {
			disConnect(defined $windows{MapOldInMain});
		});
	} else {
		$windows{LMB}->configure(-text => "", -command => sub { 1 });
	}
}

sub showMapLittle {
	unless($windows{InMap}) {
		$windows{InMap} = $windows{Map}  ->Frame( @F, -width => 200, -height => 170);
		$windows{LMC}   = $windows{InMap}->Canvas(@F, -width => 200, -height => 160);
		$windows{LMB}   = $windows{InMap}->Button(@B);
		showMapLittleButton();
		$windows{InMap}->pack;
		$windows{LMC}  ->grid(-row => 0, -column => 0);
		$windows{LMB}  ->grid(-row => 1, -column => 0);
		$windows{LMC}  ->repeat(100, sub { showMapLittleRoute()  });
		$windows{LMB}  ->repeat(100, sub { showMapLittleButton() });
		$windows{LMC}->createImage(0, 0, -anchor => nw => -image => $windows{LMC}->Photo(-file => "graphics/worldmap-small.xpm"));
		$windows{LMC}  ->CanvasBind("<ButtonPress-1>", sub {
			unless($windows{MapOldInMain}) {
				playSound("openworldmap");
				$windows{MapOldInMain} = $windows{InMain};
				$windows{InMain}       = showMapBig();
				$windows{MapOldInMain}->packForget;
				$windows{InMain}      ->pack;
			} else {
				playSound("mouseclick");
				$windows{MapOldInMain}->pack;
				$windows{InMain}      ->packForget;
				$windows{InMain}      = $windows{MapOldInMain};
				undef $windows{MapOldInMain};
			}
		});
	} else {
		$windows{LMC}->delete("obj");
	}
	my @bounces = defined $windows{Bounces} ? @{ $windows{Bounces} } : ();
	foreach my $dot ($uIP, @bounces, grep { $uObject->{Links}{$_} } keys %{ $uObject->{Links} }) {
		$windows{LMC}->createRectangle(
			mapGeoLittleBox($dot, 200 / 100, 160 / 100),
			-fill => "lightblue",
			-tags => [ "obj" ]
		);
	}
}



sub showMapBigButton {
	if($windows{ConnectedTo}) {
		$windows{BMB}->configure(-text => L("Disconnect"), -command => sub {
			disConnect(1);
			playSound("mouseclick");
			$windows{MapOldInMain} = $windows{Main}->Frame(@F);
			my $mesg = $windows{MapOldInMain}->Label(@L, -text => L("ConnTerminatedByGW"));
			my $ok   = BindLabel($windows{MapOldInMain}, L("ok"), "<ButtonPress-1>", sub { listLinks() });
			$mesg->pack;
			$ok  ->pack;
		});
	} else {
		$windows{BMB}->configure(-text => L("Connect"), -command => sub {
			playSound("mouseclick");
			if(@{ $windows{BMR} } == 0) {
				MyMesg(L("Map_ErrNoDest_Title"), L("Map_ErrNoDest_Text"));
			} else {
				$windows{MapOldInMain}->pack;
				$windows{InMain}      ->packForget;
				$windows{InMain}      = $windows{MapOldInMain};
				undef $windows{MapOldInMain};
				dial(pop @{ $windows{BMR} }, @{ $windows{BMR} });
			}
		});
	}
}


sub showMapBigRoute {
	my $sum = chkSum([
		@{ $windows{Bounces} || [ ] },
		$windows{ConnectedTo} || "",
		@{ $windows{BMR} || [ ] },
		$windows{MapBigCounter} || 0,
	]);
	if(not defined $windows{MapBigOld} or $windows{MapBigOld} ne $sum) {
		warn "new (br)!\n";
		$windows{BMC}->delete("BigRoute$_") for(0, 1);
		delete $windows{DottedLines}->{"BigRoute0"};
		if($windows{ConnectedTo}) {
			MyDottedLine(
				$windows{BMC},
				map({mapGeoBigMiddle($_, 600/100,500/100)} $uIP, @{$windows{Bounces}}, $windows{ConnectedTo}),
				-fill  => "yellow",
				-arrow => "last",
				-tags  => [ "BigRoute0" ],
			);
		}
		if(@{ $windows{BMR} } > 0) {
			$windows{BMC}->createLine(
				map({mapGeoBigMiddle($_, 600/100,500/100)} $uIP, @{ $windows{BMR} }),
				-fill  => "yellow", #"#fF4500",
				-arrow => "last",
				-tags  => [ "BigRoute1" ],
			);
		}
		$windows{MapBigOld} = $sum;
	}
}

sub showMapBig {
	$windows{MapBigCounter} = 1 - ($windows{MapBigCounter} ||= 0);
	my $screen = $windows{Main}->Frame( @F, -width => 600, -height => 550);
	$windows{BMC} = $screen    ->Canvas(@F, -width => 600, -height => 500);
	my $load      = $screen    ->Button(@B, -text => L("Map_Load"), -command => sub {
		playSound("mouseclick");
		$uObject      = update($uObject, $uIP);
		$windows{BMR} = $uObject->{MapSaved}
			if($uObject->{MapSaved});
	});
	my $save      = $screen    ->Button(@B, -text => L("Map_Save"), -command => sub {
		playSound("mouseclick");
		$uObject      = update($uObject, $uIP);
		$uObject->{MapSaved} = $windows{BMR};
		$rpc->call("storObject", $uIP, $uObject);
	});
	my $cancel    = $screen    ->Button(@B, -text => L("Map_Cancel"), -command => sub {
		playSound("mouseclick");
		$windows{BMR} = [ ];
	});
	my $start = 0;
	$start ++ if(not exists $windows{BMB});
	$windows{BMB} = $screen    ->Button(@B, -text => L("Connect"));
	$windows{BMC}->grid(-row => 0, -column => 0, -columnspan => 4);
	$save        ->grid(-row => 1, -column => 0);
	$load        ->grid(-row => 1, -column => 1);
	$cancel      ->grid(-row => 1, -column => 2);
	$windows{BMB}->grid(-row => 1, -column => 3);
	my $img = $windows{BMC}->createImage(0, 0, -anchor => nw => -image => $windows{BMC}->Photo(-file => "graphics/worldmap-large.xpm"));
	my @bounces   = defined $windows{Bounces} ? @{ $windows{Bounces} } : ();
	$windows{BMR} = [ ];
	foreach my $dot ($uIP, @bounces, grep { $uObject->{Links}{$_} } keys %{ $uObject->{Links} }) {
		$windows{BMC}->bind(
			my $box = $windows{BMC}->createRectangle(
				mapGeoBigBox($dot, 600 / 100, 500 / 100),
				-fill => "white",
				-tags => [ "obj" ]
			),
			"<ButtonPress-1>",
			sub {
#				unless($windows{ConnectedTo}) {
					playSound("addlink");
					if(grep { $windows{BMR}->[$_] eq $dot } 0 .. $#{ $windows{BMR} }) {
						$windows{BMR} = [ grep { $_ ne $dot } @{ $windows{BMR} } ];
					} else {
						push @{ $windows{BMR} }, $dot;
					}
#				}
			}
		);
		my $text = $windows{BMC}->createText(
			(map { $_ + 12 } mapGeoPos($dot, 600 / 100, 500 / 100)),
			-text => C($dot),
			-fill => "red", -anchor => "w",
			-tags => [ "obj" ],
		);
		$windows{BMC}->raise($text, $img);
	}
	if($start) {
		$windows{Top}->repeat(100, sub { showMapBigRoute()  });
		$windows{Top}->repeat(100, sub { showMapBigButton() });
	}
	return $screen;
}

1;
