#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, %D);

sub handleM {
	my ($uid, $host) = @_;
	logInScreen(
		$uid,
		$host,
		sub {
			playSound("login");
			_handleMmenu(
				sub { warn 43 },
				$uid,
				$host,
				$windows{UserEntry},
			)
		},
	);
}

sub newNews {
	my ($lL1i, @lLi1) = @_; # yeah elite ;-)
	my $Ll1i = $rpc->call("recvObject", "128.0.0.13");
	$Ll1i->{News}{u2m(time)} = { Type => $lL1i, A => [ @lLi1 ] };
	$rpc->call("storObject", "128.0.0.13", $Ll1i);
}

sub _handleMmenu {
	my ($return, $uid, $host, $user) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my $menu = new MyLinkMenu($screen);
	$menu->addItem(1, "Title"        => $host->{Name});
	$menu->addItem(1, "Subtitle"     => L("MainMenu"));
	my $noAdmin = $host->{Records}{$user}{Level} == 0 ? 0 : 1;
	$menu->addItem(1, L("ML_News")  => sub { _news(sub { _handleMmenu($return, $uid, $host, $user) }, $host, $uid, $user) });
	$menu->addItem($noAdmin, L("ML_MissionList") => sub { _missions(sub { _handleMmenu($return, $uid, $host, $user) }, $host, $uid, $user) });
	$menu->addItem($noAdmin, L("ML_SWUpgrades")  => sub { _buySoftware(sub { _handleMmenu($return, $uid, $host, $user) }, $host, $uid, $user) });
	$menu->addItem($noAdmin, L("ML_HWUpgrades")  => sub { _buyHardware(sub { _handleMmenu($return, $uid, $host, $user) }, $host, $uid, $user) });
	$menu->addItem($noAdmin, L("ML_GWUpgrades")  => sub { _buyGateway(sub { _handleMmenu($return, $uid, $host, $user) }, $host, $uid, $user) });
	$menu->addItem(1, L("ML_Rankings")           => sub { _showRankings(sub { _handleMmenu($return, $uid, $host, $user) }, $host, $uid, $user) });
	$menu->addItem(1 - $noAdmin,
								 L("AdminMenu") => sub {
									 _admin(
									 	 sub { _handleMmenu($return, $uid, $host, $user) },
										 $host, $uid, $user,
										 qw/Logs Security Records/
										)
								 });
	$menu->pack;
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub _news {
	my ($return, $host, $uid, $user) = @_;
	$host      = update($host, $uid);
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $table, $descr, $back) = (
		$screen->Label(@H,  -text => $host->{Name}, -font => [ qw/Arial 12/ ]),
		$screen->Label(@H,  -text => L("ML_News") , -font => [ qw/Arial 8/ ]),
		MyTable($screen, @F, -rows => 15, -columns => 2, -scrollbars => "e", -fixedrows => 1),
		$screen->ROText(@E, -width => 68, -height => 7, -wrap => "word"),
		$screen->Button(@B, -text => L("back"), -command => $return),
	);
	$table->put(0, $_->[0], $_->[1]) for([0, L("Timestamp")], [1, L("ML_News_Title")]);
	my $index = 0;
	foreach my $news (sort { $b <=> $a } keys %{ $host->{News} }) {
		my $showSub = sub {
			$descr->delete(qw/ 0.0 end /);
			$descr->insert("0.0", news2text($news, $host->{News}{$news})->{Body});
		};
		$table->put(++$index, 0, BindLabel($table, m2m($news), "left|<ButtonPress-1>", $showSub));
		$table->put(  $index, 1, BindLabel($table, news2text($news, $host->{News}{$news})->{Heading}, "left|<ButtonPress-1>", $showSub));
	}
	$title->grid(   -row => 0, -column => 0, -columnspan => 1, -sticky => "wn");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 1, -sticky => "wn");
	$table->grid(   -row => 2, -column => 0, -columnspan => 1, -sticky => "we");
	$descr->grid(   -row => 3, -column => 0, -columnspan => 1, -sticky => "we");
	$back->grid(    -row => 4, -column => 0, -columnspan => 1, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub news2text {
	my ($when, $type, @add) = (shift, $_[0]->{Type}, @{ $_[0]->{A} });
	my %returns = (
		ARREST => sub {
			Heading => [ "Earlier today federal agents arrested a man" ],
			Body    => [ "Earlier today $add[0] was arrested by federal agents." ],
		},
		ARRESTCC => sub {
			Heading => [ "Earlier today a hacker was arrested by federal agents" ],
			Body    => [ "Earlier today, federal agents arrested $add[1].\n\nIt's suspected that $add[0], so his MyLink agent handle, is liable to the recent broke-in in the ". C($add[2]) ."." ],
		},
		BROKENIN => sub {
			Heading => [ "Lone hacker broke in computer system" ],
			Body    => [
				"Earlier today, a lone hacker broke in the " .
				C($add[0]) .
				".\n\nFederal agents where sent to search after him.\n"
			]
		},
		BREAKATTEMPT => sub {
			Heading => [ "Break-in attempt detected" ],
			Body    => [
				"Earlier today, a lone hacker attempted to break in the " .
				C($add[0]) .
				"."
			]
		},
		DATALOSS => sub {
			Heading => [ "Major corporation suffers complete data loss" ],
			Body    => [
				"Earlier today, a lone hacker broke in the " .
				C($add[0]) .
				" and deleted many files.\n\nFederal agents where sent to search after him.\n"
			]
		},
		SYSFILES => sub {
			Heading => [ "Operating system files deleted by malicious hacker" ],
			Body    => [
				"Earlier today, a lone hacker broke in the " .
				C($add[0]) .
				" and deleted key operating system files.\n\nFederal agents where sent to search after him.\n"
			]
		},
		DOWN => sub {
			Heading => [ "Server of a major corporation completely destroyed" ],
			Body    => [
				"Earlier today, a lone hacker destroyed the " .
				C($add[0]) .
				".\n\nFederal agents where sent to search after him.\n"
			]
		},
		DBMODIFIED => sub {
			Heading => [ "Records of the ". C($add[0]) ." modified" ],
			Body    => [
				"Earlier today, the database of the " .
				C($add[0]) .
				" was modified.\n\nFederal agents where sent to search after him.\n"
			]
		},
	);
	my $return = { $returns{$type}->() };
	$return->{$_} = splice @{ $return->{$_} }, int rand @{ $return->{$_} }, 1
		for(qw/ Heading Body /);
	return $return;
}

sub _showRankings {
	my ($return, $host, $uid, $user) = @_;
	$host      = update($host, $uid);
	$uObject   = update($uObject, $uIP);
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $table, $back) = (
		$screen->Label(@H, -text => $host->{Name},    -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("ML_Rankings"), -font => [ qw/Arial 8/ ], -justify => "left"),
		MyTable(
			$screen,
			@F,
			-rows       => scalar keys %{ $host->{Records} },
			-columns    => 4,
			-scrollbars => "e",
			-fixedrows  => 1,
		),
		$screen->Button(@B, -text => L("back"), -command => $return),
	);
	$table->put(0,$_->[0],$_->[1]) for([0, L("ML_Rankings_Rank")], [1, L("ML_Rankings_Unixname")], [2, L("ML_Rankings_UR")], [3, L("ML_Rankings_Status")]);
	my $index = 0;
	foreach my $agent ( # elite Schwartzian transform :))
		sort { $b->[0] <=> $a->[0] }
			map {
				my $hisPC = $rpc->call("recvObject", $host->{Records}{$_}{IP});
				[ $hisPC->{Yeahs}, $hisPC->{Unixname}, exists $hisPC->{Dead} ? $hisPC->{Dead} : 0 ]
			}
				grep { $host->{Records}{$_}{Level} != 0 }
					keys %{ $host->{Records} }
	) {
		$table->put(++$index, 0, $index);
		$table->put($index,   1, $agent->[1]);
		$table->put($index,   2, getRank($agent->[0]));
		$table->put($index,   3, $agent->[2] ? L("ML_Rankings_InJail") : L("ML_Rankings_Active"));
	}
	$title->grid(   -row => 0, -column => 0, -columnspan => 1, -sticky => "wn");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 1, -sticky => "wn");
	$table->grid(   -row => 2, -column => 0, -columnspan => 1, -sticky => "we");
	$back->grid(    -row => 4, -column => 0, -columnspan => 1, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub getRank {
	my $yeahs = shift;
	my $rank  = 0;
	$rank++ if($yeahs > 0);
	$rank++ if($yeahs > 3);
	$rank++ if($yeahs > 7);
	return $rank;
}

sub _missions {
	my ($return, $host, $uid, $user) = @_;
	$host      = update($host, $uid);
	$uObject   = update($uObject, $uIP);
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $table, $back) = (
		$screen->Label(@H, -text => $host->{Name},       -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("ML_MissionList"), -font => [ qw/Arial 8/ ], -justify => "left"),
		MyTable(
			$screen,
			@F,
			-rows       => ((scalar keys %{ $host->{Missions} }) > 15 ? 15 : (scalar keys %{ $host->{Missions} })) + 1,
			-columns    => 4,
			-scrollbars => "e",
			-fixedrows  => 1,
		),
		$screen->Button(@B, -text => L("back"), -command => $return),
	);
	$table->put(0, $_->[0], $_->[1]) for([0, L("ML_Missions_RatingNeeded")], [1, L("ML_Missions_Subject")], [2, L("ML_Costs")], [3, L("ML_Missions_Accept")]);
	my $index = 0;
	foreach my $mission (sort { $a <=> $b } keys %{ $host->{Missions} }) {
		$table->put(++$index, 0, $table->Label(@L, -text => $host->{Missions}{$mission}{RankNeeded}));
		$table->put($index,   1, $table->Label(@L, -text => $host->{Missions}{$mission}{Subject}));
		$table->put($index,   2, $table->Label(@L, -text => L("Credits", $host->{Missions}{$mission}{Credits})));
		if($host->{Missions}{$mission}{RankNeeded} > getRank($uObject->{Yeahs})) {
			$table->put($index, 3, $table->Label(@L, -text => L("ML_Missions_TooBad")));
		} else {
			$table->put($index,   3, BindLabel($table,
																				 L("ok"),
																				 "<ButtonPress-1>",
																				 sub {
																					 $host    = update($host,    $uid);
																					 $uObject = update($uObject, $uIP);
																					 $uObject->{Mails}{u2m(time)} = {
																					 	 Type => "Mission",
																						 Time => u2m(time),
																						 From => "agents\@$host->{Name}",
																						 %{ $host->{Missions}{$mission} },
																					 };
																					 delete $host->{Missions}{$mission}
																					 	 unless($mission == 0);
																					 $rpc->call("storObject", $uIP, $uObject);
																					 $rpc->call("storObject", $uid,    $host);
																					 _missions($return, $host, $uid, $user);
																				 }));
		}
	}
	$title->grid(   -row => 0, -column => 0, -columnspan => 1, -sticky => "wn");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 1, -sticky => "wn");
	$table->grid(   -row => 2, -column => 0, -columnspan => 1, -sticky => "we");
	$back->grid(    -row => 4, -column => 0, -columnspan => 1, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}


sub _buyGateway {
	my ($return, $host, $uid, $user) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $table, $descr, $back) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("ML_GWUpgrades"), -font => [ qw/Arial 8/ ], -justify => "left"),
		MyTable(
			$screen,
			@F,
			-rows       => 15,
			-columns    => 3,
			-scrollbars => "e",
			-fixedrows  => 1,
		),
		MyScrolled($screen, "ROText", @E, -wrap => "word", -scrollbars => "ose", -width => 68, -height => 7)
	);
	$table->put(0, $_->[0], $_->[1]) for([0, L("ML_GW_Model")], [1, L("ML_Costs")], [2, L("ML_Buy")]);
	my $index = 0;
	foreach my $item (sort { $host->{Gateways}{$a}{Credits} <=> $host->{Gateways}{$b}{Credits} } keys %{ $host->{Gateways} }) {
		my $buySub = sub {
			my $uO      = $rpc->call("recvObject", $host->{Records}{$user}{IP});
			my $memUsed = 0;
			my $bu   = $rpc->call("recvObject", $uO->{Credits}[0]);
			my $bank = $bu->{Records}{$uO->{Credits}[1]};
			if($bank->{Credits} + $bank->{Loan} >= $host->{Gateways}{$item}{Credits}) {
				my %my;
				$my{CPU}      = $uO->{CPU};
				$my{Modem}    = $uO->{Modem};
				$my{Memory}   = $uO->{Memory};
				$my{Security} = grep { /Motion_Sensor|Self_Destruct/ } keys %{ $uO->{Files} };
				warn Dumper(\%my);

				my @errMsg;
				push @errMsg, L("ML_GW_ErrMoreCPU") if($my{CPU} > $host->{Gateways}{$item}{MaxCPU});
				push @errMsg, L("ML_GW_ErrMoreModem") if($my{Modem} > $host->{Gateways}{$item}{MaxModem});
				push @errMsg, L("ML_GW_ErrMoreMemory") if($my{Memory} > $host->{Gateways}{$item}{MaxCapacity});
				push @errMsg, L("ML_GW_ErrMoreSecurity") if($my{Security} > $host->{Gateways}{$item}{MaxSecurity});
				
				if(@errMsg) {
					MyMesg(L("ML_GW_ErrTitle"), join "\n", @errMsg);
				} else {
					$rpc->call("storTimer", time, {
						DelCredits => {
							bank   => $uO->{Credits}[0],
							acc    => $uO->{Credits}[1],
							to     => "agents\@MyLink International Bank",
							amount => $host->{Gateways}{$item}{Credits}
						}
					});
					$rpc->call("storTimer", time + $D{NewGW}, {
						SetKey  => [
							{
								SetKey0 => [ $item, $host->{Records}{$user}{IP}, "Gateway" ],
								SetKey1 => [ 1,     $host->{Records}{$user}{IP}, "NewGW"   ],
							},
							$host->{Records}{$user}{IP},
							"OnLogin"
						],
						Mail    => [
							$host->{Records}{$user}{IP},
							{
								Type    => "News",
								From    => "agents\@MyLink Corporation.net",
								Subject => L("ML_GW_Success_Subject"),
								Text    => L("ML_GW_Success_Text", $item),
							}
						],
					});
				}
			} else {
				MyMesg(L("ML_NeC_Title"), L("ML_NeC_Text"));
			}
		};
		my $showSub = sub {
			$descr->delete(qw/0.0 end/);
			$descr->insert("0.0", join "\n",
				$item,
				"",
				L("Status_Credits") . " " . L("Credits", $host->{Gateways}{$item}{Credits}),
				L("ML_GW_MaxCapacity") . " " . L("GQs", $host->{Gateways}{$item}{MaxCapacity}),
				L("ML_GW_MaxModem") . " " . L("GQs/s", $host->{Gateways}{$item}{MaxModem}),
				L("ML_GW_MaxCPU") . " " . L("GHz", $host->{Gateways}{$item}{MaxCPU}),
				L("ML_GW_MaxSecurity") . " " .$host->{Gateways}{$item}{MaxSecurity},
				"",
				$host->{Gateways}{$item}{Description});
		};
		$table->put(++$index, 0, BindLabel($table, $item, "<ButtonPress-1>", $showSub));
		$table->put($index,   1, BindLabel($table, L("Credits", $host->{Gateways}{$item}{Credits}), "<ButtonPress-1>", $showSub));
		$table->put($index,   2, BindLabel($table, L("ok"), "<ButtonPress-1>", $buySub));
	}
	$back = $screen->Button(@B, -text => L("back"), -command => $return);
	$title->grid(   -row => 0, -column => 0, -columnspan => 1, -sticky => "wn");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 1, -sticky => "wn");
	$table->grid(   -row => 2, -column => 0, -columnspan => 1, -sticky => "we");
	$descr->grid(   -row => 3, -column => 0, -columnspan => 1);
	$back->grid(    -row => 4, -column => 0, -columnspan => 1, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub _buySoftware {
	my ($return, $host, $uid, $user) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $table, $descr, $back) = (
		$screen->Label(@H, -text => $host->{Name},      -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("ML_SWUpgrades"), -font => [ qw/Arial 8/ ], -justify => "left"),
		MyTable(
			$screen,
			@F,
			-rows       => 15,
			-columns    => 5,
			-scrollbars => "e",
			-fixedrows  => 1,
		),
		$screen->ROText(@E, -wrap => "word", -width => 68, -height => 7)
	);
	$table->put(0, $_->[0], $_->[1]) for([0, L("Filename")], [1, L("ML_SW_Name")], [3, L("ML_Costs")], [2, L("Size")], [4, L("ML_Buy")]);
	my $index = 0;
	foreach my $item (@{ $host->{SoftwareOrder} }) {
		my $buySub = sub {
			my $uO      = $rpc->call("recvObject", $host->{Records}{$user}{IP});
			my $memUsed = 0;
			$memUsed += $uO->{Files}{$_}{Gigaquods} for(keys %{ $uO->{Files} });
			if($memUsed + $host->{Software}{$item}{Gigaquods} <= $uO->{Memory}) {
				my $bu   = $rpc->call("recvObject", $uO->{Credits}[0]);
				my $bank = $bu->{Records}{$uO->{Credits}[1]};
				if($bank->{Credits} + $bank->{Loan} >= $host->{Software}{$item}{Credits}) {
					$uO->{Files}{$item} = { Gigaquods => $host->{Software}{$item}{Gigaquods}, Encrypted => 0 };
					$bu->{Records}{$uO->{Credits}[1]}{Credits} -= $host->{Software}{$item}{Credits};
					$rpc->call("storObject", $uO->{Credits}[0], $bu);
					$rpc->call("storObject", $host->{Records}{$user}{IP}, $uO);
				} else {
					MyMesg(L("ML_NeC_Title"), L("ML_NeC_Text"));
				}
			} else {
				MyMesg(L("ML_SW_NoMem_Title"), L("ML_SW_NoMem_Text"));
			}
		};
		my $showSub = sub {
			$descr->delete(qw/0.0 end/);
			$descr->insert("0.0", join "\n",
				"$item -- $host->{Software}{$item}{Name}",
				"",
				L("Status_Credits") . " " . L("Credits", $host->{Software}{$item}{Credits}),
				L("Size") . ": " .          L("GQs", $host->{Software}{$item}{Gigaquods}),
				"",
				$host->{Software}{$item}{Description});
		};
		$table->put(++$index, 0, BindLabel($table, $item, "left|<ButtonPress-1>", $showSub));
		$table->put($index,   1, BindLabel($table, $host->{Software}{$item}{Name}, "left|<ButtonPress-1>", $showSub));
		$table->put($index,   3, BindLabel($table, L("Credits", $host->{Software}{$item}{Credits}), "right|<ButtonPress-1>", $showSub));
		$table->put($index,   2, BindLabel($table, L("GQs", $host->{Software}{$item}{Gigaquods}), "right|<ButtonPress-1>", $showSub));
		$table->put($index,   4, BindLabel($table, L("ok"), "<ButtonPress-1>", $buySub));
	}
	$back = $screen->Button(@B, -text => L("back"), -command => $return);
	$title->grid(   -row => 0, -column => 0, -columnspan => 1, -sticky => "wn");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 1, -sticky => "wn");
	$table->grid(   -row => 2, -column => 0, -columnspan => 1, -sticky => "we");
	$descr->grid(   -row => 3, -column => 0, -columnspan => 1, -sticky => "we");
	$back->grid(    -row => 4, -column => 0, -columnspan => 1, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub getPowers {
	my ($hw, $word) = (shift, (shift) ? "Old" : "New");
	my $powers = "";
	for(keys %$hw) {
		if($_ eq "Memory") {
			$powers .= L("ML_Powers_${word}_Mem",   L("GQs", $hw->{Memory})) . "\n";
		} elsif($_ eq "Modem") {
			$powers .= L("ML_Powers_${word}_Modem", L("GQs/s", $hw->{Modem})) . "\n";
		} elsif($_ eq "CPU") {
			$powers .= L("ML_Powers_${word}_CPU",   L("GHz", $hw->{CPU})) . "\n";
		} elsif($_ eq "File") {
			$powers .= L("ML_Powers_${word}_File",  $hw->{File}) . "\n";
		}
	}
	return $powers;
}

sub _buyHardware {
	my ($return, $host, $uid, $user) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my $menu = new MyLinkMenu($screen);

	my $selectSub = sub {
		my ($rr, $hh, $ii) = @_;
		my $ss = $windows{Main}->Frame(@F);
		my ($title, $subtitle, $table, $descr, $bb) = (
			$ss->Label(@H, -text => $hh->{Name}, -font => [ qw/Arial 12/ ]),
			$ss->Label(@H, -text => L("ML_HWUpgrades"), -font => [ qw/Arial 8/ ], -justify => "left"),
			MyTable(
				$ss,
				@F,
				-rows       => 15,
				-columns    => 3,
				-scrollbars => "e",
				-fixedrows  => 1,
			),
			MyScrolled($ss, "ROText", @E, -wrap => "word", -width => 68, -scrollbars => "ose", -height => 7),
			$ss->Button(@B, -text => L("back"), -command => $rr)
		);
		$table->put(0, $_->[0], $_->[1]) for([0, L("ML_SW_Name")], [1, L("ML_Costs")], [2, L("ML_Buy")]);
		my $index = 0;
		warn "($ii)\n";
		foreach my $hw (sort { $hh->{Hardware}{$ii}{$a}{Credits} <=> $hh->{Hardware}{$ii}{$b}{Credits} } keys %{ $hh->{Hardware}{$ii} }) {
			my $showSub = sub {
				$descr->delete(qw/0.0 end/);
				$descr->insert("0.0", join "\n",
					$hw,
					"",
					L("Status_Credits") . " " . L("Credits", $hh->{Hardware}{$ii}{$hw}{Credits}),
					"",
					getPowers($hh->{Hardware}{$ii}{$hw}));
			};
			my $buySub = sub {
				my $uO    = $rpc->call("recvObject", $host->{Records}{$user}{IP});
				my $model = $host->{Gateways}{$uO->{Gateway}};
				my $want  = $hh->{Hardware}{$ii}{$hw};
				my $okG   = 1;
				my $memUsed = 0;
				$memUsed += $uO->{Files}{$_}{Gigaquods} for(keys %{ $uO->{Files} });
				$okG = 0 if(exists $want->{Memory} and $uO->{Memory} + $want->{Memory} > $model->{MaxCapacity});
				$okG = 0 if(exists $want->{Modem}  and $uO->{Modem}  + $want->{Modem}  > $model->{MaxModem});
				$okG = 0 if(exists $want->{CPU}    and $uO->{CPU}    + $want->{CPU}    > $model->{MaxCPU});
				$okG = 0 if(exists $want->{File}   and scalar(grep { /Motion_Sensor|Self_Destruct/ } keys %{ $uO->{Files} }) > $model->{MaxSecurity});
				$okG = 0 if(exists $want->{File}   and $memUsed + $want->{Gigaquods}   > $uO->{Memory});
				unless($okG) {
					MyMesg(L("ML_GW_ErrTitle"), L("ML_HW_NeS_Text"));
				} else {
					my $bu   = $rpc->call("recvObject", $uO->{Credits}[0]);
					my $bank = $bu->{Records}{$uO->{Credits}[1]};
					if($bank->{Credits} + $bank->{Loan} >= $want->{Credits}) {
						$bu->{Records}{$uO->{Credits}[1]}{Credits} -= $want->{Credits};
						my @actions;
						my $ok = {
							Mail => [
								$host->{Records}{$user}{IP},
								{
									Type    => "News",
									From    => "agents\@MyLink Corporation.net",
									Subject => L("ML_GW_Success_Subject"),
									Text    => L("ML_HW_Success_Text", $hw, $ii),
								}
							],
							Push => [ { $hw => { %{ $want }, Time => u2m(time) } }, $host->{Records}{$user}{IP}, "Buyed" ],
						};
						for(keys %$want) {
							if($_ eq "Memory") {
								push @actions, { "Add".scalar(@actions) => [ $want->{Memory}, $host->{Records}{$user}{IP}, "Memory" ] };
								push @actions, {
									"GWCheck".scalar(@actions) => [
										"Memory", 
										$host->{Records}{$user}{IP},
										$host->{Gateways}{$rpc->call("recvObject", $host->{Records}{$user}{IP})->{Gateway}},
										{
											Add        => [ -$want->{Memory}, $host->{Records}{$user}{IP}, "Memory" ],
											AddCredits => {
												bank   => $uO->{Credits}[0],
												acc    => $uO->{Credits}[1],
												from   => "agents\@MyLink Corporation.net",
												amount => $want->{Credits},
											},
											Mail       => [
												$host->{Records}{$user}{IP},
												{
													Type    => "News",
													From    => "agents\@MyLink Corporation.net",
													Subject => L("ML_HW_Fail_Subject"),
													Text    => L("ML_HW_Fail_Text", $hw, $ii),
												}
											],
										},
										$ok
									]
								};
							} elsif($_ eq "Modem") {
								push @actions, { "Add".scalar(@actions) => [ $want->{Modem}, $host->{Records}{$user}{IP}, "Modem" ] };
								push @actions, {
									"GWCheck".scalar(@actions) => [
										"Modem", 
										$host->{Records}{$user}{IP},
										$host->{Gateways}{$rpc->call("recvObject", $host->{Records}{$user}{IP})->{Gateway}},
										{
											Add        => [ -$want->{Modem}, $host->{Records}{$user}{IP}, "Modem" ],
											AddCredits => {
												bank   => $uO->{Credits}[0],
												acc    => $uO->{Credits}[1],
												from   => "agents\@MyLink Corporation.net",
												amount => $want->{Credits},
											},
											Mail       => [
												$host->{Records}{$user}{IP},
												{
													Type    => "News",
													From    => "agents\@MyLink Corporation.net",
													Subject => L("ML_HW_Fail_Subject"),
													Text    => L("ML_HW_Fail_Text", $hw, $ii),
												}
											],
										},
										$ok
									]
								};
							} elsif($_ eq "CPU") {
								push @actions, { "Add".scalar(@actions) => [ $want->{CPU}, $host->{Records}{$user}{IP}, "CPU" ] };
								push @actions, {
									"GWCheck".scalar(@actions) => [
										"CPU", 
										$host->{Records}{$user}{IP},
										$host->{Gateways}{$rpc->call("recvObject", $host->{Records}{$user}{IP})->{Gateway}},
										{
											Add        => [ -$want->{Memory}, $host->{Records}{$user}{IP}, "CPU" ],
											AddCredits => {
												bank   => $uO->{Credits}[0],
												acc    => $uO->{Credits}[1],
												from   => "agents\@MyLink Corporation.net",
												amount => $want->{Credits},
											},
											Mail       => [
												$host->{Records}{$user}{IP},
												{
													Type    => "News",
													From    => "agents\@MyLink Corporation.net",
													Subject => L("ML_HW_Fail_Subject"),
													Text    => L("ML_HW_Fail_Text", $hw, $ii),
												}
											],
										},
										$ok
									]
								};
							} elsif($_ eq "File") {
								push @actions, { "SetKey".scalar(@actions) => [ { Encrypted => 0, Gigaquods => $want->{Gigaquods} }, $host->{Records}{$user}{IP}, "Files", $want->{File} ] };
								push @actions, {
									"GWCheck".scalar(@actions) => [
										"Security", 
										$host->{Records}{$user}{IP},
										$host->{Gateways}{$rpc->call("recvObject", $host->{Records}{$user}{IP})->{Gateway}},
										{
											DelKey     => [ $host->{Records}{$user}{IP}, "Files", $want->{File} ],
											AddCredits => {
												bank   => $uO->{Credits}[0],
												acc    => $uO->{Credits}[1],
												from   => "agents\@MyLink Corporation.net",
												amount => $want->{Credits},
											},
											Mail       => [
												$host->{Records}{$user}{IP},
												{
													Type    => "News",
													From    => "agents\@MyLink Corporation.net",
													Subject => L("ML_HW_Fail_Subject"),
													Text    => L("ML_HW_Fail_Text", $hw, $ii),
												}
											],
										},
										$ok
									]
								};
							}
						}
						$rpc->call("storObject", $uO->{Credits}[0], $bu);
						$rpc->call("storObject", $host->{Records}{$user}{IP}, $uO);
						$rpc->call("storTimer", time + $D{NewHW1}, {
							Mail => [
								$host->{Records}{$user}{IP},
								{
									Type    => "News",
									From    => "agents\@MyLink Corporation.net",
									Subject => L("ML_HW_AddSent_Subject"),
									Text    => L("ML_HW_AddSent_Text", $hw, $ii),
								}
							]
						});
						$rpc->call("storTimer", time + $D{NewHW2}, $_) for(@actions);
					} else {
						MyMesg(L("ML_NeC_Title"), L("ML_NeC_Text"));
					}
				}
			};
			$table->put(++$index, 0, BindLabel($table, $hw, "left|<ButtonPress-1>", $showSub));
			$table->put($index,   1, BindLabel($table, L("Credits", $hh->{Hardware}{$ii}{$hw}{Credits}), "right|<ButtonPress-1>", $showSub));
			$table->put($index,   2, BindLabel($table, L("ok"), "<ButtonPress-1>", $buySub));
		};
		$title   ->grid(-row => 0, -column => 0, -sticky => "wn");
		$subtitle->grid(-row => 1, -column => 0, -sticky => "wn");
		$table   ->grid(-row => 2, -column => 0, -sticky => "we");
		$descr   ->grid(-row => 3, -column => 0);
		$bb      ->grid(-row => 4, -column => 0, -sticky => "we");
		$ss->pack;
		$windows{InMain}->packForget if($windows{InMain});
		$windows{InMain} = $ss;
	};
	my $removeSub;
	$removeSub = sub {
		my ($rr, $hh) = @_;
		my $ss = $windows{Main}->Frame(@F);
		my ($title, $subtitle, $table, $descr, $bb) = (
			$ss->Label(@H, -text => $hh->{Name},         -font => [ qw/Arial 12/ ]),
			$ss->Label(@H, -text => L("ML_HW_RemoveHW"), -font => [ qw/Arial 8/ ], -justify => "left"),
			MyTable(
				$ss,
				@F,
				-rows       => 15,
				-columns    => 4,
				-scrollbars => "e",
				-fixedrows  => 1,
			),
			MyScrolled($ss, "ROText", @E, -wrap => "word", -scrollbars => "ose", -width => 68, -height => 7),
			$ss->Button(@B, -text => L("back"), -command => $rr)
		);
		$table->put(0, $_->[0], $_->[1]) for([0, L("Timestamp")], [1, L("ML_SW_Name")], [2, L("ML_HW_BuyedFor")], [3, " "]);
		my $index = 0;
		my $uO = $rpc->call("recvObject", $host->{Records}{$user}{IP});
		foreach my $hw (@{ $uO->{Buyed} }) {
			my $key = (keys %$hw)[0];
			my $showSub = sub {
				$descr->delete(qw/0.0 end/);
				$descr->insert("0.0", join "\n",
					$key,
					"",
					L("ML_HW_BuyedFor") . ": " . L(Credits => $hw->{$key}{Credits}),
					L("Mail_Time")      .  " " . m2m($hw->{$key}{Time}),
					"",
					getPowers($hw->{$key}, 1));
			};
			my $remSub = sub {
				my $csum = chkSum($hw);
				$uO = update($uO, $host->{Records}{$user}{IP});
				my ($want, @actions) = ($hw->{$key});
				my $GQsUsed = 0;
				$GQsUsed += $uO->{Files}{$_}{Gigaquods} for(keys %{ $uO->{Files} });
				if(exists $want->{Memory} and $GQsUsed > $uO->{Memory} - $want->{Memory}) {
					MyMesg(L("ML_HW_Busy_Title"), L("ML_HW_Busy_Text"));
				} else {
					$uO->{Buyed} = [ grep { chkSum($_) ne $csum } @{ $uO->{Buyed} } ];
					$rpc->call("storObject", $host->{Records}{$user}{IP}, $uO);
					for(keys %{ $hw->{$key} }) {
						if($_ eq "Memory") {
							push @actions, { "Add".scalar(@actions) => [ -$want->{Memory}, $host->{Records}{$user}{IP}, "Memory" ] };
						} elsif($_ eq "Modem") {
							push @actions, { "Add".scalar(@actions) => [ -$want->{Modem}, $host->{Records}{$user}{IP}, "Modem" ] };
						} elsif($_ eq "CPU") {
							push @actions, { "Add".scalar(@actions) => [ -$want->{CPU}, $host->{Records}{$user}{IP}, "CPU" ] };
						} elsif($_ eq "File") {
							push @actions, { "DelKey".scalar(@actions) => [ $host->{Records}{$user}{IP}, "Files", $want->{File} ] };
						}
					}
					$rpc->call("storTimer", time + $D{NewHW1}, {
						Mail => [
							$host->{Records}{$user}{IP},
							{
								Type    => "News",
								From    => "agents\@MyLink Corporation.net",
								Subject => L("ML_HW_DelSent_Subject"),
								Text    => L("ML_HW_DelSent_Text", $key),
							}
						]
					});
					$rpc->call("storTimer", time + $D{NewHW2}, {
						Mail => [
							$host->{Records}{$user}{IP},
							{
								Type    => "News",
								From    => "agents\@MyLink Corporation.net",
								Subject => L("ML_HW_FinDel_Subject"),
								Text    => L("ML_HW_FinDel_Text", $key),
							}
						]
					});
					$rpc->call("storTimer", time + $D{NewHW2}, $_) for(@actions);
					$removeSub->($rr, $hh);
				}
			};
			$table->put(++$index, 0, BindLabel($table, m2m($hw->{$key}{Time}),  "left|<ButtonPress-1>", $showSub));
			$table->put($index,   1, BindLabel($table, $key,                    "left|<ButtonPress-1>", $showSub));
			$table->put($index,   2, BindLabel($table, L("Credits", $hw->{$key}{Credits}), "left|<ButtonPress-1>", $showSub));
			$table->put($index,   3, BindLabel($table, L("del"),                   "<ButtonPress-1>",      $remSub));
		};
		$title   ->grid(-row => 0, -column => 0, -sticky => "wn");
		$subtitle->grid(-row => 1, -column => 0, -sticky => "wn");
		$table   ->grid(-row => 2, -column => 0, -sticky => "we");
		$descr   ->grid(-row => 3, -column => 0);
		$bb      ->grid(-row => 4, -column => 0, -sticky => "we");
		$ss->pack;
		$windows{InMain}->packForget if($windows{InMain});
		$windows{InMain} = $ss;
	};

	$menu->addItem(1, "Title"    => $host->{Name});
	$menu->addItem(1, "Subtitle" => L("ML_HWUpgrades"));

	warn "--:\n";
	warn Dumper($host->{Hardware});
	foreach my $item (sort { lc($a) cmp lc($b) } keys %{ $host->{Hardware} }) {
		warn ">>$item\n";
		$menu->addItem(1, $item, sub{ $selectSub->(sub{ _buyHardware($return, $host, $uid, $user) }, $host, $item) });
	}
	$menu->addItem(1, L("ML_HW_PrevInstalled"), sub { $removeSub->(sub{ _buyHardware($return, $host, $uid, $user) }, $host) });
	
	my $back = $screen->Button(@B, -text => L("back"), -command => $return);
	$menu->grid(-row => 0, -column => 0);
	$back->grid(-row => 1, -column => 0, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

1;
