#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, @T);

sub handleN {
	my ($uid, $host) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my $menu = new MyLinkMenu($screen);
	$menu->addItem(1, "Title"        => $host->{Name});
	$menu->addItem(1, "Subtitle"     => L("MainMenu"));
	$menu->addItem(1, "Browse"       => sub {
		_viewLinks(
			sub{ handleN($uid, $host) },
			$host,
			$uid,
			"nobody"
		)
	});
	$menu->addItem(1, L("AdminMenu") => sub {
		logInScreen($uid, $host, "admin", sub {
			playSound("login");
			_admin(
				sub{ handleN($uid, $host) },
				$host,
				$uid,
				"admin",
				qw/Logs/,
			)
		})
	});
	$menu->pack;
#	SHOW($screen, "InMain");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub logInScreen {
	my ($uid, $host, $user, $callback) = (shift, shift);
	if(ref($_[0]) eq "CODE") {
		($user, $callback) = ("", shift);
	} else {
		($user, $callback) = @_;
	};
	my $screen = $windows{Main}->Frame(@F);
	my $loginFrame = $screen->Frame(@F, -width => 300, -height => 300);
	$windows{PassEntry} = "";
	$windows{UserEntry} = $user;
	my ($helloMsg, $logonMsg, $enterUser, $enterPass, $userEntry, $passEntry) = (
		$loginFrame->Label(@H, -text => "$host->{Name}", -justify => "left", -font => [ qw/Arial 12/ ]),
		$loginFrame->Label(@H, -text => L("LIS_Logon"), -justify => "left", -font => [ qw/Arial 8/ ]),
		$loginFrame->Label(@L, -text => L("Username"), justify => "right", -anchor => "e"),
		$loginFrame->Label(@L, -text => L("Password"), justify => "right", -anchor => "e"),
		MyLinkPopup($loginFrame->Entry(@E, -textvariable => \$windows{UserEntry}),
								sub { "password://$uid" }),
		MyLinkPopup($loginFrame->Entry(@E, -textvariable => \$windows{PassEntry}, -show => "*"),
								sub { "password://$uid" }),
	);

	$windows{I_ok} = undef;
	$windows{I_ok} = $loginFrame->Button(@B, -text => L("LIS_Login"), -command => sub {
		$host = update($host, $uid);
		warn Dumper({h => $host, u => $windows{UserEntry}, p => $windows{PassEntry}});
		if(exists $host->{Records}{$windows{UserEntry}} and
			 $host->{Records}{$windows{UserEntry}}{Password} eq $windows{PassEntry}) {
			$host->{Logs}{u2m(time)} = "Logged in as $windows{UserEntry}";
			$rpc->call("storObject", $uid, $host);
			$uObject = update($uObject, $uIP);
			$uObject->{Wallet}{$uid}{$windows{UserEntry}} = $windows{PassEntry};
			$rpc->call("storObject", $uIP, $uObject);
			triggerTrace() if($host->{Records}{$windows{UserEntry}}{Level} == 0);
			$callback->();
		} else {
			playSound("zap");
			$windows{I_ok}->configure(-text => L("InvalidUserPass"), -state => "disabled");
			$screen->after(2000, sub { $windows{I_ok}->configure(
				-state => "active",
				-text  => L("LIS_Login"),
			) });
		}
	});
	$helloMsg->grid( -row => 0, -column => 0, -columnspan => 2, -sticky => "wn");
	$logonMsg->grid( -row => 1, -column => 0, -columnspan => 2, -sticky => "wn");
	$enterUser->grid(-row => 2, -column => 0,                   -sticky => "e");
	$userEntry->grid(-row => 2, -column => 1);
	$enterPass->grid(-row => 3, -column => 0,                   -sticky => "e");
	$passEntry->grid(-row => 3, -column => 1);
	$windows{I_ok}->grid(-row => 4, -column => 0, -columnspan => 2);
	$loginFrame->pack;
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

1;
