#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H);

sub handleAT {
	my ($uid, $host, $msg) = @_;
	$msg ||= L("AccessTerminal_Forbidden");
	my $screen = $windows{Main}->Frame(@F);
	my $title  = $screen->Label(@H, -text => $host->{Name}, -font => [qw/ Arial 12 /]);
	my $mesg   = $screen->Label(@L, -text => $msg);
	my $ok     = BindLabel($screen, L("ok"), "<ButtonPress-1>", sub { disConnect() });
	$title->grid(-row => 0, -column => 0, -sticky => "nw");
	$mesg ->grid(-row => 1, -column => 0, -sticky => "we");
	$ok   ->grid(-row => 2, -column => 0, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub handlePC { handleAT(@_, L("PersonalComputer_Forbidden")) }

1;
