#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, @S, @W, %D);

sub enCrypter {
	my ($level, $w, $x, $y, $uri) = @_;
	$uObject = update($uObject, $uIP);
	my ($allowed, $uid, $file) = (1);
	if($uri =~ /^local:\/\/(.+)$/) {
		($uid, $file) = ($uIP, $1);
	} elsif($uri =~ /^remote:\/\/(.*?)@(.*?)\/(.*)$/) {
		($uid, $file) = ($2, $3);
		$allowed = 0
			if($rpc->call("recvObject", $uid)->{Records}{$1}{Level} > 1);
	}
	if(not $allowed) {
		MyMesg(L("PermDenied"), L("Err_SecLevelMod"));
	} else {
		my $hisHost = $rpc->call("recvObject", $uid);
		return unless(waterWallCheck($uid, $hisHost));
		if($hisHost->{Files}{$file}{Encrypted}) {
			MyMesg(L("Programs_FileAlreadyEncrypted_Title"), L("Programs_FileAlreadyEncrypted_Text", $file));
		} else {
			$uObject = update($uObject, $uIP);
			progressSecs($x, $y, $hisHost->{Files}{$file}{Gigaquods} * 1000 /
													 $uObject->{Modem});
			$hisHost->{Files}{$file}{Encrypted} = $level;
			$rpc->call("storObject", $uid, $hisHost);
		}
	}
}

sub deCrypter {
	my ($level, $w, $x, $y, $uri) = @_;
	$uObject = update($uObject, $uIP);
	my ($allowed, $uid, $file) = (1);
	if($uri =~ /^local:\/\/(.+)$/) {
		($uid, $file) = ($uIP, $1);
	} elsif($uri =~ /^remote:\/\/(.*?)@(.*?)\/(.*)$/) {
		($uid, $file) = ($2, $3);
		$allowed = 0
			if($rpc->call("recvObject", $uid)->{Records}{$1}{Level} > 1);
	}
	if(not $allowed) {
		MyMesg(L("PermDenied"), L("Err_SecLevelMod"));
	} else {
		my $hisHost = $rpc->call("recvObject", $uid);
		return unless(waterWallCheck($uid, $hisHost));
		if($hisHost->{Files}{$file}{Encrypted} > $level) {
			MyMesg(L("Programs_TooOldDecrypter_Title"), L("Programs_TooOldDecrypter_Title", $hisHost->{Files}{$file}{Encrypted}));
		} elsif(not $hisHost->{Files}{$file}{Encrypted}) {
			MyMesg(L("Programs_FileAlreadyDecrypted_Title"), L("Programs_FileAlreadyDecrypted_Text", $file));
		} else {
			$uObject = update($uObject, $uIP);
			progressSecs($x, $y, $hisHost->{Files}{$file}{Gigaquods} * 1000 /
													 $uObject->{Modem});
			$hisHost->{Files}{$file}{Encrypted} = 0;
			$rpc->call("storObject", $uid, $hisHost);
		}
	}
}

sub fileDeleter {
	my ($w, $x, $y, $uri) = @_;
	$uObject = update($uObject, $uIP);
	if($uri =~ /^local:\/\/(.+)$/) {
		progressSecs($x, $y, $uObject->{Files}{$1}{Gigaquods} * 1000 /
												 $uObject->{Modem});
		delete $uObject->{Files}{$1};
		$rpc->call("storObject", $uIP, $uObject);
	} elsif($uri =~ /^remote:\/\/(.*?)@(.*?)\/(.*)$/) {
		my ($user, $host, $file) = ($1, $2, $3);
		my $obj = $rpc->call("recvObject", $host);
		return unless(waterWallCheck($host, $obj));
		if($obj->{Records}{$user}{Level} <= 1) {
			progressSecs($x, $y, $obj->{Files}{$file}{Gigaquods} * 1000 /
													 $uObject->{Modem});
			delete $obj->{Files}{$file};
			$rpc->call("storObject", $host, $obj);
		} else {
			MyMesg(L("PermDenied"), L("Err_SecLevelDel"));
		}
	}
}

sub fileCopier {
	my ($w, $x, $y, $source) = @_;
	my $GQs;
	$uObject  = update($uObject, $uIP);
	if($source =~ /^remote:\/\/(.*?)@(.*?)\/(.*)$/) {
		my $rhost = $rpc->call("recvObject", $2);
		$GQs      = $rhost->{Files}{$3}{Gigaquods};
	} elsif($source =~ /^local:\/\/(.+)$/) {
		$GQs      = $uObject->{Files}{$1}{Gigaquods};
	} else {
		return;
	}
	progressSecs($x, $y, $GQs * 1000 /
											 $uObject->{Modem}, "Select destination");
	push @{ $windows{NextClick} }, sub {
		my ($ww, $xx, $yy, $destination) = @_;
		$uObject = update($uObject, $uIP);
		warn "source:<<$source>>, destination:<<$destination>>\n";
		if($destination =~ /^local:\/\//) {
			if($source =~ /^remote:\/\/(.*?)@(.*?)\/(.*)$/) {
				print ">>inside<<.\n";
				my $memUsed = 0; $memUsed += $uObject->{Files}{$_}{Gigaquods} for(keys %{ $uObject->{Files} });
				my $sourceHost = $rpc->call("recvObject", $2);
				my $sourceMem = $sourceHost->{Files}{$3}{Gigaquods};
				if(exists $sourceHost->{Files}{$3} and $memUsed + $sourceMem <= $uObject->{Memory}) {
					$uObject->{Files}{$3} = $sourceHost->{Files}{$3};
					print "stored: ". Dumper($uObject);
					$rpc->call("storObject", $uIP, $uObject);
				} else {
					MyMesg(L("Programs_MemoryFull_Title"), L("Programs_MemoryFull_Text"));
				}
			}
		} elsif($destination =~ /^remote:\/\/(.*?)@(.*?)\/(.*)$/) {
			my ($user, $uid, $name) = ($1, $2, $3);
			if($source =~ /^local:\/\/(.+)$/) {
				print ">>inside<<.\n";
				my $sname = $1;
				my $obj = $rpc->call("recvObject", $uid);
				return unless(waterWallCheck($uid, $obj));
				if($obj->{Records}{$user}{Level} <= 1) {
					my $memUsed = 0; $memUsed += $obj->{Files}{$_}{Gigaquods} for(keys %{ $obj->{Files} });
					my $sourceMem = $uObject->{Files}{$sname}{Gigaquods};
					if(exists $uObject->{Files}{$sname} and $memUsed + $sourceMem <= (exists $obj->{Capacity} ?  $obj->{Capacity} : $obj->{Memory})) {
						$obj->{Files}{$sname} = $uObject->{Files}{$sname};
						print "stored: ". Dumper($obj);
						$rpc->call("storObject", $uid, $obj);
					} else {
						MyMesg(L("Programs_MemoryFull_Title"), L("Programs_MemoryFull_Text"));
					}
				} else {
					MyMesg(L("PermDenied"), L("Err_SecLevelNew"));
				}
			}
		}
	};
}

sub dictHax0r {
	my ($w, $x, $y, $uri) = @_;
	""   =~ /()()/;
	$uri =~ /password:\/\/(.+?)$/;
	return unless($1);
	my $uid = $1;
	my $host = $rpc->call("recvObject", $uid);
	$windows{UserEntry} ||= (grep { $host->{Records}{$_}{Level} == 0 } keys %{ $host->{Records} })[0];
	my $user = $windows{UserEntry};
	if(not exists $host->{Records}{$user}) {
		MyMesg(L("Bank_RemoteAccNotFound_Title"), L("Bank_RemoteAccNotFound_Text", $user, $uid));
	} else {
		triggerTrace();
		my $progressWindow = $windows{Top}->Toplevel(@F);
		$progressWindow->geometry("+$x+$y");
		$progressWindow->overrideredirect(1);
		my $pW = $progressWindow->Frame(@W);
		my $trying = $pW->Scrolled("ROText", -scrollbars => "e", -width => 13, -height => 10, @E);
		if(exists $windows{DictHackerData}) {
			# nix
		} else {
			$windows{DictHackerData} = [ split " ", <MyLinkWordlist::DATA> ];
		}
		$trying->insert("0.0", join "\n", @{ $windows{DictHackerData} });
		$uObject      = update($uObject, $uIP);
		my $delay     = 3 / $uObject->{Modem};
		my $index     = 0;
		my $scrollSub;
		$scrollSub   = sub {
			$progressWindow->destroy unless($windows{ConnectedTo});
			if($windows{DictHackerData}->[$index] eq $host->{Records}{$user}{Password}) {
				$windows{PassEntry} = $host->{Records}{$user}{Password};
				$progressWindow->after(1000, sub { $progressWindow->destroy });
			} else {
				if($index == @{ $windows{DictHackerData} }) {
					$progressWindow->after(1000, sub { $progressWindow->destroy });
				} else {
					$progressWindow->after($delay, $scrollSub);
				}
			}
			$trying->yviewScroll(+1, "units");
			$index++;
		};
		$progressWindow->after($delay, $scrollSub);
		$_->pack for($trying, $pW);
	}
}

sub passBreaker {
	my ($w, $x, $y, $uri) = @_;
	""   =~ /()()/;
	$uri =~ /password:\/\/(.+?)$/;
	return unless($1);
	my $uid = $1;
	my $host = $rpc->call("recvObject", $uid);
	$windows{UserEntry} ||= (sort { $host->{Records}{$a}{Level} <=> $host->{Records}{$b}{Level} } keys %{ $host->{Records} })[0];
	my $user = $windows{UserEntry};
	if(not exists $host->{Records}{$user}) {
		MyMesg(L("Bank_RemoteAccNotFound_Title"), L("Bank_RemoteAccNotFound_Text", $user, $uid));
	} else {
		triggerTrace();
		newNews("BREAKATTEMPT", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
		my $progressWindow = $windows{Top}->Toplevel(@F);
		$progressWindow->geometry("+$x+$y");
		$progressWindow->overrideredirect(1);
		my $pW = $progressWindow->Frame(@W);
		my (@poss, @chars) = ("a" .. "z", "-");
		push @chars, splice @poss, int rand @poss, 1 for(1 .. length($host->{Records}{$user}{Password}));
		my @labels;
		push @labels, $pW->Label(@L, -foreground => "lightblue", -font => [ qw/Courier 8/ ], -textvariable => \$chars[$_])
			for(0 .. (length($host->{Records}{$user}{Password}) - 1));
		$_->bind("<ButtonPress-1>", sub { $progressWindow->destroy }) for(@labels);
		$labels[$_]->grid(-row => 0, -column => $_) for(0 .. $#labels);
		$uObject = update($uObject, $uIP);
		my $every = 100 * 200 / daempf($uObject->{CPU});
		my $aktSub;
		my $okindex = 0;
		my $okSchon = 0;
		$aktSub = sub {
			unless($windows{ConnectedTo}) {
				$progressWindow->destroy;
				return;
			}
			for(my $i = $okindex + 1; $i < @chars; $i++) {
				$chars[$i] = ("a" .. "z", "-")[int rand 27];
			}
			if($okSchon == ((exists $host->{Firewalled} and $host->{Firewalled} >= 3) ? 10000000 : 10)) {
				$chars[$okindex] = substr($host->{Records}{$user}{Password}, $okindex, 1);
				playSound("done");
				$labels[$okindex]->configure(-foreground => "white");
				$okindex++;
				$okSchon = 0;
			} else {
				my @pChars = grep { $_ ne substr($host->{Records}{$user}{Password}, $okindex, 1) } ("a" .. "z", "-");
				$chars[$okindex] = splice @pChars, int rand @pChars, 1;
				$okSchon++;
			}
			if($okindex == length($host->{Records}{$user}{Password})) {
				$progressWindow->after(500, sub {
					$progressWindow->destroy;
					$windows{PassEntry} = $host->{Records}{$user}{Password};
				});
			} else {
				$progressWindow->after($every, $aktSub);
			}
		};
		$progressWindow->after($every, $aktSub);
		$pW->pack;
	}
}

sub progressSecs {
	my ($x, $y, $msecs, $after) = @_;
	my $w = $windows{Top}->Toplevel(@F);
	$w->geometry("+$x+$y");
	$w->overrideredirect(1);
	my $state    = 0;
	my $progress = $w->Scale(-length       => 140,
													 -sliderlength => 20,
													 -orient       => q{horizontal},
													 -showvalue    => 0,
													 -from         => 0,
													 -to           => $msecs,
													 -state        => "disabled",
													 -variable     => \$state,
													 @S);
	my $die = 0;
	$progress->pack;
	my $aSub;
	$aSub = sub {
		$state += 100;
		if($state >= $msecs) {
			unless(defined $after) {
				$die = 1;
			} elsif(not $die) {
				$progress->packForget;
				my $frame = $w->Frame(@W);
				my $label = $frame->Label(@L, -text => $after);
				$label->pack;
				$frame->pack;
				$die = 1;
			}
		} else {
			$w->after(100, $aSub);
		}
	};
	$w->after(100, $aSub);
	$w->waitVariable(\$die);
	if(defined $after) {
		push @{ $windows{NextClick} }, sub { $w->destroy };
	} else {
		$w->destroy;
	}
}

sub traceTracker {
	my ($sS, $w, $x, $y, $uri) = @_;
	my $window = $windows{Top}->Toplevel(@F);
	$windows{Top}->geometry =~ /.*?\+([^+]+)\+(.*)$/;
	$window->geometry("+$1+$2");
	$window->overrideredirect(1);
	my $W     = $window->Frame(@W);
	my $label = $W     ->Label(@L, -text => L("Programs_TT_Detecting"));
	$label->bind("<ButtonPress-1>", sub { $window->destroy });
	$_->pack for($label, $W);
	my $oATHD;
	my $updateSub;
	$updateSub = sub {
		if($windows{ConnectedTo} and $windows{ActiveTraceTimeLeft}) {
			if($sS) {
				$label->configure(-text => L("Programs_TT_Remaining", L("s", $windows{ActiveTraceTimeLeft})));
			} else {
				$label->configure(-text => L("Programs_TT_PerCent", sprintf("%.0f", 100 - $windows{ActiveTraceTimeLeft} / $windows{ActiveTraceTimeTotal} * 100) . "%"))
					if(int rand 6 == 0);
			}
			playSound("tracebleep") unless(defined $oATHD);
			$oATHD ||= 0;
			if($windows{ActiveTraceHopsDone} > $oATHD) {
				$oATHD++;
				playSound("tracebleep");
			}
		} else {
			$label->configure(-text => L("Programs_TT_NoTraces"));
			undef $oATHD;
			undef $windows{ActiveTraceTimeLeft};
		}
		$window->after(500, $updateSub);
	};
	$window->after(500, $updateSub);
}

sub ipLookup {
	my ($w, $x, $y, $uri) = @_;
	my $window = $windows{Top}->Toplevel(@F, -title => "IP Lookup");
	$window->geometry("+$x+$y");
	my $ip    = L("Programs_IP_Enter");
	my $entry = $window->Entry(@E, -textvariable => \$ip);
	my $probe = BindLabel($window, L("Programs_IP_Lookup"), "<ButtonPress-1>", sub {
		my $rhost = $rpc->call("recvObject", $ip);
		if($rhost eq "ERROR") {
			$ip = L("ErrIPNotFound");
		} else {
			$uObject = update($uObject, $uIP);
			$uObject->{Links}{$ip} = 1;
			$rpc->call("storObject", $uIP, $uObject);
			$ip      = $rhost->{Name};
			listLinks() unless($windows{ConnectedTo} or $windows{MapOldInMain});
		}
	});
	$entry->grid(-row => 0, -column => 0);
	$probe->grid(-row => 0, -column => 1);
	FFF($entry);
	$entry->bind("<FocusIn>", sub { $ip = "" if($ip eq L("Programs_IP_Enter")) });
}

sub logDeleter {
	my ($w, $x, $y, $uri, $secure) = @_;
	"" =~ /()()/;
	$uri =~ /^log:\/\/([^\/]+)\/(.+)$/;
	return unless($1);
	my ($uid, $key) = ($1, $2);
	progressSecs($x, $y, (1000 + ($secure eq "secure" ? 500 : 0)) / $uObject->{Modem});
	my $host = $rpc->call("recvObject", $uid);
	if($secure eq "secure") {
		delete $host->{Logs}{$key};
	} else {
		$host->{Logs}{$key} = "(deleted)$host->{Logs}{$key}";
	}
	$rpc->call("storObject", $uid, $host);
}

sub logUnDeleter {
	my ($w, $x, $y, $uri, $secure) = @_;
	"" =~ /()()/;
	$uri =~ /^log:\/\/([^\/]+)\/(.+)$/;
	return unless($1);
	progressSecs($x, $y, 100 * 3000 / $uObject->{Modem} / $uObject->{CPU});
	my ($uid, $key) = ($1, $2);
	my $host = $rpc->call("recvObject", $uid);
	if($host->{Logs}{$key} =~ /^\(deleted\)(.+)$/) {
		$host->{Logs}{$key} = $1;
	}
	$rpc->call("storObject", $uid, $host);
}

sub logModifier {
	my ($cN, $w, $x, $y, $uri) = @_;
	"" =~ /()()/;
	$uri =~ /^log:\/\/([^\/]+)\/(.+)$/;
	return unless($1);
	my ($uid, $key) = ($1, $2);
	my $window = $windows{Top}->Toplevel(@F, -title => "Log Modifier"); $window->geometry("+$x+$y");
	my $host   = $rpc->call("recvObject", $uid);
	my $log    = $host->{Logs}{$key};
	$log       = "(deleted)" if($log =~ /^\(deleted\)/);
	my $entry  = $window->Entry(@E, -width => 40, -textvariable => \$log);
	my $newTS  = $window->Entry(@E, -width => 10, -textvariable => \my $newTime);
	my $newTX  = $window->Entry(@E, -width => 30, -textvariable => \my $newMesg);
	my $create = BindLabel($window, "New",    "<ButtonPress-1>", sub {
		return unless($cN);
		$entry->gridForget;
		$newTime = m2m("YYYYmmddHHMMSS");
		$newMesg = L("Programs_LM_New");
		$newTS->grid(-row => 0, -column => 1);
		$newTX->grid(-row => 0, -column => 2);
		$cN = 2;
	});
	$create->configure(-foreground => "grey") unless($cN);
	my $commit = BindLabel($window, L("CommitChanges"), "<ButtonPress-1>", sub {
		progressSecs($x, $y, 100 * ($cN < 2 ? 3000 : 5000) / $uObject->{Modem} / $uObject->{CPU});
		$host = update($host, $uid);
		if($cN < 2) {
			$host->{Logs}{$key} = $log;
		} elsif($cN == 2) {
			$host->{Logs}{m2u($newTime)} = $newMesg;
		}
		$rpc->call("storObject", $uid, $host);
		$window->destroy;
	});
	$create->grid(-row => 0, -column => 0, -columnspan => 1);
	$entry ->grid(-row => 0, -column => 1, -columnspan => 2);
	$commit->grid(-row => 0, -column => 3, -columnspan => 1);
	$window->waitWindow;
}

sub voiceAnalyzer {
	my ($w, $x, $y, $uri) = @_;
	my $window = $windows{Top}->Toplevel(@F, -title => "Voice Analyzer"); $window->geometry("+$x+$y");
	my ($statusLine, $status, $record, $play, $recordEd) = (L("Programs_V_RecordingReady"));
	($status, $record, $play) = (
		$window->Label(@L,  -width => 27,  -textvariable => \$statusLine),
		$window->Button(@B, -state => "disabled", -foreground => "red", -text => "o", -command => sub {
			if(not defined $windows{ConnectedTo} or
				$rpc->call("recvObject", $windows{ConnectedTo})->{Type} ne "V") {
				$record->configure(-state => "active");
				$play  ->configure(-state => "disabled");
				$statusLine = L("Programs_V_NoVConnection");
			} else {
				$_->configure(-state => "disabled") for($record, $play);
				$recordEd = $windows{ConnectedTo};
				$statusLine = L("Programs_V_Recording");
				$record->configure(-state => "disabled");
				$window->after(6000, sub {
					$statusLine = L("Programs_V_Analyzing");
					$window->after(6000, sub {
						$statusLine = L("Programs_V_ReproducingReady");
						$play->configure(-state => "active");
					});
				});
			}
		}),
		$window->Button(@B, -foreground => "green", -text => ">", -state => "disabled", -command => sub {
			$_->configure(-state => "disabled") for($record, $play);
			$statusLine = L("Programs_V_Reproducing");
			my $hisID = 0;
			$hisID   += ord($_) * ord($_) for(split "", C($recordEd));
			triggerTrace() if(defined $windows{ConnectedTo} and $rpc->call("recvObject", $windows{ConnectedTo})->{Type} ne "V");
			playSound("analyser/verifyme" . ($hisID % 4 + 1));
			$window->after(9000, sub {
				$windows{VoiceIPC} = $recordEd;
				$_->configure(-state => "active") for($record, $play);
				$statusLine = L("Programs_V_RecAndRepReady");
			});
		}),
	);
	$window->repeat(500, sub {
		if(defined $windows{VoiceOkGiven} and $windows{VoiceOkGiven}) {
			$record->configure(-state => "active");
		} elsif(defined $windows{VoiceOkGiven} and not $windows{VoiceOkGiven}) {
			$statusLine = L("Programs_V_Analyzing") if($statusLine eq L("Programs_V_Recording"));
			$record->configure(-state => "disabled");
		}
	});
	$status->grid(-row => 0, -column => 0);
	$record->grid(-row => 0, -column => 1);
	$play  ->grid(-row => 0, -column => 2);
}

sub deCypher {
	my ($w, $x, $y, $uri) = @_;
	"" =~ /()()/;
	$uri =~ /^elliptic:\/\/(.+)$/;
	return unless($1);
	my $uid    = $1;
	my $host   = $rpc->call("recvObject", $uid);
	$uObject   = update($uObject, $uIP);
	my $shouldTake = ($host->{EllipticStrength} || 1) *
									 $windows{EllipticTotal} /
									 5 *
									 (60000 / daempf($uObject->{CPU}));
	warn "$shouldTake\n$uObject->{CPU}\n$windows{EllipticTotal}\n";
	triggerTrace();
	$windows{EllipticIPC} = 60000 / daempf($uObject->{CPU});
	progressSecs($x, $y, $shouldTake + 1000);
}

sub daempf {
	my $GHz = shift;
	$GHz   /= 1.3 if($GHz > 100);
	$GHz   /= 1.5 if($GHz > 200);
	$GHz   /= 1.7 if($GHz > 300);
	return $GHz;
}

sub recordExtor {
	my ($w, $x, $y, $uri) = @_;
	if($uri =~ /^records:\/\/(.*)$/) {
		my $uid  = $1;
		my $host = $rpc->call("recvObject", $uid);
		progressSecs($x, $y, 500 * scalar keys %{ $host->{Records} });
		$uObject = update($uObject, $uIP);
		$uObject->{Wallet}{$uid} = { map { $_ => $host->{Records}{$_}{Password} } keys %{ $host->{Records} } };
		$rpc->call("storObject", $uIP, $uObject);
	} elsif($uri =~ /^wallet:\/\/(.*)$/) {
		my $uid  = $1;
		my $host = $rpc->call("recvObject", $uid);
		progressSecs($x, $y, 500 * scalar keys %{ $host->{Wallet} });
		$uObject = update($uObject, $uIP);
		$uObject->{Wallet}{$_} = $host->{Wallet}{$_} for(keys %{ $host->{Wallet} });
		$rpc->call("storObject", $uIP, $uObject);
	}
}

sub recordCrator {
	my ($w, $x, $y, $uri) = @_;
	if($uri =~ /^records:\/\/(.*)$/) {
		$uObject = update($uObject, $uIP);
		my $uid  = $1;
		my $window = $windows{Top}->Toplevel(@F, -title => "Record Creator");
		$window->geometry("+$x+$y");
		my ($username, $password, $level, $voice) = map { substr(L($_), 0, -1) } qw/Username Password SecurityLevel VoiceAuth/;
		my $idx  = 0;
		my $host = $rpc->call("recvObject", $uid);
		$window->Entry(@E, -textvariable => \$_, -width => 8)->grid(-row => 0, -column => $idx++)
			for($username, $password, $level, $host->{Type} =~ /^(C|B)$/ ? ($voice) : ());
		BindLabel($window, L("Programs_R_Create"), "<ButtonPress-1>", sub {
			progressSecs($x, $y, 1000 / $uObject->{Modem});
			$host = update($host, $uid);
			$host->{Records}{$username} = {
				Password => $password,
				Level    => $level,
				$host->{Type} =~ /^(C|B)$/
					? (Voice => $voice)
					: ()
			};
			$rpc->call("storObject", $uid, $host);
			$uObject = update($uObject, $uIP);
			$uObject->{Wallet}{$uid}{$username} = $password;
			$rpc->call("storObject", $uIP, $uObject);
			$window->destroy;
		})->grid(-row => 0, -column => $idx);
	}
}

sub fireWall {
	my ($level, $w, $x, $y, $uri) = @_;
	$uObject = update($uObject, $uIP);
	$uObject->{Firewalled} = $level;
	$rpc->call("storObject", $uIP, $uObject);
	my $window = $windows{Top}->Toplevel(@F, -title => "Firewall v$level");
	$window->geometry("+$x+$y");
	my $label  = $window->Label(@L, -width => 30, -text => L("Programs_F_Started"));
	my $exitSub = sub {
		$uObject = update($uObject, $uIP);
		$uObject->{Firewalled} = 0;
		$rpc->call("storObject", $uIP, $uObject);
	};
	$label->bind("<ButtonPress-1>", $exitSub);
	$label->bind("<Destroy>",       $exitSub);
	$label->pack;
	my $OldUn = undef;
	$window->repeat(1000, sub {
		$uObject = update($uObject, $uIP);
		my $Un = $uObject->{UnAuthAccess} || undef;
		if(
			not (not defined $OldUn and not defined $Un) and
			(
				(not defined $OldUn and defined $Un) or
				(defined $OldUn and not defined $Un) or
				($OldUn ne $Un)
			)
		) {
			$window->after(300, sub { playSound("zap") });
			$window->after(500, sub { playSound("zap") });
			$window->after(700, sub { playSound("zap") });
			$window->after(900, sub { playSound("zap") });
			if(defined $Un) {
				$label->configure(-text => L("Programs_F_UnAuthBy", $Un));
			} else {
				$label->configure(-text => L("Programs_F_UnAuthEnd"));
			}
		}
		$OldUn = $Un;
	}) if($level >= 2);
}

sub AVKit {
	my ($type, $w, $x, $y, $uri) = @_;
	progressSecs(9000);
	$uObject = update($uObject, $uIP);
	$uObject->{ARPed} = 0;
	$rpc->call("storObject", $uIP, $uObject);
}

sub virus {
	my ($type, $w, $x, $y, $uri) = @_;
	if($uri eq "undef") {
		$uObject = update($uObject, $uIP);
		if($type eq "arp") {
			$uObject->{ARPed} = 1;
			$rpc->call("storObject", $uIP, $uObject);
		} else {
			$windows{Top}->geometry =~ /([^x]+)x([^+]+)/;
			my ($mx, $my) = ($1, $2);
			for(my $x = 0;   $x <= $mx; $x += $mx / 10) {
				for(my $y = 0; $y <= $my; $y += $my / 10) {
					my ($xx, $yy) = ($x, $y);
					$windows{Top}->after(
						4 * ($x + $y),
						sub {
							warn ">$xx >$yy\n";
							$windows{Top}
							->Frame(-width => $mx / 10, -height => $my / 10)
							->place(-in => $windows{Top}, -x => $xx, -y => $yy);
						}
					);
				}
			}
			$windows{Top}->after(4 * ($mx + $my), sub {
				$uObject->{Down} = 1;
				$rpc->call("storTimer", time + $D{ReUp}, { ReUp => $uIP });
				$rpc->call("storObject", $uIP, $uObject);
			});
		}
	} elsif($uri =~ /^console:\/\/(.*)$/) {
		my $uid  = $1;
		my $host = $rpc->call("recvObject", $uid);
		my $rabbit = sub {
			my $uu = shift;
			$rpc->call("storTimer", time + 30, { Down => $uu });
			$rpc->call("storTimer", time + 30 + $D{ReUp}, { ReUp => $uu });
			newNews("DOWN", $uid) unless(exists $host->{NoNews} and $host->{NoNews});
		};
		if($type eq "rabbit") {
			$rabbit->($uid);
			$windows{Top}->after(30 * 1000, sub { disConnect() if($windows{ConnectedTo}) });
		} elsif($type eq "worm") {
			my (%visited, $recurse) = ();
			$recurse = sub {
				my $ur = shift;
				return if($visited{$ur});
				$visited{$ur}++;
				$recurse->($_) for(@{ $rpc->call("recvObject", $ur)->{Links} });
			};
			if($rpc->call("recvObject", $uid)->{Type} eq "P") {
				$rabbit->($uid);
			} else {
				$recurse->($uid);
				$rabbit->($_) for(keys %visited);
			}
			$windows{Top}->after(30 * 1000, sub { disConnect() if($windows{ConnectedTo}) });
		} elsif($type eq "orwell") {
			$rpc->call("storTimer", time, { Spy => { sendto => $uIP, uid => $uid, ohost => $host } });
		} elsif($type eq "arp") {
			if($host->{Type} eq "P") {
				$host->{ARPed} = 1;
				$rpc->call("storObject", $uid, $host);
			} else {
				$rabbit->($uid);
			}
		}
	} else {
		MyMesg(L("Programs_V_NfC_Title"), L("Programs_V_NfC_Text"));
	}
}

sub waterWall {
	my ($trigger, $w, $x, $y, $uri) = @_;
	warn ">$windows{ConnectedTo} >$trigger >$uri\n";
	return unless($windows{ConnectedTo});
	triggerTrace() if($trigger);
	$windows{NoFirewall} = 1;
	my $updSub;
	$updSub = sub {
		unless($windows{ConnectedTo}) {
			$windows{NoFirewall} = 0;
		} else {
			$windows{Top}->after(200, $updSub);
		}
	};
	$updSub->();
}

sub waterWallCheck {
	my ($uid, $host) = @_;
	if($host->{Firewalled} and not $windows{NoFirewall} and not $uid eq $uIP) {
		MyMesg(L("PermDenied"), L("NoAccessByFirewall"));
		return 0;
	} else {
		return 1;
	}
}

sub lateinVocab {
	my ($w, $x, $y, $uri) = @_;
	my $window = $windows{Top}->Toplevel(@F, -title => "Latein Vokabeln powered by Latein AG");
	$window->geometry("+$x+$y");
	my %vokabeln = split /\t/, $rpc->call("recvObject", "212.202.155.119")->{Vocabular};
	my $searchF  = $window->Entry(@E, -textvariable => \my $search);
	my $searchT;
	my $searchO  = BindLabel($window, "Suche!", "<ButtonPress-1>", sub {
		$search  = lc($search);
		$searchT->gridForget if($searchT);
		$searchT = MyTable($window, @F, -rows => 5, -columns => 2, -fixedrows => 1, -scrollbars => "oeon");
		$searchT->put(0, $_->[0], $_->[1]) for([0, "Latein"], [1, "Deutsch"]);
		my $index = 0;
		map { $searchT->put(++$index, 0, $_); $searchT->put($index, 1, $vokabeln{$_}) }
		grep { lc($_) =~ /\Q$search\E/ or lc($vokabeln{$_}) =~ /\Q$search\E/ }
		keys %vokabeln;
		$searchT->grid(-row => 1, -column => 0, -columnspan => 2);
	});
	$searchF->grid(-row => 0, -column => 0);
	$searchO->grid(-row => 0, -column => 1);
}

1;
