#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, @W);

sub handleU {
	my ($uid, $host) = @_;
	$uObject   = update($uObject, $uIP);
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $hello, $button, $hiddenFrame, @contacts);
	($title, $subtitle, $hello, $button, $hiddenFrame) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [qw/ Arial 12 /]),
		$screen->Label(@H, -text => L("PAS"),      -font => [qw/ Arial 8 /]),
		$screen->Label(@L, -text => join("\n\t >", L("PAS_Hello"), keys %{ $host->{Contacts} })),
		BindLabel($screen, L("ok"), "<ButtonPress-1>", sub {
			$_->gridForget for($hello, $button);
			$hiddenFrame->grid(-row => 3, -column => 0);
		}),
		$screen->Frame(@F),
	);
	@contacts = genContacts($hiddenFrame, $host);
	$contacts[$_]->grid(-row => int($_ / 2), -column => $_ % 2, -sticky => "wens") for(0 .. $#contacts);
	$title   ->grid(-row => 0, -column => 0, -sticky => "wn");
	$subtitle->grid(-row => 1, -column => 0, -sticky => "wn");
	$hello   ->grid(-row => 2, -column => 0);
	$button  ->grid(-row => 3, -column => 0);
	$screen->pack(-fill => "both");
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

sub genContacts {
	my ($frame, $host)  = @_;
	my $addPhoto        = $frame->Photo(-file => "graphics/add.xpm");
	my $addHoveredPhoto = $frame->Photo(-file => "graphics/add-hovered.xpm");
	return map {
		my $name  = $_;
		my $frame = $frame->Frame(@W);
		my ($func, $show, $ip, $keep);
		($func, $show, $ip, $keep) = (
			$frame->Label(-text => "$name:"),
			BindLabel($frame, C($host->{Contacts}{$name}), "<ButtonPress-1>", sub { dial($host->{Contacts}{$name}) }),
			BindLabel($frame, $host->{Contacts}{$name}, "<ButtonPress-1>", sub { dial($host->{Contacts}{$name}) }),
			BindLabel($frame,
								$frame->Label(
									@L,
									exists $uObject->{Links}{$host->{Contacts}{$name}}
										? (-text  => " ")
										: (-image => $addPhoto)
								),
								"<ButtonPress-1>",
								sub {
									$uObject = update($uObject, $uIP);
									if(not exists $uObject->{Links}{$host->{Contacts}{$name}}) {
										$uObject->{Links}{$host->{Contacts}{$name}} = 1;
										$rpc->call("storObject", $uIP, $uObject);
										showMap();
										$keep->configure(-image => undef);
										$keep->configure(-text => " ");
									}
								}),
		);
		$keep->bind("<Enter>", sub {
			$keep->configure(-image => $addHoveredPhoto) if(not exists $uObject->{Links}{$host->{Contacts}{$name}});
		});
		$keep->bind("<Leave>", sub {
			$keep->configure(-image => $addPhoto)        if(not exists $uObject->{Links}{$host->{Contacts}{$name}})
		});
		$func->grid(-row => 0, -column => 0, -columnspan => 2, -sticky => "we");
		$show->grid(-row => 1, -column => 0, -columnspan => 2, -sticky => "we");
		$ip  ->grid(-row => 2, -column => 0, -columnspan => 1, -sticky => "w");
		$keep->grid(-row => 2, -column => 1, -columnspan => 1, -sticky => "e");
		$frame;
	} sort { lc($a) cmp lc($b) } keys %{ $host->{Contacts} };
}

1;
