#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H, @T);

sub handleP {
	my ($uid, $host) = @_;
	my $okSub = sub {
		playSound("login");
		_admin(0, $host, $uid, $host->{Unixname}, qw/Bank Links Wallet Logs Records LogOut Console/);
	};
	if($uid ne $uIP and $host->{LoggedIn}) {
		my $level = $host->{Firewalled} || 0;
		if($level == 0) {
			$okSub->();
		} elsif($level >= 1) {
			if($level >= 2) {
				$host = update($host, $uid);
				$host->{UnAuthAccess} = $uIP;
				$rpc->call("storObject", $uid, $host);
			}
			logInScreen(
				$uid,
				$host,
				$okSub,
			);
		}
	} else {
		my $screen = $windows{Main}->Frame(@F);
		my ($title, $msg, $ok) = (
			$screen->Label(@H, -text => $host->{Name}, -font => [qw/ Arial 12 /]),
			$screen->Label(@L, -wraplength => "500", -text =>
				$uid ne $uIP
					? L("Player_Unfair")
					: L("Player_Feedback")),
			BindLabel($screen, L("ok"), "<ButtonPress-1>", sub { disConnect() }),
		);
		$_->grid(-row => 0, -column => 0, -sticky => "wn") for($title, $msg);
		$_->grid(-row => 1, -column => 0, -sticky => "wn") for($msg);
		$_->grid(-row => 2, -column => 0, -sticky => "we") for($ok);
		$screen->pack;
		$windows{InMain}->packForget if($windows{InMain});
		$windows{InMain} = $screen;
	}
}

sub _externWallet {
	my ($return, $host, $uid, $user) = @_;
	$host = update($host, $uid);
	my $screen = $windows{Main}->Frame(@F);
	my ($title, $subtitle, $tree, $back) = (
		$screen->Label(@H, -text => $host->{Name}, -font => [ qw/Arial 12/ ]),
		$screen->Label(@H, -text => L("Admin_Wallet"), -font => [ qw/Arial 8/ ], -justify => "left"),
		MyLinkPopup(
			MyScrolled(
				$screen,
				"HList",
				@T,
				-separator  => "/",
				-width      => 60,
				-height     => 17,
				-scrollbars => "ose",
			),
			"wallet://$uid",
		),
		$screen->Button(@B, -text => L("back"), -command => $return),
	);
	$tree->add("/", -text => L("Wallet_KnownHosts"));
	foreach my $hh (keys %{ $host->{Wallet} }) {
		$tree->add("/$hh", -text => $rpc->call("recvObject", $hh)->{Name});
		$tree->add("/$hh/$_", -text => "$_: $host->{Wallet}{$hh}{$_}") for(keys %{ $host->{Wallet}{$hh} });
	}
	$title->grid(   -row => 0, -column => 0, -columnspan => 1, -sticky => "wn");
	$subtitle->grid(-row => 1, -column => 0, -columnspan => 1, -sticky => "wn");
	$tree->grid(    -row => 2, -column => 0, -columnspan => 1, -sticky => "wens");
	$back->grid(    -row => 3, -column => 0, -columnspan => 1, -sticky => "we");
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

1;
