#!/usr/bin/perl -w

use warnings;
use strict;

use Digest::MD5 qw/md5_hex/;
use POSIX qw/strftime/;

sub chkSum { md5_hex(_chkSumRecurse(shift)) }

sub _chkSumRecurse {
	my $object = shift;
	if(not ref($object)) {
		return "$object";
	} elsif(ref($object) eq "ARRAY") {
		return join("", map { _chkSumRecurse($_) } @$object);
	} elsif(ref($object) eq "HASH") {
		return join("", sort map { _chkSumRecurse($_) } keys %$object, values %$object);
	}
}

sub u2m { return strftime("%Y%m%d%H%M%S", localtime(shift)) }

sub m2m { @_ = split "", shift; "$_[6]$_[7]/$_[4]$_[5]/$_[0]$_[1]$_[2]$_[3] $_[8]$_[9]:$_[10]$_[11]:$_[12]$_[13]" }

sub m2u { @_ = split "", shift; "$_[6]$_[7]$_[8]$_[9]$_[3]$_[4]$_[0]$_[1]$_[11]$_[12]$_[14]$_[15]$_[17]$_[18]" }

1;
