package Tk::MyTree;
# Tree -- TixTree widget
#
# Derived from Tree.tcl in Tix 4.1
#
# Chris Dean <ctdean@cogit.com>

use vars qw($VERSION);
$VERSION = '3.021'; # $Id: //depot/Tk8/Tixish/Tree.pm#21 $

use Tk ();
use Tk::Derived;
use Tk::Tree;
use base  qw(Tk::Derived Tk::Tree);
use strict;

Construct Tk::Widget 'MyTree';

sub Tk::Widget::ScrlMyTree { shift->Scrolled('MyTree' => @_) }

sub _indicator_image
{
 my( $w, $ent, $image ) = @_;
 my $data = $w->privateData();
 if (@_ > 2)
  {
   if (defined $image)
    {
     $w->indicatorCreate( $ent, -itemtype => 'image' )
         unless $w->indicatorExists($ent);
     $data->{$ent} = $image;
		 if($image eq "plus" or $image eq "minus") {
      $w->indicatorConfigure($ent, -image => $w->Pixmap(-file => "graphics/$image.xpm"));
		 }
    }
   else
    {
     $w->indicatorDelete( $ent ) if $w->indicatorExists( $ent );
     delete $data->{$ent};
    }
  }
 return $data->{$ent};
}

1;
