#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H);

sub handleV {
	my ($uid, $host) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my ($id, $text)  = (0, "$host->{Name}\n\n\n");
	my $proto  = MyLinkPopup($screen->Label(@L, -textvariable => \$text), "voice://$uid");
	$proto->grid(qw/ -row 0 -column 0 -sticky wen /);
	$id       += ord($_) * ord($_) for(split "", $host->{Name});
	$windows{VoiceOkGiven} = 0;
	my @sayings = (
		([    0, L("Voice_Ringing") . "\n" ], [ 2500, "play:ringout" ]) x ($id % 3 + 2),
		[   500, "\n" ],
		[     0, "play:phonepickup" ],
		[   700, L("Voice_Open") . "\n" ],
		[  1800, "play:analyser/hello" . ($id % 4 + 1) . "_0" ],
		[  1800, "play:analyser/hello" . ($id % 4 + 1) . "_1" ],
		[  2000, "play:analyser/hello" . ($id % 4 + 1) . "_2" ],
		[   100, "play:phonepickup" ],
		[  4000, "\n" . L("Voice_Close") . "\n" ],
	);
	my $process;
	$process = sub {
		if(@sayings == 0) {
			undef $windows{VoiceOkGiven};
			disConnectOnly($uid);
			return;
		}
		my ($wait, $tt) = @{ shift @sayings };
		if($tt =~ /^play:(.+)$/) {
			playSound($1);
		} else {
			if($tt =~ /open/) {
				$windows{VoiceOkGiven} = $uid;
			} elsif($tt =~ /close/) {
				$windows{VoiceOkGiven} = 0;
			}
			$text .= $tt;
		}
		$screen->after($wait, $process);
	};
	$screen->after(1, $process);
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

1;
