#!/usr/bin/perl -w

use warnings;
use strict;

our $rpc;
our %windows;
our ($uIP, $uObject);
our (@F, @B, @L, @E, @H);

sub handleW {
	my ($uid, $host) = @_;
	my $screen = $windows{Main}->Frame(@F);
	my $menu   = MyLinkMenu->new($screen);
	$menu->addItem(1, Title    => $host->{Name});
	$menu->addItem(1, Subtitle => L("Webserver"));
	foreach my $site (sort keys %{ $host->{Sites} }) {
		my $ssite = $site;
		$ssite =~ s/^[A-Z]\. // if($ssite =~ /^[A-Z]\. /);
		$menu->addItem(1, $ssite => sub {
			$host  = update($host, $uid);
			my $ss = $windows{Main}->Frame(@F);
			my ($mt, $st, $tt, $rb) = (
				$ss->Label(@H, -text => $host->{Name}, -font => [qw/ Arial 12 /]),
				$ss->Label(@H, -text => $ssite,        -font => [qw/ Arial  8 /]),
				MyScrolled(
					$ss,
					"ROText",
					@E,
					-width      => 68,
					-height     => 15,
					-wrap       => "word",
					-scrollbars => "osoe",
				),
				BindLabel($ss, L("back"), "<ButtonPress-1>", sub { handleW($uid, $host) }),
			);
			$tt->insert("0.0", $host->{Sites}{$site});
			$mt->grid(-row => 0, -column => 0, -sticky => "nw");
			$st->grid(-row => 1, -column => 0, -sticky => "nw");
			$tt->grid(-row => 2, -column => 0, -sticky => "we");
			$rb->grid(-row => 3, -column => 0, -sticky => "we");
			$ss->pack;
			$windows{InMain}->packForget if($windows{InMain});
			$windows{InMain} = $ss;
		});
	}
	$menu->addItem(scalar keys %{ $host->{Records} } > 0, Admin => sub {
		logInScreen(
			$uid,
			$host,
			sub {
				playSound("login");
				newNews("BROKENIN", $uid) if(exists $host->{NoNews} and $host->{NoNews});
				_admin(
					sub { handleW($uid, $host) },
					$host,
					$uid,
					(grep { $host->{Records}{$_}{Level} == 0 } keys %{ $host->{Records} })[0],
					qw/Logs Security Console Sites/
				)
			}
		)
	});
	$menu->pack;
	$screen->pack;
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
}

1;
