#!/usr/bin/perl -w

use warnings;
use strict;

use Tk;
use Tk::Table;
use Tk::ROText;
use Tk::Tree;
use Tk::Optionmenu;
use Tk::BrowseEntry;

require MyLinkTree;
require MyLinkSum;
require MyLinkDottedLine;

our $VERSION;
our %windows;
our ($uIP, $uObject);
our $rpc;
our (@F, @B, @L, @E, @H, @M, @S, @P, @SB, @T, @HL, @W, %actions, %D);
our ($LANG, $DEFAULT_LANG, %TEXTS);

sub SHOW {
	my ($mywindow, $name) = @_;
	my $p = $name;
	$p =~ s/^In//;
	$mywindow->place(-in => $windows{$p}, -relx => 0, -rely => 0, -anchor => "nw");
#	$windows{$name}->gridForget if($windows{$name});
#	$windows{$name}->packForget if($windows{$name});
	$windows{$name}->placeForget if($windows{$name});
	$windows{$name} = $mywindow;
}

sub MyScrolled {
	my ($parent, $type, %options) = @_;
	my $object = $parent->Scrolled($type, %options);
	$object->Subwidget("yscrollbar")->configure(@SB) if($options{-scrollbars} =~ /e/);
	$object->Subwidget("xscrollbar")->configure(@SB) if($options{-scrollbars} =~ /s/);
	return $object;
}

sub MyTable {
	my ($parent, %options) = @_;
	my $object = $parent->Table(%options);
	$parent->afterIdle(sub {
		$object->{ysb}->configure(@SB) if($options{-scrollbars} =~ /e/);
		$object->{xsb}->configure(@SB) if($options{-scrollbars} =~ /s/);
	});
	return $object;
}

sub startwin {
	initStyle();
	my @C = @E;

	my ($server, $ip, $user, $pass, @pips) = ("http://servername:port/RPC2");
	if(-f "mylink.dat") {
		open my $config, "mylink.dat" or die $!;
			chomp(($LANG, $server, @pips) = <$config>);
		close $config;
	}
	
	my $top        = new MainWindow(-width => 800, -height => 600, @F);
	my $bfa        = $top->Frame(-width => 800, -height => 600, @F);
	my $logo       = $bfa->Label(@L, -image => $bfa->Photo(-file => "graphics/mylink.xpm"));
	my $configN    = $bfa->Photo(-file => "graphics/configure.xpm");
	my $configure  = $bfa->Label(@L, -image => $configN);
	my $thanks     = $bfa->Label(@H, -anchor => "center", -justify => "center", -text => L("Thanks"));
	my $error      = $bfa->Label(@L, -foreground => "red", -anchor => "center", -text => L("Help"));

	my $useLang    = $bfa->BrowseEntry(@C, -variable => \$LANG);
		$useLang->insert("end", $_) for keys %TEXTS;
		my $heLang   = $bfa->Label(@L, -text => L("Language"));
	my $useServer  = $bfa->Entry(@C, -textvariable => \$server);
		my $heServer = $bfa->Label(@L, -text => L("GameServerURL"));
	my $useIP      = $bfa->BrowseEntry(@C, -variable => \$ip);
		$useIP->insert("end", $_) for(sort @pips);
		$ip = $pips[0] if(@pips);
		my $heIP     = $bfa->Label(@L, -text => L("GatewayIP"));
	my $useUser    = $bfa->Entry(@C, -textvariable => \$user);
		my $heUser   = $bfa->Label(@L, -text => L("Username"));
	my $usePass    = $bfa->Entry(@C, -textvariable => \$pass, -show => "*");
		my $hePass   = $bfa->Label(@L, -text => L("Password"));

	my $useNewIP   = $bfa->Entry(@C, -textvariable => \my $newIP);
		my $heNewIP  = $bfa->Label(@L, -text => L("RegisterGWIP"));
	my $useNewUID  = $bfa->Entry(@C, -textvariable => \my $newUser);
		my $heNewUID = $bfa->Label(@L, -text => L("Username"));
	my $useNewPas  = $bfa->Entry(@C, -textvariable => \my $newPass, -show => "*");
		my $heNewPas = $bfa->Label(@L, -text => L("Password"));
	my $useNewRN   = $bfa->Entry(@C, -textvariable => \my $newReal);
		my $heNewRN  = $bfa->Label(@L, -text => L("Realname"));
	my $useNewBir  = $bfa->Entry(@C, -textvariable => \my $newBirth); $newBirth = "dd/mm/YYYY";
		my $heNewBir = $bfa->Label(@L, -text => L("DateOfBirth"));
	my $useNewMar  = $bfa->Entry(@C, -textvariable => \my $newMarital);
		my $heNewMar = $bfa->Label(@L, -text => L("MaritalStatus"));
	my $useNewPer  = $bfa->Entry(@C, -textvariable => \my $newPersonal);
		my $heNewPer = $bfa->Label(@L, -text => L("PersonalStatus"));
	my $newOK      = $bfa->Button(@B,-text => L("OrderGateway"));

	my $showed = 0;
	$configure->bind("<ButtonPress-3>", sub {
		playSound("mouseclick");
		$error->configure(-text => "");
		if($showed) {
			$_->placeForget for($heLang, $useLang, $heServer, $useServer);
		} else {
			$heLang   ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2,           -y => 205);
				$useLang->place(-in => $bfa, -anchor => "nw", -x => 800 / 2,           -y => 205);
			$heServer   ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2,           -y => 230);
				$useServer->place(-in => $bfa, -anchor => "nw", -x => 800 / 2,           -y => 230);
		}
		$showed = 1 - $showed;
	});
	$configure->bind("<ButtonPress-1>", sub {
		playSound("mouseclick");
		$error->configure(-text => "");
		my $newError;
		if(not $server or $server eq "http://servername:port/RPC2") {
			$newError = L("ErrNoServerURL");
		} elsif(not $ip) {
			$newError = L("ErrNoGatewayIP");
		} elsif(not $user) {
			$newError = L("ErrNoUsername");
		} elsif(not $pass) {
			$newError = L("ErrNoPassword");
		} else {
			startnet($server);
			my $pong;
			eval { $pong = $rpc->call("ping") };
			if($@) {
				$newError = L("ErrNotReachable");
			} elsif($pong ne "pong-$VERSION") {
				$pong =~ s/^.*?-//;
				$newError = L("ErrDifferentVer", $pong, $VERSION);
			} else {
				my $writeok = 1;
				$top->after(progressAnim($ip, $top), sub {
					$uIP     = $ip;
					$uObject = $rpc->call("recvObject", "$ip");
					if($uObject eq "ERROR") {
						$newError = L("ErrIPNotFound");
					} elsif($uObject->{Type} ne "P") {
						$newError = L("ErrNotAGateway");
					} elsif(not exists $uObject->{Records}{$user} or $uObject->{Records}{$user}{Password} ne $pass) {
						$newError = L("InvalidUserPass")
					} elsif((exists $uObject->{Dead} and $uObject->{Dead}) or (exists $uObject->{Down} and $uObject->{Down})) {
						$newError = L("ErrGatewayDown");
					} else {
						open my $configO, ">mylink.dat" or die $!;
							$configO->print(join "\n", $LANG, $server, $ip, keys%{{map{$_=>1}grep{$_ ne$ip}@pips}});
						close $configO;
						$bfa->packForget;
						$windows{Top} = $top;
						startSub();
					}
					if($newError) {
						$error->configure(-text => $newError);
						$error->after(1000, sub { $error->configure(-text => "") });
					}
				});
			}
		}
		if($newError) {
			$error->configure(-text => $newError);
			$error->after(1000, sub { $error->configure(-text => "") });
		}
	});
	$configure->bind("<ButtonPress-2>", sub {
		playSound("mouseclick");
		$error->configure(-text => "");
		my $newError;
		$_->placeForget for($heIP, $useIP, $heUser, $useUser, $hePass, $usePass, $heServer, $useServer);
		$configure->bind("<ButtonPress-$_>", sub { 1 }) for(1, 2);
		$thanks->configure(-text => L("NewUser"));
		$heNewIP    ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2, -y => 205);
			$useNewIP ->place(-in => $bfa, -anchor => "nw", -x => 800 / 2, -y => 205);
		$heNewUID   ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2, -y => 230);
			$useNewUID->place(-in => $bfa, -anchor => "nw", -x => 800 / 2, -y => 230);
		$heNewPas   ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2, -y => 255);
			$useNewPas->place(-in => $bfa, -anchor => "nw", -x => 800 / 2, -y => 255);
		$heNewRN    ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2, -y => 280);
			$useNewRN ->place(-in => $bfa, -anchor => "nw", -x => 800 / 2, -y => 280);
		$heNewBir   ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2, -y => 305);
			$useNewBir->place(-in => $bfa, -anchor => "nw", -x => 800 / 2, -y => 305);
		$heNewMar   ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2, -y => 330);
			$useNewMar->place(-in => $bfa, -anchor => "nw", -x => 800 / 2, -y => 330);
		$heNewPer   ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2, -y => 355);
			$useNewPer->place(-in => $bfa, -anchor => "nw", -x => 800 / 2, -y => 355);
		$newOK      ->place(-in => $bfa, -anchor => "center", -x => 800 / 2, -y => 390);
		$newOK->configure(-command => sub {
			if(not $newIP or not $newUser or not $newPass or not $newReal or not $newBirth =~ /^[0-9][0-9]\/[0-9][0-9]\/[0-9][0-9][0-9][0-9]$/ or not $newMarital or not $newPersonal) {
				$newError = L("ErrFillCorrectly");
			} else {
				if(not $server or $server eq "http://servername:port/RPC2") {
					$newError = L("ErrNoServerURL");
				} else {
					startnet($server);
					my $pong;
					eval { $pong = $rpc->call("ping") };
					if($@) {
						$newError = L("ErrNotReachable");
					} elsif($pong ne "pong-$VERSION") {
						$pong =~ s/^.*?-//;
						$newError = L("ErrDifferentVer", $pong, $VERSION);
					} elsif($rpc->call("recvObject", $newIP) eq "ERROR") {
						newUserBackend($newIP, $newUser, $newPass, $newReal, m2u("$newBirth 00:00:00"), $newMarital, $newPersonal);
						open my $configO, ">mylink.dat" or die $!;
  						$configO->print(join "\n", $LANG, $server, $newIP, keys%{{map{$_=>1}@pips}});
						close $configO;
						playSound("success");
						$newError = L("RegCompleted");
						$top->after(progressAnim($ip, $top), sub {
							$uIP     = "$newIP";
							$uObject = $rpc->call("recvObject", $uIP);
							$bfa->packForget;
							$windows{Top} = $top;
							startSub();
						});
					} else {
						$newError = L("ErrIPInUse");
					}
				}
			}
			if($newError) {
				$error->configure(-text => $newError);
				$error->after(1000, sub { $error->configure(-text => "") });
			}
		});
	});
	
	$logo       ->place(-in => $bfa, -anchor => "nw", -x => 800 / 2 - 434 / 2, -y => 600 / 5 - 59 / 2);
	$configure  ->place(-in => $bfa, -anchor => "se", -x => 800,               -y => 600);
	$heIP       ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2,           -y => 255);
		$useIP    ->place(-in => $bfa, -anchor => "nw", -x => 800 / 2,           -y => 255);
	$heUser     ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2,           -y => 280);
		$useUser  ->place(-in => $bfa, -anchor => "nw", -x => 800 / 2,           -y => 280);
	$hePass     ->place(-in => $bfa, -anchor => "ne", -x => 800 / 2,           -y => 305);
		$usePass  ->place(-in => $bfa, -anchor => "nw", -x => 800 / 2,           -y => 305);
	$error      ->place(-in => $bfa, -anchor => "center", -x => 800 / 2,       -y => 420);
	$thanks     ->place(-in => $bfa, -anchor => "center", -x => 800 / 2,       -y => 500);
	$bfa->pack;

	FFF($useIP);

	warn "Graphics subsystem started successfully.\n";
	MainLoop;
}

sub startSub {
	push @E, -tile   => $windows{Top}->Photo(-file => "graphics/tile.xpm");
	$windows{PMails} = $windows{Top}->Frame(-width => 800, -height =>  50, @F);
	
	$windows{PMain}  = $windows{Top}->Frame(-width => 600, -height => 550, @F);

	$windows{PMap}   = $windows{Top}->Frame(-width => 200, -height => 170, @F);
	$windows{PInfos} = $windows{Top}->Frame(-width => 200, -height => 330, @F);

	my $routine      = sub {
		my ($pseudo, $width, $height) = @_;
		my $frame  = $pseudo->Frame(-width => $width, -height => $height, @F);
		my $dummyH = $frame ->Frame(-width => 0,      -height => $height, @F);
		my $dummyW = $frame ->Frame(-width => $width, -height => 0,       @F);
		my $eigent = $frame ->Frame(-width => $width, -height => $height, @F);
		$dummyH->grid(-row => 0, -column => 0, -rowspan => 2, -sticky => "n");
		$dummyW->grid(-row => 0, -column => 1, -rowspan => 1, -sticky => "n");
		$eigent->grid(-row => 1, -column => 1, -rowspan => 1, -sticky => "n");
		$frame->pack(-side => "top");
		$frame->packPropagate(0);
		$eigent->gridPropagate(0);
		return $eigent;
	};

	$windows{Main}  = $routine->($windows{PMain},  600, 550);
	$windows{Map}   = $routine->($windows{PMap},   200, 170);
	$windows{Infos} = $routine->($windows{PInfos}, 200, 330);
	$windows{Mails} = $routine->($windows{PMails}, 800, 50);

	$windows{PMain}->grid( -column => 0, -columnspan => 1, -row => 0, -rowspan => 2,-sticky=>"new");
	$windows{PMap}->grid(  -column => 1, -columnspan => 1, -row => 0, -rowspan => 1,-sticky=>"new");
	$windows{PInfos}->grid(-column => 1, -columnspan => 1, -row => 1, -rowspan => 1,-sticky=>"new");
	$windows{PMails}->grid(-column => 0, -columnspan => 2, -row => 2, -rowspan => 1,-sticky=>"new");
	
	if(exists $uObject->{OnLogin} and $uObject->{OnLogin}) {
		$rpc->call("storTimer", time, $uObject->{OnLogin});
		delete $uObject->{OnLogin};
		$rpc->call("storObject", $uIP, $uObject);
		$rpc->call("checkTimer");
		$uObject = update($uObject, $uIP);
	}

	do { mapGeoPos($_, 1, 1); C_N($_) } for(keys %{ $uObject->{Links} });

	showMails();
	showMap();
	$windows{Top}->repeat(1000, sub { $windows{InfoScreen}->() if(defined $windows{InfoScreen}) });
	if(exists $uObject->{NewGW} and $uObject->{NewGW}) {
		mainMsg(L("NewGW", $uObject->{Gateway}));
		$uObject->{NewGW} = 0;
		$rpc->call("storObject", $uIP, $uObject);
	} else {
		mainMsg(L("GWBack"));
	}
	$uObject->{Firewalled} = 0;
	$uObject->{LoggedIn}   = 1;
	$rpc->call("storObject", $uIP, $uObject);
	$windows{Main}->bind("<Destroy>", sub { exitSub() });
	$windows{Main}->repeat(5000, sub {
		$uObject = update($uObject, $uIP);
		if(exists $uObject->{LogOut} and $uObject->{LogOut}) {
			$uObject->{LogOut} = 0;
			$rpc->call("storObject", $uIP, $uObject);
			$windows{Top}->destroy;
		}
	});
	checkForDead();
	$windows{Top}->repeat(20000, sub { $rpc->call("checkTimer") });
}

sub exitSub {
	warn "Shutting down... ";
	$uObject = update($uObject, $uIP);
	$uObject->{Firewalled} = 0;
	$uObject->{LoggedIn}   = 0;
	$rpc->call("storObject", $uIP, $uObject);
	warn "done.\n";
}

sub mainMsg {
	my ($msg, $screen, $callback) = (shift, $windows{Main}->Frame(@F), shift || sub { listLinks() });
	my ($label, $ok) = ($screen->Label(@L, -text => $msg), $screen->Button(@B, -text => "Ok", -command => sub { playSound("mouseclick"); $callback->() }));
	$_->pack for($label, $ok, $screen);
	undef $windows{MapOldInMain};
	$windows{InMain}->packForget if($windows{InMain});
	$windows{InMain} = $screen;
#	SHOW($screen, "InMain");
}

sub playSound {
	system("artsdsp play sounds/$_[0].wav &");
}

package MyLinkMenu;

our @ISA = qw/Tk::Frame/;

sub addItem {
	my ($frame, $active, $item, $sub) = @_;
	$frame->configure(@main::F);
	$frame->{itemIndex} = 0 unless(exists $frame->{itemIndex});

	if($frame->{itemIndex} == 0) {
		my $hello = $frame->Label(-anchor => "w", -text => $sub, -font => [ qw/Arial 12/ ], @main::H);
		$hello->grid(-row => 0, -column => 0, -sticky => "wn");
	} elsif($frame->{itemIndex} == 1) {
		$sub =~ s/\b(.)/\U$1/g;
		my $hello = $frame->Label(-anchor => "w", -text => $sub, -font => [ qw/Arial 8/ ], @main::H);
		$hello->grid(-row => 1, -column => 0, -sticky => "wn");
	} else {
		if(not defined $frame->{itemPaFrame}) {
			$frame->{itemPaFrame} = $frame->Frame(@main::F);
			$frame->{itemPaFrame}->grid(-row => 2, -column => 0, -sticky => "w");
			$frame->{itemPaFrame}->Frame(@main::F, -width => 80)->grid(-row => 0, -column => 0);
		}
		my $photo  = $frame->{itemPaFrame}->Photo(-file => "graphics/menudot.xpm");
		my $bullet = $frame->{itemPaFrame}->Label(@main::L, -image => $photo);
		my $text   = $frame->{itemPaFrame}->Label(-text    => $item,
																							-justify => "left",
																							-anchor  => "w",
																							-width   => 21,
																							@main::L, -foreground => $active ? "white" : "grey");
		$bullet->bind("<ButtonPress-1>", sub { main::playSound("menuitemclick"); $sub->() }) if($active);
		$text  ->bind("<ButtonPress-1>", sub { main::playSound("menuitemclick"); $sub->() }) if($active);
		$_->bind("<Enter>",sub{$photo->configure(-file=>"graphics/menudot-hovered.xpm")})for($bullet, $text);
		$_->bind("<Leave>",sub{$photo->configure(-file=>"graphics/menudot.xpm")})for($bullet, $text);
		$bullet->grid(-row => $frame->{itemIndex}, -column => 1);
		$text->grid(  -row => $frame->{itemIndex}, -column => 2);
	}
	$frame->{itemIndex}++;
}

package main;

sub BindLabel {
	my ($parent, $text, $event, $sub) = @_;
	my $object =
		ref($text)
			? $text
			:	$event =~ /-1/
				? $parent->Button(
					@B,
					-text => $text,
					$event =~ /^left\|/
						? (-anchor => "w")
						: $event =~ /^right\|/
							? (-anchor => "e")
							: ()
					)
				: $parent->Label (@L, -text => $text);
	$event =~ s/^(left|right)\|//;
	$object->bind($event, sub { playSound("mouseclick"); $sub->($object) });
	return $object;
}

sub MyLinkForm {
	my ($parent,
			$options,
			$type)    = (shift, shift, shift);
	my @keys      = @{ (shift) };
	my @values    = @{ (shift) };
	my $frame     = $parent->Frame(@F);
	my @labels; push @labels, $frame->Label(@L, -text => $_) for(@keys);
	my @entrys; push @entrys, $type eq "Entries"
		? (
				ref($values[$_])
					? $frame->Entry(@E, -textvariable => $values[$_], @$options, $keys[$_] =~ /[pP]assword/ ? (-show => "*") : ())
					: $frame->Label(@L, -text         => $values[$_], @$options)
			)
		: $frame->Label(@L, -textvariable => $values[$_], @$options)
			for(0 .. $#values);
	my $index;
	$index = 0; $_->grid(-row => $index++, -column => 0, -sticky => "w") for(@labels);
	$index = 0; $_->grid(-row => $index++, -column => 1, -sticky => "e") for(@entrys);
	return $frame;
}

sub LL { (shift)->Label(@L, -text => shift, @_) }

sub MyLinkPopup {
	%actions = (
		"File_Copier-prog"       => sub { fileCopier(@_) },
		"File_Deleter-prog"      => sub { fileDeleter(@_) },
		"Decrypter_v1-prog"      => sub { deCrypter(1, @_) },
		"Decrypter_v2-prog"      => sub { deCrypter(2, @_) },
		"Decrypter_v3-prog"      => sub { deCrypter(3, @_) },
		"Decrypter_v4-prog"      => sub { deCrypter(4, @_) },
		"Decrypter_v5-prog"      => sub { deCrypter(5, @_) },
		"Decrypter_v6-prog"      => sub { deCrypter(6, @_) },
		"Decrypter_v7-prog"      => sub { deCrypter(7, @_) },
		"Encrypter_v1-prog"      => sub { enCrypter(1, @_) },
		"Encrypter_v2-prog"      => sub { enCrypter(2, @_) },
		"Encrypter_v3-prog"      => sub { enCrypter(3, @_) },
		"Encrypter_v4-prog"      => sub { enCrypter(4, @_) },
		"Encrypter_v5-prog"      => sub { enCrypter(5, @_) },
		"Encrypter_v6-prog"      => sub { enCrypter(6, @_) },
		"Encrypter_v7-prog"      => sub { enCrypter(7, @_) },
		"Password_Breaker-prog"  => sub { passBreaker(@_) },
		"Dictionary_Hacker-prog" => sub { dictHax0r(@_) },
		"Trace_Tracker_v1-prog"  => sub { traceTracker(0, @_) },
		"Trace_Tracker_v2-prog"  => sub { traceTracker(1, @_) },
		"IP_Lookup-prog"         => sub { ipLookup(@_) },
		"Log_Deleter_v1-prog"    => sub { logDeleter(@_, "insecure") },
		"Log_Deleter_v2-prog"    => sub { logDeleter(@_, "secure") },
		"Log_UnDeleter-prog"     => sub { logUnDeleter(@_) },
		"Log_Modifier_v1-prog"   => sub { logModifier(0, @_) },
		"Log_Modifier_v2-prog"   => sub { logModifier(1, @_) },
		"Voice_Analyzer-prog"    => sub { voiceAnalyzer(@_) },
		"Decypher-prog"          => sub { deCypher(@_) },
		"Record_Extor-prog"      => sub { recordExtor(@_) },
		"Record_Creator-prog"    => sub { recordCrator(@_) },
		"Firewall_v1-prog"       => sub { fireWall(1, @_) },
		"Firewall_v2-prog"       => sub { fireWall(2, @_) },
		"Firewall_v3-prog"       => sub { fireWall(3, @_) },
		"Server_Editor-prog"     => sub { serverEditor(@_) },
		"Mission_Editor-prog"    => sub { missionEditor(@_) },
		"Rabbit_Virus-prog"      => sub { virus("rabbit", @_) },
		"Worm_Virus-prog"        => sub { virus("worm",   @_) },
		"Orwell_Virus-prog"      => sub { virus("orwell", @_) },
		"ARP_Virus-prog"         => sub { virus("arp",    @_) },
		"AV_Kit_v1-prog"         => sub { AVKit(1, @_) },
		"Firewall_Disable-prog"  => sub { waterWall(1, @_) },
		"Firewall_Bypass-prog"   => sub { waterWall(0, @_) },
		"Latein_Vocab-prog"      => sub { lateinVocab(@_) },
	);
	my ($object, $uri, $after) = (undef, undef, undef);
	if(ref($_[0])) {
		($object, $uri, $after) = @_;
	} else {
		$object        = $_[1]->Label(-text => $_[0], @L);
		($uri, $after) = ($_[2], $_[3]);
	}
	my $event = $uri eq "undef" ? "<ButtonRelease-1>" : "<ButtonRelease-3>";
	my @bind1 = (
		"$event" =>
		[
			sub {
				my ($w, $x, $y) = @_;
				$uObject = update($uObject, $uIP);
				my $idx  = 0;
				my %MLO  = map { $_ => $idx++ } @{ $rpc->call("recvObject", "128.0.0.13")->{SoftwareOrder} };
				my $ruri = $uri;
				$ruri = $uri->() if(ref($uri) eq "CODE");
				my $menu;
				if(ref($object) eq "ARRAY") {
					$menu = $object->[0]->Menu(-type => "tearoff", @P);
				} else {
					$menu = $object->Menu(-type => "tearoff", @P);
				}
				my @prgs;
				foreach my $program (sort { (exists $MLO{$a} and exists $MLO{$b}) ? ($MLO{$a} <=> $MLO{$b}) : ($a cmp $b) } grep { exists $actions{$_} } keys %{ $uObject->{Files} }) {
					push @prgs, $menu->command(@M,
																		 -label   => $program,
																		 -command => sub {
																		 	 playSound("menuitemclick");
																			 $uObject = update($uObject, $uIP);
																			 if($uObject->{Files}{$program}{Encrypted}) {
																			 	 MyMesg(L("ErrEncryptedPrograms_Title"), L("ErrEncryptedPrograms_Text"));
																			 } else {
																		 	   playSound("runsoftware");
																		 	   $actions{$program}->($w, $x, $y, $ruri);
																			   $after->() if(defined $after);
																			 }
																		 });
				}
				$menu->overrideredirect(1);
				$menu->Post($x, $y);
				if($ruri eq "undef") {
					$menu->geometry =~ /^([0-9]+)x([0-9]+)\+([0-9]+)\+([0-9]+)$/;
					$menu->geometry("$1x$2+$3+" . ($4 - $2));
				}
			},
			Ev("X"),
			Ev("Y"),
		],
	);
	my @bind2 = (
		"<ButtonPress-1>" =>
		[
			sub {
				my ($w, $x, $y) = @_;
				my $ruri = $uri;
				$ruri = $uri->() if(ref($uri) eq "CODE");
				if(defined $windows{NextClick}) {
					while(@{ $windows{NextClick} }) {
						my $nsub = shift @{ $windows{NextClick} };
						$nsub->($w, $x, $y, $ruri);
					}
				}
				$after->() if(defined $after);
			},
			Ev("X"),
			Ev("Y"),
		],
	) unless($event eq "<ButtonRelease-1>");
	if(ref($object) eq "ARRAY") {
		$object->[0]->bind($object->[1], @bind1);
		$object->[0]->bind($object->[1], @bind2);
	} else {
		$object->bind(@bind1);
		$object->bind(@bind2);
	}
	return $object;
}

sub FFF {
	foreach my $object (@_) {
		$object->focusFollowsMouse;
		$object->bind("<FocusIn>", sub { $object->eventGenerate("<End>") });
	}
}

sub MyMesgBox {
	warn "@_\n";
	my %args  = @_;
	my $windo = $windows{Top}->Toplevel(-width => 100, -height => 50);
	$windows{Top}->geometry =~ /.*?\+([^+]+)\+(.*)$/;
	$windo->geometry("+" . ($1 + 800/2) . "+" . ($2 + 600/2));
	$windo->overrideredirect(1);
	my $frame = $windo->Frame(@W);
	my $label = $frame->Label(@L,  -text => $args{-text});
	my $retur = 0;
	my $error = $frame->Label(@L,  -background => "blue", -text => "Error");
	my $butto = $frame->Button(@B, -text => L("ok"), -command => sub {
		playSound("mouseclick");
		$windo->destroy;
	});
	$error->grid(-row => 0, -column => 0, -sticky => "we");
	$label->grid(-row => 1, -column => 0, -sticky => "we");
	$butto->grid(-row => 2, -column => 0, -sticky => "we");
	$frame->pack;
}

sub MyMesg {
	my ($parent, $title, $mesg) = (
		ref($_[0])
			? shift
			: $windows{Top},
		shift,
		shift
	);
	$parent->messageBox(@L, -title => $title, -message => $mesg, -font => [qw/ Arial 8 /]);
#	$parent->geometry =~ /^([^x]+)x([^+]+)\+([^+]+)\+(.*)$/;
#	my $win = $parent->Toplevel(@F);
#	$win->geometry("200x50+" . ($3 + $1 / 2) . "+" . ($4 + $2 / 2));
#	$win->overrideredirect(1);
#	my $fra = $win->Frame(@W);
#	$fra
#		->Label(@L, -text => $mesg, -wraplength => 200)
#		->grid(-row => 0, -column => 0, -sticky => "wen");
#	$fra->Button(@B, -text => "ok", -command => sub {
#		playSound("mouseclick");
#		$win->destroy;
#	})
#		->grid(-row => 1, -column => 0, -sticky => "wes");
#	$fra->pack;
}

1;
